/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSRegistrationReturnServlet
extends HttpServlet {
    ServletConfig config = null;
    IDFFMetaManager metaManager = null;
    private static String COMMON_ERROR_PAGE = "";
    private HttpServletRequest request = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("FSRegistrationReturnServlet Initializing...");
        this.config = config;
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FSUtils.debug.message("FSRegistrationReturnServlet doGetPost...");
        String providerAlias = "";
        providerAlias = FSServiceUtils.getMetaAlias(request);
        if (providerAlias == null || providerAlias.length() < 1) {
            FSUtils.debug.error("Unable to retrieve alias, Hosted Provider. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (this.metaManager == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
        ProviderDescriptorType hostedProviderDesc = null;
        BaseConfigType hostedConfig = null;
        String hostedEntityId = null;
        String hostedProviderRole = null;
        try {
            hostedProviderRole = this.metaManager.getProviderRoleByMetaAlias(providerAlias);
            hostedEntityId = this.metaManager.getEntityIDByMetaAlias(providerAlias);
            if (hostedProviderRole != null && hostedProviderRole.equalsIgnoreCase("IDP")) {
                hostedProviderDesc = this.metaManager.getIDPDescriptor(realm, hostedEntityId);
                hostedConfig = this.metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
            } else if (hostedProviderRole != null && hostedProviderRole.equalsIgnoreCase("SP")) {
                hostedProviderDesc = this.metaManager.getSPDescriptor(realm, hostedEntityId);
                hostedConfig = this.metaManager.getSPDescriptorConfig(realm, hostedEntityId);
            }
            if (hostedProviderDesc == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException eam) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = request;
        this.setRegistrationURL(hostedConfig, providerAlias);
        FSNameRegistrationResponse regisResponse = null;
        try {
            regisResponse = FSNameRegistrationResponse.parseURLEncodedRequest(request);
        }
        catch (FSMsgException e) {
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-request-improper", "registration-failed");
            return;
        }
        catch (SAMLException e) {
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-request-improper", "registration-failed");
            return;
        }
        String remoteEntityId = regisResponse.getProviderId();
        ProviderDescriptorType remoteDesc = null;
        boolean isIDP = false;
        try {
            if (hostedProviderRole.equalsIgnoreCase("SP")) {
                remoteDesc = this.metaManager.getIDPDescriptor(realm, remoteEntityId);
                isIDP = true;
            } else {
                remoteDesc = this.metaManager.getSPDescriptor(realm, remoteEntityId);
            }
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("FSRegistrationReturnServlet:", (Throwable)((Object)e));
        }
        if (remoteDesc == null) {
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-request-improper", "registration-failed");
            return;
        }
        boolean bVerify = true;
        try {
            if (FSServiceUtils.isSigningOn()) {
                bVerify = this.verifyResponseSignature(request, remoteDesc, remoteEntityId, isIDP);
            }
        }
        catch (SAMLException e) {
            bVerify = false;
        }
        catch (FSException e) {
            bVerify = false;
        }
        if (bVerify) {
            FSNameRegistrationHandler handlerObj = new FSNameRegistrationHandler();
            handlerObj.setHostedDescriptor(hostedProviderDesc);
            handlerObj.setHostedDescriptorConfig(hostedConfig);
            handlerObj.setHostedEntityId(hostedEntityId);
            handlerObj.setHostedProviderRole(hostedProviderRole);
            handlerObj.setMetaAlias(providerAlias);
            handlerObj.setRemoteEntityId(remoteEntityId);
            handlerObj.setRemoteDescriptor(remoteDesc);
            handlerObj.setRealm(realm);
            handlerObj.processRegistrationResponse(request, response, regisResponse);
            return;
        }
        FSUtils.debug.error("FSRegistrationReturnServlet Signature on registration request is invalidCannot proceed name registration");
        String[] data = new String[]{FSUtils.bundle.getString("registration-invalid-signature")};
        LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
        FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-request-improper", "registration-failed");
    }

    private boolean verifyResponseSignature(HttpServletRequest request, ProviderDescriptorType remoteDescriptor, String remoteEntityId, boolean isIDP) throws SAMLException, FSException {
        FSUtils.debug.message("Entered FSRegistrationRequestServlet::verifyRegistrationSignature");
        X509Certificate cert = KeyUtil.getVerificationCert(remoteDescriptor, remoteEntityId, isIDP);
        if (cert == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSRegistrationRequestServlet.verifyRegistrationSignature: couldn't obtain this site's cert.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
        }
        boolean isValidSign = FSSignatureUtil.verifyRequestSignature(request, cert);
        if (!isValidSign) {
            FSUtils.debug.error("Registration response is not properly signed");
            return false;
        }
        FSUtils.debug.message("Registration response is properly signed");
        return true;
    }

    protected void setRegistrationURL(BaseConfigType hostedConfig, String metaAlias) {
        COMMON_ERROR_PAGE = FSServiceUtils.getErrorPageURL(this.request, hostedConfig, metaAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }
}

