/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSRegistrationRequestServlet
extends HttpServlet {
    private static String COMMON_ERROR_PAGE = "";
    private IDFFMetaManager metaManager = null;
    private HttpServletRequest request = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("Entered FSRegistrationRequestServlet Init");
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    protected void setRegistrationURL(BaseConfigType hostedConfig, String metaAlias) {
        COMMON_ERROR_PAGE = FSServiceUtils.getErrorPageURL(this.request, hostedConfig, metaAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String providerAlias = FSServiceUtils.getMetaAlias(request);
        if (providerAlias == null || providerAlias.length() < 1) {
            FSUtils.debug.error("Unable to retrieve alias, Hosted Provider. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (this.metaManager == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
        ProviderDescriptorType hostedProviderDesc = null;
        BaseConfigType hostedConfig = null;
        String hostedEntityId = null;
        String hostedProviderRole = null;
        try {
            hostedProviderRole = this.metaManager.getProviderRoleByMetaAlias(providerAlias);
            hostedEntityId = this.metaManager.getEntityIDByMetaAlias(providerAlias);
            if (hostedProviderRole != null && hostedProviderRole.equalsIgnoreCase("IDP")) {
                hostedProviderDesc = this.metaManager.getIDPDescriptor(realm, hostedEntityId);
                hostedConfig = this.metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
            } else if (hostedProviderRole != null && hostedProviderRole.equalsIgnoreCase("SP")) {
                hostedProviderDesc = this.metaManager.getSPDescriptor(realm, hostedEntityId);
                hostedConfig = this.metaManager.getSPDescriptorConfig(realm, hostedEntityId);
            }
            if (hostedProviderDesc == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException eam) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = request;
        this.setRegistrationURL(hostedConfig, providerAlias);
        FSNameRegistrationRequest regisRequest = new FSNameRegistrationRequest();
        try {
            regisRequest = FSNameRegistrationRequest.parseURLEncodedRequest(request);
        }
        catch (FSMsgException e) {
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-request-improper", "registration-failed");
            return;
        }
        catch (SAMLException e) {
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-request-improper", "registration-failed");
            return;
        }
        if (regisRequest == null) {
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-request-improper", "registration-failed");
        } else {
            this.doRequestProcessing(request, response, hostedProviderDesc, hostedConfig, hostedProviderRole, realm, hostedEntityId, providerAlias, regisRequest);
        }
    }

    private void doRequestProcessing(HttpServletRequest request, HttpServletResponse response, ProviderDescriptorType hostedProviderDesc, BaseConfigType hostedConfig, String hostedProviderRole, String realm, String hostedEntityId, String providerAlias, FSNameRegistrationRequest regisRequest) {
        FSUtils.debug.message("Entered FSRegistrationRequestServlet::doRequestProcessing");
        String remoteEntityId = regisRequest.getProviderId();
        String retURL = null;
        ProviderDescriptorType remoteDesc = null;
        boolean isIDP = false;
        try {
            if (hostedProviderRole.equalsIgnoreCase("SP")) {
                remoteDesc = this.metaManager.getIDPDescriptor(realm, remoteEntityId);
                isIDP = true;
            } else {
                remoteDesc = this.metaManager.getSPDescriptor(realm, remoteEntityId);
            }
            retURL = remoteDesc.getRegisterNameIdentifierServiceReturnURL();
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("FSRegistrationRequestServlet.doRequest Processing: Can not retrieve remote provider data." + remoteEntityId);
            String[] data = new String[]{remoteEntityId, realm};
            LogUtil.error(Level.INFO, "INVALID_PROVIDER", data);
            FSServiceUtils.returnToSource(response, retURL, COMMON_ERROR_PAGE, "registration-failed", "metadata-error-check");
            return;
        }
        boolean bVerify = true;
        if (FSServiceUtils.isSigningOn()) {
            try {
                if (remoteDesc == null) {
                    FSUtils.debug.error("Cannot retrieve provider descriptor.");
                    String[] data = new String[]{remoteEntityId, realm};
                    LogUtil.error(Level.INFO, "INVALID_PROVIDER", data);
                    FSServiceUtils.returnToSource(response, retURL, COMMON_ERROR_PAGE, "registration-failed", "metadata-error-check");
                    return;
                }
                FSUtils.debug.message("Calling verifyRegistrationSignature");
                bVerify = this.verifyRegistrationSignature(request, remoteDesc, remoteEntityId, isIDP);
            }
            catch (FSException e) {
                FSUtils.debug.error("FSRegistrationRequestServlet::processRegistrationRequest Signature on registration request is invalidCannot proceed federation registration");
                String[] data = new String[]{FSUtils.bundle.getString("registration-invalid-signature")};
                LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
                FSServiceUtils.returnToSource(response, retURL, COMMON_ERROR_PAGE, "registration-failed", "metadata-error-check");
                return;
            }
            catch (SAMLException e) {
                FSUtils.debug.error("FSRegistrationRequestServlet::processRegistrationRequestSignature on registration request is invalidCannot proceed federation registration");
                String[] data = new String[]{FSUtils.bundle.getString("registration-invalid-signature")};
                LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
                FSServiceUtils.returnToSource(response, retURL, COMMON_ERROR_PAGE, "registration-failed", "metadata-error-check");
                return;
            }
        }
        if (bVerify) {
            if (this.metaManager.isTrustedProvider(realm, hostedEntityId, remoteEntityId)) {
                FSNameRegistrationHandler regisHandler = new FSNameRegistrationHandler();
                if (regisHandler != null) {
                    regisHandler.setHostedDescriptor(hostedProviderDesc);
                    regisHandler.setHostedDescriptorConfig(hostedConfig);
                    regisHandler.setRemoteDescriptor(remoteDesc);
                    regisHandler.setRemoteEntityId(remoteEntityId);
                    regisHandler.setHostedEntityId(hostedEntityId);
                    regisHandler.setHostedProviderRole(hostedProviderRole);
                    regisHandler.setMetaAlias(providerAlias);
                    regisHandler.setRealm(realm);
                    regisHandler.processRegistrationRequest(request, response, regisRequest);
                    return;
                }
                FSUtils.debug.error("Unable to get registration handler. User account Not valid");
            } else {
                FSUtils.debug.error("Remote provider not in trusted list");
            }
        } else {
            FSUtils.debug.error("FSRegistrationRequestServlet::doRequestProcesing Signature on registration request is invalidCannot proceed name registration");
            String[] data = new String[]{FSUtils.bundle.getString("registration-invalid-signature")};
            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
        }
        FSServiceUtils.returnToSource(response, retURL, COMMON_ERROR_PAGE, "registration-failed", "metadata-error-check");
    }

    private boolean verifyRegistrationSignature(HttpServletRequest request, ProviderDescriptorType remoteDescriptor, String remoteEntityId, boolean isIDP) throws SAMLException, FSException {
        FSUtils.debug.message("Entered FSRegistrationRequestServlet::verifyRegistrationSignature");
        X509Certificate cert = KeyUtil.getVerificationCert(remoteDescriptor, remoteEntityId, isIDP);
        if (cert == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSRegistrationRequestServlet.verifyRegistrationSignature:couldn't obtain this site's cert .");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
        }
        boolean isValidSign = FSSignatureUtil.verifyRequestSignature(request, cert);
        if (!isValidSign) {
            FSUtils.debug.error("Registration request is not properly signed");
            return false;
        }
        FSUtils.debug.message("Registration request is properly signed");
        return true;
    }
}

