/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.sun.identity.federation.common.FSUtils;
import java.util.HashMap;
import java.util.Map;

public final class FSRegistrationManager {
    private static Map instanceMap = new HashMap();
    private Map registrationRequestMap = new HashMap();

    private FSRegistrationManager() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSRegistrationManager(): Called. A new instance of FSRegistrationManager created");
        }
    }

    protected HashMap getRegistrationMap(String registrationId) {
        FSUtils.debug.message("FSRegistrationManager::getRegistrationMap");
        if (this.registrationRequestMap.containsKey(registrationId)) {
            return (HashMap)this.registrationRequestMap.get(registrationId);
        }
        return null;
    }

    protected void setRegistrationMapInfo(String registrationId, HashMap valMap) {
        FSUtils.debug.message("Entered FSRegistrationManager::setRegistrationMapInfo");
        this.removeRegistrationMapInfo(registrationId);
        this.registrationRequestMap.put(registrationId, valMap);
    }

    protected void removeRegistrationMapInfo(String registrationId) {
        FSUtils.debug.message("Entered FSRegistrationManager::removeRegistrationMapInfo");
        if (this.registrationRequestMap.containsKey(registrationId)) {
            this.registrationRequestMap.remove(registrationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FSRegistrationManager getInstance(String metaAlias) {
        FSUtils.debug.message("Entered FSRegistrationManager::getInstance");
        FSRegistrationManager instance = null;
        Class clazz = FSRegistrationManager.class;
        synchronized (clazz) {
            instance = (FSRegistrationManager)instanceMap.get(metaAlias);
            if (instance == null) {
                FSUtils.debug.message("Constructing a new instance of FSRegistrationManager");
                instance = new FSRegistrationManager();
                instanceMap.put(metaAlias, instance);
            }
            return instance;
        }
    }
}

