/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSRegistrationInitiationServlet
extends HttpServlet {
    private static String REGISTRATION_DONE_URL = "";
    private static String COMMON_ERROR_PAGE = "";
    private IDFFMetaManager metaManager = null;
    protected String locale = null;
    private HttpServletRequest request = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("Entered FSRegistrationInitiationServlet Init");
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    protected void setRegistrationURL(BaseConfigType hostedConfig, String metaAlias) {
        REGISTRATION_DONE_URL = FSServiceUtils.getRegistrationDonePageURL(this.request, hostedConfig, metaAlias);
        COMMON_ERROR_PAGE = FSServiceUtils.getErrorPageURL(this.request, hostedConfig, metaAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("REGISTRATION_DONE_URL : " + REGISTRATION_DONE_URL + "\nCOMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String providerAlias = request.getParameter("metaAlias");
        if (providerAlias == null || providerAlias.length() < 1) {
            FSUtils.debug.error("Unable to retrieve alias, Hosted Provider. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (this.metaManager == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        ProviderDescriptorType hostedProviderDesc = null;
        BaseConfigType hostedConfig = null;
        String hostedRole = null;
        String hostedEntityId = null;
        String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
        try {
            hostedRole = this.metaManager.getProviderRoleByMetaAlias(providerAlias);
            hostedEntityId = this.metaManager.getEntityIDByMetaAlias(providerAlias);
            if (hostedRole != null && hostedRole.equalsIgnoreCase("SP")) {
                hostedProviderDesc = this.metaManager.getSPDescriptor(realm, hostedEntityId);
                hostedConfig = this.metaManager.getSPDescriptorConfig(realm, hostedEntityId);
            } else if (hostedRole != null && hostedRole.equalsIgnoreCase("IDP")) {
                hostedProviderDesc = this.metaManager.getIDPDescriptor(realm, hostedEntityId);
                hostedConfig = this.metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
            }
            if (hostedProviderDesc == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException eam) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request", (Throwable)((Object)eam));
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = request;
        this.setRegistrationURL(hostedConfig, providerAlias);
        this.doRegistrationInitiation(request, response, hostedProviderDesc, hostedConfig, hostedEntityId, hostedRole, providerAlias);
    }

    private Object getValidToken(HttpServletRequest request) {
        FSUtils.debug.message("Entered FSRegistrationInitiationServlet::getValidToken");
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object ssoToken = sessionProvider.getSession(request);
            if (ssoToken == null || !sessionProvider.isValid(ssoToken)) {
                FSUtils.debug.error("Session is not valid redirecting for authentication");
                return null;
            }
            return ssoToken;
        }
        catch (SessionException e) {
            FSUtils.debug.error("SessionException caught: ", (Throwable)((Object)e));
            return null;
        }
    }

    private void doRegistrationInitiation(HttpServletRequest request, HttpServletResponse response, ProviderDescriptorType hostedProviderDesc, BaseConfigType hostedConfig, String hostedEntityId, String hostedRole, String hostedProviderAlias) {
        block14: {
            FSUtils.debug.message("Entered FSRegistrationInitiationServlet::doRegistrationInitiation");
            try {
                Object ssoToken = this.getValidToken(request);
                if (ssoToken != null) {
                    String providerId = request.getParameter("_liberty_id");
                    if (providerId == null || providerId.length() < 1) {
                        FSUtils.debug.error("Provider Id not found, display error page");
                        FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "registration-no-provider", "contact-admin");
                        return;
                    }
                    FSServiceManager instSManager = FSServiceManager.getInstance();
                    if (instSManager != null) {
                        SessionProvider sessionProvider;
                        FSNameRegistrationHandler handlerObj;
                        FSUtils.debug.message("FSServiceManager Instance not null");
                        String remoteProviderRole = "SP";
                        FSAccountFedInfo fedinfo = null;
                        if (hostedRole.equalsIgnoreCase("SP")) {
                            remoteProviderRole = "IDP";
                            FSSessionManager sessManager = FSSessionManager.getInstance(hostedProviderAlias);
                            FSSession ssoSession = sessManager.getSession(ssoToken);
                            if (ssoSession != null && !ssoSession.getOneTime()) {
                                fedinfo = ssoSession.getAccountFedInfo();
                            }
                        }
                        if ((handlerObj = instSManager.getNameRegistrationHandler(providerId, remoteProviderRole, (sessionProvider = SessionManager.getProvider()).getPrincipalName(ssoToken), hostedEntityId, hostedProviderAlias)) != null) {
                            handlerObj.setHostedDescriptor(hostedProviderDesc);
                            handlerObj.setHostedDescriptorConfig(hostedConfig);
                            handlerObj.setMetaAlias(hostedProviderAlias);
                            handlerObj.setHostedProviderRole(hostedRole);
                            handlerObj.setHostedEntityId(hostedEntityId);
                            if (fedinfo != null) {
                                handlerObj.setAccountInfo(fedinfo);
                            }
                            boolean bStatus = handlerObj.handleNameRegistration(request, response, ssoToken);
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("handleNameRegistration status is : " + bStatus);
                            }
                            return;
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Unable to get registration handler. User account Not valid");
                        }
                    } else {
                        FSUtils.debug.message("FSServiceManager Instance null");
                    }
                    FSServiceUtils.returnLocallyAfterOperation(response, REGISTRATION_DONE_URL, false, "regisSuccess", "regisFailure");
                    return;
                }
                FSServiceUtils.redirectForAuthentication(request, response, hostedProviderAlias);
                return;
            }
            catch (IOException e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("IOException in doRegistrationInitiation:", (Throwable)e);
                }
            }
            catch (SessionException ex) {
                if (!FSUtils.debug.messageEnabled()) break block14;
                FSUtils.debug.message("SessionException in doRegistrationInitiation", (Throwable)((Object)ex));
            }
        }
        FSServiceUtils.returnLocallyAfterOperation(response, REGISTRATION_DONE_URL, false, "regisSuccess", "regisFailure");
    }
}

