/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.namemapping;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSNameIdentifierMappingRequest;
import com.sun.identity.federation.message.FSNameIdentifierMappingResponse;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.xml.XMLUtils;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSNameMappingHandler {
    private FSAccountManager accountMgr = null;
    private String hostedEntityID = null;
    private ProviderDescriptorType hostedProviderDesc = null;
    private BaseConfigType hostedConfig = null;
    private String metaAlias = null;
    private String realm = null;
    private static IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();

    public FSNameMappingHandler(String entityID, ProviderDescriptorType hostedDesc, BaseConfigType hostedConfig, String metaAlias) {
        FSUtils.debug.message("FSNameMappingHandler: entering constructor");
        this.hostedEntityID = entityID;
        this.hostedProviderDesc = hostedDesc;
        this.hostedConfig = hostedConfig;
        this.metaAlias = metaAlias;
        this.realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        try {
            this.accountMgr = FSAccountManager.getInstance(metaAlias);
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.error("FSNameMappingHandler: " + FSUtils.bundle.getString("federation-failed-account-instance"));
        }
    }

    public NameIdentifier getNameIdentifier(String userID, String remoteEntityID, boolean local) throws FSAccountMgmtException, SAMLException {
        FSAccountFedInfo accountInfo = this.accountMgr.readAccountFedInfo(userID, remoteEntityID);
        NameIdentifier nameIdentifier = null;
        if (local) {
            NameIdentifier remoteNI;
            nameIdentifier = accountInfo.getLocalNameIdentifier();
            if (nameIdentifier == null && (remoteNI = accountInfo.getRemoteNameIdentifier()) != null) {
                nameIdentifier = new NameIdentifier(remoteNI.getName(), this.hostedEntityID, remoteNI.getFormat());
            }
        } else {
            NameIdentifier localNI;
            nameIdentifier = accountInfo.getRemoteNameIdentifier();
            if (nameIdentifier == null && (localNI = accountInfo.getLocalNameIdentifier()) != null) {
                nameIdentifier = new NameIdentifier(localNI.getName(), remoteEntityID, localNI.getFormat());
            }
        }
        if (nameIdentifier != null && (nameIdentifier.getFormat().length() == 0 || nameIdentifier.getFormat() == null)) {
            nameIdentifier.setFormat("urn:liberty:iff:nameid:federated");
        }
        return nameIdentifier;
    }

    public NameIdentifier getNameIdentifier(FSNameIdentifierMappingRequest mappingRequest, String remoteEntityID, boolean local) throws FSAccountMgmtException, SAMLException {
        FSAccountFedInfoKey acctkey = new FSAccountFedInfoKey(mappingRequest.getProviderID(), mappingRequest.getNameIdentifier().getName().trim());
        HashMap<String, FSNameIdentifierMappingRequest> env = new HashMap<String, FSNameIdentifierMappingRequest>();
        env.put("FSNameIdentifierMappingRequest", mappingRequest);
        String userID = this.accountMgr.getUserID(acctkey, this.realm, env);
        return this.getNameIdentifier(userID, remoteEntityID, local);
    }

    public static boolean verifyNameIdMappingResponseSignature(Element elt, SOAPMessage msg, String realm) {
        FSUtils.debug.message("FSNameMappingHandler.verifyNameIdMappingResponseSignature:Called");
        try {
            FSNameIdentifierMappingResponse nimRes = new FSNameIdentifierMappingResponse(elt);
            if (metaManager == null) {
                FSUtils.debug.error("FSNameMappingHandler.verifyNameIdMappingResponseSignature: Unable to get meta manager");
                return false;
            }
            String entityId = nimRes.getProviderID();
            X509Certificate cert = KeyUtil.getVerificationCert(metaManager.getIDPDescriptor(realm, entityId), entityId, true);
            if (cert == null) {
                FSUtils.debug.error("FSNameMappingHandler.verifyNameIdMappingResponseSignature: couldn't obtain the cert for signature verification.");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameMappingHandler.verifyNameIdMappingResponseSignature: Provider's cert is found.");
                FSUtils.debug.message("FSNameMappingHandler.verifyNameIdMappingResponseSignature:xmlString to be verified: " + XMLUtils.print((Node)elt));
            }
            Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            return manager.verifyXMLSignature(doc, cert);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSNameMappingHandler.verifyNameIdMappingResponseSignature: Exception occured while verifying signature:", (Throwable)e);
            return false;
        }
    }
}

