/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.multiprotocol.SingleLogoutManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSSingleLogoutHandler {
    private HttpServletResponse response = null;
    private HttpServletRequest request = null;
    private String locale = null;
    private String userID = null;
    private String sessionIndex = "";
    private boolean isWMLAgent = false;
    private boolean isCurrentProviderIDPRole;
    private IDFFMetaManager metaManager = null;
    private ProviderDescriptorType remoteDescriptor = null;
    private ProviderDescriptorType hostedDescriptor = null;
    private BaseConfigType hostedConfig = null;
    private static final char QUESTION_MARK = '?';
    private static final char AMPERSAND = '&';
    private static String LOGOUT_DONE_URL = null;
    private static String COMMON_ERROR_URL = null;
    private String remoteEntityId = "";
    private String realm = null;
    private String hostedEntityId = "";
    private String hostedRole = null;
    private String metaAlias = null;
    private String relayState = null;
    private boolean logoutStatus = true;
    private boolean isHttpRedirect = false;
    private Object ssoToken = null;
    private FSLogoutResponse respObj = null;
    private FSLogoutNotification requestLogout = null;
    private String singleLogoutProtocol = null;

    public FSSingleLogoutHandler() {
        FSUtils.debug.message("FSSingleLogoutHandler::Constructor");
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    protected void setLogoutURL() {
        LOGOUT_DONE_URL = FSServiceUtils.getLogoutDonePageURL(this.request, this.hostedConfig, this.metaAlias);
        COMMON_ERROR_URL = FSServiceUtils.getErrorPageURL(this.request, this.hostedConfig, this.metaAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("LOGOUT_DONE_URL : " + LOGOUT_DONE_URL + "\nCOMMON_ERROR_URL : " + COMMON_ERROR_URL);
        }
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setSingleLogoutProtocol(String protocol) {
        this.singleLogoutProtocol = protocol;
    }

    public FSLogoutStatus handleSingleLogout(HttpServletResponse response, HttpServletRequest request, FSSessionPartner currentSessionProvider, String userID, String sessionIndex, boolean isWMLAgent, Object ssoToken) {
        String strProfile;
        FSUtils.debug.message("Entered FSSingleLogoutHandler::handleSingleLogout");
        this.response = response;
        this.request = request;
        this.locale = FSServiceUtils.getLocale(request);
        this.setLogoutURL();
        this.userID = userID;
        this.sessionIndex = sessionIndex;
        this.isWMLAgent = isWMLAgent;
        if (currentSessionProvider != null) {
            this.isCurrentProviderIDPRole = currentSessionProvider.getIsRoleIDP();
            this.remoteEntityId = currentSessionProvider.getPartner();
            this.setRemoteDescriptor(this.getRemoteDescriptor(this.remoteEntityId));
        }
        this.ssoToken = ssoToken;
        this.singleLogoutProtocol = strProfile = this.getProfileToCommunicateLogout();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Communicating logout with provider " + this.remoteEntityId + " using profile " + strProfile);
        }
        FSUtils.debug.message("FSSingleLogoutHandler, in case 1");
        FSLogoutStatus bLogoutStatus = null;
        if (strProfile.equals("http://projectliberty.org/profiles/slo-sp-http") || strProfile.equals("http://projectliberty.org/profiles/slo-idp-http")) {
            FSUtils.debug.message("In redirect profile");
            try {
                String[] values = new String[]{"false"};
                SessionManager.getProvider().setProperty(ssoToken, "isSOAPProfile", values);
            }
            catch (UnsupportedOperationException ex) {
            }
            catch (SessionException ex) {
                // empty catch block
            }
            bLogoutStatus = this.doHttpRedirect(this.remoteEntityId);
        } else if (strProfile.equals("http://projectliberty.org/profiles/slo-idp-soap") || strProfile.equals("http://projectliberty.org/profiles/slo-sp-soap")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("In SOAP profile, current partner IDP? " + this.isCurrentProviderIDPRole);
            }
            try {
                String[] values = new String[]{"true"};
                SessionManager.getProvider().setProperty(ssoToken, "isSOAPProfile", values);
            }
            catch (UnsupportedOperationException ex) {
            }
            catch (SessionException ex) {
                // empty catch block
            }
            bLogoutStatus = this.doIDPSoapProfile(this.remoteEntityId);
        } else if (strProfile.equals("http://projectliberty.org/profiles/slo-idp-http-get") && !this.isCurrentProviderIDPRole) {
            FSUtils.debug.message("In GET profile");
            FSLogoutUtil.removeCurrentSessionPartner(this.metaAlias, this.remoteEntityId, ssoToken, userID);
            bLogoutStatus = this.doHttpGet(this.remoteEntityId);
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Single Logout Profile cannot be processed. Verify profile in metadata");
            }
            String[] data = new String[]{strProfile};
            LogUtil.error(Level.INFO, "LOGOUT_PROFILE_NOT_SUPPORTED", data);
            FSServiceUtils.returnLocallyAfterOperation(response, LOGOUT_DONE_URL, false, "logoutSuccess", "logoutFailure");
            return new FSLogoutStatus("samlp:Responder");
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Logout completed first round with status : " + bLogoutStatus);
        }
        if (!bLogoutStatus.getStatus().equalsIgnoreCase("samlp:Success")) {
            FSServiceUtils.returnLocallyAfterOperation(response, LOGOUT_DONE_URL, false, "logoutSuccess", "logoutFailure");
        }
        return bLogoutStatus;
    }

    private void continueLogout(boolean isSuccess) {
        FSUtils.debug.message("Entered FSSingleLogoutHandler::continueLogout");
        if (FSLogoutUtil.liveConnectionsExist(this.userID, this.metaAlias)) {
            FSUtils.debug.message("More liveConnectionsExist");
            HashMap providerMap = FSLogoutUtil.getCurrentProvider(this.userID, this.metaAlias, this.ssoToken);
            if (providerMap != null) {
                FSSessionPartner currentSessionProvider = (FSSessionPartner)providerMap.get("PartnerSession");
                this.sessionIndex = (String)providerMap.get("SessionIndex");
                if (currentSessionProvider != null) {
                    String currentEntityId = currentSessionProvider.getPartner();
                    this.isCurrentProviderIDPRole = currentSessionProvider.getIsRoleIDP();
                    ProviderDescriptorType currentDesc = null;
                    try {
                        currentDesc = this.isCurrentProviderIDPRole ? this.metaManager.getIDPDescriptor(this.realm, currentEntityId) : this.metaManager.getSPDescriptor(this.realm, currentEntityId);
                    }
                    catch (Exception e) {
                        FSUtils.debug.error("FSSingleLogoutHandler:cannot get meta:", (Throwable)e);
                    }
                    this.setRemoteDescriptor(currentDesc);
                    FSSessionManager sessionManager = FSSessionManager.getInstance(this.metaAlias);
                    FSSession session = sessionManager.getSession(sessionManager.getSessionList(this.userID), this.sessionIndex);
                    if (!this.supportSOAPProfile(this.remoteDescriptor)) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Single Logout Profile cannot be processed. Verify profile in metadata");
                        }
                        String[] data = new String[]{"http://projectliberty.org/profiles/slo-idp-soap"};
                        LogUtil.error(Level.INFO, "LOGOUT_PROFILE_NOT_SUPPORTED", data);
                        return;
                    }
                    FSUtils.debug.message("FSSLOHandler, SOAP in case 2");
                    if (this.doIDPSoapProfile(currentEntityId).getStatus().equalsIgnoreCase("samlp:Success") || !this.isCurrentProviderIDPRole) {
                        FSLogoutUtil.removeCurrentSessionPartner(this.metaAlias, currentEntityId, this.ssoToken, this.userID);
                        FSUtils.debug.message("SOAP partner removed, case 3");
                    }
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Reached else part  currentSessionProvider is null. nothing more to broadcast\nNo more providers, destroy usersession call destroyPrincipalSession");
                }
                FSLogoutUtil.destroyPrincipalSession(this.userID, this.metaAlias, this.sessionIndex, this.request, this.response);
                if (this.response != null) {
                    this.returnAfterCompletion();
                }
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("GetCurrentProvider returns null HashMap Clean session and return\nNo live connections, destroy user  session call destroyPrincipalSession");
            }
            FSLogoutUtil.destroyPrincipalSession(this.userID, this.metaAlias, this.sessionIndex, this.request, this.response);
            if (this.response != null) {
                this.returnAfterCompletion();
            }
            return;
        }
        FSUtils.debug.message("Reached else part in continuelogout");
        if (isSuccess || !this.isCurrentProviderIDPRole) {
            FSUtils.debug.message("No live connections, destroy session");
            FSLogoutUtil.destroyPrincipalSession(this.userID, this.metaAlias, this.sessionIndex, this.request, this.response);
        }
        this.callPostSingleLogoutSuccess(this.respObj, "http://projectliberty.org/profiles/slo-sp-soap");
        if (this.response != null) {
            this.returnAfterCompletion();
        }
    }

    private FSLogoutStatus doHttpRedirect(String entityId) {
        try {
            FSUtils.debug.message("In HTTP Redirect profile");
            this.isHttpRedirect = true;
            FSSessionManager sMgr = FSSessionManager.getInstance(this.metaAlias);
            FSSession session = sMgr.getSession(this.ssoToken);
            FSAccountFedInfo acctObj = null;
            if (session != null) {
                acctObj = session.getAccountFedInfo();
            }
            if (acctObj == null && !session.getOneTime()) {
                acctObj = FSLogoutUtil.getCurrentWorkingAccount(this.userID, entityId, this.metaAlias);
            }
            if (acctObj == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSingleLogoutHandler.doHttpRedirect: Account might have been terminated.");
                }
                return new FSLogoutStatus("samlp:Success");
            }
            FSLogoutNotification reqLogout = this.createSingleLogoutRequest(acctObj, this.sessionIndex);
            if (this.relayState != null) {
                reqLogout.setRelayState(this.relayState);
            }
            if (reqLogout == null) {
                FSUtils.debug.message("Logout Request is null");
                return new FSLogoutStatus("samlp:Requester");
            }
            reqLogout.setMinorVersion(this.getMinorVersion(this.remoteDescriptor));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSingleLogoutHandler::doHttpRedirect " + this.remoteDescriptor.getSingleLogoutServiceURL() + "\nLogout request: " + reqLogout.toXMLString());
            }
            String urlEncodedRequest = reqLogout.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Retrieving self certalias  : " + certAlias);
                }
                if (certAlias == null || certAlias.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSingleLogoutHandler:: doHttpRedirect: couldn't obtain this site's cert alias.");
                    }
                    return new FSLogoutStatus("samlp:Responder");
                }
                urlEncodedRequest = FSSignatureUtil.signAndReturnQueryString(urlEncodedRequest, certAlias);
            }
            StringBuffer redirectURL = new StringBuffer();
            String retURL = this.remoteDescriptor.getSingleLogoutServiceURL();
            FSUtils.debug.message("Encoded Redirect URL " + urlEncodedRequest);
            redirectURL.append(retURL);
            if (retURL.indexOf(63) == -1) {
                redirectURL.append('?');
            } else {
                redirectURL.append('&');
            }
            redirectURL.append(urlEncodedRequest);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSingleLogoutHandler::doHttpRedirect URL is " + redirectURL.toString());
            }
            this.response.sendRedirect(redirectURL.toString());
            return new FSLogoutStatus("samlp:Success");
        }
        catch (FSMsgException e) {
            FSUtils.debug.error("FSSingleLogoutHandler:: doHttpRedirect FSMsgException:", (Throwable)((Object)e));
        }
        catch (IOException e) {
            FSUtils.debug.error("FSSingleLogoutHandler::doHttpRedirect IOException:", (Throwable)e);
        }
        return new FSLogoutStatus("samlp:Responder");
    }

    protected void returnAfterCompletion() {
        block27: {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSSingleLogoutHandler::returnAC: PROTOCOL=" + this.singleLogoutProtocol + ", relayState=" + this.relayState);
            }
            try {
                String returnProviderId = "";
                String relayState = "";
                String logoutStatusString = "";
                String inResponseTo = "";
                FSReturnSessionManager mngInst = FSReturnSessionManager.getInstance(this.metaAlias);
                HashMap providerMap = new HashMap();
                if (mngInst != null) {
                    providerMap = mngInst.getUserProviderInfo(this.userID);
                }
                if (providerMap != null) {
                    returnProviderId = (String)providerMap.get("Provider");
                    relayState = (String)providerMap.get("RelayState");
                    logoutStatusString = (String)providerMap.get("logoutStatus");
                    if (logoutStatusString == null || logoutStatusString.length() == 0) {
                        logoutStatusString = "samlp:Success";
                    }
                    inResponseTo = (String)providerMap.get("responseTo");
                    mngInst.removeUserProviderInfo(this.userID);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Deleted " + returnProviderId + " from return list");
                    }
                    ProviderDescriptorType descriptor = null;
                    descriptor = this.hostedRole.equalsIgnoreCase("IDP") ? this.metaManager.getSPDescriptor(this.realm, returnProviderId) : this.metaManager.getIDPDescriptor(this.realm, returnProviderId);
                    String retURL = descriptor.getSingleLogoutServiceReturnURL();
                    if (retURL != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Getting provider " + returnProviderId + " IDP Return URL = " + retURL);
                        }
                        FSLogoutResponse responseLogout = new FSLogoutResponse();
                        responseLogout.setResponseTo(inResponseTo);
                        responseLogout.setRelayState(relayState);
                        responseLogout.setProviderId(this.hostedEntityId);
                        responseLogout.setStatus(logoutStatusString);
                        responseLogout.setID("logout-sig-ID");
                        responseLogout.setMinorVersion(this.getMinorVersion(descriptor));
                        responseLogout.setResponseID(FSUtils.generateID());
                        this.callPostSingleLogoutSuccess(responseLogout, "http://projectliberty.org/profiles/slo-idp-http");
                        if (MultiProtocolUtils.isMultipleProtocolSession(this.request, "idff") && this.hostedRole.equalsIgnoreCase("IDP") && !MultiProtocolUtils.isMultiProtocolRelayState(relayState)) {
                            int retStatus = this.handleMultiProtocolLogout(false, responseLogout.toXMLString(true, true), returnProviderId);
                            if (retStatus == 3) {
                                return;
                            }
                            if (retStatus == 2 || retStatus == 1) {
                                responseLogout.setStatus("samlp:Responder");
                            }
                        }
                        String urlEncodedResponse = responseLogout.toURLEncodedQueryString();
                        if (FSServiceUtils.isSigningOn()) {
                            String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                            if (certAlias == null || certAlias.length() == 0) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                                }
                                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                            }
                            urlEncodedResponse = FSSignatureUtil.signAndReturnQueryString(urlEncodedResponse, certAlias);
                        }
                        StringBuffer redirectURL = new StringBuffer();
                        redirectURL.append(retURL);
                        if (retURL.indexOf(63) == -1) {
                            redirectURL.append('?');
                        } else {
                            redirectURL.append('&');
                        }
                        redirectURL.append(urlEncodedResponse);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Response to be sent : " + redirectURL.toString());
                        }
                        String[] data = new String[]{this.userID};
                        LogUtil.access(Level.INFO, "LOGOUT_SUCCESS", data);
                        this.response.sendRedirect(redirectURL.toString());
                        return;
                    }
                    break block27;
                }
                FSUtils.debug.message("no source provider. return to local status page");
                if (this.singleLogoutProtocol != null && this.singleLogoutProtocol.equals("http://projectliberty.org/profiles/slo-idp-soap") && this.relayState != null && MultiProtocolUtils.isMultiProtocolRelayState(this.relayState)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSingleLogoutHandler::returnAC: this is multiProto for IDP initiated SOAP");
                    }
                    return;
                }
                if (MultiProtocolUtils.isMultipleProtocolSession(this.request, "idff") && this.hostedRole.equalsIgnoreCase("IDP") && !MultiProtocolUtils.isMultiProtocolRelayState(relayState)) {
                    int retStatus;
                    boolean isSOAPInitiated = false;
                    if (this.singleLogoutProtocol.equals("http://projectliberty.org/profiles/slo-idp-soap") || this.singleLogoutProtocol.equals("http://projectliberty.org/profiles/slo-sp-soap")) {
                        isSOAPInitiated = true;
                    }
                    if ((retStatus = this.handleMultiProtocolLogout(isSOAPInitiated, null, this.remoteEntityId)) == 3) {
                        return;
                    }
                    if (retStatus == 2 || retStatus == 1) {
                        this.logoutStatus = false;
                    }
                }
                if (this.logoutStatus) {
                    FSServiceUtils.returnLocallyAfterOperation(this.response, LOGOUT_DONE_URL, true, "logoutSuccess", "logoutFailure");
                }
                return;
            }
            catch (IDFFMetaException e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Unable to get LRURL. No location to redirect. processing completed");
                }
                String[] data = new String[]{FSUtils.bundle.getString("logout-redirect-failed")};
                LogUtil.error(Level.INFO, "LOGOUT_REDIRECT_FAILED", data);
            }
            catch (Exception ex) {
                String[] data = new String[]{FSUtils.bundle.getString("logout-redirect-failed")};
                LogUtil.error(Level.INFO, "LOGOUT_REDIRECT_FAILED", data);
            }
        }
    }

    private FSLogoutStatus doHttpGet(String providerId) {
        FSUtils.debug.message("doHttpGet - Entered");
        if (this.isWMLAgent) {
            return this.doWMLGet(providerId);
        }
        return this.doHTMLGet(providerId);
    }

    private FSLogoutStatus doWMLGet(String providerId) {
        try {
            FSUtils.debug.message("In WML based response");
            StringBuffer destination = new StringBuffer();
            destination.append(this.hostedDescriptor.getSingleLogoutServiceURL());
            if (destination.toString().indexOf(63) == -1) {
                destination.append('?');
            } else {
                destination.append('&');
            }
            destination.append("logoutSource=logoutGet");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Submit action : " + destination.toString());
            }
            this.response.setContentType("text/vnd.wap.wml");
            PrintWriter out = this.response.getWriter();
            out.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1");
            out.println("//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
            out.println("<wml>");
            out.println("<card id=\"redirect\" title=\"Log Out\">");
            out.println("<onenterforward>");
            out.println("<go method=\"post\" href=\"" + destination.toString() + "\">");
            FSUtils.debug.message("Calling getLogoutGETProviders");
            HashMap providerMap = FSLogoutUtil.getLogoutGETProviders(this.userID, providerId, this.sessionIndex, this.realm, this.metaAlias);
            Vector providerGetList = (Vector)providerMap.get("Provider");
            FSUtils.debug.message("Calling cleanSessionMapProviders");
            FSLogoutUtil.cleanSessionMapProviders(this.userID, providerGetList, this.metaAlias);
            FSUtils.debug.message("Calling getMultiLogoutRequest");
            String multiLogoutRequest = this.getMultiLogoutRequest(providerMap);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Image Statements : " + multiLogoutRequest);
            }
            out.println(multiLogoutRequest);
            out.println("</go>");
            out.println("</onenterforward>");
            out.println("<onenterbackward>");
            out.println("<prev/>");
            out.println("</onenterbackward>");
            out.println("<onenterbackward>");
            out.println("<p>");
            out.println("logout initiated ...");
            out.println("</p>");
            out.println("</card>");
            out.println("</wml>");
            out.close();
            return new FSLogoutStatus("samlp:Success");
        }
        catch (IOException e) {
            FSUtils.debug.error("Error in performing HTTP GET for WML agent:", (Throwable)e);
            return new FSLogoutStatus("samlp:Responder");
        }
    }

    private FSLogoutStatus doHTMLGet(String providerId) {
        try {
            FSUtils.debug.message("In HTML based response");
            StringBuffer destination = new StringBuffer();
            destination.append(this.hostedDescriptor.getSingleLogoutServiceURL());
            if (destination.toString().indexOf(63) == -1) {
                destination.append('?');
            } else {
                destination.append('&');
            }
            destination.append("logoutSource=logoutGet");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Submit action : " + destination.toString());
            }
            PrintWriter out = this.response.getWriter();
            this.response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>Logout in progress</TITLE></HEAD>");
            out.println("<BODY Onload=\"document.forms[0].submit()\">");
            out.println("<p><b> Logout in progress ...");
            out.println("If you have JavaScript disabled, please press the Continue button.");
            out.println("Otherwise, please wait.</p>");
            out.println("<FORM METHOD=\"POST\" ACTION=\"" + destination.toString() + "\">");
            out.println("<P>");
            FSUtils.debug.message("Calling getLogoutGETProviders");
            HashMap providerMap = FSLogoutUtil.getLogoutGETProviders(this.userID, providerId, this.sessionIndex, this.realm, this.metaAlias);
            Vector providerGetList = (Vector)providerMap.get("Provider");
            FSUtils.debug.message("Calling cleanSessionMapProviders");
            FSLogoutUtil.cleanSessionMapProviders(this.userID, providerGetList, this.metaAlias);
            FSUtils.debug.message("Calling getMultiLogoutRequest");
            String multiLogoutRequest = this.getMultiLogoutRequest(providerMap);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Image Statements : " + multiLogoutRequest);
            }
            out.println(multiLogoutRequest);
            out.println("<P><BR>");
            out.println("<input type=\"submit\" name=\"Continue\" ");
            out.println("value=\"Continue logout\"/>");
            out.println("</FORM></BODY></HTML>");
            out.close();
            return new FSLogoutStatus("samlp:Success");
        }
        catch (IOException e) {
            FSUtils.debug.error("Error in performing HTTP GET for regular agent");
            return new FSLogoutStatus("samlp:Responder");
        }
    }

    private String getMultiLogoutRequest(HashMap providerMap) {
        try {
            Vector providerList = (Vector)providerMap.get("Provider");
            HashMap sessionList = (HashMap)providerMap.get("SessionIndex");
            StringBuffer imgString = new StringBuffer();
            if (providerList != null) {
                for (int i = 0; i < providerList.size(); ++i) {
                    String providerId = (String)providerList.elementAt(i);
                    FSAccountFedInfo currentAccount = FSLogoutUtil.getCurrentWorkingAccount(this.userID, providerId, this.metaAlias);
                    FSLogoutNotification reqLogout = this.createSingleLogoutRequest(currentAccount, (String)sessionList.get(providerId));
                    SPDescriptorType descriptor = this.metaManager.getSPDescriptor(this.realm, providerId);
                    reqLogout.setMinorVersion(this.getMinorVersion(descriptor));
                    String urlEncodedRequest = reqLogout.toURLEncodedQueryString();
                    String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("certalias  : " + certAlias);
                    }
                    if (certAlias == null || certAlias.length() == 0) {
                        if (!FSUtils.debug.messageEnabled()) continue;
                        FSUtils.debug.message("FSSingleLogoutHandler getMultiLogoutRequest: couldn't obtain this site's cert alias.");
                        continue;
                    }
                    urlEncodedRequest = FSSignatureUtil.signAndReturnQueryString(urlEncodedRequest, certAlias);
                    StringBuffer redirectURL = new StringBuffer();
                    String retURL = descriptor.getSingleLogoutServiceURL();
                    redirectURL.append(retURL);
                    if (retURL.indexOf(63) == -1) {
                        redirectURL.append('?');
                    } else {
                        redirectURL.append('&');
                    }
                    redirectURL.append(urlEncodedRequest);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSingleLogoutHandler::doHttpRedirect URL is " + redirectURL.toString());
                    }
                    imgString.append("<IMG SRC=\"").append(redirectURL.toString()).append("\" />");
                }
                return imgString.toString();
            }
        }
        catch (FSMsgException e) {
            FSUtils.debug.error("FSSingleLogoutHandler::getMultiLogoutRequest FSMsgException", (Throwable)((Object)e));
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("FSSingleLogoutHandler::getMultiLogoutRequest  IDFFMetaException", (Throwable)((Object)e));
        }
        FSUtils.debug.error("Returning null from getMultiLogoutRequest");
        return null;
    }

    private FSLogoutStatus doIDPSoapProfile(String providerId) {
        FSLogoutStatus bSoapStatus;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSLOHandler.doIDPSoapProfile : providerId=" + providerId);
        }
        if ((bSoapStatus = this.doSoapProfile(providerId)).getStatus().equalsIgnoreCase("samlp:Success")) {
            FSUtils.debug.message("SOAP first round went fine. Calling continue logout");
            FSLogoutUtil.removeCurrentSessionPartner(this.metaAlias, providerId, this.ssoToken, this.userID);
            FSUtils.debug.message("SOAP partner removed in case of success");
        } else {
            FSUtils.debug.message("SOAP first round false. No continue logout");
            if (!this.isCurrentProviderIDPRole) {
                FSLogoutUtil.removeCurrentSessionPartner(this.metaAlias, providerId, this.ssoToken, this.userID);
            }
            this.logoutStatus = false;
        }
        if (!(this.isHttpRedirect || !this.logoutStatus && this.isCurrentProviderIDPRole)) {
            this.continueLogout(this.logoutStatus);
        }
        if (!this.isHttpRedirect) {
            FSUtils.debug.message("FSSLOHandler.doIDPSoapProfile: call MP/SOAP");
            try {
                if (SessionManager.getProvider().isValid(this.ssoToken) && MultiProtocolUtils.isMultipleProtocolSession(this.ssoToken, "idff")) {
                    int retStatus = this.handleMultiProtocolLogout(true, null, this.remoteEntityId);
                    this.logoutStatus = this.updateLogoutStatus(this.logoutStatus, retStatus);
                }
            }
            catch (SessionException ex) {
                FSUtils.debug.message("FSSLOHandler.doIDPSoapProfile2", (Throwable)((Object)ex));
            }
        }
        if (!this.logoutStatus) {
            return new FSLogoutStatus("samlp:Responder");
        }
        if (this.response != null && !this.isHttpRedirect) {
            this.returnAfterCompletion();
        }
        return bSoapStatus;
    }

    private boolean updateLogoutStatus(boolean logoutStatus, int retStatus) {
        boolean status = logoutStatus;
        switch (retStatus) {
            case 2: {
                status = false;
                break;
            }
            case 1: {
                status = false;
                break;
            }
        }
        return status;
    }

    private FSLogoutStatus doSoapProfile(String providerId) {
        block29: {
            FSUtils.debug.message("Entered IDP's doSoapProfile");
            try {
                FSSessionManager sMgr = FSSessionManager.getInstance(this.metaAlias);
                FSSession session = sMgr.getSession(this.ssoToken);
                FSAccountFedInfo currentAccount = null;
                if (session != null) {
                    currentAccount = session.getAccountFedInfo();
                }
                if (currentAccount == null && !session.getOneTime()) {
                    currentAccount = FSLogoutUtil.getCurrentWorkingAccount(this.userID, providerId, this.metaAlias);
                }
                if (currentAccount == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSingleLogoutHandler. User's account may have been terminated.");
                    }
                    return new FSLogoutStatus("samlp:Success");
                }
                FSLogoutNotification reqLogout = this.createSingleLogoutRequest(currentAccount, this.sessionIndex);
                reqLogout.setMinorVersion(this.getMinorVersion(this.remoteDescriptor));
                if (reqLogout != null) {
                    FSSOAPService instSOAP = FSSOAPService.getInstance();
                    if (instSOAP != null) {
                        SOAPMessage msgLogout;
                        FSUtils.debug.message("Signing suceeded. To call bindLogoutRequest");
                        reqLogout.setID("logout-sig-ID");
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("logout request before sign: " + reqLogout.toXMLString(true, true));
                        }
                        if ((msgLogout = instSOAP.bind(reqLogout.toXMLString(true, true))) != null) {
                            SOAPMessage retSOAPMessage = null;
                            try {
                                if (FSServiceUtils.isSigningOn()) {
                                    int minorVersion = reqLogout.getMinorVersion();
                                    switch (minorVersion) {
                                        case 0: {
                                            msgLogout = this.signLogoutRequest(msgLogout, "id", reqLogout.getID());
                                            break;
                                        }
                                        case 2: {
                                            msgLogout = this.signLogoutRequest(msgLogout, "RequestID", reqLogout.getRequestID());
                                            break;
                                        }
                                        default: {
                                            FSUtils.debug.message("invalid minor version.");
                                        }
                                    }
                                }
                                retSOAPMessage = instSOAP.sendMessage(msgLogout, this.remoteDescriptor.getSoapEndpoint());
                            }
                            catch (Exception e) {
                                FSUtils.debug.error("FSSOAPException in doSOAPProfile Cannot send request", (Throwable)e);
                                return new FSLogoutStatus("samlp:Responder");
                            }
                            if (retSOAPMessage != null) {
                                FederationSPAdapter spAdapter;
                                Element elt = instSOAP.parseSOAPMessage(retSOAPMessage);
                                if (FSServiceUtils.isSigningOn() && !this.verifyResponseSignature(retSOAPMessage)) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("Response signature verification failed");
                                    }
                                    FSServiceUtils.returnLocallyAfterOperation(this.response, LOGOUT_DONE_URL, false, "logoutSuccess", "logoutFailure");
                                    return new FSLogoutStatus("samlp:Requester");
                                }
                                this.requestLogout = reqLogout;
                                this.respObj = new FSLogoutResponse(elt);
                                if (this.hostedRole != null && this.hostedRole.equalsIgnoreCase("SP") && (spAdapter = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig)) != null) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("FSSLOHandler.preSingleLogoutProcess, SP/SOAP");
                                    }
                                    try {
                                        spAdapter.preSingleLogoutProcess(this.hostedEntityId, this.request, this.response, this.userID, reqLogout, this.respObj, "http://projectliberty.org/profiles/slo-sp-soap");
                                    }
                                    catch (Exception e) {
                                        FSUtils.debug.error("spAdapter.preSingleLogoutProcess, SP/SOAP:", (Throwable)e);
                                    }
                                }
                                Status status = this.respObj.getStatus();
                                StatusCode statusCode = status.getStatusCode();
                                StatusCode secondLevelStatus = statusCode.getStatusCode();
                                String statusString = statusCode.getValue();
                                if (statusString.equalsIgnoreCase("samlp:Success")) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("FSSingleLogoutHandler:  doSoapProfile returning success");
                                    }
                                    return new FSLogoutStatus("samlp:Success");
                                }
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSSingleLogoutHandler: SOAP Profile failure " + statusString);
                                }
                                return new FSLogoutStatus(statusString);
                            }
                        }
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to bindLogoutRequest.Current Provider cannot be processed");
                    }
                    break block29;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Unable to create logout request Current Provider cannot be processed");
                }
            }
            catch (Exception e) {
                FSUtils.debug.error("In IOException of doSOAPProfile : ", (Throwable)e);
            }
        }
        return new FSLogoutStatus("samlp:Responder");
    }

    private FSLogoutNotification createSingleLogoutRequest(FSAccountFedInfo acctInfo, String sessionIndex) {
        FSUtils.debug.message("Entered FSSingleLogoutHandler::createSingleLogoutRequest");
        FSLogoutNotification reqName = new FSLogoutNotification();
        if (reqName != null) {
            NameIdentifier nameIdentifier = acctInfo.getRemoteNameIdentifier();
            if (nameIdentifier == null) {
                nameIdentifier = acctInfo.getLocalNameIdentifier();
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Hosted Provider Id : " + this.hostedEntityId);
            }
            reqName.setProviderId(this.hostedEntityId);
            reqName.setNameIdentifier(nameIdentifier);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Session index is " + sessionIndex);
            }
            if (sessionIndex != null) {
                reqName.setSessionIndex(sessionIndex);
            }
            return reqName;
        }
        return null;
    }

    public void setHostedDescriptor(ProviderDescriptorType hostedProviderDesc) {
        this.hostedDescriptor = hostedProviderDesc;
    }

    public void setHostedDescriptorConfig(BaseConfigType hostedConfig) {
        this.hostedConfig = hostedConfig;
    }

    public void setHostedEntityId(String hostedEntityId) {
        this.hostedEntityId = hostedEntityId;
    }

    public void setHostedProviderRole(String hostedRole) {
        this.hostedRole = hostedRole;
    }

    public void setMetaAlias(String metaAlias) {
        this.metaAlias = metaAlias;
    }

    public void setRemoteDescriptor(ProviderDescriptorType remoteDesc) {
        this.remoteDescriptor = remoteDesc;
    }

    protected ProviderDescriptorType getRemoteDescriptor(String remoteEntityId) {
        if (remoteEntityId == null || remoteEntityId.length() == 0 || this.metaManager == null) {
            return null;
        }
        FSUtils.debug.message("FSSingleLogoutHandler :: getRemoteDescriptor...");
        ProviderDescriptorType providerDesc = null;
        try {
            providerDesc = this.isCurrentProviderIDPRole ? this.metaManager.getIDPDescriptor(this.realm, remoteEntityId) : this.metaManager.getSPDescriptor(this.realm, remoteEntityId);
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("FSSingleLogoutHandler:: getRemoteDescriptor failed:", (Throwable)((Object)e));
        }
        return providerDesc;
    }

    protected String getProfileToCommunicateLogout() {
        FSUtils.debug.message("FSSingleLogoutHandler :: getProfileToCommunicateLogout...");
        if (this.singleLogoutProtocol != null) {
            return this.singleLogoutProtocol;
        }
        String retProfileType = "";
        if (this.metaManager != null) {
            ProviderDescriptorType descriptor = this.remoteDescriptor;
            if (this.isCurrentProviderIDPRole) {
                FSUtils.debug.message("Local provider is SP");
                descriptor = this.hostedDescriptor;
            } else {
                FSUtils.debug.message("Local provider is IDP");
            }
            List profiles = descriptor.getSingleLogoutProtocolProfile();
            if (profiles != null && !profiles.isEmpty()) {
                retProfileType = (String)profiles.iterator().next();
            }
        }
        return retProfileType;
    }

    public FSLogoutStatus processHttpSingleLogoutRequest(HttpServletResponse response, HttpServletRequest request, FSLogoutNotification reqLogout, FSSessionPartner currentSessionProvider, String userID, String sourceEntityId, String sessionIndex, boolean isWMLAgent, String relayState, String isSourceIDP) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSSingleLogoutHandler:: processHttpSingleLogoutRequest - HTTP");
        }
        this.response = response;
        this.request = request;
        this.requestLogout = reqLogout;
        this.locale = FSServiceUtils.getLocale(request);
        this.setLogoutURL();
        if (currentSessionProvider != null) {
            this.isCurrentProviderIDPRole = currentSessionProvider.getIsRoleIDP();
            this.remoteEntityId = currentSessionProvider.getPartner();
            this.setRemoteDescriptor(this.getRemoteDescriptor(this.remoteEntityId));
        }
        this.userID = userID;
        this.sessionIndex = sessionIndex;
        this.isWMLAgent = isWMLAgent;
        if (reqLogout != null) {
            FSUtils.debug.message("FSLogoutNotification formed really well");
            FSReturnSessionManager localManager = FSReturnSessionManager.getInstance(this.metaAlias);
            if (localManager != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Added " + sourceEntityId + " top return list");
                }
                localManager.setUserProviderInfo(userID, sourceEntityId, isSourceIDP, relayState, reqLogout.getRequestID());
            } else {
                FSUtils.debug.message("Cannot get FSReturnSessionManager");
            }
            FSSessionManager sessionManager = FSSessionManager.getInstance(this.metaAlias);
            FSSession session = sessionManager.getSession(sessionManager.getSessionList(userID), sessionIndex);
            if (currentSessionProvider == null) {
                FSUtils.debug.message("currentSessionProvider is null. destroy and return");
                FSLogoutUtil.destroyPrincipalSession(userID, this.metaAlias, reqLogout.getSessionIndex(), request, response);
                this.returnAfterCompletion();
                return new FSLogoutStatus("samlp:Success");
            }
            String currentEntityId = currentSessionProvider.getPartner();
            this.isCurrentProviderIDPRole = currentSessionProvider.getIsRoleIDP();
            FSUtils.debug.message("FSSLOHandler, in case 3");
            FSLogoutUtil.cleanSessionMapPartnerList(userID, currentEntityId, this.metaAlias, session);
            FSLogoutStatus bLogoutStatus = null;
            List profiles = this.remoteDescriptor.getSingleLogoutProtocolProfile();
            if (profiles != null && (profiles.contains("http://projectliberty.org/profiles/slo-sp-http") || profiles.contains("http://projectliberty.org/profiles/slo-idp-http"))) {
                FSUtils.debug.message("In redirect profile");
                bLogoutStatus = this.doHttpRedirect(currentEntityId);
            } else if (profiles != null && profiles.contains("http://projectliberty.org/profiles/slo-idp-http-get") && !this.isCurrentProviderIDPRole) {
                FSUtils.debug.message("In GET profile");
                bLogoutStatus = this.doHttpGet(currentEntityId);
            } else {
                FSUtils.debug.error("Provider " + currentEntityId + "doesn't support HTTP profile.");
                this.returnAfterCompletion();
                bLogoutStatus = new FSLogoutStatus("samlp:Responder");
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Logout completed first round with status : " + bLogoutStatus);
            }
            return bLogoutStatus;
        }
        String[] data = new String[]{userID};
        LogUtil.error(Level.INFO, "LOGOUT_FAILED_REQUEST_IMPROPER", data);
        FSUtils.debug.message("Request not proper. Cannot proceed with single logout");
        this.returnAfterCompletion();
        return new FSLogoutStatus("samlp:Requester");
    }

    protected FSLogoutStatus processSingleLogoutRequest(FSLogoutNotification reqLogout, FSSessionPartner currentSessionProvider, String userID, String sourceEntityId, String sessionIndex, boolean isWMLAgent, String isSourceIDP) {
        FSUtils.debug.message("Entered FSSingleLogoutHandler::processSingleLogoutRequest - SOAP");
        if (currentSessionProvider != null) {
            this.isCurrentProviderIDPRole = currentSessionProvider.getIsRoleIDP();
            this.remoteEntityId = currentSessionProvider.getPartner();
            this.setRemoteDescriptor(this.getRemoteDescriptor(this.remoteEntityId));
        }
        this.requestLogout = reqLogout;
        this.userID = userID;
        this.sessionIndex = sessionIndex;
        this.isWMLAgent = isWMLAgent;
        if (reqLogout != null) {
            FSUtils.debug.message("FSLogoutNotification formed really well");
            if (currentSessionProvider == null) {
                FSUtils.debug.message("currentSessionProvider is null. destroy and return");
                Vector sessionObjList = FSLogoutUtil.getSessionObjectList(userID, this.metaAlias, sessionIndex);
                if (sessionObjList != null && !sessionObjList.isEmpty()) {
                    String sessid = ((FSSession)sessionObjList.get(0)).getSessionID();
                    try {
                        this.ssoToken = SessionManager.getProvider().getSession(sessid);
                    }
                    catch (SessionException ex) {
                        // empty catch block
                    }
                }
                FSLogoutUtil.destroyPrincipalSession(userID, this.metaAlias, reqLogout.getSessionIndex(), this.request, this.response);
                int retStatus = this.handleMultiProtocolLogout(true, null, sourceEntityId);
                if (retStatus == 2 || retStatus == 1) {
                    return new FSLogoutStatus("logoutFailure");
                }
                return new FSLogoutStatus("samlp:Success");
            }
            String currentEntityId = currentSessionProvider.getPartner();
            this.isCurrentProviderIDPRole = currentSessionProvider.getIsRoleIDP();
            if (!this.supportSOAPProfile(this.remoteDescriptor)) {
                return new FSLogoutStatus("lib:Unsupported");
            }
            FSSessionManager sessionManager = FSSessionManager.getInstance(this.metaAlias);
            FSSession session = sessionManager.getSession(sessionManager.getSessionList(userID), sessionIndex);
            FSUtils.debug.message("FSSLOHandler, process logout case 4");
            FSLogoutUtil.cleanSessionMapPartnerList(userID, currentEntityId, this.metaAlias, session);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Communicate with provider " + currentEntityId + " using soap profile.");
            }
            FSUtils.debug.message("In SOAP profile");
            FSLogoutStatus bLogoutStatus = this.doIDPSoapProfile(currentEntityId);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Logout completed first round with status : " + bLogoutStatus);
            }
            return bLogoutStatus;
        }
        String[] data = new String[]{userID};
        LogUtil.error(Level.INFO, "LOGOUT_FAILED_REQUEST_IMPROPER", data);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Request not proper Cannot proceed federation termination");
        }
        return new FSLogoutStatus("samlp:Requester");
    }

    private boolean supportSOAPProfile(ProviderDescriptorType currentDesc) {
        FSUtils.debug.message("Entered FSSingleLogoutHandler::supportSOAPProfile");
        if (currentDesc == null) {
            return false;
        }
        List profiles = currentDesc.getSingleLogoutProtocolProfile();
        return profiles != null && (profiles.contains("http://projectliberty.org/profiles/slo-idp-soap") || profiles.contains("http://projectliberty.org/profiles/slo-sp-soap"));
    }

    private SOAPMessage signLogoutRequest(SOAPMessage msg, String idAttrName, String id) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSSingleLogoutHandler::signLogoutRequest");
        String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
        if (certAlias == null || certAlias.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSingleLogoutHandler:: signLogoutRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSingleLogoutHandler::signLogoutRequest Provider's certAlias is found: " + certAlias);
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
        String xpath = "//*[local-name()='ProviderID']";
        manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), idAttrName, id, false, xpath);
        return FSServiceUtils.convertDOMToSOAP(doc);
    }

    private boolean verifyResponseSignature(SOAPMessage msg) {
        FSUtils.debug.message("Entered FSLogoutResponse::verifyResponseSignature");
        try {
            X509Certificate cert = KeyUtil.getVerificationCert(this.remoteDescriptor, this.remoteEntityId, !this.hostedRole.equalsIgnoreCase("IDP"));
            if (cert == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Logout.verifyResponseSignaturecouldn't obtain this site's cert.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
            }
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
            return manager.verifyXMLSignature(doc, cert);
        }
        catch (SAMLException e) {
            FSUtils.debug.error("Error in verifying response:", (Throwable)((Object)e));
            return false;
        }
    }

    private int getMinorVersion(ProviderDescriptorType descriptor) {
        try {
            if (descriptor != null) {
                return FSServiceUtils.getMinorVersion(descriptor.getProtocolSupportEnumeration());
            }
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSingleLogoutHandler.getMinorVersion:Error in getting in minor ver.", (Throwable)e);
        }
        return 0;
    }

    private void callPostSingleLogoutSuccess(FSLogoutResponse responseLogout, String sloProfile) {
        FederationSPAdapter spAdapter;
        if (this.hostedRole != null && this.hostedRole.equalsIgnoreCase("SP") && (spAdapter = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig)) != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSingleLogoutHandler, call postSingleLogoutSuccess");
            }
            try {
                spAdapter.postSingleLogoutSuccess(this.hostedEntityId, this.request, this.response, this.userID, this.requestLogout, responseLogout, sloProfile);
            }
            catch (Exception e) {
                FSUtils.debug.error("postSingleLogoutSuccess." + sloProfile, (Throwable)e);
            }
        }
    }

    private int handleMultiProtocolLogout(boolean isSOAPInited, String responseXML, String remoteSPId) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSLOHandler.handleMultiProtocolLogout: isSOAP initiated = " + isSOAPInited + ", response XML=" + responseXML);
        }
        if (this.ssoToken == null) {
            try {
                this.ssoToken = SessionManager.getProvider().getSession(this.request);
            }
            catch (SessionException ex) {
                FSUtils.debug.message("FSSLOHandler.handleMPLogout: null", (Throwable)((Object)ex));
                return 4;
            }
        }
        try {
            if (!SessionManager.getProvider().isValid(this.ssoToken)) {
                return 4;
            }
        }
        catch (SessionException ex) {
            FSUtils.debug.message("FSSLOHandler.handleMPLogout: invalid", (Throwable)((Object)ex));
            return 4;
        }
        HashSet<Object> set = new HashSet<Object>();
        set.add(this.ssoToken);
        int currentStatus = this.logoutStatus ? 0 : 2;
        int retStatus = 0;
        try {
            String requestXML = this.requestLogout == null ? null : this.requestLogout.toXMLString(true, true);
            String finalRelayState = this.relayState;
            if (finalRelayState == null || finalRelayState.length() == 0) {
                finalRelayState = LOGOUT_DONE_URL;
            }
            retStatus = SingleLogoutManager.getInstance().doIDPSingleLogout(set, this.userID, this.request, this.response, isSOAPInited, FSLogoutUtil.isIDPInitiatedProfile(this.singleLogoutProtocol), "idff", this.realm, this.hostedEntityId, remoteSPId, finalRelayState, requestXML, responseXML, currentStatus);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSLOHandler.doIDPProfile: MP/SOAP", (Throwable)e);
            retStatus = 2;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSLOHandler.handleMultiProtocolLogout: return status = " + retStatus);
        }
        return retStatus;
    }
}

