/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.common.FSUtils;
import java.util.HashMap;
import java.util.Map;
import netscape.ldap.util.DN;

public final class FSReturnSessionManager {
    private static Map instanceMap = new HashMap();
    private Map userAndProviderMap = new HashMap();

    private FSReturnSessionManager() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSReturnSessionManager(): Called. A new instance of FSReturnSessionManager created");
        }
    }

    public HashMap getUserProviderInfo(String userDN) {
        FSUtils.debug.message("FSReturnSessionManager::getUserProviderInfo");
        userDN = new DN(userDN).toRFCString().toLowerCase();
        return (HashMap)this.userAndProviderMap.get(userDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogoutStatus(String logoutStatus, String userDN) {
        HashMap userMap;
        FSUtils.debug.message("FSReturnSessionManager::setLogoutStatus");
        userDN = new DN(userDN).toRFCString().toLowerCase();
        if (userDN != null && (userMap = (HashMap)this.userAndProviderMap.get(userDN)) != null) {
            userMap.remove("logoutStatus");
            userMap.put("logoutStatus", logoutStatus);
            this.removeUserProviderInfo(userDN);
            Map map = this.userAndProviderMap;
            synchronized (map) {
                this.userAndProviderMap.put(userDN, userMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserProviderInfo(String userDN, String providerId, String isIDP, String relayState, String responseTo) {
        FSUtils.debug.message("Entered FSReturnSessionManager::setUserProviderInfo");
        userDN = new DN(userDN).toRFCString().toLowerCase();
        HashMap<String, String> valMap = new HashMap<String, String>();
        valMap.put("Provider", providerId);
        valMap.put("ROLE", isIDP);
        valMap.put("RelayState", relayState);
        valMap.put("responseTo", responseTo);
        this.removeUserProviderInfo(userDN);
        Map map = this.userAndProviderMap;
        synchronized (map) {
            this.userAndProviderMap.put(userDN, valMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserProviderInfo(String userDN) {
        FSUtils.debug.message("Entered FSReturnSessionManager::removeUserProviderInfo");
        userDN = new DN(userDN).toRFCString().toLowerCase();
        Map map = this.userAndProviderMap;
        synchronized (map) {
            this.userAndProviderMap.remove(userDN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSReturnSessionManager getInstance(String metaAlias) {
        FSUtils.debug.message("Entered FSReturnSessionManager::getInstance");
        FSReturnSessionManager instance = null;
        Class clazz = FSReturnSessionManager.class;
        synchronized (clazz) {
            instance = (FSReturnSessionManager)instanceMap.get(metaAlias);
            if (instance == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Constructing a new instance of FSReturnSessionManager");
                }
                instance = new FSReturnSessionManager();
                instanceMap.put(metaAlias, instance);
            }
            return instance;
        }
    }
}

