/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.Status;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSReturnLogoutServlet
extends HttpServlet {
    IDFFMetaManager metaManager = null;
    private static String COMMON_ERROR_PAGE = "";
    private String univId = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("FSReturnLogoutServlet Initializing...");
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher dispatcher;
        Status status;
        String logoutStatus;
        boolean isRemoteIDP;
        ProviderDescriptorType remoteDesc;
        String remoteEntityId;
        FSLogoutResponse logoutResponse;
        Object ssoToken;
        String providerAlias;
        block37: {
            FSUtils.debug.message("FSReturnLogoutServlet doGetPost...");
            providerAlias = request.getParameter("metaAlias");
            if (providerAlias == null || providerAlias.length() < 1) {
                providerAlias = FSServiceUtils.getMetaAlias(request);
            }
            if (providerAlias == null || providerAlias.length() < 1) {
                FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
                response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
                return;
            }
            ssoToken = null;
            try {
                SessionProvider sessionProvider = SessionManager.getProvider();
                ssoToken = sessionProvider.getSession(request);
                if (ssoToken == null || !sessionProvider.isValid(ssoToken)) {
                    FSUtils.debug.message("FSReturnLogoutRequest: Unable to get principal");
                    response.sendError(500, FSUtils.bundle.getString("nullSSOToken"));
                    return;
                }
                this.univId = sessionProvider.getPrincipalName(ssoToken);
            }
            catch (SessionException ssoExp) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSReturnLogoutRequest: Unable to get principal", (Throwable)((Object)ssoExp));
                }
                response.sendError(500, FSUtils.bundle.getString("nullSSOToken"));
                return;
            }
            if (this.metaManager == null) {
                FSUtils.debug.error("Failed to get meta manager");
                response.sendError(500, FSUtils.bundle.getString("federation-failed-meta-instance"));
                return;
            }
            String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
            String hostedRole = null;
            String hostedEntityId = null;
            BaseConfigType hostedConfig = null;
            try {
                hostedRole = this.metaManager.getProviderRoleByMetaAlias(providerAlias);
                hostedEntityId = this.metaManager.getEntityIDByMetaAlias(providerAlias);
                if (hostedRole != null) {
                    if (hostedRole.equalsIgnoreCase("IDP")) {
                        hostedConfig = this.metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
                    } else if (hostedRole.equalsIgnoreCase("SP")) {
                        hostedConfig = this.metaManager.getSPDescriptorConfig(realm, hostedEntityId);
                    }
                }
                if (hostedConfig == null) {
                    throw new IDFFMetaException((String)null);
                }
            }
            catch (IDFFMetaException e) {
                FSUtils.debug.error("Failed to get Hosted Provider");
                response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
                return;
            }
            this.setLogoutURL(request, hostedConfig, providerAlias);
            logoutResponse = null;
            try {
                logoutResponse = FSLogoutResponse.parseURLEncodedRequest(request);
            }
            catch (FSMsgException e) {
                FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "logout-request-improper", "logout-failed");
                return;
            }
            catch (SAMLException e) {
                FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "logout-request-improper", "logout-failed");
                return;
            }
            remoteEntityId = logoutResponse.getProviderId();
            remoteDesc = null;
            isRemoteIDP = false;
            try {
                if (hostedRole.equalsIgnoreCase("IDP")) {
                    remoteDesc = this.metaManager.getSPDescriptor(realm, remoteEntityId);
                } else if (hostedRole.equalsIgnoreCase("SP")) {
                    remoteDesc = this.metaManager.getIDPDescriptor(realm, remoteEntityId);
                    isRemoteIDP = true;
                }
            }
            catch (IDFFMetaException e) {
                if (!FSUtils.debug.messageEnabled()) break block37;
                FSUtils.debug.message("FSLogoutReturnServlet.doGetPost:", (Throwable)((Object)e));
            }
        }
        if (remoteDesc == null) {
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "logout-request-improper", "logout-failed");
            return;
        }
        boolean bVerify = true;
        if (FSServiceUtils.isSigningOn()) {
            try {
                bVerify = this.verifyResponseSignature(request, remoteDesc, remoteEntityId, isRemoteIDP);
            }
            catch (SAMLException e) {
                bVerify = false;
            }
            catch (FSException e) {
                bVerify = false;
            }
        }
        if ((logoutStatus = (status = logoutResponse.getStatus()).getStatusCode().getValue()).equalsIgnoreCase("samlp:Success") || !isRemoteIDP) {
            FSLogoutUtil.removeCurrentSessionPartner(providerAlias, remoteEntityId, ssoToken, this.univId);
        }
        if (bVerify) {
            if (!logoutStatus.equalsIgnoreCase("samlp:Success")) {
                FSReturnSessionManager localManager = FSReturnSessionManager.getInstance(providerAlias);
                if (localManager != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("update status of logout to failure  in session manager");
                    }
                    localManager.setLogoutStatus(logoutStatus, this.univId);
                } else {
                    FSUtils.debug.message("Cannot get FSReturnSessionManager");
                }
                FSUtils.debug.error("FSReturnLogoutServlet, failed logout response " + logoutStatus);
                String[] data = new String[]{this.univId};
                LogUtil.error(Level.INFO, "LOGOUT_FAILED", data);
                FSLogoutUtil.sendErrorPage(request, response, providerAlias);
                return;
            }
        } else {
            FSUtils.debug.error("FSReturnLogoutServlet Signature on logout response is invalidCannot proceed logout");
            String[] data = new String[]{this.univId};
            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
            FSServiceUtils.showErrorPage(response, COMMON_ERROR_PAGE, "logout-request-improper", "logout-failed");
            return;
        }
        StringBuffer processLogout = new StringBuffer();
        request.setAttribute("logoutSource", (Object)"remote");
        processLogout.append("/ProcessLogout").append("/").append("metaAlias").append(providerAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("About to get RequestDispatcher for " + processLogout.toString());
        }
        if ((dispatcher = this.getServletConfig().getServletContext().getRequestDispatcher(processLogout.toString())) == null) {
            FSUtils.debug.message("RequestDispatcher is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Unable to find " + processLogout + "\ncalling sendErrorPage ");
            }
            FSLogoutUtil.sendErrorPage(request, response, providerAlias);
            return;
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean verifyResponseSignature(HttpServletRequest request, ProviderDescriptorType remoteDescriptor, String remoteEntityId, boolean isRemoteIDP) throws SAMLException, FSException {
        FSUtils.debug.message("Entered FSReturnLogoutServlet::verifylogoutSignature");
        X509Certificate cert = KeyUtil.getVerificationCert(remoteDescriptor, remoteEntityId, isRemoteIDP);
        if (cert == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSReturnLogoutServlet.verifyRegistrationSignature: couldn't obtain this site's cert.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
        }
        boolean isValidSign = FSSignatureUtil.verifyRequestSignature(request, cert);
        if (!isValidSign) {
            FSUtils.debug.error("Logout response is not properly signed");
            return false;
        }
        FSUtils.debug.message("Logout response is properly signed");
        return true;
    }

    protected void setLogoutURL(HttpServletRequest request, BaseConfigType hostedConfig, String metaAlias) {
        COMMON_ERROR_PAGE = FSServiceUtils.getErrorPageURL(request, hostedConfig, metaAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }
}

