/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.encode.URLEncDec;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSSSOBrowserArtifactProfileHandler
extends FSSSOAndFedHandler {
    private Element samlRequestElement = null;
    private SOAPMessage soapMsg = null;

    public void setSOAPMessage(SOAPMessage msg) {
        this.soapMsg = msg;
    }

    public void setSAMLRequestElement(Element root) {
        FSUtils.debug.message("FSBrowserArtifactConsumerHandler.setSAMLRequestElement: Called");
        this.samlRequestElement = root;
    }

    protected FSSSOBrowserArtifactProfileHandler() {
    }

    public FSSSOBrowserArtifactProfileHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, SPDescriptorType spDescriptor, BaseConfigType spConfig, String spEntityId, String relayState) {
        super(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
    }

    public FSSSOBrowserArtifactProfileHandler(HttpServletRequest request, HttpServletResponse response, Request samlRequest) {
        this.request = request;
        this.response = response;
    }

    public void processAuthnRequest(FSAuthnRequest authnRequest, boolean bPostAuthn) {
        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: Called");
        try {
            if (bPostAuthn) {
                if (this.processPostAuthnSSO(authnRequest)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processingsuccessful");
                    }
                    return;
                }
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processing failed");
                }
                String[] data = new String[]{FSUtils.bundle.getString("AuthnRequestProcessingFailed")};
                LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", data);
                this.sendSAMLArtifacts(null);
                return;
            }
            boolean authnRequestSigned = this.spDescriptor.isAuthnRequestsSigned();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: ProviderID : " + this.spEntityId + " AuthnRequestSigned : " + authnRequestSigned);
            }
            if (FSServiceUtils.isSigningOn() && authnRequestSigned) {
                if (!this.verifyRequestSignature(authnRequest)) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Signature Verification Failed");
                    String[] data = new String[]{FSUtils.bundle.getString("signatureVerificationFailed")};
                    LogUtil.error(Level.INFO, "SIGNATURE VERIFICATION FAILED", data);
                    this.sendSAMLArtifacts(null);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Signature Verified");
                }
            }
            if (this.processPreAuthnSSO(authnRequest)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processing  successful");
                }
                return;
            }
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processing failed");
            }
            String[] data = new String[]{FSUtils.bundle.getString("AuthnRequestProcessingFailed")};
            LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", data);
            this.sendSAMLArtifacts(null);
            return;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: Exception Occured: ", (Throwable)e);
            this.sendSAMLArtifacts(null);
            return;
        }
    }

    public FSResponse processSAMLRequest(FSSAMLRequest samlRequest) {
        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processSAMLRequest: Called");
        try {
            return this.createSAMLResponse(samlRequest);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.processSAMLRequest: Fatal error, cannot create status or response: ", (Throwable)e);
            return null;
        }
    }

    private FSResponse createSAMLResponse(FSSAMLRequest samlRequest) throws FSException {
        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Called");
        FSResponse retResponse = null;
        String respID = FSUtils.generateID();
        String inResponseTo = samlRequest.getRequestID();
        ArrayList contents = new ArrayList();
        String message = null;
        String remoteAddr = this.request.getRemoteAddr();
        String respPrefix = FSUtils.bundle.getString("responseLogMessage") + " " + remoteAddr;
        int reqType = samlRequest.getContentType();
        if (reqType == -1) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Found element in the request which are not supported");
            }
            message = FSUtils.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), message, null);
                retResponse = new FSResponse(respID, inResponseTo, status, contents);
                retResponse.setMinorVersion(samlRequest.getMinorVersion());
            }
            catch (SAMLException se) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response: ", (Throwable)((Object)se));
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                String[] data = new String[]{respPrefix, retResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
            } else {
                String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
            }
            return retResponse;
        }
        FSAssertionManager am = null;
        try {
            am = FSAssertionManager.getInstance(this.metaAlias);
        }
        catch (FSException se) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Cannot instantiate FSAssertionManager");
            }
            message = se.getMessage();
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), message, null);
                retResponse = new FSResponse(respID, inResponseTo, status, contents);
                retResponse.setMinorVersion(samlRequest.getMinorVersion());
            }
            catch (SAMLException sse) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response: ", (Throwable)((Object)sse));
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                String[] data = new String[]{respPrefix, retResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
            } else {
                String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
            }
            return retResponse;
        }
        List artifacts = null;
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (reqType == 3) {
            artifacts = samlRequest.getAssertionArtifact();
            int length = artifacts.size();
            String sourceID = null;
            String providerID = null;
            AssertionArtifact art = null;
            for (int j = 0; j < length; ++j) {
                art = (AssertionArtifact)artifacts.get(j);
                if (sourceID != null) {
                    if (sourceID.equals(art.getSourceID())) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Artifacts not from the same source");
                    }
                    message = FSUtils.bundle.getString("mismatchSourceID");
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester", new StatusCode("lib:FederationDoesNotExist", null)), message, null);
                        retResponse = new FSResponse(respID, inResponseTo, status, contents);
                        retResponse.setMinorVersion(samlRequest.getMinorVersion());
                    }
                    catch (SAMLException ex) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response: ", (Throwable)((Object)ex));
                    }
                    if (LogUtil.isAccessLoggable(Level.FINER)) {
                        String[] data = new String[]{respPrefix, retResponse.toString()};
                        LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
                    } else {
                        String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
                        LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
                    }
                    return retResponse;
                }
                sourceID = art.getSourceID();
            }
            if (art != null) {
                try {
                    providerID = am.getDestIdForArtifact(art);
                }
                catch (FSException ex) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: FSException Occured while retrieving sp's providerID for the artifact: ", (Throwable)((Object)ex));
                    providerID = null;
                }
                if (providerID == null) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: artifact received does not correspond to any SP");
                    message = FSUtils.bundle.getString("invalidSource");
                    try {
                        Status sorig = am.getErrorStatus(art);
                        Status status = sorig != null ? sorig : new Status(new StatusCode("samlp:Requester", new StatusCode("lib:FederationDoesNotExist", null)), message, null);
                        retResponse = new FSResponse(respID, inResponseTo, status, contents);
                        retResponse.setMinorVersion(samlRequest.getMinorVersion());
                        return retResponse;
                    }
                    catch (SAMLException sse) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: ", (Throwable)((Object)sse));
                        return null;
                    }
                }
                try {
                    if (!metaManager.isTrustedProvider(this.realm, this.hostedEntityId, providerID)) {
                        FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                        message = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                        Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                        retResponse = new FSResponse(respID, inResponseTo, status, contents);
                        retResponse.setMinorVersion(samlRequest.getMinorVersion());
                        return retResponse;
                    }
                    this.spDescriptor = metaManager.getSPDescriptor(this.realm, providerID);
                    this.spEntityId = providerID;
                    remoteAddr = providerID;
                }
                catch (Exception ae) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: FSAllianceManagementException Occured while getting", (Throwable)ae);
                    message = ae.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                        retResponse = new FSResponse(respID, inResponseTo, status, contents);
                        retResponse.setMinorVersion(samlRequest.getMinorVersion());
                        return retResponse;
                    }
                    catch (SAMLException sse) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: ", (Throwable)((Object)sse));
                        return null;
                    }
                }
                if (FSServiceUtils.isSigningOn()) {
                    if (!this.verifySAMLRequestSignature(this.samlRequestElement, this.soapMsg)) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: SAMLRequest signature verification failed");
                        message = FSUtils.bundle.getString("signatureVerificationFailed");
                        try {
                            Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                            retResponse = new FSResponse(respID, inResponseTo, status, contents);
                            retResponse.setMinorVersion(samlRequest.getMinorVersion());
                            return retResponse;
                        }
                        catch (SAMLException sse) {
                            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: " + sse.getMessage());
                        }
                    } else if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtProfileHandler.createSAMLResp: SAMLRequest signature verified");
                    }
                }
            } else {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: No artifact found in samlRequest");
                message = FSUtils.bundle.getString("missingArtifact");
                try {
                    Status status = new Status(new StatusCode("samlp:Requester"), message, null);
                    retResponse = new FSResponse(respID, inResponseTo, status, contents);
                    retResponse.setMinorVersion(samlRequest.getMinorVersion());
                    return retResponse;
                }
                catch (SAMLException sse) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: ", (Throwable)((Object)sse));
                    return null;
                }
            }
            for (int i = 0; i < length; ++i) {
                AssertionArtifact artifact = (AssertionArtifact)artifacts.get(i);
                Assertion assertion = null;
                try {
                    assertion = am.getAssertion(artifact, this.spEntityId);
                }
                catch (FSException e) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:could not find matching assertion:", (Throwable)((Object)e));
                    }
                    message = e.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), message, null);
                        retResponse = new FSResponse(respID, inResponseTo, status, contents);
                        retResponse.setMinorVersion(samlRequest.getMinorVersion());
                    }
                    catch (SAMLException sse) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: ", (Throwable)((Object)sse));
                    }
                    if (LogUtil.isAccessLoggable(Level.FINER)) {
                        String[] data = new String[]{respPrefix, retResponse.toString()};
                        LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
                    } else {
                        String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
                        LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
                    }
                    return retResponse;
                }
                if (assertion == null) continue;
                assertions.add(i, assertion);
            }
        }
        int assertionSize = assertions.size();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: found " + assertionSize + "assertions.");
        }
        for (int i = 0; i < assertionSize; ++i) {
            Assertion assn = (Assertion)assertions.get(i);
            Conditions conds = assn.getConditions();
            Set trcs = conds.getAudienceRestrictionCondition();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: checking to see if assertions are for host:" + remoteAddr);
            }
            if (trcs == null || trcs.isEmpty()) continue;
            Iterator trcsIterator = trcs.iterator();
            while (trcsIterator.hasNext()) {
                if (((AudienceRestrictionCondition)trcsIterator.next()).containsAudience(remoteAddr)) continue;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: removing TRC notmeant for this host");
                }
                assertions.remove(assn);
            }
        }
        assertionSize = assertions.size();
        if (assertionSize == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Matching Assertions(s) not created for this host");
            }
            message = FSUtils.bundle.getString("mismatchDest");
            try {
                Status status = new Status(new StatusCode("samlp:Success"), message, null);
                retResponse = new FSResponse(respID, inResponseTo, status, contents);
                retResponse.setMinorVersion(samlRequest.getMinorVersion());
            }
            catch (SAMLException se) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:", (Throwable)((Object)se));
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                String[] data = new String[]{respPrefix, retResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
            } else {
                String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
            }
            return retResponse;
        }
        if (reqType == 3) {
            if (assertions.size() == artifacts.size()) {
                message = null;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Matching Assertion found");
                }
                try {
                    Status status = new Status(new StatusCode("samlp:Success"), message, null);
                    retResponse = new FSResponse(respID, inResponseTo, status, assertions);
                    retResponse.setMinorVersion(samlRequest.getMinorVersion());
                }
                catch (SAMLException se) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:", (Throwable)((Object)se));
                    return null;
                }
                catch (Exception e) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:", (Throwable)e);
                    return null;
                }
                if (LogUtil.isAccessLoggable(Level.FINER)) {
                    String[] data = new String[]{respPrefix, retResponse.toString()};
                    LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
                } else {
                    String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
                    LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
                }
                return retResponse;
            }
            message = FSUtils.bundle.getString("unequalMatch");
            try {
                Status status = new Status(new StatusCode("samlp:Success"), message, null);
                retResponse = new FSResponse(respID, inResponseTo, status, assertions);
                retResponse.setMinorVersion(samlRequest.getMinorVersion());
            }
            catch (SAMLException se) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:", (Throwable)((Object)se));
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                String[] data = new String[]{respPrefix, retResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
            } else {
                String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
            }
            return retResponse;
        }
        try {
            message = null;
            Status status = new Status(new StatusCode("samlp:Success"), message, null);
            retResponse = new FSResponse(respID, inResponseTo, status, assertions);
            retResponse.setMinorVersion(samlRequest.getMinorVersion());
        }
        catch (SAMLException se) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:", (Throwable)((Object)se));
        }
        if (LogUtil.isAccessLoggable(Level.FINER)) {
            String[] data = new String[]{respPrefix, retResponse.toString()};
            LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", data);
        } else {
            String[] data = new String[]{respPrefix, FSUtils.bundle.getString("responseID") + "=" + retResponse.getResponseID() + "," + FSUtils.bundle.getString("inResponseTo") + "=" + retResponse.getInResponseTo()};
            LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", data);
        }
        return retResponse;
    }

    protected boolean doSingleSignOn(Object ssoToken, String inResponseTo, NameIdentifier opaqueHandle, NameIdentifier idpOpaqueHandle) {
        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.doSingleSignOn: Called");
        List artList = this.createSAMLAssertionArtifact(ssoToken, inResponseTo, opaqueHandle, idpOpaqueHandle);
        this.sendSAMLArtifacts(artList);
        return true;
    }

    protected List createSAMLAssertionArtifact(Object ssoToken, String inResponseTo, NameIdentifier userHandle, NameIdentifier idpHandle) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLAssertionArtifact: Called");
        }
        ArrayList<String> artifactList = new ArrayList<String>();
        try {
            FSAssertionManager am = FSAssertionManager.getInstance(this.metaAlias);
            AssertionArtifact artifact = am.createFSAssertionArtifact(SessionManager.getProvider().getSessionID(ssoToken), this.realm, this.spEntityId, userHandle, idpHandle, inResponseTo, this.authnRequest.getMinorVersion());
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionArtifact id = " + artifact.toString());
            }
            String artid = artifact.getAssertionArtifact();
            artifactList.add(artid);
            return artifactList;
        }
        catch (FSException se) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLAssertionArtifact(0): ", (Throwable)((Object)se));
            return null;
        }
        catch (SAMLException se) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLAssertionArtifact(1): ", (Throwable)((Object)se));
            return null;
        }
        catch (SessionException se) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLAssertionArtifact(2): ", (Throwable)((Object)se));
            return null;
        }
    }

    private void sendSAMLArtifacts(List artis) {
        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: Called");
        if (artis == null) {
            artis = this.createFaultSAMLArtifact();
        }
        try {
            String targetURL = FSServiceUtils.getAssertionConsumerServiceURL(this.spDescriptor, this.authnRequest.getAssertionConsumerServiceID());
            StringBuffer sb = new StringBuffer(1000);
            if (artis == null || artis.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: Sending null artifact");
                }
                sb.append("SAMLart").append("=").append("&");
            } else {
                Iterator iter = artis.iterator();
                while (iter.hasNext()) {
                    String art = URLEncDec.encode((String)((String)iter.next()));
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: " + art);
                    }
                    sb.append("SAMLart").append("=").append(art).append("&");
                }
            }
            StringBuffer tmp = new StringBuffer(1000);
            if (targetURL.indexOf(63) == -1) {
                tmp.append(targetURL).append("?");
            } else {
                tmp.append(targetURL).append("&");
            }
            tmp.append(sb.toString());
            String relayURL = this.authnRequest.getRelayState();
            if (relayURL != null) {
                tmp.append("RelayState").append("=").append(URLEncDec.encode((String)relayURL));
            }
            this.response.setStatus(302);
            String redirecto = tmp.toString();
            this.response.setContentType("text/html");
            this.response.setHeader("Location", redirecto);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: Sending artifacts to: " + redirecto);
            }
            String[] data = new String[]{redirecto};
            LogUtil.access(Level.FINER, "REDIRECT_TO", data);
            this.response.sendRedirect(redirecto);
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: ", (Throwable)ex);
            return;
        }
    }

    private List createFaultSAMLArtifact() {
        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler. In createFaultSAMLArtifacts");
        String handle = SAMLUtils.generateAssertionHandle();
        if (handle == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.create FaultSAMLArtifacts: couldn't generate assertion handle.");
            }
            return null;
        }
        try {
            String sourceSuccinctID = FSUtils.generateSourceID(this.hostedEntityId);
            FSAssertionArtifact art = new FSAssertionArtifact(SAMLUtils.stringToByteArray(sourceSuccinctID), handle.getBytes("ISO-8859-1"));
            ArrayList<String> artis = new ArrayList<String>();
            artis.add(art.getAssertionArtifact());
            FSAssertionManager am = FSAssertionManager.getInstance(this.metaAlias);
            am.setErrStatus(art, this.noFedStatus);
            return artis;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSBrowserArtifactProfileHandler.createFaultSAMLArtifacts: ", (Throwable)e);
            return null;
        }
    }

    protected boolean verifySAMLRequestSignature(Element samlRequestElement, SOAPMessage msg) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.verifySAMLRequestSignature: Called");
        }
        try {
            X509Certificate cert = KeyUtil.getVerificationCert(this.spDescriptor, this.spEntityId, false);
            if (cert == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.verifySAMLRequestSignature: couldn't obtain this site's cert.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
            }
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
            return manager.verifyXMLSignature(doc, cert);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.verifySAMLRequestSignature: Exception occured while verifying IDP's signature:", (Throwable)e);
            return false;
        }
    }
}

