/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.common.Extension;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class FSSSOAndFedService
extends HttpServlet {
    private static FSSOAPService soapService = FSSOAPService.getInstance();
    private static MessageFactory msgFactory = null;
    private static IDFFMetaManager metaManager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            FSUtils.debug.error("FSSSOAndFedService.init: create message factory failed.", (Throwable)ex);
            throw new ServletException(ex.getMessage());
        }
        metaManager = FSUtils.getIDFFMetaManager();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IDPDescriptorConfigElement hostedConfig;
        IDPDescriptorType hostedDesc;
        String hostEntityId;
        String realm;
        String metaAlias;
        FSAuthnRequest authnRequest;
        boolean bLECP;
        boolean bPostAuthn;
        block13: {
            FSUtils.debug.message("FSSSOAndFedService.doGet: Called");
            if (request == null || response == null) {
                FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("nullInputParameter"));
                response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            bPostAuthn = false;
            bLECP = false;
            String authnIndicator = request.getParameter("Authn");
            if (authnIndicator != null) {
                FSUtils.debug.message("FSSSOAndFedService.doGet:Post Authentication SSO");
                bPostAuthn = true;
                String lecpIndicator = request.getParameter("LECP");
                if (lecpIndicator == null) {
                    FSUtils.debug.message("FSSSOAndFedService.doGet:non LECP request");
                    bLECP = false;
                } else {
                    FSUtils.debug.message("FSSSOAndFedService.doGet:post Authn LECP request");
                    bLECP = true;
                }
                String requestId = request.getParameter("RequestID");
                String hostEntityId2 = request.getParameter("_liberty_idp");
                String authnContext = request.getParameter("AuthnContext");
                String realm2 = request.getParameter("realm");
                String metaAlias2 = request.getParameter("metaAlias");
                FSSessionManager sessionService = FSSessionManager.getInstance(metaAlias2);
                FSAuthnRequest authnRequest2 = sessionService.getAuthnRequest(requestId);
                if (authnRequest2 == null) {
                    FSUtils.debug.message("FSSSOAndFedService.doGet: authnRequest is null");
                }
                if (authnContext == null || authnContext.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedService.doGet: authnContext is null. Using default password");
                    }
                    authnContext = "http://www.projectliberty.org/schemas/authctx/classes/Password";
                }
                if (authnRequest2 != null && realm2 != null && realm2.length() != 0 && hostEntityId2 != null && hostEntityId2.length() != 0 && authnContext != null && authnContext.length() != 0) {
                    this.handleAuthnRequest(request, response, authnRequest2, realm2, hostEntityId2, bLECP, authnContext);
                    return;
                }
                FSUtils.debug.error("FSSSOAndFedService.doGet: AuthnRequest not found in FSSessionManager");
                response.sendError(500, FSUtils.bundle.getString("nullInput"));
                return;
            }
            FSUtils.debug.message("FSSSOAndFedService.doGet:Pre Authentication SSO");
            bPostAuthn = false;
            authnRequest = null;
            try {
                authnRequest = FSAuthnRequest.parseURLEncodedRequest(request);
                if (authnRequest == null) {
                    FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("invalidAuthnRequest"));
                    String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnRequest")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_REQUEST", data);
                    response.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
                    return;
                }
            }
            catch (FSException e) {
                FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("invalidAuthnRequest") + ", queryString=" + request.getQueryString(), (Throwable)((Object)e));
                String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnRequest")};
                LogUtil.error(Level.INFO, "INVALID_AUTHN_REQUEST", data);
                response.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
                return;
            }
            metaAlias = null;
            realm = null;
            hostEntityId = null;
            hostedDesc = null;
            hostedConfig = null;
            try {
                metaAlias = FSServiceUtils.getMetaAlias(request);
                realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
                hostEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
                hostedDesc = metaManager.getIDPDescriptor(realm, hostEntityId);
                hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostEntityId);
            }
            catch (Exception e) {
                if (!FSUtils.debug.messageEnabled()) break block13;
                FSUtils.debug.message("FSSSOAndFedService: couldn't obtain hosted entity id:", (Throwable)e);
            }
        }
        this.handleAuthnRequest(request, response, authnRequest, bPostAuthn, bLECP, realm, hostEntityId, metaAlias, hostedDesc, hostedConfig);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IDPDescriptorConfigElement hostedConfig;
        IDPDescriptorType hostedDesc;
        String hostEntityId;
        String realm;
        String metaAlias;
        FSAuthnRequest authnRequest;
        block15: {
            FSUtils.debug.message("FSSSOAndFedService.doPost: Called");
            if (request == null || response == null) {
                response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            if (this.isLECPRequest(request)) {
                String useForward = (String)request.getAttribute("forwardrequest");
                if (useForward != null && useForward.equals("yes")) {
                    FSUtils.debug.message("FSSSOAndFedService.doPost: LECP forward");
                    this.doGet(request, response);
                } else {
                    try {
                        MimeHeaders mimeHeaders = SAMLUtils.getMimeHeaders(request);
                        ServletInputStream sInputStream = request.getInputStream();
                        SOAPMessage soapMessage = msgFactory.createMessage(mimeHeaders, (InputStream)sInputStream);
                        this.onMessage(request, response, soapMessage);
                    }
                    catch (SOAPException se) {
                        throw new ServletException((Throwable)se);
                    }
                }
                return;
            }
            String enocodedAuthnRequest = request.getParameter("LAREQ");
            if (enocodedAuthnRequest == null) {
                this.doGet(request, response);
                return;
            }
            enocodedAuthnRequest = enocodedAuthnRequest.replace(' ', '\n');
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService.doPost: BASE64 encoded AuthnRequest at the RECEIVER: " + enocodedAuthnRequest);
            }
            authnRequest = null;
            try {
                authnRequest = FSAuthnRequest.parseBASE64EncodedString(enocodedAuthnRequest);
                if (authnRequest == null) {
                    FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("invalidAuthnRequest"));
                    String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnRequest")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_REQUEST", data);
                    response.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedService: AuthnRequest received:" + authnRequest.toXMLString());
                }
            }
            catch (FSException e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedService: " + FSUtils.bundle.getString("invalidAuthnRequest"), (Throwable)((Object)e));
                }
                response.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
                return;
            }
            metaAlias = null;
            realm = null;
            hostEntityId = null;
            hostedDesc = null;
            hostedConfig = null;
            try {
                metaAlias = FSServiceUtils.getMetaAlias(request);
                realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
                hostEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
                hostedDesc = metaManager.getIDPDescriptor(realm, hostEntityId);
                hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostEntityId);
            }
            catch (Exception e) {
                if (!FSUtils.debug.messageEnabled()) break block15;
                FSUtils.debug.message("FSSSOAndFedService: couldn't obtain hosted entity id:", (Throwable)e);
            }
        }
        this.handleAuthnRequest(request, response, authnRequest, false, false, realm, hostEntityId, metaAlias, hostedDesc, hostedConfig);
    }

    private boolean isLECPRequest(HttpServletRequest request) {
        String lecpHeader = request.getHeader("Liberty-Enabled");
        if (lecpHeader != null) {
            FSUtils.debug.message("FSSSOAndFedService: is LECP request.");
            return true;
        }
        String contentType = request.getHeader("content-type");
        return contentType != null && contentType.startsWith("text/xml");
    }

    private void handleAuthnRequest(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, String realm, String hostEntityId, boolean bLECP, String authnContext) {
        String metaAlias;
        IDPDescriptorConfigElement hostedConfig;
        IDPDescriptorType hostedDesc;
        block14: {
            block13: {
                FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: Called");
                hostedDesc = null;
                hostedConfig = null;
                metaAlias = null;
                try {
                    hostedDesc = metaManager.getIDPDescriptor(realm, hostEntityId);
                    hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostEntityId);
                    if (hostedConfig != null) {
                        metaAlias = hostedConfig.getMetaAlias();
                    }
                }
                catch (Exception e) {
                    if (!FSUtils.debug.messageEnabled()) break block13;
                    FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: Couldn't obtain hosted meta:", (Throwable)e);
                }
            }
            Object ssoToken = null;
            String userID = null;
            try {
                SessionProvider sessionProvider = SessionManager.getProvider();
                ssoToken = sessionProvider.getSession(request);
                if (ssoToken == null) {
                    FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: session token is null.");
                    return;
                }
                if (!sessionProvider.isValid(ssoToken)) {
                    FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: session token is not valid.");
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: session token is valid.");
                }
                FSSessionManager sessionManager = FSSessionManager.getInstance(metaAlias);
                FSSession session = sessionManager.getSession(ssoToken);
                userID = sessionProvider.getPrincipalName(ssoToken);
                if (session == null) {
                    session = new FSSession(sessionProvider.getSessionID(ssoToken));
                    session.setAuthnContext(authnContext);
                    sessionManager.addSession(userID, session);
                } else {
                    session.setAuthnContext(authnContext);
                }
            }
            catch (SessionException se) {
                FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: ", (Throwable)((Object)se));
                return;
            }
            try {
                if (userID == null) {
                    LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, ssoToken);
                    return;
                }
                String remoteEntityID = authnRequest.getProviderId();
                FSAccountManager acctMng = FSAccountManager.getInstance(metaAlias);
                acctMng.readAccountFedInfo(userID, remoteEntityID);
            }
            catch (FSAccountMgmtException exp) {
                if (!FSUtils.debug.messageEnabled()) break block14;
                FSUtils.debug.message("FSSSOAndFedService:: handleAuthnRequest() No account information avialable for user. So no invocation  of name registration. ", (Throwable)((Object)exp));
            }
        }
        this.handleAuthnRequest(request, response, authnRequest, true, bLECP, realm, hostEntityId, metaAlias, hostedDesc, hostedConfig);
    }

    private void handleAuthnRequest(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, boolean bPostAuthn, boolean bLECP, String realm, String hostEntityId, String metaAlias, IDPDescriptorType hostedDesc, BaseConfigType hostedConfig) {
        FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: Called");
        try {
            SessionProvider provider = SessionManager.getProvider();
            Object session = provider.getSession(request);
            if (session != null && provider.isValid(session)) {
                MultiProtocolUtils.addFederationProtocol(session, "idff");
            }
        }
        catch (SessionException e) {
            FSUtils.debug.warning("FSSSOFedService.handleAuthnRequest: hub", (Throwable)((Object)e));
        }
        try {
            FSSessionManager sessionService;
            if (!bPostAuthn && !authnRequest.getIsPassive()) {
                sessionService = FSSessionManager.getInstance(metaAlias);
                sessionService.setAuthnRequest(authnRequest.getRequestID(), authnRequest);
            } else {
                sessionService = FSSessionManager.getInstance(metaAlias);
                sessionService.removeAuthnRequest(authnRequest.getRequestID());
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: Trying to handle AuthnRequest message: " + authnRequest.toXMLString());
                List extensions = authnRequest.getExtensions();
                if (extensions != null && !extensions.isEmpty()) {
                    FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: AuthnRequest extensions: " + ((Extension)extensions.get(0)).getAttributeMap());
                }
            }
            FSServiceManager sm = FSServiceManager.getInstance();
            FSSSOAndFedHandler handler = null;
            handler = !bLECP ? sm.getSSOAndFedHandler(request, response, authnRequest, realm) : sm.getLECPProfileHandler(request, response, authnRequest, realm);
            if (handler == null) {
                FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: could not create SSOAndFedHandler");
                String[] data = new String[]{FSUtils.bundle.getString("requestProcessingFailed")};
                LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", data);
                response.sendError(500, FSUtils.bundle.getString("requestProcessingFailed"));
                return;
            }
            handler.setHostedEntityId(hostEntityId);
            handler.setMetaAlias(metaAlias);
            handler.setHostedDescriptor(hostedDesc);
            handler.setHostedDescriptorConfig(hostedConfig);
            handler.setRealm(realm);
            handler.processAuthnRequest(authnRequest, bPostAuthn);
            return;
        }
        catch (Exception se) {
            FSUtils.debug.error("FSSSOAndFedService: Exception occured:", (Throwable)se);
            try {
                response.sendError(500, se.getMessage());
            }
            catch (IOException ex) {
                FSUtils.debug.error("FSSSOAndFedService: Exception occured " + ex.getMessage());
            }
            return;
        }
    }

    public void onMessage(HttpServletRequest request, HttpServletResponse response, SOAPMessage message) {
        FSUtils.debug.message("FSSSOAndFedService.onMessage: Called");
        try {
            Element elt = soapService.parseSOAPMessage(message);
            if (elt == null) {
                FSUtils.debug.error("FSSSOAndFedService.onMessage: Error in processing. Invalid SOAPMessage");
                response.setStatus(500);
                this.returnSOAPMessage(soapService.formSOAPError("Server", "cannotProcessRequest", null), response);
                return;
            }
            String eltTagName = elt.getTagName().trim();
            String ns = elt.getNamespaceURI().trim();
            String nodeName = elt.getLocalName().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService.onMessage: tagName: " + eltTagName + " namespaceUri: " + ns + " localName: " + nodeName);
            }
            if (nodeName.equalsIgnoreCase("AuthnRequest") && ns.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12") || ns.equalsIgnoreCase("urn:liberty:iff:2003-08")) {
                SOAPMessage retMessage = null;
                try {
                    FSAuthnRequest authnRequest = new FSAuthnRequest(elt);
                    String metaAlias = FSServiceUtils.getMetaAlias(request);
                    IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                    String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
                    String hostEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
                    IDPDescriptorType hostedDesc = metaManager.getIDPDescriptor(realm, hostEntityId);
                    IDPDescriptorConfigElement hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostEntityId);
                    FSSessionManager sessionService = FSSessionManager.getInstance(metaAlias);
                    sessionService.setAuthnRequest(authnRequest.getRequestID(), authnRequest);
                    this.handleLECPRequest(request, response, authnRequest, hostedDesc, hostedConfig, realm, hostEntityId, metaAlias);
                    retMessage = null;
                }
                catch (Exception e) {
                    FSUtils.debug.error("FSSSOAndFedService.onMessage: Error in processing lecp AuthnRequest:", (Throwable)e);
                    response.setStatus(500);
                    this.returnSOAPMessage(soapService.formSOAPError("Server", "cannotProcessRequest", null), response);
                    return;
                }
                this.returnSOAPMessage(retMessage, response);
                return;
            }
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Invalid SOAP Request:" + nodeName);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Error in processing Request: Exception occured: ", (Throwable)e);
            response.setStatus(500);
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(strm));
            FSUtils.debug.error(strm.toString());
            this.returnSOAPMessage(soapService.formSOAPError("Server", "cannotProcessRequest", null), response);
            return;
        }
        this.returnSOAPMessage(soapService.formSOAPError("Server", "cannotProcessRequest", null), response);
    }

    private void handleLECPRequest(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, IDPDescriptorType hostedDesc, BaseConfigType hostedConfig, String realm, String hostEntityId, String metaAlias) {
        FSUtils.debug.message("FSSSOAndFedService.handleLECPRequest:");
        try {
            FSServiceManager sm = FSServiceManager.getInstance();
            FSSSOLECPProfileHandler handler = sm.getLECPProfileHandler(request, response, authnRequest, realm);
            handler.setHostedEntityId(hostEntityId);
            handler.setMetaAlias(metaAlias);
            handler.setHostedDescriptor(hostedDesc);
            handler.setHostedDescriptorConfig(hostedConfig);
            handler.setRealm(realm);
            handler.processLECPAuthnRequest(authnRequest);
        }
        catch (Exception se) {
            FSUtils.debug.error("FSSSOAndFedService.handleLECPRequest: processing LECP request failed." + se);
            return;
        }
    }

    private void returnSOAPMessage(SOAPMessage msg, HttpServletResponse response) {
        try {
            if (msg != null) {
                SAMLUtils.setMimeHeaders(msg.getMimeHeaders(), response);
                ServletOutputStream servletoutputstream = response.getOutputStream();
                msg.writeTo((OutputStream)servletoutputstream);
                servletoutputstream.flush();
                return;
            }
            response.flushBuffer();
            return;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOAndFedService.returnSOAPMessage: Exception::", (Throwable)e);
            return;
        }
    }
}

