/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.common.PeriodicGroupRunnable;
import com.sun.identity.common.ScheduleableGroupAction;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.TimerPool;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSAttributeMapper;
import com.sun.identity.federation.services.FSRealmAttributeMapper;
import com.sun.identity.federation.services.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.fednsso.FSProxyHandler;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.POSTCleanUpRunnable;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.encode.CookieUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSAssertionArtifactHandler {
    private String idpSessionIndex = null;
    private Date reAuthnOnOrAfterDate = null;
    private AuthnContext authnContextStmt = null;
    private List cookieDomainList = FSServiceUtils.getCookieDomainList();
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected IDPDescriptorType idpDescriptor = null;
    protected String idpEntityId = null;
    protected FSAuthnRequest authnRequest = null;
    protected String relayState = null;
    protected static Map idTimeMap = Collections.synchronizedMap(new HashMap());
    private static TaskRunnable cGoThrough = null;
    private static TaskRunnable cPeriodic = null;
    protected boolean doFederate = false;
    protected String nameIDPolicy = null;
    protected AttributeStatement bootStrapStatement = null;
    protected AttributeStatement _autoFedStatement = null;
    protected Map autoFedSearchMap = null;
    protected List securityAssertions = null;
    protected Object ssoToken = null;
    protected FSAuthnResponse authnResponse = null;
    protected Element samlResponseElt = null;
    protected List attrStatements = new ArrayList();
    protected SPDescriptorType hostDesc = null;
    protected BaseConfigType hostConfig = null;
    protected String realm = null;
    protected String hostEntityId = null;
    protected String hostMetaAlias = null;
    protected static String ANONYMOUS_PRINCIPAL = "anonymous";
    protected FSAttributeMapper attributeMapper = null;
    protected FSRealmAttributeMapper realmAttributeMapper = null;
    protected FSResponse samlResponse = null;

    public void setHostEntityId(String entityId) {
        this.hostEntityId = entityId;
    }

    public void setHostDescriptor(SPDescriptorType desc) {
        this.hostDesc = desc;
    }

    public void setHostDescriptorConfig(BaseConfigType config) {
        this.hostConfig = config;
    }

    public void setMetaAlias(String metaAlias) {
        this.hostMetaAlias = metaAlias;
    }

    public String getHostEntityId() {
        return this.hostEntityId;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public FSAuthnRequest getAuthnRequest() {
        return this.authnRequest;
    }

    public void setAuthnRequest(FSAuthnRequest authnRequest) {
        this.authnRequest = authnRequest;
    }

    protected FSAssertionArtifactHandler() {
    }

    public FSAssertionArtifactHandler(HttpServletRequest request, HttpServletResponse response, IDPDescriptorType idpDescriptor, String idpEntityId, boolean doFederate, String nameIDPolicy, String relayState) {
        this.request = request;
        this.response = response;
        this.relayState = relayState;
        this.idpDescriptor = idpDescriptor;
        this.idpEntityId = idpEntityId;
        this.doFederate = doFederate;
        this.nameIDPolicy = nameIDPolicy;
    }

    public FSAssertionArtifactHandler(HttpServletRequest request, HttpServletResponse response, IDPDescriptorType idpDescriptor, String idpEntityId, FSAuthnRequest authnRequest, boolean doFederate, String relayState) {
        this.request = request;
        this.response = response;
        this.relayState = relayState;
        this.idpDescriptor = idpDescriptor;
        this.idpEntityId = idpEntityId;
        if (authnRequest != null) {
            this.authnRequest = authnRequest;
            this.nameIDPolicy = authnRequest.getNameIDPolicy();
        }
        this.doFederate = doFederate;
    }

    public void processAuthnResponse(FSAuthnResponse authnResponse) {
        block39: {
            FSUtils.debug.message("FSAssertionArtifactHandler.ProcessAuthnResponse: Called");
            this.authnResponse = authnResponse;
            FederationSPAdapter spAdapter = FSServiceUtils.getSPAdapter(this.hostEntityId, this.hostConfig);
            if (spAdapter != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler, POST Invokde spAdapter.preSSOFederationProcess");
                }
                try {
                    spAdapter.preSSOFederationProcess(this.hostEntityId, this.request, this.response, this.authnRequest, authnResponse, null);
                }
                catch (Exception e) {
                    FSUtils.debug.error("FSAssertionArtifactHandler SPAdapter.preSSOFederationSuccess", (Throwable)e);
                }
            }
            String baseURL = FSServiceUtils.getBaseURL(this.request);
            String framedLoginPageURL = FSServiceUtils.getCommonLoginPageURL(this.hostMetaAlias, this.authnRequest.getRelayState(), null, this.request, baseURL);
            this.relayState = this.authnRequest.getRelayState();
            if (this.relayState == null || this.relayState.trim().length() == 0) {
                this.relayState = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "providerHomePageURL");
                if (this.relayState == null || this.relayState.trim().length() == 0) {
                    this.relayState = baseURL + "/samples/idff/sp/index.jsp";
                }
            }
            try {
                int handleType;
                boolean valid;
                if (authnResponse == null) {
                    String[] data = new String[]{FSUtils.bundle.getString("missingAuthnResponse")};
                    LogUtil.error(Level.INFO, "MISSING_AUTHN_RESPONSE", data);
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("missingAuthnResponse") + " AuthnRequest Processing Failed at the IDP " + "Redirecting to the Framed Login Page");
                    this.response.sendRedirect(framedLoginPageURL);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doPost:Received " + authnResponse.toXMLString());
                }
                if (!(valid = this.verifyResponseStatus(authnResponse))) {
                    FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
                    String inResponseTo = authnResponse.getInResponseTo();
                    sessionManager.removeAuthnRequest(inResponseTo);
                    String[] data = new String[]{authnResponse.toXMLString()};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
                    FSUtils.debug.warning("FSAssertionArtifactHandler. processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostEntityId, this.request, this.response, this.authnRequest, authnResponse, null, 1)) {
                        this.response.sendRedirect(framedLoginPageURL);
                    }
                    return;
                }
                List assertions = authnResponse.getAssertion();
                FSSubject validSubject = (FSSubject)this.validateAssertions(assertions);
                if (validSubject == null) {
                    String[] data = new String[]{FSUtils.bundle.getString("invalidAssertion")};
                    LogUtil.error(Level.INFO, "INVALID_ASSERTION", data);
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("InvalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(framedLoginPageURL);
                    return;
                }
                FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
                if (this.doFederate) {
                    NameIdentifier ni;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Initiate Account Federation");
                    }
                    if ((ni = validSubject.getIDPProvidedNameIdentifier()) == null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: IDPProvided NameIdentifier is null");
                        }
                        ni = validSubject.getNameIdentifier();
                    }
                    if (ni != null) {
                        int returnCode = this.doAccountFederation(ni);
                        if (returnCode == 0) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Account federation successful");
                            }
                            String inResponseTo = authnResponse.getInResponseTo();
                            sessionManager.removeAuthnRequest(inResponseTo);
                            sessionManager.removeLocalSessionToken(inResponseTo);
                            return;
                        }
                        String[] data = new String[]{FSUtils.bundle.getString("AccountFederationFailed")};
                        LogUtil.error(Level.INFO, "ACCOUNT_FEDERATION_FAILED", data);
                        FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("AccountFederationFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                        if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostEntityId, this.request, this.response, this.authnRequest, authnResponse, this.samlResponse, returnCode)) {
                            this.response.sendRedirect(framedLoginPageURL);
                        }
                        break block39;
                    }
                    throw new FSException("missingNIofSubject", null);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Initiate SingleSign-On");
                }
                NameIdentifier niIdp = validSubject.getIDPProvidedNameIdentifier();
                NameIdentifier ni = validSubject.getNameIdentifier();
                if (niIdp == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: IDPProvided NameIdentifier is null");
                    }
                    niIdp = ni;
                }
                if (niIdp == null || ni == null) {
                    String[] data = new String[]{FSUtils.bundle.getString("invalidResponse")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
                    FSUtils.debug.error("FSAssertionArtifactHandler. processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(framedLoginPageURL);
                    return;
                }
                String idpHandle = niIdp.getName();
                String spHandle = ni.getName();
                if (idpHandle == null || spHandle == null) {
                    String[] data = new String[]{FSUtils.bundle.getString("invalidResponse")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(framedLoginPageURL);
                    return;
                }
                if (idpHandle.equals(spHandle)) {
                    ni = niIdp;
                    handleType = 1;
                } else {
                    handleType = 0;
                }
                HashMap<String, FSAuthnResponse> env = new HashMap<String, FSAuthnResponse>();
                env.put("FSAuthnResponse", authnResponse);
                int returnCode = this.doSingleSignOn(ni, handleType, niIdp, env);
                if (returnCode == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Accountfederation successful");
                    }
                    String requestID = authnResponse.getInResponseTo();
                    sessionManager.removeAuthnRequest(requestID);
                    if (this.isIDPProxyEnabled(requestID)) {
                        this.sendProxyResponse(requestID);
                        return;
                    }
                    String[] data = new String[]{this.relayState};
                    LogUtil.access(Level.INFO, "ACCESS_GRANTED_REDIRECT_TO", data);
                    FSUtils.debug.message("ArtifactHandler.notfederated, postSSO");
                    if (spAdapter != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAssertionArtifactHandler, Invoke spAdapter.postSSOFederationSuccess");
                        }
                        try {
                            if (spAdapter.postSSOFederationSuccess(this.hostEntityId, this.request, this.response, this.ssoToken, this.authnRequest, authnResponse, null)) {
                                return;
                            }
                        }
                        catch (Exception e) {
                            FSUtils.debug.error("FSAssertionArtifadctHandler SPAdapter.postSSOFederationSuccess:", (Throwable)e);
                        }
                    }
                    this.redirectToResource(this.relayState);
                    return;
                }
                String[] data = new String[]{FSUtils.bundle.getString("SSOfailed")};
                LogUtil.error(Level.INFO, "SINGLE_SIGNON_FAILED", data);
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostEntityId, this.request, this.response, this.authnRequest, authnResponse, null, returnCode)) {
                    this.response.sendRedirect(framedLoginPageURL);
                }
                return;
            }
            catch (Exception e) {
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: Exception Occured: ", (Throwable)e);
                try {
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(framedLoginPageURL);
                }
                catch (IOException ioe) {
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: IOException Occured: ", (Throwable)ioe);
                    return;
                }
                return;
            }
        }
    }

    protected boolean verifyResponseStatus(Response resp) {
        FSUtils.debug.message("FSAssertionArtifactHandler.verifyResponseStatus: Called");
        if (!resp.getStatus().getStatusCode().getValue().endsWith(":Success")) {
            FSUtils.debug.warning("FSAssertionArtifactHandler.verifyResponse: Incorrect StatusCode value.");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.verifyResponse: StatusCode value verified.");
        }
        return true;
    }

    protected Subject validateAssertions(List assertions) {
        FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertions: Called");
        FSSubject subject = null;
        Iterator iter = assertions.iterator();
        FSAssertion assertion = null;
        String aIDString = null;
        String issuer = null;
        Iterator stmtIter = null;
        Statement statement = null;
        int stmtType = -1;
        SubjectConfirmation subConf = null;
        Set confMethods = null;
        String confMethod = null;
        Date date = null;
        long time = System.currentTimeMillis() + 180000L;
        while (iter.hasNext()) {
            assertion = (FSAssertion)iter.next();
            if (!this.authnRequest.getRequestID().equals(assertion.getInResponseTo())) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion does not correspond to any valid request");
                return null;
            }
            if (FSServiceUtils.isSigningOn() && !this.verifyAssertionSignature(assertion)) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion signature verification failed");
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Assertion signature verified");
            }
            if (idTimeMap.containsKey(aIDString = assertion.getAssertionID())) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion: " + aIDString + " is used");
                return null;
            }
            issuer = assertion.getIssuer();
            try {
                if (this.idpEntityId != null) {
                    if (!this.idpEntityId.equals(issuer)) {
                        FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not the entity where AuthnRequest was sent originally.");
                        return null;
                    }
                } else {
                    FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is: " + issuer);
                    IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                    IDPDescriptorType idpDesc = metaManager.getIDPDescriptor(this.realm, issuer);
                    if (idpDesc == null) {
                        FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not on the trust list");
                        return null;
                    }
                    this.setProviderDescriptor(idpDesc);
                    this.setProviderEntityId(issuer);
                }
            }
            catch (Exception ex) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not on the trust list");
                return null;
            }
            if (!assertion.isTimeValid()) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion's time is not valid.");
                return null;
            }
            Conditions conds = assertion.getConditions();
            if (!this.forThisServer(conds)) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion is not issued for this site.");
                return null;
            }
            boolean authnStatementFound = false;
            if (assertion.getStatement() != null) {
                stmtIter = assertion.getStatement().iterator();
                while (stmtIter.hasNext()) {
                    AttributeStatement attrStatement;
                    statement = (Statement)stmtIter.next();
                    stmtType = statement.getStatementType();
                    if (stmtType == 1) {
                        block30: {
                            FSAuthenticationStatement authStatement = (FSAuthenticationStatement)statement;
                            authnStatementFound = true;
                            try {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: validating AuthenticationStatement:" + authStatement.toXMLString());
                                }
                            }
                            catch (FSException e) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Exception. Invalid AuthenticationStatement: ", (Throwable)((Object)e));
                                return null;
                            }
                            this.reAuthnOnOrAfterDate = authStatement.getReauthenticateOnOrAfter();
                            this.idpSessionIndex = authStatement.getSessionIndex();
                            this.authnContextStmt = authStatement.getAuthnContext();
                            subject = (FSSubject)authStatement.getSubject();
                            if (subject == null) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Subject is null");
                                return null;
                            }
                            try {
                                if (!FSUtils.debug.messageEnabled()) break block30;
                                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: found Authentication Statement. Subject = " + subject.toXMLString());
                            }
                            catch (FSException e) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion:  Exception. Invalid subject: ", (Throwable)((Object)e));
                                continue;
                            }
                        }
                        subConf = subject.getSubjectConfirmation();
                        if (subConf == null || (confMethods = subConf.getConfirmationMethod()) == null || confMethods.size() != 1) {
                            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: missing or extra ConfirmationMethod.");
                            return null;
                        }
                        confMethod = (String)confMethods.iterator().next();
                        if (confMethod == null || !confMethod.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer") && !confMethod.equals(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT) && !confMethod.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01")) {
                            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: wrong ConfirmationMethod");
                            return null;
                        }
                        if (!FSUtils.debug.messageEnabled()) continue;
                        FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Confirmation method: " + confMethod);
                        continue;
                    }
                    if (stmtType != 3 || this.checkForAttributeStatement(attrStatement = (AttributeStatement)statement)) continue;
                    this.attrStatements.add(attrStatement);
                }
            }
            if (!authnStatementFound) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: No Authentication statement found in the Assertion. User is not authenticated by the IDP");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Adding " + aIDString + " to idTimeMap.");
            }
            if ((date = conds.getNotOnorAfter()) != null) {
                cGoThrough.addElement((Object)aIDString);
                idTimeMap.put(aIDString, new Long(date.getTime()));
            } else {
                cPeriodic.addElement((Object)aIDString);
                idTimeMap.put(aIDString, aIDString);
            }
            this.securityAssertions = assertion.getDiscoveryCredential();
        }
        if (subject == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: couldn't find Subject.");
            return null;
        }
        return subject;
    }

    private boolean checkForAttributeStatement(AttributeStatement attrStatement) {
        List attributes = attrStatement.getAttribute();
        if (attributes == null || attributes.size() == 0) {
            return false;
        }
        Iterator iter = attributes.iterator();
        Attribute attribute = (Attribute)iter.next();
        if (attribute.getAttributeName().equals("DiscoveryResourceOffering")) {
            this.bootStrapStatement = attrStatement;
            return true;
        }
        if (attribute.getAttributeName().equals("AutoFederateAttribute")) {
            String enabledStr;
            this._autoFedStatement = attrStatement;
            List attrValue = null;
            try {
                attrValue = attribute.getAttributeValue();
            }
            catch (SAMLException se) {
                FSUtils.debug.error("FSAssertionArtifactHandler.checkForAttributeStatement: ", (Throwable)((Object)se));
            }
            String _autoFedValue = null;
            if (attrValue != null && attrValue.size() != 0) {
                Iterator iter2 = attrValue.iterator();
                Element elem = (Element)iter2.next();
                _autoFedValue = XMLUtils.getElementValue((Element)elem);
            }
            if ((enabledStr = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "enableAutoFederation")) != null && enabledStr.equalsIgnoreCase("true") && _autoFedValue != null) {
                this.autoFedSearchMap = new HashMap();
                HashSet<String> set = new HashSet<String>();
                set.add(_autoFedValue);
                this.autoFedSearchMap.put(IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "autoFederationAttribute"), set);
            }
            return true;
        }
        return false;
    }

    protected boolean verifyAssertionSignature(FSAssertion assertion) {
        FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Called");
        try {
            if (!assertion.isSigned()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Assertion is not signed");
                }
                return false;
            }
            X509Certificate cert = KeyUtil.getVerificationCert(this.idpDescriptor, this.idpEntityId, true);
            if (cert == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: couldn't obtain this site's cert.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
            }
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.authnResponse != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHander.verifyAssertionSignature:  xml string to be verified:" + XMLUtils.print((Node)this.authnResponse.getDOMElement().getOwnerDocument()));
                }
                return manager.verifyXMLSignature(this.authnResponse.getDOMElement().getOwnerDocument(), cert);
            }
            if (this.samlResponseElt != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHander.verifyAssertionSignature:  xml string to be verified:" + XMLUtils.print((Node)this.samlResponseElt.getOwnerDocument()));
                }
                return manager.verifyXMLSignature(this.samlResponseElt.getOwnerDocument(), cert);
            }
            return false;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionArtifactHandler.verifyAssertionSignature: Exception occured while verifying IDP's signature:", (Throwable)e);
            return false;
        }
    }

    protected boolean forThisServer(Conditions conds) {
        FSUtils.debug.message("FSAssertionArtifactHandler.forThisServer: Called");
        if (conds == null || this.hostEntityId == null || this.hostEntityId.length() == 0) {
            return true;
        }
        Set targetConds = conds.getAudienceRestrictionCondition();
        if (targetConds == null || targetConds.isEmpty()) {
            return true;
        }
        boolean forThis = false;
        Iterator tcIter = targetConds.iterator();
        AudienceRestrictionCondition targetCond = null;
        while (tcIter.hasNext()) {
            targetCond = (AudienceRestrictionCondition)tcIter.next();
            if (!targetCond.containsAudience(this.hostEntityId)) continue;
            forThis = true;
            if (!FSUtils.debug.messageEnabled()) break;
            FSUtils.debug.message("FSAssertionArtifactHandler.forThisServer: Assertion is validated to befor this server");
            break;
        }
        return forThis;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int generateToken(NameIdentifier ni, int handleType, NameIdentifier niIdp, Map env) {
        FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Called");
        if (ni == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Invalid userDN input");
            return 10;
        }
        try {
            FSSessionManager sessionManager;
            FSSession session;
            Object ssoSession;
            SessionProvider sessionProvider;
            String authnContextClassRef;
            FSAccountFedInfo fedInfo;
            String userID;
            block53: {
                FSSPAuthenticationContextInfo authnContextInfo;
                block51: {
                    FSAccountManager accountManager;
                    String affiliationID;
                    String name;
                    block54: {
                        name = ni.getName();
                        String nameSpace = ni.getNameQualifier();
                        if (nameSpace == null || nameSpace.length() == 0) {
                            nameSpace = this.hostEntityId;
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Trying to get userDN for opaqueHandle= " + name + " ,securityDomain= " + nameSpace + " And HandleType=" + handleType);
                        }
                        affiliationID = this.authnRequest.getAffiliationID();
                        FSAccountFedInfoKey fedKey = new FSAccountFedInfoKey(nameSpace, name);
                        accountManager = FSAccountManager.getInstance(this.hostMetaAlias);
                        userID = accountManager.getUserID(fedKey, this.realm, env);
                        fedInfo = null;
                        if (userID != null) break block54;
                        if (niIdp != null && nameSpace.equals(affiliationID)) {
                            fedKey = new FSAccountFedInfoKey(affiliationID, niIdp.getName());
                            userID = accountManager.getUserID(fedKey, this.realm, env);
                            if (userID == null) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle. fedKey=" + fedKey.toString());
                                return 11;
                            }
                            FSAccountFedInfo oldInfo = accountManager.readAccountFedInfo(userID, affiliationID);
                            if (oldInfo != null) {
                                accountManager.removeAccountFedInfo(userID, oldInfo);
                            }
                            fedInfo = new FSAccountFedInfo(this.idpEntityId, ni, niIdp, true);
                            fedInfo.setAffiliation(true);
                            fedKey = new FSAccountFedInfoKey(nameSpace, name);
                            accountManager.writeAccountFedInfo(userID, fedKey, fedInfo);
                            break block51;
                        } else {
                            FSAccountFedInfoKey oldKey = new FSAccountFedInfoKey(this.idpEntityId, name);
                            if (oldKey == null) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle.");
                                return 11;
                            }
                            userID = accountManager.getUserID(oldKey, this.realm, env);
                            if (userID != null) {
                                fedInfo = accountManager.readAccountFedInfo(userID, this.idpEntityId);
                                if (fedInfo != null && fedInfo.isFedStatusActive()) {
                                    NameIdentifier localNI = fedInfo.getLocalNameIdentifier();
                                    if (localNI != null) {
                                        localNI.setNameQualifier(this.hostEntityId);
                                    }
                                    accountManager.removeAccountFedInfo(userID, fedInfo);
                                    NameIdentifier remoteNI = fedInfo.getRemoteNameIdentifier();
                                    if (remoteNI != null) {
                                        remoteNI.setNameQualifier(this.hostEntityId);
                                    }
                                    fedInfo = new FSAccountFedInfo(this.idpEntityId, localNI, remoteNI, true);
                                    accountManager.removeAccountFedInfoKey(userID, oldKey);
                                    FSAccountFedInfoKey newKey = new FSAccountFedInfoKey(this.hostEntityId, name);
                                    accountManager.writeAccountFedInfo(userID, newKey, fedInfo);
                                    break block51;
                                } else {
                                    FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle.");
                                    return 11;
                                }
                            }
                            String enabledStr = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "enableAutoFederation");
                            if (enabledStr != null && enabledStr.equalsIgnoreCase("true") && this._autoFedStatement != null) {
                                userID = accountManager.getUserID(this.autoFedSearchMap, this.realm, null);
                                if (userID == null) {
                                    FSUtils.debug.error("FSAssertionArtifactHandler. generateToken:Can't dereference handle.");
                                    return 12;
                                }
                                FSAccountFedInfoKey newKey = new FSAccountFedInfoKey(this.hostEntityId, name);
                                fedInfo = new FSAccountFedInfo(this.idpEntityId, null, ni, true);
                                accountManager.writeAccountFedInfo(userID, newKey, fedInfo);
                                break block51;
                            } else {
                                FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle.");
                                return 11;
                            }
                        }
                    }
                    fedInfo = affiliationID != null ? accountManager.readAccountFedInfo(userID, affiliationID) : accountManager.readAccountFedInfo(userID, this.idpEntityId, name);
                    if (fedInfo == null) {
                        FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: User's account is not federated, id=" + userID);
                        return 11;
                    }
                }
                authnContextClassRef = null;
                int authnLevel = 0;
                Map authnContextInfoMap = FSServiceUtils.getSPAuthContextInfo(this.hostConfig);
                if (this.authnContextStmt != null && this.authnContextStmt.getAuthnContextClassRef() != null && this.authnContextStmt.getAuthnContextClassRef().length() != 0) {
                    authnContextClassRef = this.authnContextStmt.getAuthnContextClassRef();
                    if (authnContextClassRef != null && authnContextClassRef.length() != 0) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: AuthnContextClassRef found in AuthenticationStatement:" + authnContextClassRef);
                        }
                        if ((authnContextInfo = (FSSPAuthenticationContextInfo)authnContextInfoMap.get(authnContextClassRef)) != null) {
                            authnLevel = authnContextInfo.getAuthenticationLevel();
                        } else {
                            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Could not find AuthnContextClassInfo for authnContextClassRef: " + authnContextClassRef + "Using default authnContextClass");
                            authnContextClassRef = null;
                        }
                    }
                } else {
                    FSUtils.debug.warning("FSAssertionArtifactHandler.generateToken: Could not find AuthnContextClassRef in the AuthenticationStatement. Using default authnContextClass");
                }
                if (authnContextClassRef == null || authnContextClassRef.length() == 0) {
                    authnContextClassRef = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "defaultAuthnContext");
                    authnContextInfo = (FSSPAuthenticationContextInfo)authnContextInfoMap.get(authnContextClassRef);
                    if (authnContextInfo == null) {
                        FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Could not find authentication level for default authentication context class");
                        return 10;
                    }
                    authnLevel = authnContextInfo.getAuthenticationLevel();
                }
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("principalName", userID);
                valueMap.put("realm", this.realm);
                valueMap.put("AuthLevel", String.valueOf(authnLevel));
                valueMap.put("authInstant", this.getAuthInstant());
                valueMap.put("idpEntityID", this.idpEntityId);
                sessionProvider = SessionManager.getProvider();
                try {
                    ssoSession = sessionProvider.createSession(valueMap, this.request, this.response, new StringBuffer(this.relayState));
                }
                catch (SessionException se) {
                    FSUtils.debug.error("FSAssertionArtifactHandler.generateToken:cannot generate token:", (Throwable)((Object)se));
                    int failureCode = se.getErrCode();
                    if (failureCode == SessionException.AUTH_USER_INACTIVE) {
                        return 13;
                    }
                    if (failureCode == SessionException.AUTH_USER_LOCKED) {
                        return 14;
                    }
                    if (failureCode != SessionException.AUTH_ACCOUNT_EXPIRED) return 16;
                    return 15;
                }
                try {
                    sessionProvider.addListener(ssoSession, new FSTokenListener(this.hostMetaAlias));
                }
                catch (Exception e) {
                    if (!FSUtils.debug.messageEnabled()) break block53;
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken:Couldn't add listener to session:", (Throwable)e);
                }
            }
            String value = sessionProvider.getSessionID(ssoSession);
            this.ssoToken = ssoSession;
            Iterator iter = null;
            String fedCookieName = SystemConfigurationUtil.getProperty("com.sun.identity.federation.fedCookieName");
            String fedCookieValue = "yes";
            Cookie fedCookie = null;
            if (this.cookieDomainList != null) {
                iter = this.cookieDomainList.iterator();
                while (iter != null && iter.hasNext()) {
                    fedCookie = CookieUtils.newCookie((String)fedCookieName, (String)fedCookieValue, (int)31536000, (String)"/", (String)((String)iter.next()));
                    this.response.addCookie(fedCookie);
                }
            } else {
                fedCookie = CookieUtils.newCookie((String)fedCookieName, (String)fedCookieValue, (int)31536000, (String)"/", null);
                this.response.addCookie(fedCookie);
            }
            if ((session = (sessionManager = FSSessionManager.getInstance(this.hostMetaAlias)).getSession(userID, value)) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: An Existing session found for userID:" + userID + " And SessionID: " + value + " Adding partner to the Session");
                }
                session.addSessionPartner(new FSSessionPartner(this.idpEntityId, true));
                session.setSessionIndex(this.idpSessionIndex);
                sessionManager.addSession(userID, session);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: No existing session found for userID:" + userID + " And SessionID: " + value + " Creating a new Session");
                }
                session = new FSSession(value);
                session.addSessionPartner(new FSSessionPartner(this.idpEntityId, true));
                if (this.idpSessionIndex != null) {
                    session.setSessionIndex(this.idpSessionIndex);
                }
                sessionManager.addSession(userID, session);
            }
            if (authnContextClassRef != null) {
                session.setAuthnContext(authnContextClassRef);
            }
            if (fedInfo != null) {
                session.setAccountFedInfo(fedInfo);
            }
            if (this.bootStrapStatement != null) {
                session.setBootStrapAttributeStatement(this.bootStrapStatement);
            }
            if (this._autoFedStatement != null) {
                session.setAutoFedStatement(this._autoFedStatement);
            }
            if (this.attrStatements.size() != 0) {
                session.setAttributeStatements(this.attrStatements);
                Map attributeMap = null;
                this.setAttributeMapper();
                if (this.realmAttributeMapper != null) {
                    attributeMap = this.realmAttributeMapper.getAttributes(this.attrStatements, this.realm, this.hostEntityId, this.idpEntityId, this.ssoToken);
                } else if (this.attributeMapper != null) {
                    attributeMap = this.attributeMapper.getAttributes(this.attrStatements, this.hostEntityId, this.idpEntityId, this.ssoToken);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Attribute map :" + attributeMap);
                }
                if (attributeMap != null) {
                    this.setAttributeMap(this.ssoToken, attributeMap);
                }
            }
            if (this.securityAssertions == null) return 0;
            session.setBootStrapCredential(this.securityAssertions);
            return 0;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Exception Occured ", (Throwable)e);
            return 10;
        }
    }

    protected void processSAMLRequest() {
    }

    protected int doSingleSignOn(NameIdentifier ni, int handleType, NameIdentifier niIdp, Map env) {
        FSUtils.debug.message("FSAssertionArtifactHandler.doSingleSignOn: Called");
        int returnCode = this.generateToken(ni, handleType, niIdp, env);
        if (returnCode != 0) {
            String[] data = new String[]{FSUtils.bundle.getString("failGenerateSSOToken")};
            LogUtil.error(Level.INFO, "FAILED_SSO_TOKEN_GENERATION", data);
        }
        return returnCode;
    }

    protected void redirectToResource(String resourceURL) throws FSException {
    }

    protected int doAccountFederation(NameIdentifier ni) {
        FederationSPAdapter spAdapter;
        FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation:Called");
        if (ni == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:" + FSUtils.bundle.getString("invalidInput"));
            return 3;
        }
        Object ssoToken = null;
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation: Couldn't obtain session provider:", (Throwable)((Object)se));
            String[] data = new String[]{FSUtils.bundle.getString("failGenerateSSOToken")};
            LogUtil.error(Level.INFO, "FAILED_SSO_TOKEN_GENERATION", data);
            return 4;
        }
        try {
            ssoToken = sessionProvider.getSession(this.request);
            if (ssoToken == null || !sessionProvider.isValid(ssoToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: couldn't obtain session from cookie");
                }
                ssoToken = null;
            }
        }
        catch (SessionException se) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: exception when getting session from cookie:");
            }
            ssoToken = null;
        }
        FSSessionManager sessionManager = null;
        if (ssoToken == null && this.nameIDPolicy != null && this.nameIDPolicy.equals("onetime")) {
            try {
                ssoToken = this.generateAnonymousToken(this.response);
            }
            catch (SessionException se) {
                int failureCode = se.getErrCode();
                failureCode = failureCode == SessionException.AUTH_USER_INACTIVE ? 6 : (failureCode == SessionException.AUTH_USER_LOCKED ? 7 : (failureCode == SessionException.AUTH_ACCOUNT_EXPIRED ? 8 : 5));
                return failureCode;
            }
        }
        if (ssoToken == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:Account federation failed. Invalid session");
            return 5;
        }
        try {
            String sessionID;
            FSSession session;
            String opaqueHandle = ni.getName();
            String userID = sessionProvider.getPrincipalName(ssoToken);
            String securityDomain = ni.getNameQualifier();
            if (securityDomain == null || securityDomain.length() == 0) {
                securityDomain = this.hostEntityId;
            }
            FSAccountFedInfo accountInfo = new FSAccountFedInfo(this.idpEntityId, null, ni, true);
            FSAccountManager accountManager = FSAccountManager.getInstance(this.hostMetaAlias);
            FSAccountFedInfoKey fedKey = null;
            String affiliationID = this.authnRequest.getAffiliationID();
            if (affiliationID != null) {
                fedKey = new FSAccountFedInfoKey(affiliationID, opaqueHandle);
                accountInfo.setAffiliation(true);
            } else {
                fedKey = new FSAccountFedInfoKey(securityDomain, opaqueHandle);
            }
            if (this.nameIDPolicy == null || !this.nameIDPolicy.equals("onetime")) {
                accountManager.writeAccountFedInfo(userID, fedKey, accountInfo);
            }
            if (sessionManager == null) {
                sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
            }
            if ((session = sessionManager.getSession(userID, sessionID = sessionProvider.getSessionID(ssoToken))) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: No existing session found  for userID:" + userID + " And SessionID: " + sessionID + " Creating a new Session");
                }
                session.addSessionPartner(new FSSessionPartner(this.idpEntityId, true));
                session.setSessionIndex(this.idpSessionIndex);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: An Existing session foundfor userID:" + userID + " And SessionID: " + sessionID + " Adding partner to the Session");
                }
                session = new FSSession(sessionID);
                session.addSessionPartner(new FSSessionPartner(this.idpEntityId, true));
                if (this.idpSessionIndex != null) {
                    session.setSessionIndex(this.idpSessionIndex);
                }
            }
            if (this.nameIDPolicy != null && this.nameIDPolicy.equals("onetime")) {
                session.setOneTime(true);
                session.setUserID(userID);
            }
            String authnContextClassRef = null;
            if (this.authnContextStmt != null) {
                authnContextClassRef = this.authnContextStmt.getAuthnContextClassRef();
            }
            if (authnContextClassRef == null || authnContextClassRef.length() == 0) {
                authnContextClassRef = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "defaultAuthnContext");
            }
            if (authnContextClassRef != null) {
                session.setAuthnContext(authnContextClassRef);
            }
            session.setAccountFedInfo(accountInfo);
            if (this.bootStrapStatement != null) {
                session.setBootStrapAttributeStatement(this.bootStrapStatement);
            }
            if (this.attrStatements.size() != 0) {
                Map attributeMap = null;
                this.setAttributeMapper();
                if (this.realmAttributeMapper != null) {
                    attributeMap = this.realmAttributeMapper.getAttributes(this.attrStatements, this.realm, this.hostEntityId, this.idpEntityId, ssoToken);
                } else if (this.attributeMapper != null) {
                    attributeMap = this.attributeMapper.getAttributes(this.attrStatements, this.hostEntityId, this.idpEntityId, ssoToken);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Attribute map :" + attributeMap);
                }
                if (attributeMap != null) {
                    this.setAttributeMap(ssoToken, attributeMap);
                }
            }
            if (this.securityAssertions != null) {
                session.setBootStrapCredential(this.securityAssertions);
            }
            sessionManager.addSession(userID, session);
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:" + FSUtils.bundle.getString("ExceptionOccured"), (Throwable)ex);
            return 9;
        }
        String[] data = new String[]{this.relayState};
        LogUtil.access(Level.INFO, "ACCESS_GRANTED_REDIRECT_TO", data);
        if (this.nameIDPolicy == null || !this.nameIDPolicy.equals("onetime")) {
            String fedCookieName = SystemConfigurationUtil.getProperty("com.sun.identity.federation.fedCookieName");
            String fedCookieValue = "yes";
            Cookie fedCookie = null;
            Iterator iter = null;
            if (this.cookieDomainList != null) {
                iter = this.cookieDomainList.iterator();
                while (iter != null && iter.hasNext()) {
                    fedCookie = CookieUtils.newCookie((String)fedCookieName, (String)fedCookieValue, (int)31536000, (String)"/", (String)((String)iter.next()));
                    this.response.addCookie(fedCookie);
                }
            } else {
                fedCookie = CookieUtils.newCookie((String)fedCookieName, (String)fedCookieValue, (int)31536000, (String)"/", null);
                this.response.addCookie(fedCookie);
            }
        }
        if ((spAdapter = FSServiceUtils.getSPAdapter(this.hostEntityId, this.hostConfig)) != null) {
            FSUtils.debug.message("Invoke spAdapter");
            try {
                if (spAdapter.postSSOFederationSuccess(this.hostEntityId, this.request, this.response, ssoToken, this.authnRequest, this.authnResponse, this.samlResponse)) {
                    return 0;
                }
            }
            catch (Exception e) {
                FSUtils.debug.error("FSAssertionArtifactHandler SPAdapter.postSSOFederationSuccess", (Throwable)e);
            }
        }
        try {
            this.redirectToResource(this.relayState);
            return 0;
        }
        catch (Exception e) {
            return 3;
        }
    }

    protected Object generateAnonymousToken(HttpServletResponse response) throws SessionException {
        FSUtils.debug.message("FSAssertionArtifactHandler.generateAnonymous");
        try {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("principalName", ANONYMOUS_PRINCIPAL);
            valueMap.put("realm", this.realm);
            valueMap.put("AuthLevel", "0");
            valueMap.put("authInstant", this.getAuthInstant());
            valueMap.put("idpEntityID", this.idpEntityId);
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object ssoSession = sessionProvider.createSession(valueMap, this.request, response, new StringBuffer(this.relayState));
            try {
                sessionProvider.addListener(ssoSession, new FSTokenListener(this.hostMetaAlias));
            }
            catch (Exception e) {
                FSUtils.debug.error("FSAssertionArtifactHandler.generateAnonymousToken:Couldn't add listener to session:", (Throwable)e);
            }
            return ssoSession;
        }
        catch (SessionException se) {
            FSUtils.debug.error("FSAssertionArtifactHandler.genAnonymousToken failed.", (Throwable)((Object)se));
            throw se;
        }
        catch (Exception ae) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateAnonymousToken failed.", (Throwable)ae);
            return null;
        }
    }

    protected FSAuthnRequest getInResponseToRequest(String requestID) {
        FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getInResponseToRequest: Called");
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
        this.authnRequest = sessionManager.getAuthnRequest(requestID);
        return this.authnRequest;
    }

    protected String getProvider(String requestID) {
        FSUtils.debug.message("FSAssertionArtifactHandler.getProvider: Called");
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
        return sessionManager.getIDPEntityID(requestID);
    }

    public void setProviderDescriptor(IDPDescriptorType idpDescriptor) {
        this.idpDescriptor = idpDescriptor;
    }

    public void setProviderEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public String getAuthInstant() {
        return DateUtils.toUTCDateFormat((Date)new Date());
    }

    protected boolean isIDPProxyEnabled(String requestID) {
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
        return sessionManager.getProxySPDescriptor(requestID) != null;
    }

    protected void sendProxyResponse(String requestID) {
        FSUtils.debug.message("FSAssertionArtifactHandler.sendProxyResponse::");
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
        FSAuthnRequest origRequest = sessionManager.getProxySPAuthnRequest(requestID);
        if (FSUtils.debug.messageEnabled()) {
            try {
                FSUtils.debug.message("FSAssertionHandler.sendProxyResponse:" + origRequest.toXMLString());
            }
            catch (Exception ex) {
                FSUtils.debug.error("FSAssertionHandler.sendProxyResponse:toString(): Failed.", (Throwable)ex);
            }
        }
        SPDescriptorType proxyDescriptor = sessionManager.getProxySPDescriptor(requestID);
        String proxySPEntityId = origRequest.getProviderId();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.sendProxyResponse:Original requesting service provider id:" + proxySPEntityId);
        }
        FSSession session = sessionManager.getSession(this.ssoToken);
        if (this.authnContextStmt != null) {
            String authnContext = this.authnContextStmt.getAuthnContextClassRef();
            session.setAuthnContext(authnContext);
        }
        session.addSessionPartner(new FSSessionPartner(proxySPEntityId, false));
        if (FSUtils.debug.messageEnabled()) {
            Iterator partners = session.getSessionPartners().iterator();
            while (partners.hasNext()) {
                FSSessionPartner part = (FSSessionPartner)partners.next();
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("PARTNERS" + part.getPartner());
            }
        }
        IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
        SPDescriptorConfigElement proxySPConfig = null;
        try {
            proxySPConfig = metaManager.getSPDescriptorConfig(this.realm, proxySPEntityId);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionArtifactHandler.sendProxyResponse:Couldn't obtain proxy sp meta:", (Throwable)e);
        }
        FSProxyHandler handler = new FSProxyHandler(this.request, this.response, origRequest, proxyDescriptor, proxySPConfig, proxySPEntityId, origRequest.getRelayState(), this.ssoToken);
        IDPDescriptorType localIDPDesc = null;
        IDPDescriptorConfigElement localIDPConfig = null;
        String localIDPMetaAlias = null;
        try {
            localIDPDesc = metaManager.getIDPDescriptor(this.realm, this.hostEntityId);
            localIDPConfig = metaManager.getIDPDescriptorConfig(this.realm, this.hostEntityId);
            localIDPMetaAlias = localIDPConfig.getMetaAlias();
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionartifactHandler.sendProxyResponse:Exception when obtaining local idp meta:", (Throwable)e);
        }
        handler.setRealm(this.realm);
        handler.setHostedEntityId(this.hostEntityId);
        handler.setHostedDescriptor(localIDPDesc);
        handler.setHostedDescriptorConfig(localIDPConfig);
        handler.setMetaAlias(localIDPMetaAlias);
        handler.processAuthnRequest(origRequest, true);
    }

    private void setAttributeMap(Object token, Map attributeMap) {
        block6: {
            if (attributeMap == null || attributeMap.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.setAttributeMap: Attribute map is empty");
                }
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.setAttributeMap: Attribute map that will be populated to ssotoken:" + attributeMap);
            }
            try {
                Set entrySet = attributeMap.entrySet();
                SessionProvider sessionProvider = SessionManager.getProvider();
                Iterator iter = entrySet.iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String[] values = new String[]{(String)entry.getValue()};
                    sessionProvider.setProperty(token, (String)entry.getKey(), values);
                }
            }
            catch (Exception e) {
                if (!FSUtils.debug.messageEnabled()) break block6;
                FSUtils.debug.message("FSAssertionArtifactHandler.setAttributeMap:Cannot set attributes to session:", (Throwable)e);
            }
        }
    }

    private void setAttributeMapper() {
        String mapperStr = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "attributeMapperClass");
        if (mapperStr != null && mapperStr.length() != 0) {
            try {
                Object mapperClass = Thread.currentThread().getContextClassLoader().loadClass(mapperStr).newInstance();
                if (mapperClass instanceof FSRealmAttributeMapper) {
                    this.realmAttributeMapper = (FSRealmAttributeMapper)mapperClass;
                } else if (mapperClass instanceof FSAttributeMapper) {
                    this.attributeMapper = (FSAttributeMapper)mapperClass;
                }
            }
            catch (Exception e) {
                FSUtils.debug.error("FSAssertionArtifactHandler.getAttributeMapper:", (Throwable)e);
            }
        }
    }

    static {
        long period = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-cleanup-interval") * 1000;
        cGoThrough = new POSTCleanUpRunnable(period, idTimeMap);
        TimerPool timerPool = SystemTimerPool.getTimerPool();
        timerPool.schedule(cGoThrough, new Date((System.currentTimeMillis() + period) / 1000L * 1000L));
        ScheduleableGroupAction periodicAction = new ScheduleableGroupAction(){

            public void doGroupAction(Object obj) {
                idTimeMap.remove(obj);
            }
        };
        cPeriodic = new PeriodicGroupRunnable(periodicAction, period, 180000L, true);
        timerPool.schedule(cPeriodic, new Date((System.currentTimeMillis() + period) / 1000L * 1000L));
    }
}

