/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FSSession {
    private List sessionPartners = null;
    private String sessionID = null;
    private String sessionIndex = null;
    private Map extraSessionAttributes = null;
    private String authnContext = null;
    private AttributeStatement statement = null;
    private NodeList resourceOfferings = null;
    private List securityAssertions = null;
    private boolean oneTimeFederation = false;
    private FSAccountFedInfo fedInfo = null;
    private String userID = null;
    private List attrStatements = null;
    private AttributeStatement _autoFedStatement = null;

    public FSSession(String sessionID, List sessionPartners) {
        this.sessionID = sessionID;
        this.extraSessionAttributes = new HashMap();
        this.sessionPartners = sessionPartners != null ? sessionPartners : new ArrayList();
    }

    public FSSession(String sessionID) {
        this(sessionID, null);
    }

    public String getAuthnContext() {
        return this.authnContext;
    }

    public void setAuthnContext(String authnContext) {
        this.authnContext = authnContext;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public List getSessionPartners() {
        return this.sessionPartners;
    }

    public void addSessionPartner(FSSessionPartner sessionPartner) {
        Iterator i = this.sessionPartners.iterator();
        while (i.hasNext()) {
            if (!((FSSessionPartner)i.next()).equals(sessionPartner)) continue;
            return;
        }
        this.sessionPartners.add(sessionPartner);
    }

    public FSSessionPartner getCurrentSessionPartner() {
        Iterator i = this.sessionPartners.iterator();
        if (i.hasNext()) {
            return (FSSessionPartner)i.next();
        }
        return null;
    }

    public void removeSessionPartner(String sessionPartner) {
        Iterator i = this.sessionPartners.iterator();
        while (i.hasNext()) {
            FSSessionPartner oldSessionPartner = (FSSessionPartner)i.next();
            if (!oldSessionPartner.isEquals(sessionPartner)) continue;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSession.removeSessionPartner : Removing " + sessionPartner);
            }
            i.remove();
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void addAttribute(String key, String value) {
        this.extraSessionAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        return (String)this.extraSessionAttributes.get(key);
    }

    boolean isEquals(String sessionId) {
        return this.sessionID.equals(sessionId);
    }

    boolean equals(FSSession session) {
        return this.sessionID.equals(session.getSessionID());
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public void setBootStrapAttributeStatement(AttributeStatement statement) {
        this.statement = statement;
        try {
            Document doc = XMLUtils.toDOMDocument((String)statement.toString(true, true), (Debug)FSUtils.debug);
            Element element = doc.getDocumentElement();
            this.resourceOfferings = element.getElementsByTagNameNS("urn:liberty:disco:2003-08", "ResourceOffering");
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSSession.setBootStrapAttributeStatementCan not parse the attribute statement:", (Throwable)ex);
        }
    }

    public AttributeStatement getBootStrapAttributeStatement() {
        return this.statement;
    }

    public NodeList getBootStrapResourceOfferings() {
        return this.resourceOfferings;
    }

    public void setBootStrapCredential(List assertions) {
        this.securityAssertions = assertions;
    }

    public List getBootStrapCredential() {
        return this.securityAssertions;
    }

    public void setAutoFedStatement(AttributeStatement autoFedStmt) {
        this._autoFedStatement = autoFedStmt;
    }

    public AttributeStatement getAutoFedStatement() {
        return this._autoFedStatement;
    }

    public void setAttributeStatements(List attrStatements) {
        this.attrStatements = attrStatements;
    }

    public List getAttributeStatements() {
        return this.attrStatements;
    }

    public void setOneTime(boolean oneTimeFlag) {
        this.oneTimeFederation = oneTimeFlag;
    }

    public boolean getOneTime() {
        return this.oneTimeFederation;
    }

    public void setAccountFedInfo(FSAccountFedInfo fedInfo) {
        this.fedInfo = fedInfo;
    }

    public FSAccountFedInfo getAccountFedInfo() {
        return this.fedInfo;
    }

    public void setUserID(String userID) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSession.setUserID : " + userID);
        }
        this.userID = userID;
    }

    public String getUserID() {
        return this.userID;
    }
}

