/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSSOAPService {
    private static FSSOAPService instance = null;
    private static MessageFactory fac = null;
    private static SOAPConnectionFactory scf = null;

    private FSSOAPService() {
    }

    public SOAPMessage bind(String xmlString) {
        SOAPMessage msg = null;
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type", "text/xml");
        StringBuffer envBegin = new StringBuffer(100);
        envBegin.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("\n").append("<").append("soap-env").append(":Body>").append("\n");
        StringBuffer envEnd = new StringBuffer(100);
        envEnd.append("</").append("soap-env").append(":Body>").append("\n").append("</").append("soap-env").append(":Envelope>").append("\n");
        try {
            StringBuffer sb = new StringBuffer(300);
            sb.append(envBegin).append(xmlString).append(envEnd);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("response created is: " + sb.toString() + "\n--------------------");
            }
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            bop.write(sb.toString().getBytes("UTF-8"));
            msg = fac.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(bop.toByteArray()));
        }
        catch (Exception e) {
            FSUtils.debug.error("could not build response:", (Throwable)e);
            return null;
        }
        return msg;
    }

    public SOAPMessage sendMessage(SOAPMessage msg, String soapEndPoint) throws IOException, SOAPException {
        try {
            FSUtils.debug.message("just started in func sendMessage");
            if (soapEndPoint == null) {
                FSUtils.debug.error("createSOAPReceiverURL Error!");
                String[] data = new String[]{soapEndPoint};
                LogUtil.error(Level.INFO, "FAILED_SOAP_URL_END_POINT_CREATION", data);
                return null;
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)output);
            String xmlString = output.toString("UTF-8");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SENDING message: \n " + xmlString + "\nURLEndpoint :" + soapEndPoint + "\nSOAP CALL");
            }
            SOAPConnection con = scf.createConnection();
            SOAPMessage reply = con.call(msg, (Object)soapEndPoint);
            FSUtils.debug.message("SOAP CALL COMPLETED");
            if (reply == null) {
                return null;
            }
            output = new ByteArrayOutputStream();
            reply.writeTo((OutputStream)output);
            xmlString = output.toString("UTF-8");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("REPLIED message: \n " + xmlString);
            }
            return reply;
        }
        catch (Exception e) {
            FSUtils.debug.error("In catch of sendMessage", (Throwable)e);
            return null;
        }
    }

    public boolean sendTerminationMessage(SOAPMessage msg, String soapEndPoint) {
        try {
            FSUtils.debug.message("started in func sendTerminationMessage");
            if (soapEndPoint == null) {
                FSUtils.debug.error("createSOAPReceiverURL Error!");
                String[] data = new String[]{FSUtils.bundle.getString("failCreateURLEndpoint")};
                LogUtil.error(Level.INFO, "FAILED_SOAP_URL_END_POINT_CREATION", data);
                return false;
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)output);
            if (FSUtils.debug.messageEnabled()) {
                String xmlString = output.toString("UTF-8");
                FSUtils.debug.message("SENDING message: \n " + xmlString);
                FSUtils.debug.message("URLEndpoint :" + soapEndPoint);
            }
            SOAPConnection con = scf.createConnection();
            SOAPMessage reply = con.call(msg, (Object)soapEndPoint);
            FSUtils.debug.message("SOAP CALL COMPLETED");
            return true;
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("In catch of sendTerminationMessage", (Throwable)e);
            }
            return false;
        }
    }

    public Element parseSOAPMessage(SOAPMessage message) {
        FSUtils.debug.message("FSSOAPService.parseSOAPMessage: Called");
        ByteArrayOutputStream bop = null;
        String xmlString = null;
        try {
            block25: {
                bop = new ByteArrayOutputStream();
                message.writeTo((OutputStream)bop);
                xmlString = bop.toString("UTF-8");
                Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)FSUtils.debug);
                Element root = doc.getDocumentElement();
                String rootName = root.getLocalName();
                if (rootName == null || rootName.length() == 0) {
                    FSUtils.debug.error("FSSOAPService.parseSOAPMessage: Local name of the SOAPElement in  the SOAPMessage passed seems to be missing");
                    return null;
                }
                if (!rootName.equals("Envelope") || !root.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    FSUtils.debug.error("FSSOAPService.parseSOAPMessage: Could notparse SOAPMessage, either root element is not Envelope or invalid name space");
                    return null;
                }
                NodeList nlbody = root.getChildNodes();
                int blength = nlbody.getLength();
                if (blength <= 0) {
                    FSUtils.debug.error("FSSOAPService.parseSOAPMessage: Message does not have body");
                    return null;
                }
                Node child = null;
                boolean found = false;
                for (int i = 0; i < blength; ++i) {
                    String childName;
                    child = nlbody.item(i);
                    if (child.getNodeType() != 1 || !(childName = child.getLocalName()).equals("Body")) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    FSUtils.debug.error("FSSOAPService.parseSOAPMessage: Message does not have body1");
                    return null;
                }
                Element body = (Element)child;
                NodeList nl = body.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                int length = nl.getLength();
                if (length > 1) {
                    return null;
                }
                if (length != 0) {
                    child = nl.item(0);
                    if (child.getNodeType() != 1) {
                        return null;
                    }
                    if (child.getLocalName().equalsIgnoreCase("Fault")) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSOAPService. parseSOAPMessage soap-env:Fault found in the SOAPMessage");
                        }
                        return (Element)child;
                    }
                }
                try {
                    child = this.getSAMLElement(body, "Request");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getSAMLElement(body, "Response");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "AuthnResponseEnvelope");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "AuthnRequest");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "RegisterNameIdentifierRequest");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "RegisterNameIdentifierResponse");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "FederationTerminationNotification");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "LogoutRequest");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "LogoutResponse");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "NameIdentifierMappingRequest");
                    if (child != null) {
                        return (Element)child;
                    }
                    child = this.getFederationElement(body, "NameIdentifierMappingResponse");
                    if (child != null) {
                        return (Element)child;
                    }
                    FSUtils.debug.error("FSSOAPService.parseMessage:Invalid message type.");
                }
                catch (FSException e) {
                    if (!FSUtils.debug.messageEnabled()) break block25;
                    FSUtils.debug.message("SOAPService.parseSOAPMessage: Couldn't object protocol message element.");
                }
            }
            return null;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSOAPService.parseSOAPMessage: Exception ", (Throwable)e);
            return null;
        }
    }

    private Node getSAMLElement(Element body, String nodeName) throws FSException {
        NodeList nl = body.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", nodeName);
        int length = nl.getLength();
        if (length > 1) {
            throw new FSException((String)null);
        }
        if (length != 0) {
            return nl.item(0);
        }
        return null;
    }

    private Node getFederationElement(Element body, String nodeName) throws FSException {
        NodeList nl = body.getElementsByTagNameNS("http://projectliberty.org/schemas/core/2002/12", nodeName);
        int length = nl.getLength();
        if (length == 0) {
            nl = body.getElementsByTagNameNS("urn:liberty:iff:2003-08", nodeName);
            length = nl.getLength();
        }
        if (length > 1) {
            throw new FSException((String)null);
        }
        if (length != 0) {
            return nl.item(0);
        }
        return null;
    }

    public SOAPMessage doSyncCall(HttpServletResponse response, SOAPMessage msg, ProviderDescriptorType partnerDecriptor, boolean needAuthn) throws IOException, SOAPException {
        SOAPConnection con;
        SOAPMessage reply;
        FSUtils.debug.message("FSSOAPService.doSyncCall: Called");
        String soapURL = this.createSOAPReceiverUrl(response, partnerDecriptor, false);
        if (soapURL == null) {
            FSUtils.debug.error("FSSOAPService.doSyncCall: createSOAPReceiverURL Error!");
            String[] data = new String[]{FSUtils.bundle.getString("failCreateURLEndpoint")};
            LogUtil.error(Level.INFO, "FAILED_SOAP_URL_END_POINT_CREATION", data);
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)output);
        String xmlString = output.toString("UTF-8");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSOAPService.doSyncCall: SENDING message\n" + xmlString);
        }
        if ((reply = (con = scf.createConnection()).call(msg, (Object)soapURL)) == null) {
            response.sendError(500, FSUtils.bundle.getString("noReplyfromSOAPReceiver"));
            return null;
        }
        output = new ByteArrayOutputStream();
        reply.writeTo((OutputStream)output);
        xmlString = output.toString("UTF-8");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSOAPService.doSyncCall: REPLIED message:\n" + xmlString);
        }
        return reply;
    }

    public String createSOAPReceiverUrl(HttpServletResponse response, ProviderDescriptorType partnerDecriptor, boolean needAuthn) throws IOException {
        String username = null;
        String password = null;
        String to = partnerDecriptor.getSoapEndpoint();
        String authtype = null;
        String soapURL = null;
        if (needAuthn) {
            int idnx = -1;
            idnx = to.indexOf("//");
            if (idnx == -1) {
                FSUtils.debug.error("FSSOAPService.createSOAPReceiverUrl: createSOAPReceiverUrl: SOAP-Receiver-URL illegal format.");
                response.sendError(500, FSUtils.bundle.getString("illegalFormatSOAPUrl"));
                return null;
            }
            String protocol = to.substring(0, idnx - 1);
            if (authtype.equalsIgnoreCase("BASICAUTH") || authtype.equalsIgnoreCase("NOAUTH")) {
                if (!protocol.equals("http")) {
                    String[] data = new String[]{protocol, authtype};
                    LogUtil.error(Level.INFO, "MISMATCH_AUTH_TYPE_AND_PROTOCOL", data);
                    response.sendError(500, FSUtils.bundle.getString("mismatchAuthTypeandProtocol"));
                    return null;
                }
            } else if (authtype.equalsIgnoreCase("SSLWITHBASICAUTH") || authtype.equalsIgnoreCase("SSL")) {
                if (!protocol.equals("https")) {
                    String[] data = new String[]{protocol, authtype};
                    LogUtil.error(Level.INFO, "MISMATCH_AUTH_TYPE_AND_PROTOCOL", data);
                    response.sendError(500, FSUtils.bundle.getString("mismatchAuthTypeandProtocol"));
                    return null;
                }
            } else {
                String[] data = new String[]{authtype};
                LogUtil.error(Level.INFO, "WRONG_AUTH_TYPE", data);
                response.sendError(500, FSUtils.bundle.getString("wrongAuthType"));
                return null;
            }
            if (authtype.equalsIgnoreCase("BASICAUTH") || authtype.equalsIgnoreCase("SSLWITHBASICAUTH")) {
                Map userMap = null;
                username = (String)userMap.get("iplanet-am-saml-user");
                password = (String)userMap.get("iplanet-am-saml-password");
                if (username == null || password == null) {
                    FSUtils.debug.error("FSSOAPService.createSOAPReceiverUrl: PartnerSite required basic authentication. But the user name used for authentication is null.");
                    response.sendError(500, FSUtils.bundle.getString("wrongConfigBasicAuth"));
                    return null;
                }
                StringBuffer toSOAP = new StringBuffer(100);
                toSOAP.append(to.substring(0, idnx + 2)).append(username).append(":").append(password).append("@").append(to.substring(idnx + 2));
                soapURL = toSOAP.toString();
            }
            return null;
        }
        soapURL = to;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSOAPService.createSOAPReceiverUrl: Sending message to URL: " + soapURL);
        }
        String[] data = new String[]{soapURL};
        LogUtil.access(Level.FINER, "SOAP_RECEIVER_URL", data);
        return soapURL;
    }

    public SOAPMessage formSOAPError(String faultcode, String faultString, String detail) {
        SOAPMessage msg = null;
        SOAPEnvelope envelope = null;
        SOAPFault sf = null;
        SOAPBody body = null;
        DetailEntry se = null;
        try {
            msg = fac.createMessage();
            envelope = msg.getSOAPPart().getEnvelope();
            body = envelope.getBody();
            sf = body.addFault();
            Name qname = envelope.createName(faultcode, null, "http://schemas.xmlsoap.org/soap/envelope/");
            sf.setFaultCode(qname);
            sf.setFaultString(FSUtils.bundle.getString(faultString));
            if (detail != null && detail.length() != 0) {
                Detail det = sf.addDetail();
                se = det.addDetailEntry(envelope.createName("Problem"));
                se.addAttribute(envelope.createName("details"), FSUtils.bundle.getString(detail));
            }
        }
        catch (SOAPException e) {
            FSUtils.debug.error("FSSOAPService.formSOAPError:", (Throwable)e);
            return null;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSSOAPService getInstance() {
        FSUtils.debug.message("FSSOAPService.getInstance: Called");
        Class clazz = FSServiceManager.class;
        synchronized (clazz) {
            if (instance == null) {
                FSUtils.debug.message("Constructing a new instance of FSSOAPService");
                instance = new FSSOAPService();
            }
            return instance;
        }
    }

    static {
        try {
            fac = MessageFactory.newInstance();
        }
        catch (Exception ex) {
            FSUtils.debug.error(FSUtils.bundle.getString("missingSOAPMessageFactory"), (Throwable)ex);
        }
        try {
            scf = SOAPConnectionFactory.newInstance();
        }
        catch (SOAPException e) {
            FSUtils.debug.error("FSSOAPService", (Throwable)e);
        }
    }
}

