/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnRequestEnvelope;
import com.sun.identity.federation.message.FSIDPList;
import com.sun.identity.federation.message.common.IDPEntries;
import com.sun.identity.federation.message.common.IDPEntry;
import com.sun.identity.federation.message.common.RequestAuthnContext;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.shared.encode.URLEncDec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class FSLoginHelper {
    private static String headerKey = "headerKey";
    private static String responseDataKey = "responseData";
    private static String URLKey = "urlKey";
    private String interSiteURL = null;
    private static String authnReqIDKey = "RequestID";
    private static String providerIDKey = "_liberty_idp";
    private String amserverURI = null;
    private String authContextString = null;
    private String respondWithString = null;
    private boolean forceAuthn;
    private boolean isPassive;
    private String nameIDPolicy = null;
    private String realm = null;
    private String hostEntityID = null;
    private BaseConfigType hostConfig = null;
    private SPDescriptorType hostDescriptor = null;
    private List cotList = null;
    private String protocolProfile = null;
    private static IDFFMetaManager metaManager = null;
    private String errorPage = null;
    private HttpServletRequest request = null;
    private boolean isPassiveQuery = false;
    private String actionOnNoFedCookie = null;
    private String anonymousOnetime = null;

    public FSLoginHelper(HttpServletRequest request) {
        this.request = request;
        this.amserverURI = FSServiceUtils.getBaseURL(request);
        this.interSiteURL = this.amserverURI + "/" + "IntersiteTransferService";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLoginHepler::Constructor called. Setting BaseURL to " + this.amserverURI + request.getParameter("metaAlias"));
        }
        String passiveQuery = request.getParameter("isPassive");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLoginHepler::isPassive query param" + passiveQuery);
        }
        if (passiveQuery != null && passiveQuery.equals("true")) {
            this.isPassiveQuery = true;
        }
        this.actionOnNoFedCookie = request.getParameter("actionOnNoFedCookie");
        if (this.actionOnNoFedCookie == null || this.actionOnNoFedCookie.length() == 0) {
            this.actionOnNoFedCookie = "passive";
        }
        this.anonymousOnetime = request.getParameter("anonymousOnetime");
    }

    private void setMetaInfo(String metaAlias, String authLevel) throws FSLoginHelperException {
        block9: {
            try {
                this.realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
                if (metaManager == null) {
                    FSUtils.debug.error("FSLoginHelper::setMetaInfo could not get meta manager handle Cannot proceed so throwing error page");
                    throw new FSLoginHelperException("FSLoginHelper:: could not get meta manager handle.");
                }
                this.hostEntityID = metaManager.getEntityIDByMetaAlias(metaAlias);
                this.hostDescriptor = metaManager.getSPDescriptor(this.realm, this.hostEntityID);
                this.hostConfig = metaManager.getSPDescriptorConfig(this.realm, this.hostEntityID);
                if (this.hostDescriptor == null) {
                    FSUtils.debug.error("FSLoginHelper::setMetaInfo getHostedProviderByMetaAlias retured null. Cannot proceed so throwing error page");
                    throw new FSLoginHelperException("FSLoginHelper:: could not get host provider Descriptor handle.");
                }
                if (this.hostConfig != null) {
                    this.nameIDPolicy = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "nameIDPolicy");
                    this.cotList = IDFFMetaUtils.getAttributeValueFromConfig(this.hostConfig, "cotlist");
                    this.respondWithString = "lib:AuthenticationStatement";
                    this.forceAuthn = IDFFMetaUtils.getBooleanAttributeValueFromConfig(this.hostConfig, "forceAuthn");
                    this.isPassive = IDFFMetaUtils.getBooleanAttributeValueFromConfig(this.hostConfig, "isPassive");
                    this.protocolProfile = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "supportedSSOProfile");
                    this.authContextString = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "defaultAuthnContext");
                    this.errorPage = FSServiceUtils.getErrorPageURL(this.request, this.hostConfig, metaAlias);
                    if (authLevel != null) {
                        FSUtils.debug.message("FSLoginHelper()::authLevel not null");
                        Map spAuthInfoMap = FSServiceUtils.getSPAuthContextInfo(this.hostConfig);
                        Set mapSet = spAuthInfoMap.entrySet();
                        Iterator iter = mapSet.iterator();
                        FSSPAuthenticationContextInfo tmpObj = null;
                        while (iter.hasNext()) {
                            Map.Entry mapEntry = iter.next();
                            tmpObj = (FSSPAuthenticationContextInfo)mapEntry.getValue();
                            int authLevelInt = Integer.parseInt(authLevel);
                            if (tmpObj.getAuthenticationLevel() != authLevelInt) continue;
                            this.authContextString = tmpObj.getAuthenticationContext();
                            if (!FSUtils.debug.messageEnabled()) break;
                            FSUtils.debug.message("FSLoginHelper()::Found auth context " + this.authContextString + "for auth level " + authLevel);
                            break;
                        }
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLoginHelper()::respondWithString: " + this.respondWithString);
                        FSUtils.debug.message("FSLoginHelper()::providerID: " + this.hostEntityID);
                        FSUtils.debug.message("FSLoginHelper()::forceAuthn: " + this.forceAuthn);
                        FSUtils.debug.message("FSLoginHelper()::isPassive: " + this.isPassive);
                    }
                    break block9;
                }
                FSUtils.debug.error("FSLoginHelper:setMetaInfo failedhost extended meta is null");
                throw new FSLoginHelperException("FSLoginHelper::could not get host meta config.");
            }
            catch (IDFFMetaException metaExp) {
                FSUtils.debug.error("FSLoginHelper::setMetaInfo meta management Failed.", (Throwable)((Object)metaExp));
                throw new FSLoginHelperException("FSLoginHelper::IDFFMetaException:" + metaExp.getMessage());
            }
            catch (Exception exp) {
                FSUtils.debug.error("FSLoginHelper::setMetaInfo General Exception caugth.", (Throwable)exp);
                throw new FSLoginHelperException("FSLoginHelper::Exception:" + exp.getMessage());
            }
        }
    }

    public Map createAuthnRequest(Map headers, String LRURL, String authLevel, String metaAlias, String remoteEntityID, boolean isFedCookiePresent) throws FSLoginHelperException {
        HashMap<String, String> retHeaderMap = new HashMap<String, String>();
        this.setMetaInfo(metaAlias, authLevel);
        FSUtils.debug.message("FSLoginHelper.createAuthnRequest(): called");
        FSAuthnRequest authnRequest = null;
        authnRequest = remoteEntityID != null ? this.getAuthnReq(headers, LRURL, true) : this.getAuthnReq(headers, LRURL, false);
        if (authnRequest == null) {
            FSUtils.debug.error("FSLoginHelper.createAuthnRequest()::AuthnRequest is null");
            String redirectURL = this.errorPage + "&" + "federror" + "=" + URLEncDec.encode((String)"Unable to create AuthnRequest") + "&" + "fedremark" + "=" + URLEncDec.encode((String)"Please check your Federation Configuration.");
            return this.createMap(redirectURL, null, retHeaderMap);
        }
        String requestID = authnRequest.getRequestID();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest()::RequestID: " + requestID);
        }
        FSSessionManager sessMngr = FSSessionManager.getInstance(metaAlias);
        sessMngr.setAuthnRequest(requestID, authnRequest);
        sessMngr.setIDPEntityID(requestID, remoteEntityID);
        String redirectURL = null;
        boolean isSingleIDP = true;
        boolean isSSO = false;
        Set idpSet = this.getIDPs(metaAlias);
        if (remoteEntityID == null) {
            isSSO = true;
        }
        if (idpSet.size() > 1) {
            isSingleIDP = false;
        }
        if (this.isLECPProfile(headers)) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest():LECP Request Identified");
            retHeaderMap.put("content-type", "application/vnd.liberty-request+xml");
            String responseData = null;
            try {
                FSAuthnRequestEnvelope authnRequestEnvelope = null;
                boolean isPassive = false;
                FSIDPList idpList = null;
                String assertionConsumerURL = FSServiceUtils.getAssertionConsumerServiceURL(this.hostDescriptor, null);
                ArrayList<IDPEntry> idpEntryList = null;
                String idpID = null;
                Object idpName = null;
                String idpLocation = null;
                Iterator iter = idpSet.iterator();
                while (iter.hasNext()) {
                    idpID = (String)iter.next();
                    if (idpID == null) continue;
                    IDPDescriptorType idpDescr = metaManager.getIDPDescriptor(this.realm, idpID);
                    idpLocation = idpDescr.getSingleSignOnServiceURL();
                    if (idpEntryList == null) {
                        idpEntryList = new ArrayList<IDPEntry>();
                    }
                    idpEntryList.add(new IDPEntry(idpID, idpID, idpLocation));
                }
                IDPEntries idpEntries = new IDPEntries(idpEntryList);
                idpList = new FSIDPList(idpEntries, null);
                int minorVersion = FSServiceUtils.getMinorVersion(this.hostDescriptor.getProtocolSupportEnumeration());
                idpList.setMinorVersion(minorVersion);
                authnRequest.setMinorVersion(minorVersion);
                if (FSServiceUtils.isSigningOn() && this.hostDescriptor.isAuthnRequestsSigned()) {
                    authnRequest.signXML(IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "signingCertAlias"));
                }
                authnRequestEnvelope = new FSAuthnRequestEnvelope(authnRequest, this.hostEntityID, this.hostEntityID, assertionConsumerURL, idpList, isPassive);
                authnRequestEnvelope.setMinorVersion(minorVersion);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLoginHelper.createAuthnRequest: AuthnRequestEnvelope: " + authnRequestEnvelope.toXMLString());
                }
                responseData = authnRequestEnvelope.toXMLString();
            }
            catch (Exception e) {
                FSUtils.debug.error("FSLoginHelper.createAuthnRequest(): Exception Occured: " + e.getMessage());
            }
            Map retMap = this.createMap(null, responseData, retHeaderMap);
            retMap.put(authnReqIDKey, requestID);
            return retMap;
        }
        String tldURL = this.getTLDURL();
        if (isSSO && tldURL != null && !isSingleIDP) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLoginHelper:: createAuthnRequest In case where isSSO true and tldURL is true and not single idp. So redirecting to thirdlevel domain");
            }
            redirectURL = tldURL + "?" + "RelayState" + "=" + URLEncDec.encode((String)(this.interSiteURL + "?" + authnReqIDKey + "=" + URLEncDec.encode((String)requestID) + "&" + "metaAlias" + "=" + metaAlias));
        } else {
            if (isSSO && !isSingleIDP) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLoginHelper:: createAuthnRequest  In case where isSSO true and not a single idp so have show common login page");
                }
                Map retMap = this.createMap(null, null, retHeaderMap);
                retMap.put(authnReqIDKey, requestID);
                return retMap;
            }
            boolean noIDP = false;
            if (remoteEntityID == null) {
                if (idpSet != null && idpSet.size() > 0) {
                    remoteEntityID = (String)idpSet.iterator().next();
                } else {
                    FSUtils.debug.error("FSLoginHelper:: no idps found in config. Cannot proceed.");
                    redirectURL = this.errorPage + "&" + "federror" + "=" + URLEncDec.encode((String)"No IDPs Found in Configuration.") + "&" + "fedremark" + "=" + URLEncDec.encode((String)"Please configure you Federation Services for an IDP.");
                    noIDP = true;
                }
            }
            if (!noIDP) {
                String succintID = FSUtils.generateSourceID(remoteEntityID);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLoginHelper:: createAuthnRequest  Redirecting to intersiteTransfer URL " + this.interSiteURL + " with providerID and Base64 encoded SuccintID. " + remoteEntityID + "---" + succintID);
                }
                if (!isFedCookiePresent) {
                    if (this.actionOnNoFedCookie.equals("commonlogin")) {
                        Map retMap = this.createMap(null, null, retHeaderMap);
                        retMap.put(authnReqIDKey, requestID);
                        return retMap;
                    }
                    if (this.actionOnNoFedCookie.equals("active")) {
                        this.changeToPassiveAuthnRequest(requestID, false, metaAlias);
                    } else {
                        this.changeToPassiveAuthnRequest(requestID, true, metaAlias);
                    }
                }
                String providerID = FSUtils.stringToBase64(succintID);
                redirectURL = this.interSiteURL + "?" + authnReqIDKey + "=" + URLEncDec.encode((String)requestID) + "&" + providerIDKey + "=" + URLEncDec.encode((String)providerID) + "&" + "metaAlias" + "=" + metaAlias;
            }
        }
        if (this.isPassiveQuery) {
            this.changeToPassiveAuthnRequest(requestID, true, metaAlias);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest()::redirectURL : " + redirectURL);
        }
        if (this.isWMLProfile(headers)) {
            retHeaderMap.put("content-type", "text/vnd.wap.wml");
        } else {
            retHeaderMap.put("content-type", "text/html");
        }
        Map retMap = this.createMap(redirectURL, null, retHeaderMap);
        retMap.put(authnReqIDKey, requestID);
        return retMap;
    }

    void changeToPassiveAuthnRequest(String requestID, boolean isPassiveFlag, String metaAlias) {
        FSUtils.debug.message("FSPreLogin.changeToPassiveAuthnRequest called");
        FSSessionManager sessMngr = FSSessionManager.getInstance(metaAlias);
        if (sessMngr == null) {
            FSUtils.debug.message("Session Manager null");
            return;
        }
        FSAuthnRequest authnRequest = sessMngr.getAuthnRequest(requestID);
        if (authnRequest != null && !authnRequest.getFederate()) {
            authnRequest.setIsPassive(isPassiveFlag);
            authnRequest.setForceAuthn(false);
        }
        sessMngr.setAuthnRequest(requestID, authnRequest);
    }

    private Set getIDPs(String metaAlias) {
        HashSet<String> idpSet = new HashSet<String>();
        try {
            String provider = "";
            String providerStatus = "";
            String role = "IDP".toLowerCase();
            IDPDescriptorType providerDesc = null;
            IDPDescriptorConfigElement providerConfig = null;
            Set trustedProviders = metaManager.getAllTrustedProviders(metaAlias);
            if (trustedProviders != null && !trustedProviders.isEmpty()) {
                Iterator it = trustedProviders.iterator();
                while (it.hasNext()) {
                    provider = (String)it.next();
                    providerDesc = metaManager.getIDPDescriptor(this.realm, provider);
                    providerConfig = metaManager.getIDPDescriptorConfig(this.realm, provider);
                    if (providerDesc == null || providerConfig == null) continue;
                    providerStatus = IDFFMetaUtils.getFirstAttributeValueFromConfig(providerConfig, "providerStatus");
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLoginHelper::getIDPs For providerId " + provider + " status is " + providerStatus);
                    }
                    if (providerStatus != null && providerStatus.length() != 0 && (providerStatus == null || !providerStatus.equalsIgnoreCase("active"))) continue;
                    idpSet.add(provider);
                }
            }
        }
        catch (IDFFMetaException ame) {
            FSUtils.debug.error("FSLoginHelper::getIDPs Error in getting idp List:", (Throwable)((Object)ame));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLoginHelper::getIDPs returing idpset as " + idpSet);
        }
        return idpSet;
    }

    private FSAuthnRequest getAuthnReq(Map headers, String LRURL, boolean federate) throws FSLoginHelperException {
        FSAuthnRequest authnRequest = null;
        RequestAuthnContext authnContext = null;
        ArrayList<String> respondWithArray = new ArrayList<String>();
        ArrayList<String> authnContextProfileClassRefArray = new ArrayList<String>();
        ArrayList authnContextStatementRefArray = new ArrayList();
        try {
            if (this.isLECPProfile(headers)) {
                this.protocolProfile = "http://projectliberty.org/profiles/lecp";
            } else if (this.isWMLProfile(headers)) {
                this.protocolProfile = "http://projectliberty.org/profiles/wml-post";
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLoginHelper::getAuthnReq():Federation profile is:" + this.protocolProfile);
            }
            if (this.respondWithString != null) {
                StringTokenizer st = new StringTokenizer(this.respondWithString, ",");
                while (st.hasMoreTokens()) {
                    String tmpString = st.nextToken();
                    respondWithArray.add(tmpString);
                }
            } else {
                respondWithArray = null;
            }
            authnContextProfileClassRefArray.add(this.authContextString);
            authnContextStatementRefArray = null;
            String authnContextComparison = "minimum";
            authnContext = new RequestAuthnContext(authnContextProfileClassRefArray, authnContextStatementRefArray, authnContextComparison);
            String nameIDPolicyForReal = !federate && this.nameIDPolicy.equals("federated") ? "none" : this.nameIDPolicy;
            if (this.anonymousOnetime != null && this.anonymousOnetime.equals("true")) {
                nameIDPolicyForReal = "onetime";
                federate = true;
            }
            authnRequest = new FSAuthnRequest(null, respondWithArray, this.hostEntityID, this.forceAuthn, this.isPassive, federate, nameIDPolicyForReal, this.protocolProfile, authnContext, LRURL, "minimum");
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSLoginHelper.getAuthnReq():Error during procesing:", (Throwable)ex);
            throw new FSLoginHelperException("FSLoginHelper.getAuthnReq() In Exception " + ex.getMessage());
        }
        return authnRequest;
    }

    private Map createMap(String redirectURL, String content, Map retHeaderMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(headerKey, retHeaderMap);
        if (redirectURL != null) {
            map.put(URLKey, redirectURL);
        } else if (content != null) {
            map.put(responseDataKey, content);
        }
        return map;
    }

    private boolean isLECPProfile(Map headers) {
        FSUtils.debug.message("FSLoginHelper.isLECPProfile called");
        if (headers != null) {
            String lecpHeaderValue = (String)headers.get("Liberty-Enabled");
            if (lecpHeaderValue == null) {
                String header = "Liberty-Enabled".toLowerCase();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLoginHelper.isLECPProfile checking for lower case header: " + header);
                }
                lecpHeaderValue = (String)headers.get(header);
            }
            return lecpHeaderValue != null;
        }
        return false;
    }

    private boolean isWMLProfile(Map headers) {
        String wmlHeaderValue;
        if (headers != null && (wmlHeaderValue = (String)headers.get("accept")) != null && wmlHeaderValue.toLowerCase().indexOf("text/vnd.wap.wml") != -1) {
            FSUtils.debug.message("FSLoginHelper.isWMLProfile() :: true ");
            return true;
        }
        return false;
    }

    private String getTLDURL() {
        String tldURL;
        block10: {
            tldURL = null;
            FSUtils.debug.message("FSLoginHelper.getTLDURL() :: called");
            try {
                if (this.cotList == null || this.cotList.isEmpty()) {
                    FSUtils.debug.error("FSLoginHelper::getTLDURL():Received COT Set is Invalid");
                    break block10;
                }
                if (this.cotList.size() > 1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLoginHelper::getTLDURL() Multiple COTs found will do polling ");
                    }
                } else {
                    FSUtils.debug.message("FSLoginHelper::getTLDURL() Single COT found");
                }
                Iterator iter = this.cotList.iterator();
                CircleOfTrustManager cotManager = new CircleOfTrustManager();
                while (iter.hasNext()) {
                    CircleOfTrustDescriptor cotDesc = cotManager.getCircleOfTrust(this.realm, (String)iter.next());
                    if (cotDesc == null || !cotDesc.getCircleOfTrustStatus().equalsIgnoreCase("active")) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLoginHelper::getTLDURL found a active cot with cotid : " + cotDesc.getCircleOfTrustName());
                    }
                    tldURL = cotDesc.getIDFFReaderServiceURL();
                    break;
                }
            }
            catch (COTException ame) {
                FSUtils.debug.error("FSLoginHelper.getTLDURL():COTException:", (Throwable)((Object)ame));
            }
            catch (Exception exp) {
                FSUtils.debug.error("FSLoginHelper.getTLDURL():General Exception:", (Throwable)exp);
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLoginHelper::getTLDURL().tldURL  " + tldURL);
        }
        return tldURL;
    }

    public String createAuthnRequestEnvelope(HttpServletRequest request) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequestEnvelope(): called" + request.getParameter("metaAlias"));
        }
        try {
            String metaAlias = request.getParameter("metaAlias");
            this.setMetaInfo(metaAlias, null);
            FSAuthnRequest authnRequest = null;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String hn = headerNames.nextElement().toString();
                String hv = request.getHeader(hn);
                headerMap.put(hn, hv);
            }
            Set idpSet = this.getIDPs(metaAlias);
            String LRURL = request.getParameter("RelayState");
            if (LRURL == null || LRURL.equals("")) {
                LRURL = FSServiceUtils.getFederationDonePageURL(request, this.hostConfig, metaAlias);
            }
            authnRequest = this.getAuthnReq(headerMap, LRURL, true);
            authnRequest.setMinorVersion(FSServiceUtils.getMinorVersion(this.hostDescriptor.getProtocolSupportEnumeration()));
            if (authnRequest == null) {
                FSUtils.debug.error("FSLoginHelper.createAuthnRequest()::AuthnRequest is null");
                return this.errorPage + "&" + "federror" + "=" + URLEncDec.encode((String)"Unable to create AuthnRequest") + "&" + "fedremark" + "=" + URLEncDec.encode((String)"Please check your Federation Configuration.");
            }
            String requestID = authnRequest.getRequestID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLoginHelper.createAuthnRequest()::RequestID: " + requestID);
            }
            FSSessionManager sessMngr = FSSessionManager.getInstance(metaAlias);
            sessMngr.setAuthnRequest(requestID, authnRequest);
            Object ssoToken = SessionManager.getProvider().getSession(request);
            if (ssoToken != null) {
                sessMngr.setLocalSessionToken(requestID, ssoToken);
            }
            FSAuthnRequestEnvelope authnRequestEnvelope = null;
            boolean isPassive = false;
            FSIDPList idpList = null;
            String assertionConsumerURL = FSServiceUtils.getAssertionConsumerServiceURL(this.hostDescriptor, null);
            ArrayList<IDPEntry> idpEntryList = null;
            String idpID = null;
            String idpLocation = null;
            Iterator iter = idpSet.iterator();
            while (iter.hasNext()) {
                idpID = (String)iter.next();
                if (idpID == null) continue;
                IDPDescriptorType idpDescr = metaManager.getIDPDescriptor(this.realm, idpID);
                idpLocation = idpDescr.getSingleSignOnServiceURL();
                if (idpEntryList == null) {
                    idpEntryList = new ArrayList<IDPEntry>();
                }
                idpEntryList.add(new IDPEntry(idpID, idpID, idpLocation));
            }
            int minorVersion = FSServiceUtils.getMinorVersion(this.hostDescriptor.getProtocolSupportEnumeration());
            IDPEntries idpEntries = new IDPEntries(idpEntryList);
            idpList = new FSIDPList(idpEntries, null);
            idpList.setMinorVersion(minorVersion);
            if (FSServiceUtils.isSigningOn() && this.hostDescriptor.isAuthnRequestsSigned()) {
                authnRequest.signXML(IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "signingCertAlias"));
            }
            authnRequestEnvelope = new FSAuthnRequestEnvelope(authnRequest, this.hostEntityID, this.hostEntityID, assertionConsumerURL, idpList, isPassive);
            authnRequestEnvelope.setMinorVersion(minorVersion);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLoginHelper.createAuthnRequest: AuthnRequestEnvelope: " + authnRequestEnvelope.toXMLString());
            }
            return authnRequestEnvelope.toXMLString();
        }
        catch (Exception e) {
            FSUtils.debug.error("FSLoginHelper.createAuthnRequest():Exception Occured: ", (Throwable)e);
            return null;
        }
    }

    static {
        metaManager = FSUtils.getIDFFMetaManager();
    }
}

