/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.shared.validation.IntegerValidator;
import com.sun.identity.shared.validation.ValidationException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class FSIDPAuthenticationContextInfo
implements Serializable {
    private String authenticationContext = null;
    private String moduleIndicatorKey = null;
    private String moduleIndicatorValue = null;
    private int level = -1;

    public FSIDPAuthenticationContextInfo() {
    }

    public FSIDPAuthenticationContextInfo(String infoString) throws FSException {
        if (infoString == null) {
            throw new FSException("nullInput", null);
        }
        StringTokenizer stk = new StringTokenizer(infoString, "|");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            int equalSign = token.indexOf("=");
            if (equalSign == -1) {
                throw new FSException("wrongInput", null);
            }
            try {
                String key = token.substring(0, equalSign);
                String value = token.substring(equalSign + 1, token.length());
                if (key.equalsIgnoreCase("context")) {
                    this.authenticationContext = value;
                    continue;
                }
                if (key.equalsIgnoreCase("key")) {
                    this.moduleIndicatorKey = value;
                    continue;
                }
                if (key.equalsIgnoreCase("value")) {
                    this.moduleIndicatorValue = value;
                    continue;
                }
                if (key.equalsIgnoreCase("level")) {
                    this.level = Integer.parseInt(value);
                    continue;
                }
                throw new FSException("wrongInput", null);
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FSException("wrongInput", null);
            }
            catch (NumberFormatException ne) {
                throw new FSException("wrongInput", null);
            }
        }
        if (this.authenticationContext == null || this.moduleIndicatorKey == null || this.moduleIndicatorValue == null || this.level == -1) {
            throw new FSException("wrongInput", null);
        }
    }

    public FSIDPAuthenticationContextInfo(String authenticationContext, String moduleIndicatorKey, String moduleIndicatorValue, int level) throws FSException {
        this.setAuthenticationContext(authenticationContext);
        this.setLevel(level);
        this.setModuleIndicatorKey(moduleIndicatorKey);
        this.setModuleIndicatorValue(moduleIndicatorValue);
    }

    public FSIDPAuthenticationContextInfo(String authenticationContext, String moduleIndicatorKey, String moduleIndicatorValue, String level) throws FSException {
        this.setAuthenticationContext(authenticationContext);
        this.setLevel(level);
        this.setModuleIndicatorKey(moduleIndicatorKey);
        this.setModuleIndicatorValue(moduleIndicatorValue);
    }

    public String getAuthenticationContext() {
        return this.authenticationContext;
    }

    public void setAuthenticationContext(String authenticationContext) throws FSException {
        if (authenticationContext == null || authenticationContext.trim().length() == 0) {
            throw new FSException("meta_missing_auth_context", null);
        }
        this.authenticationContext = authenticationContext;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(String level) throws FSException {
        IntegerValidator validator = IntegerValidator.getInstance();
        try {
            validator.validate(level);
            this.level = Integer.parseInt(level);
        }
        catch (ValidationException e) {
            throw new FSException("meta_invalid_level", null);
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getModuleIndicatorKey() {
        return this.moduleIndicatorKey;
    }

    public void setModuleIndicatorKey(String moduleIndicatorKey) {
        this.moduleIndicatorKey = moduleIndicatorKey;
    }

    public String getModuleIndicatorValue() {
        return this.moduleIndicatorValue;
    }

    public void setModuleIndicatorValue(String moduleIndicatorValue) {
        this.moduleIndicatorValue = moduleIndicatorValue;
    }
}

