/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.EncryptedNameIdentifier;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSDiscoveryBootStrap {
    private AttributeStatement _bootStrapStatement = null;
    private List _assertions = null;
    private Object _ssoToken = null;
    private boolean _hasCredentials = false;

    public FSDiscoveryBootStrap(Object ssoToken, AuthnContext authnContext, FSSubject sub, String userID, String wscID, String realm) throws FSException {
        if (sub == null || userID == null) {
            FSUtils.debug.error("FSDiscoBootStrap: null values.");
            throw new FSException("nullInputParameter", null);
        }
        this._ssoToken = ssoToken;
        try {
            ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
            ArrayList<Element> resourceOfferings = new ArrayList<Element>();
            Document offering = this.getResourceOffering(sub, authnContext, userID, wscID, realm);
            resourceOfferings.add(offering.getDocumentElement());
            Attribute attribute = new Attribute("DiscoveryResourceOffering", "urn:liberty:disco:2003-08", resourceOfferings);
            attributeList.add(attribute);
            this._bootStrapStatement = new AttributeStatement(sub, attributeList);
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSDiscoBootStrap: Constructorwhile creating discovery bootstrap statement", (Throwable)ex);
            throw new FSException(ex);
        }
    }

    private Document getResourceOffering(FSSubject libSubject, AuthnContext authnContext, String userID, String wscID, String realm) throws FSException {
        FSUtils.debug.message("FSDiscoveryBootStrap.getResourceOffering:Init");
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append("saml:").append("AttributeValue").append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"").append(">").append("\n");
        DiscoEntryElement discoEntry = DiscoServiceManager.getBootstrappingDiscoEntry();
        if (discoEntry == null) {
            throw new FSException("nullDiscoveryOffering", null);
        }
        try {
            ResourceOfferingType offering = discoEntry.getResourceOffering();
            ServiceInstanceType serviceInstance = offering.getServiceInstance();
            String providerID = serviceInstance.getProviderID();
            if (!DiscoServiceManager.useImpliedResource()) {
                ResourceIDMapper idMapper = DiscoServiceManager.getResourceIDMapper(providerID);
                if (idMapper == null) {
                    idMapper = DiscoServiceManager.getDefaultResourceIDMapper();
                }
                ObjectFactory fac = new ObjectFactory();
                ResourceIDType resourceID = fac.createResourceIDType();
                String resourceIDValue = idMapper.getResourceID(providerID, userID);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDiscoveryBootStrap.getResourceOffering: ResourceID Value:" + resourceIDValue);
                }
                resourceID.setValue(resourceIDValue);
                offering.setResourceID(resourceID);
            }
            ArrayList<DiscoEntryElement> discoEntryList = new ArrayList<DiscoEntryElement>();
            discoEntryList.add(discoEntry);
            SessionSubject sessionSubject = null;
            sessionSubject = DiscoServiceManager.encryptNIinSessionContext() ? new SessionSubject(EncryptedNameIdentifier.getEncryptedNameIdentifier(libSubject.getNameIdentifier(), realm, providerID), libSubject.getSubjectConfirmation(), libSubject.getIDPProvidedNameIdentifier()) : new SessionSubject(libSubject.getNameIdentifier(), libSubject.getSubjectConfirmation(), libSubject.getIDPProvidedNameIdentifier());
            SessionContext invocatorSession = new SessionContext(sessionSubject, authnContext, providerID);
            Map map = DiscoUtils.checkPolicyAndHandleDirectives(userID, null, discoEntryList, null, invocatorSession, wscID, this._ssoToken);
            List offerings = (List)map.get("offerings");
            if (offerings.isEmpty()) {
                FSUtils.debug.message("FSDiscoBootStrap.getResourceOffering:no ResourceOffering");
                throw new FSException("nullDiscoveryOffering", null);
            }
            ResourceOffering resourceOffering = (ResourceOffering)offerings.get(0);
            this._assertions = (List)map.get("credentials");
            if (this._assertions != null && this._assertions.size() != 0) {
                this._hasCredentials = true;
            }
            sb.append(resourceOffering.toString());
            sb.append("</").append("saml:").append("AttributeValue>");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSDiscoveryBootStap.getResourceOffering:Resource Offering:" + sb.toString());
            }
            return XMLUtils.toDOMDocument((String)sb.toString(), null);
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSDiscoveryBootStrap.getResourceOffering:Exception while creating resource offering.", (Throwable)ex);
            throw new FSException(ex);
        }
    }

    public boolean hasCredentials() {
        return this._hasCredentials;
    }

    public Advice getCredentials() {
        if (this._assertions != null && this._assertions.size() != 0) {
            ArrayList assertionList = new ArrayList();
            assertionList.addAll(this._assertions);
            return new Advice(null, assertionList, null);
        }
        return null;
    }

    public AttributeStatement getBootStrapStatement() {
        return this._bootStrapStatement;
    }
}

