/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSRealmAttributeMapper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class FSDefaultRealmAttributeMapper
implements FSRealmAttributeMapper {
    public Map getAttributes(List statements, String realm, String hostEntityId, String remoteEntityId, Object token) {
        Object attributes;
        HashMap<String, String> map = new HashMap<String, String>();
        if (statements == null || statements.size() == 0) {
            return map;
        }
        Map configMap = null;
        try {
            SPDescriptorConfigElement spConfig;
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            if (metaManager != null && (spConfig = metaManager.getSPDescriptorConfig(realm, hostEntityId)) != null) {
                attributes = IDFFMetaUtils.getAttributes(spConfig);
                configMap = FSServiceUtils.parseAttributeConfig((List)attributes.get("spAttributeMap"));
            }
        }
        catch (IDFFMetaException fme) {
            FSUtils.debug.error("FSDefaultAttributeMapper.getAttributes: Unable to read configuration map.", (Throwable)((Object)fme));
            return map;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSDefaultAttributeMapper.getAttributeMap: Configured map " + configMap);
        }
        Iterator iter = statements.iterator();
        while (iter.hasNext()) {
            AttributeStatement statement = (AttributeStatement)iter.next();
            attributes = statement.getAttribute();
            if (attributes == null || attributes.size() == 0) continue;
            Iterator iter1 = attributes.iterator();
            while (iter1.hasNext()) {
                String valueString;
                String realAttrName;
                Attribute attribute = (Attribute)iter1.next();
                List values = null;
                try {
                    values = attribute.getAttributeValue();
                }
                catch (SAMLException ex) {
                    if (!FSUtils.debug.messageEnabled()) continue;
                    FSUtils.debug.message("FSDefaultAttributeMapper.getAttributes: Exception", (Throwable)((Object)ex));
                    continue;
                }
                if (values == null || values.size() == 0) continue;
                String attributeName = attribute.getAttributeName();
                if (configMap != null && !configMap.isEmpty() && (realAttrName = (String)configMap.get(attributeName)) != null && realAttrName.length() > 0) {
                    attributeName = realAttrName;
                }
                if ((valueString = XMLUtils.getElementValue((Element)((Element)values.get(0)))) == null || valueString.length() <= 0) continue;
                map.put(attributeName, valueString);
            }
        }
        return map;
    }
}

