/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSAuthContextResult;
import com.sun.identity.federation.services.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class FSAuthnDecisionHandler {
    private Map idpAuthContextMap = null;
    private String loginURL = null;
    private static IDFFMetaManager metaManager = null;
    private int compAuthType = 0;

    public FSAuthnDecisionHandler(String realm, String entityID, HttpServletRequest request) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnDecisionHandler::Constructor called with entityID" + entityID);
        }
        this.loginURL = SystemConfigurationUtil.getProperty("com.sun.identity.federation.services.idpLoginURL");
        if (this.loginURL == null || this.loginURL.trim().length() == 0) {
            this.loginURL = FSServiceUtils.getBaseURL(request) + "/UI/Login";
        }
        this.loginURL = this.loginURL + '?' + "arg" + '=' + "newsession";
        this.getIDPAuthContextInfo(realm, entityID);
    }

    private void getIDPAuthContextInfo(String realm, String entityID) {
        block8: {
            if (metaManager == null) {
                return;
            }
            try {
                IDPDescriptorConfigElement entityConfig = metaManager.getIDPDescriptorConfig(realm, entityID);
                if (entityConfig == null) {
                    return;
                }
                Map attributes = IDFFMetaUtils.getAttributes(entityConfig);
                List mappings = (List)attributes.get("idpAuthnContextMapping");
                if (mappings != null && !mappings.isEmpty()) {
                    this.idpAuthContextMap = new HashMap();
                    Iterator iter = mappings.iterator();
                    while (iter.hasNext()) {
                        String infoString = (String)iter.next();
                        try {
                            FSIDPAuthenticationContextInfo info = new FSIDPAuthenticationContextInfo(infoString);
                            this.idpAuthContextMap.put(info.getAuthenticationContext(), info);
                        }
                        catch (FSException fe) {
                            if (!FSUtils.debug.messageEnabled()) continue;
                            FSUtils.debug.message("FSAuthContextHandler.getIDPAuthContextInfo: info is not valid:" + infoString + " ", (Throwable)((Object)fe));
                        }
                    }
                }
            }
            catch (IDFFMetaException e) {
                if (!FSUtils.debug.messageEnabled()) break block8;
                FSUtils.debug.message("FSAuthContextHandler.getIDPAuthContextInfo: ", (Throwable)((Object)e));
            }
        }
    }

    private FSIDPAuthenticationContextInfo getHigherAuthContext(int currentStrength) {
        FSUtils.debug.message("FSAuthnDecisionHandler::getHigherAuthContext called.");
        Iterator iter = this.idpAuthContextMap.entrySet().iterator();
        while (iter.hasNext()) {
            FSIDPAuthenticationContextInfo returnObj = (FSIDPAuthenticationContextInfo)((Object)iter.next());
            if (returnObj == null || returnObj.getLevel() <= currentStrength) continue;
            return returnObj;
        }
        FSUtils.debug.message("FSAuthnDecisionHandler::getHigherAuthContext returning null");
        return null;
    }

    private FSIDPAuthenticationContextInfo getLowerAuthContext(int currentStrength) {
        FSUtils.debug.message("FSAuthnDecisionHandler::getHigherAuthContext called.");
        FSIDPAuthenticationContextInfo returnObj = null;
        Iterator iter = this.idpAuthContextMap.entrySet().iterator();
        while (iter.hasNext()) {
            FSIDPAuthenticationContextInfo tempObj = (FSIDPAuthenticationContextInfo)((Object)iter.next());
            if (tempObj == null || tempObj.getLevel() >= currentStrength || returnObj != null && returnObj.getLevel() >= tempObj.getLevel()) continue;
            returnObj = tempObj;
        }
        return returnObj;
    }

    public FSAuthContextResult decideAuthnContext(List authContextRef, String presentAuthContext, String authType) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnDecisionHandler::decideAuthnContext called with list. " + authContextRef + " and authComparisonType " + authType);
        }
        if (authType == null) {
            authType = "minimum";
        }
        FSAuthContextResult returnObj = new FSAuthContextResult();
        if (authContextRef != null) {
            if (authType.equals("minimum")) {
                this.compAuthType = 1;
            } else if (authType.equals("better")) {
                this.compAuthType = 2;
            } else if (authType.equals("maximum")) {
                this.compAuthType = 3;
            }
            Iterator authIter = authContextRef.iterator();
            while (authIter.hasNext()) {
                String authCntxt = (String)authIter.next();
                returnObj = this.decideAuthnContext(authCntxt, presentAuthContext);
                if (returnObj == null) continue;
                return returnObj;
            }
        }
        return returnObj;
    }

    public FSAuthContextResult getURLForAuthnContext(List authContextClassRef, String authType) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnDecisionHandler::getURLForAuthnContext called with list. " + authContextClassRef + " and authComparisonType " + authType);
        }
        if (authType == null) {
            authType = "minimum";
        }
        FSAuthContextResult returnObj = null;
        if (authContextClassRef != null && authType != null) {
            if (authType.equals("minimum")) {
                this.compAuthType = 1;
            } else if (authType.equals("better")) {
                this.compAuthType = 2;
            } else if (authType.equals("maximum")) {
                this.compAuthType = 3;
            }
            Iterator authIter = authContextClassRef.iterator();
            while (authIter.hasNext()) {
                String authCntxt = (String)authIter.next();
                returnObj = this.getURLForAuthnContext(authCntxt);
                if (returnObj == null || returnObj.getLoginURL() == null) continue;
                return returnObj;
            }
        }
        return returnObj;
    }

    public FSAuthContextResult getURLForAuthnContext(List authContextClassRef) {
        return this.getURLForAuthnContext(authContextClassRef, null);
    }

    private FSAuthContextResult getURLForAuthnContext(String authContextRef) {
        FSUtils.debug.message("FSAuthDecisionHandler::getURLForAuthContext. Entered method");
        if (authContextRef != null && this.idpAuthContextMap != null) {
            FSIDPAuthenticationContextInfo authInfo = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get(authContextRef);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnDecisionHandler::getURLForAuthnContext in auth context checking for " + authContextRef);
            }
            if (authInfo != null) {
                String returnURL = new String();
                if (this.loginURL != null) {
                    FSAuthContextResult authResult = new FSAuthContextResult();
                    String moduleIndicator = authInfo.getModuleIndicatorValue();
                    String authKey = authInfo.getModuleIndicatorKey();
                    returnURL = !authKey.equalsIgnoreCase("none") && moduleIndicator != null ? this.loginURL + "&" + authInfo.getModuleIndicatorKey() + "=" + moduleIndicator : this.loginURL;
                    authResult.setLoginURL(returnURL);
                    authResult.setAuthContextRef(authInfo.getAuthenticationContext());
                    return authResult;
                }
                FSUtils.debug.error("FSAuthnDecisionHandler::getURLForAuthnContext.login url is null, or auth info is not found");
            } else {
                FSUtils.debug.error("FSAuthnDecisionHandler::getURLForAuthnContext. Could not get any authcontext");
            }
        } else if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnDecisionHandler::getURLForAuthContext. Method called withauthContextMinRef null");
        }
        return null;
    }

    private FSAuthContextResult decideAuthnContext(String authContextMinRef, String presentAuthContext) {
        FSUtils.debug.message("FSAuthnDecisionHandler::decideAuthnContext. Entered method");
        if (authContextMinRef != null && this.idpAuthContextMap != null) {
            FSIDPAuthenticationContextInfo presentAuthObj = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get(presentAuthContext);
            FSIDPAuthenticationContextInfo newAuthObj = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get(authContextMinRef);
            if (presentAuthObj != null && newAuthObj != null) {
                if (presentAuthObj.getLevel() >= newAuthObj.getLevel()) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthnDecisionHandler::decideAuthnContext.Present Auth Level higher than needed.");
                    }
                    return new FSAuthContextResult();
                }
                return this.getURLForAuthnContext(authContextMinRef);
            }
            FSUtils.debug.error("FSAuthnDecisionHandler::decideAuthnContext Not Supported AuthContext");
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnDecisionHandler::decideAuthnContext. Method called with authContextMinRef null");
        }
        return null;
    }

    static {
        metaManager = FSUtils.getIDFFMetaManager();
    }
}

