/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;

public class SPProvidedNameIdentifier
extends NameIdentifier {
    protected int minorVersion = 0;

    public SPProvidedNameIdentifier(String name, String nameQualifier, String format) throws SAMLException {
        super(name, nameQualifier, format);
    }

    public SPProvidedNameIdentifier(Element spProvidedNameIdentifierElement) throws FSMsgException {
        Element elt = spProvidedNameIdentifierElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SPProvidedNameIdentifier(Element): local name missing");
            }
            throw new FSMsgException("nullInput", null);
        }
        if (!eltName.equals("SPProvidedNameIdentifier")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SPProvidedNameIdentifier(Element: invalid root element");
            }
            throw new FSMsgException("invalidElement", null);
        }
        String read = elt.getAttribute("NameQualifier");
        if (read != null) {
            this.setNameQualifier(read);
        }
        if ((read = elt.getAttribute("Format")) != null) {
            this.setFormat(read);
        }
        if ((read = XMLUtils.getElementValue((Element)elt)) == null || read.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SPProvidedNameIdentifier(Element:  null input specified");
            }
            throw new FSMsgException("nullInput", null);
        }
        this.setName(read);
    }

    public SPProvidedNameIdentifier(String securityDomain, String name) throws FSMsgException {
        if (name == null || name.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SPProvidedNameIdentifier: null input specified");
            }
            throw new FSMsgException("nullInput", null);
        }
        this.setName(name);
        if (securityDomain == null) {
            this.setNameQualifier("");
        } else {
            this.setNameQualifier(securityDomain);
        }
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toXMLString() throws FSMsgException {
        String xml = this.toXMLString(true, false);
        return xml;
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        if (includeNS) {
            appendNS = "lib:";
        }
        xml.append("<").append(appendNS).append("SPProvidedNameIdentifier").append(" ").append(NS).append(" ");
        if (this.getNameQualifier() != null && this.getNameQualifier().length() != 0) {
            xml.append("NameQualifier").append("=\"").append(this.getNameQualifier()).append("\"").append(" ");
        }
        if (this.getFormat() != null && this.getFormat().length() != 0) {
            xml.append("Format").append("=\"").append(this.getFormat()).append("\"").append(" ");
        }
        if (this.getName() != null && this.getName().length() != 0) {
            xml.append(">").append(this.getName());
            xml.append("</").append(appendNS).append("SPProvidedNameIdentifier").append(">\n");
        }
        return xml.toString();
    }
}

