/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestAuthnContext {
    private List authnContextClassRefList = null;
    private List authnContextStatementRefList = null;
    private String authnContextComparison = null;
    private int minorVersion = 0;

    public RequestAuthnContext(List authnContextClassRefList, List authnContextStatementRefList, String authnContextComparison) {
        this.authnContextStatementRefList = authnContextStatementRefList;
        this.authnContextClassRefList = authnContextClassRefList;
        this.authnContextComparison = authnContextComparison;
    }

    public RequestAuthnContext() {
    }

    public RequestAuthnContext(Element root) throws FSMsgException {
        if (root == null) {
            FSUtils.debug.message("AuthnContext.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String tag = root.getLocalName();
        if (tag == null) {
            FSUtils.debug.error("AuthnContext.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        if (!tag.equals("RequestAuthnContext") && !tag.equals("AuthnContext")) {
            FSUtils.debug.error("AuthnContext.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("AuthnContextClassRef")) {
                if (this.authnContextStatementRefList != null) {
                    FSUtils.debug.error("AuthnContext(Element): Shouldcontain either <AuthnContextStatementRef> or <AuthnContextClassRef>");
                    throw new FSMsgException("wrongInput", null);
                }
                if (this.authnContextClassRefList == null || this.authnContextClassRefList == Collections.EMPTY_LIST) {
                    this.authnContextClassRefList = new ArrayList();
                }
                this.authnContextClassRefList.add(XMLUtils.getElementValue((Element)((Element)child)));
                continue;
            }
            if (childName.equals("AuthnContextStatementRef")) {
                if (this.authnContextClassRefList != null) {
                    FSUtils.debug.error("AuthnContext(Element): Shouldcontain either <AuthnContextStatementRef> or <AuthnContextClassRef>");
                    throw new FSMsgException("wrongInput", null);
                }
                if (this.authnContextStatementRefList == null || this.authnContextStatementRefList == Collections.EMPTY_LIST) {
                    this.authnContextStatementRefList = new ArrayList();
                }
                this.authnContextStatementRefList.add(XMLUtils.getElementValue((Element)((Element)child)));
                continue;
            }
            if (!childName.equals("AuthnContextComparison")) continue;
            this.authnContextComparison = XMLUtils.getElementValue((Element)((Element)child));
        }
    }

    public List getAuthnContextClassRefList() {
        return this.authnContextClassRefList;
    }

    public void setAuthnContextClassRefList(List authnContextClassRefList) {
        this.authnContextClassRefList = authnContextClassRefList;
    }

    public List getAuthnContextStatementRefList() {
        return this.authnContextStatementRefList;
    }

    public void setAuthnContextStatementRefList(List authnContextStatementRefList) {
        this.authnContextStatementRefList = authnContextStatementRefList;
    }

    public String getAuthnContextComparison() {
        return this.authnContextComparison;
    }

    public void setAuthnContextComparison(String authnContextComparison) {
        this.authnContextComparison = authnContextComparison;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        Iterator j;
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String prefixAC = "";
        String prefixLIB = "";
        String uriAC = "";
        String uriLIB = "";
        if (includeNS) {
            prefixLIB = "lib:";
            prefixAC = "AC:";
        }
        if (declareNS) {
            if (this.minorVersion == 2) {
                uriLIB = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
                uriAC = " xmlns:ac=\"urn:liberty:ac:2003-08\"";
            } else {
                uriLIB = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
                uriAC = " xmlns:ac=\"http://projectliberty.org/schemas/authctx/2002/05\"";
            }
        }
        xml.append("<").append(prefixLIB);
        if (this.minorVersion == 2) {
            xml.append("RequestAuthnContext");
        } else {
            xml.append("AuthnContext");
        }
        xml.append(uriLIB).append(">\n");
        if (this.authnContextClassRefList != null && this.authnContextClassRefList != Collections.EMPTY_LIST) {
            if (this.authnContextStatementRefList != null && this.authnContextClassRefList != Collections.EMPTY_LIST) {
                throw new FSMsgException("ExclusiveEntries", null);
            }
            j = this.authnContextClassRefList.iterator();
            while (j.hasNext()) {
                xml.append("<").append(prefixLIB).append("AuthnContextClassRef").append(">");
                xml.append((String)j.next());
                xml.append("</").append(prefixLIB).append("AuthnContextClassRef").append(">\n");
            }
        }
        if (this.authnContextStatementRefList != null && this.authnContextStatementRefList != Collections.EMPTY_LIST) {
            j = this.authnContextStatementRefList.iterator();
            while (j.hasNext()) {
                xml.append("<").append(prefixLIB).append("AuthnContextStatementRef").append(">");
                xml.append((String)j.next());
                xml.append("</").append(prefixLIB).append("AuthnContextStatementRef").append(">\n");
            }
        }
        if (this.minorVersion == 2) {
            xml.append("<").append(prefixLIB).append("AuthnContextComparison").append(">").append(this.authnContextComparison).append("</").append(prefixLIB).append("AuthnContextComparison").append(">\n");
        }
        xml.append("</").append(prefixLIB);
        if (this.minorVersion == 2) {
            xml.append("RequestAuthnContext").append(">\n");
        } else {
            xml.append("AuthnContext").append(">\n");
        }
        return xml.toString();
    }

    public static RequestAuthnContext parseURLEncodedRequest(HttpServletRequest request, int minorVersion) throws FSMsgException {
        String strAuthnContextComparison;
        String strAuthnContextStatementRef;
        RequestAuthnContext retAuthnContext = new RequestAuthnContext();
        String strAuthnContextClassRef = request.getParameter("AuthnContextClassRef");
        if (strAuthnContextClassRef != null) {
            StringTokenizer st = new StringTokenizer(strAuthnContextClassRef);
            while (st.hasMoreTokens()) {
                if (retAuthnContext.authnContextClassRefList == null) {
                    retAuthnContext.authnContextClassRefList = new ArrayList();
                }
                retAuthnContext.authnContextClassRefList.add(st.nextToken());
            }
        }
        if ((strAuthnContextStatementRef = request.getParameter("AuthnContextStatementRef")) != null) {
            StringTokenizer st = new StringTokenizer(strAuthnContextStatementRef);
            while (st.hasMoreTokens()) {
                if (retAuthnContext.authnContextStatementRefList == null) {
                    retAuthnContext.authnContextStatementRefList = new ArrayList();
                }
                retAuthnContext.authnContextStatementRefList.add(st.nextToken());
            }
        }
        if ((strAuthnContextComparison = request.getParameter("AuthnContextComparison")) != null) {
            retAuthnContext.setAuthnContextComparison(strAuthnContextComparison);
        }
        retAuthnContext.setMinorVersion(minorVersion);
        return retAuthnContext;
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        Iterator j;
        StringBuffer strEncodedString;
        StringBuffer urlEncodedAuthnReq = new StringBuffer(300);
        if (this.authnContextClassRefList != null && !this.authnContextClassRefList.isEmpty()) {
            if (this.authnContextStatementRefList != null && !this.authnContextStatementRefList.isEmpty()) {
                throw new FSMsgException("ExclusiveEntries", null);
            }
            strEncodedString = new StringBuffer(100);
            j = this.authnContextClassRefList.iterator();
            strEncodedString.append((String)j.next());
            while (j.hasNext()) {
                strEncodedString.append(" ").append((String)j.next());
            }
            urlEncodedAuthnReq.append("AuthnContextClassRef=").append(URLEncDec.encode((String)strEncodedString.toString())).append('&');
        }
        if (this.authnContextStatementRefList != null && !this.authnContextStatementRefList.isEmpty()) {
            strEncodedString = new StringBuffer(100);
            j = this.authnContextStatementRefList.iterator();
            strEncodedString.append((String)j.next());
            while (j.hasNext()) {
                strEncodedString.append(" ").append((String)j.next());
            }
            urlEncodedAuthnReq.append("AuthnContextClassRef=").append(URLEncDec.encode((String)strEncodedString.toString())).append('&');
        }
        if (this.minorVersion == 2 && this.authnContextComparison != null) {
            urlEncodedAuthnReq.append("AuthnContextComparison=").append(URLEncDec.encode((String)this.authnContextComparison)).append('&');
        }
        return urlEncodedAuthnReq.toString();
    }
}

