/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extension {
    private List children = null;
    private Map avpairs = null;
    private int minorVersion = 0;

    public Extension(List children) throws FSMsgException {
        Extension.validateChildren(children);
        this.children = children;
    }

    public Extension(Element element) throws FSMsgException {
        if (element == null) {
            FSUtils.debug.error("Extension.Extension: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String nodeName = element.getLocalName();
        if (!"Extension".equals(nodeName)) {
            FSUtils.debug.error("Extension.Extension: wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(XMLUtils.print((Node)child));
            this.addToAvpairs((Element)child);
        }
    }

    public Extension(Map avpairs) throws FSMsgException {
        this.setAttributeMap(avpairs);
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) throws FSMsgException {
        Extension.validateChildren(children);
        this.children = children;
    }

    public Map getAttributeMap() {
        if (this.children == null || this.children.isEmpty()) {
            return null;
        }
        if (this.avpairs != null) {
            return this.avpairs;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            String xml = (String)iter.next();
            Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)FSUtils.debug);
            if (doc == null) continue;
            Element element = doc.getDocumentElement();
            this.addToAvpairs(element);
        }
        return this.avpairs;
    }

    public void setAttributeMap(Map avpairs) throws FSMsgException {
        this.avpairs = avpairs;
        if (avpairs != null && !avpairs.isEmpty()) {
            Iterator iter = avpairs.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)avpairs.get(key);
                String xml = "<" + key + ">" + XMLUtils.escapeSpecialCharacters((String)value) + "</" + key + ">";
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(xml);
            }
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        String prefix = "";
        String uri = "";
        StringBuffer xml = new StringBuffer();
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        xml.append("<").append(prefix).append("Extension").append(uri).append(">");
        if (this.children != null && !this.children.isEmpty()) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                String child = (String)iter.next();
                xml.append(child);
            }
        }
        xml.append("</").append(prefix).append("Extension").append(">");
        return xml.toString();
    }

    public static Extension parseURLEncodedRequest(HttpServletRequest request, String prefix, int minorVersion) throws FSMsgException {
        HashMap<String, String> attrMap = null;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paraName = (String)e.nextElement();
            if (!paraName.startsWith(prefix)) continue;
            String key = paraName.substring(prefix.length());
            String value = request.getParameter(paraName);
            if (attrMap == null) {
                attrMap = new HashMap<String, String>();
            }
            attrMap.put(key, value);
        }
        if (attrMap == null) {
            return null;
        }
        Extension extension = new Extension(attrMap);
        extension.setMinorVersion(minorVersion);
        return extension;
    }

    public String toURLEncodedQueryString(String prefix) throws FSMsgException {
        Map attrMap = this.getAttributeMap();
        if (attrMap == null || attrMap.isEmpty()) {
            return "";
        }
        StringBuffer queryString = new StringBuffer();
        Iterator iter = attrMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = URLEncDec.encode((String)((String)attrMap.get(key)));
            key = URLEncDec.encode((String)(prefix + key));
            if (queryString.length() > 0) {
                queryString.append('&');
            }
            queryString.append(key).append('=').append(value);
        }
        return queryString.toString();
    }

    private void addToAvpairs(Element element) {
        String ns = element.getNamespaceURI();
        if (ns == null && !XMLUtils.hasElementChild((Node)element)) {
            String key = element.getLocalName();
            String value = XMLUtils.getElementValue((Element)element);
            if (this.avpairs == null) {
                this.avpairs = new HashMap();
            }
            this.avpairs.put(key, value);
        }
    }

    private static void validateChildren(List children) throws FSMsgException {
        if (children != null && !children.isEmpty()) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                String xml = (String)iter.next();
                Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)FSUtils.debug);
                if (doc != null) continue;
                FSUtils.debug.error("Extension.validateChildren: Error while parsing input xml string");
                throw new FSMsgException("parseError", null);
            }
        }
    }
}

