/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Element;

public class EncryptableNameIdentifier {
    private String _nameQualifier = "";
    private String _name = "";
    private String _nonce = "";
    private String _format = "";
    private Date _issueInstant = null;

    protected EncryptableNameIdentifier() {
    }

    public EncryptableNameIdentifier(NameIdentifier ni) throws FSException {
        if (ni == null) {
            throw new FSException("nullInput", null);
        }
        this._nameQualifier = ni.getNameQualifier();
        this._name = ni.getName();
        if (this._nameQualifier == null || this._name == null) {
            throw new FSException("nullInput", null);
        }
        this._format = ni.getFormat();
        if (this._format == null) {
            throw new FSException("notValidFormat", null);
        }
        this._nonce = FSUtils.generateID();
        this._issueInstant = new Date();
    }

    public EncryptableNameIdentifier(String name, String nameQualifier, String format, Date issueInstant, String nonce) throws FSException {
        if (name == null || nameQualifier == null || issueInstant == null || format == null || nonce == null) {
            throw new FSException("nullInput", null);
        }
        this._name = name;
        this._nameQualifier = nameQualifier;
        this._format = format;
        this._nonce = nonce;
        this._issueInstant = issueInstant;
    }

    public EncryptableNameIdentifier(Element nameIdentifier) throws FSException {
        Element elt = nameIdentifier;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("EncryptableNameIdentifier: local name missing");
            }
            throw new FSException("nullInput", null);
        }
        if (!eltName.equals("EncryptableNameIdentifier")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("EncryptableNameIdentifier: invalid root element");
            }
            throw new FSException("invalidElement", null);
        }
        String read = elt.getAttribute("NameQualifier");
        if (read != null) {
            this._nameQualifier = read;
        }
        if ((read = elt.getAttribute("Format")) != null) {
            this._format = read;
        }
        if ((read = elt.getAttribute("Nonce")) != null) {
            this._nonce = read;
        }
        if ((read = elt.getAttribute("IssueInstant")) != null) {
            try {
                this._issueInstant = DateUtils.stringToDate((String)read);
            }
            catch (ParseException pe) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("EncryptableNameIdentifier: Could not parse issue instant", (Throwable)pe);
                }
                throw new FSException("wrongInput", null);
            }
        }
        if ((read = XMLUtils.getElementValue((Element)elt)) == null || read.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("EncryptableNameIdentifier: null input specified");
            }
            throw new FSException("nullInput", null);
        }
        this._name = read;
    }

    public String getFormat() {
        return this._format;
    }

    public boolean setFormat(String format) {
        if (format == null || format.length() == 0) {
            return false;
        }
        this._format = format;
        return true;
    }

    public String getNameQualifier() {
        return this._nameQualifier;
    }

    public boolean setNameQualifier(String nameQualifier) {
        if (nameQualifier == null || nameQualifier.length() == 0) {
            return false;
        }
        this._nameQualifier = nameQualifier;
        return true;
    }

    protected boolean setName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        this._name = name;
        return true;
    }

    public String getName() {
        return this._name;
    }

    public String getNonce() {
        return this._nonce;
    }

    public Date getIssueInstant() {
        return this._issueInstant;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
        }
        if (includeNS) {
            appendNS = "lib:";
        }
        String dateStr = null;
        if (this._issueInstant != null) {
            dateStr = DateUtils.toUTCDateFormat((Date)this._issueInstant);
        }
        xml.append("<").append(appendNS).append("EncryptableNameIdentifier").append(NS);
        if (this._nameQualifier != null && this._nameQualifier.length() != 0) {
            xml.append(" ").append("NameQualifier").append("=\"").append(this._nameQualifier).append("\"");
        }
        if (this._format != null && this._format.length() != 0) {
            xml.append(" ").append("Format").append("=\"").append(this._format).append("\"");
        }
        if (this._nonce != null && this._nonce.length() != 0) {
            xml.append(" ").append("Nonce").append("=\"").append(this._nonce).append("\"");
        }
        if (this._issueInstant != null && dateStr.length() != 0) {
            xml.append(" ").append("IssueInstant").append("=\"").append(dateStr).append("\"");
        }
        xml.append(">").append(this._name);
        xml.append("</").append(appendNS).append("EncryptableNameIdentifier").append(">");
        return xml.toString();
    }
}

