/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthnContext {
    protected String authnContextClassRef = null;
    protected String authnContextStatementRef = null;
    protected int minorVersion = 0;

    public AuthnContext() {
    }

    public AuthnContext(String authnContextClassRef, String authnContextStatementRef) {
        this.authnContextClassRef = authnContextClassRef;
        this.authnContextStatementRef = authnContextStatementRef;
    }

    public AuthnContext(Element root) throws FSMsgException {
        if (root == null) {
            FSUtils.debug.message("AuthnContext(): null input.");
            throw new FSMsgException("nullInput", null);
        }
        String tag = root.getLocalName();
        if (tag == null || !tag.equals("AuthnContext")) {
            FSUtils.debug.message("AuthnContext: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        String namespace = root.getNamespaceURI();
        if (namespace != null && namespace.equals("urn:liberty:iff:2003-08")) {
            this.minorVersion = 2;
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("AuthnContextClassRef")) {
                if (this.authnContextClassRef != null) {
                    FSUtils.debug.error("AuthnContext(Element): Shouldcontain only one AuthnContextClassRef element");
                    throw new FSMsgException("wrongInput", null);
                }
                this.authnContextClassRef = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (childName.equals("AuthnContextStatementRef")) {
                if (this.authnContextStatementRef != null) {
                    FSUtils.debug.error("AuthnContext(Element): Should contain  only one AuthnContextStatementRef element");
                    throw new FSMsgException("wrongInput", null);
                }
                this.authnContextStatementRef = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (!childName.equals("AuthenticationContextStatement") || !FSUtils.debug.messageEnabled()) continue;
            FSUtils.debug.message("AuthnContext(Element): Authentication Statement");
        }
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    public String getAuthnContextStatementRef() {
        return this.authnContextStatementRef;
    }

    public void setAuthnContextStatementRef(String authnContextStatementRef) {
        this.authnContextStatementRef = authnContextStatementRef;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String prefixAC = "";
        String prefixLIB = "";
        String uriAC = "";
        String uriLIB = "";
        if (includeNS) {
            prefixLIB = "lib:";
            prefixAC = "AC:";
        }
        if (declareNS) {
            if (this.minorVersion == 2) {
                uriLIB = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
                uriAC = " xmlns:ac=\"urn:liberty:ac:2003-08\"";
            } else {
                uriLIB = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
                uriAC = " xmlns:ac=\"http://projectliberty.org/schemas/authctx/2002/05\"";
            }
        }
        xml.append("<").append(prefixLIB).append("AuthnContext").append(uriLIB).append(">");
        if (this.authnContextClassRef != null && !this.authnContextClassRef.equals("")) {
            xml.append("<").append(prefixLIB).append("AuthnContextClassRef").append(">");
            xml.append(this.authnContextClassRef);
            xml.append("</").append(prefixLIB).append("AuthnContextClassRef").append(">");
        } else {
            xml.append("<").append(prefixLIB).append("AuthnContextClassRef").append(">");
            xml.append("http://www.projectliberty.org/schemas/authctx/classes/Password");
            xml.append("</").append(prefixLIB).append("AuthnContextClassRef").append(">");
        }
        if (this.authnContextStatementRef != null && !this.authnContextStatementRef.equals("")) {
            xml.append("<").append(prefixLIB).append("AuthnContextStatementRef").append(">");
            xml.append(this.authnContextStatementRef);
            xml.append("</").append(prefixLIB).append("AuthnContextStatementRef").append(">");
        } else {
            xml.append("<").append(prefixLIB).append("AuthnContextStatementRef").append(">");
            xml.append("http://www.projectliberty.org/schemas/authctx/classes/Password");
            xml.append("</").append(prefixLIB).append("AuthnContextStatementRef").append(">");
        }
        xml.append("</").append(prefixLIB).append("AuthnContext").append(">");
        return xml.toString();
    }
}

