/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.protocol.AbstractResponse;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSLogoutResponse
extends AbstractResponse {
    private String providerId;
    private String relayState;
    private Status status;
    protected String xmlString;
    protected String signatureString;
    protected String id;
    private String inResponseTo;

    public FSLogoutResponse() {
        try {
            this.setIssueInstant(new Date());
            this.providerId = new String();
            StatusCode statusCode = new StatusCode("samlp:Success");
            this.status = new Status(statusCode);
            this.relayState = new String();
        }
        catch (SAMLException e) {
            FSUtils.debug.error("FSLogoutResponse.constructor:", (Throwable)((Object)e));
        }
    }

    public FSLogoutResponse(String responseID, String inResponseTo, Status status, String providerId, String relayState) throws FSMsgException {
        if (responseID == null || responseID.length() == 0) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                throw new FSMsgException("errorGenerateID", null);
            }
        } else {
            this.responseID = responseID;
        }
        if (inResponseTo == null) {
            FSUtils.debug.message("Response: inResponseTo is null.");
            throw new FSMsgException("nullInput", null);
        }
        this.inResponseTo = inResponseTo;
        if (status == null) {
            FSUtils.debug.message("Response: missing <Status>.");
            throw new FSMsgException("missingElement", null);
        }
        this.status = status;
        this.providerId = providerId;
        this.relayState = relayState;
        this.setIssueInstant(new Date());
    }

    public FSLogoutResponse(Element root) throws FSMsgException, SAMLException {
        if (root == null) {
            FSUtils.debug.message("FSLogoutResponse.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("LogoutResponse")) {
            FSUtils.debug.message("FSLogoutResponse.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        this.id = root.getAttribute("id");
        this.responseID = root.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse.parseXML: Reponse doesn't have ResponseID.");
            }
            Object[] args = new String[]{"ResponseID"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        this.inResponseTo = root.getAttribute("InResponseTo");
        if (this.inResponseTo == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse.parseXML: Response doesn't have InResponseTo.");
            }
            Object[] args = new String[]{"InResponseTo"};
            throw new FSMsgException("missingAttribute", args);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.message("FSLogoutResponse(Element): missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)instantString);
        }
        catch (ParseException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse(Element): could not parse IssueInstant", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Status")) {
                if (this.status != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutResponse: included more than one <Status>");
                    }
                    throw new FSMsgException("moreElement", null);
                }
                this.status = new Status((Element)child);
                continue;
            }
            if (childName.equals("Signature")) continue;
            if (childName.equals("ProviderID")) {
                if (this.providerId != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutResponse: included more than one providerId");
                    }
                    throw new FSMsgException("moreElement", null);
                }
                this.providerId = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (childName.equals("RelayState")) {
                this.relayState = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse: included wrong element:" + childName);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.status == null) {
            FSUtils.debug.message("FSLogoutResponse:missing element <Status>.");
            throw new FSMsgException("oneElement", null);
        }
        if (this.providerId == null) {
            FSUtils.debug.message("FSLogoutResponse: missing element providerId.");
            throw new FSMsgException("oneElement", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1((Element)root, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print((Node)root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getResponseTo() {
        return this.inResponseTo;
    }

    public void setResponseTo(String inResponseTo) {
        this.inResponseTo = inResponseTo;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        block2: {
            try {
                StatusCode statusCode = new StatusCode(status);
                this.status = new Status(statusCode);
            }
            catch (Exception e) {
                if (!FSUtils.debug.messageEnabled()) break block2;
                FSUtils.debug.message("FSLogoutResponse(Element): could not set attribute:", (Throwable)e);
            }
        }
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    private void parseMajorVersion(String majorVer) throws FSMsgException, SAMLException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response(Element): invalid MajorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Response(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws FSMsgException, SAMLException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response(Element): invalid MinorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("Response(Element):MinorVersion of the Response is too high.");
            throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("Response(Element):MinorVersion of the Response is too low.");
            throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooLow", null);
        }
    }

    public static FSLogoutResponse parseXML(String xml) throws FSMsgException {
        FSLogoutResponse logoutResponse = null;
        try {
            Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)FSUtils.debug);
            Element root = doc.getDocumentElement();
            logoutResponse = new FSLogoutResponse(root);
        }
        catch (SAMLException ex) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse.parseXML: Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null, (Throwable)((Object)ex));
        }
        return logoutResponse;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"").append(" ").append('?').append(">").append("\n");
        }
        String prefixLIB = "";
        String uriLIB = "";
        if (includeNS) {
            prefixLIB = "lib:";
        }
        if (declareNS) {
            uriLIB = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        String instantString = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSLogoutResponse.toXMLString: providerId is null in the response with responseId:" + this.responseID);
            Object[] args = new String[]{this.responseID};
            throw new FSMsgException("nullProviderIdWResponseId", args);
        }
        xml.append("<").append(prefixLIB).append("LogoutResponse").append(uriLIB).append(" ");
        if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
            xml.append("id").append('=').append("\"").append(this.id).append("\"").append(" ").append(" ");
        }
        if (this.responseID != null) {
            xml.append("ResponseID").append('=').append("\"").append(this.responseID).append("\"").append(" ").append(" ");
        }
        if (this.inResponseTo != null) {
            xml.append("InResponseTo").append('=').append("\"").append(this.inResponseTo).append("\"").append(" ").append(" ");
        }
        xml.append("MajorVersion").append('=').append("\"").append(this.majorVersion).append("\"").append(" ").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append(" ").append("IssueInstant").append('=').append("\"").append(instantString).append("\"").append(">");
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print((Node)this.signature);
                xml.append(this.signatureString);
            }
        }
        if (this.providerId != null) {
            xml.append("<").append(prefixLIB).append("ProviderID").append(">").append(this.providerId).append("</").append(prefixLIB).append("ProviderID").append(">");
        }
        if (this.status != null) {
            xml.append(this.status.toString(includeNS, true));
        }
        if (this.relayState != null) {
            xml.append("<").append(prefixLIB).append("RelayState").append(">").append(this.relayState).append("</").append(prefixLIB).append("RelayState").append(">");
        }
        xml.append("</").append(prefixLIB).append("LogoutResponse").append(">");
        return xml.toString();
    }

    public static FSLogoutResponse parseBASE64EncodedString(String encodedRes) throws FSMsgException, SAMLException {
        if (encodedRes != null) {
            String decodedNameRegRes = new String(Base64.decode((String)encodedRes));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse.parseBASE64EncodedString: decoded input string: " + decodedNameRegRes);
            }
            return FSLogoutResponse.parseXML(decodedNameRegRes);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLogoutResponse.parseBASE64EncodedString: null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.responseID == null || this.responseID.length() == 0) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSLogoutResponse.toBASE64EncodedString: couldn't generate ResponseID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        return Base64.encode((byte[])this.toXMLString().getBytes());
    }

    public void signXML() {
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSLogoutResponse.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutResponse.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "ResponseID", this.getResponseID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print((Node)elem);
        return super.setSignature(elem);
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSLogoutResponse.toURLEncodedQueryString: providerId is null in the response ");
            throw new FSMsgException("nullProviderIdInRequest", null);
        }
        if (this.responseID == null || this.responseID.length() == 0) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: couldn't generate responseID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer urlEncodedAuthnReq = new StringBuffer(300);
        urlEncodedAuthnReq.append("ResponseID").append('=').append(URLEncDec.encode((String)this.responseID)).append('&');
        if (this.inResponseTo != null && this.inResponseTo.length() > 0) {
            urlEncodedAuthnReq.append("InResponseTo").append('=').append(URLEncDec.encode((String)this.inResponseTo)).append('&');
        }
        urlEncodedAuthnReq.append("MajorVersion").append('=').append(this.majorVersion).append('&').append("MinorVersion").append('=').append(this.minorVersion).append('&');
        if (this.issueInstant == null) {
            FSUtils.debug.error("FSLogoutResponse.toURLEncodedQueryString: issueInstant missing");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        urlEncodedAuthnReq.append("IssueInstant").append('=').append(URLEncDec.encode((String)DateUtils.toUTCDateFormat((Date)this.issueInstant))).append('&');
        if (this.providerId != null && this.providerId.length() != 0) {
            urlEncodedAuthnReq.append("ProviderID").append('=').append(URLEncDec.encode((String)this.providerId)).append('&');
        }
        if (this.relayState != null && this.relayState.length() != 0) {
            urlEncodedAuthnReq.append("RelayState").append('=').append(URLEncDec.encode((String)this.relayState)).append('&');
        }
        if (this.status != null) {
            urlEncodedAuthnReq.append("Value").append('=').append(URLEncDec.encode((String)this.status.getStatusCode().getValue())).append('&');
        }
        return urlEncodedAuthnReq.toString();
    }

    public static FSLogoutResponse parseURLEncodedRequest(HttpServletRequest request) throws FSMsgException, SAMLException {
        String value;
        FSLogoutResponse retLogoutResponse = new FSLogoutResponse();
        try {
            FSUtils.debug.message("checking minor version");
            retLogoutResponse.majorVersion = Integer.parseInt(request.getParameter("MajorVersion"));
            retLogoutResponse.minorVersion = Integer.parseInt(request.getParameter("MinorVersion"));
        }
        catch (NumberFormatException ex) {
            throw new FSMsgException("invalidNumber", null);
        }
        String requestID = request.getParameter("ResponseID");
        if (requestID == null) {
            Object[] args = new String[]{"ResponseID"};
            throw new FSMsgException("missingAttribute", args);
        }
        retLogoutResponse.responseID = requestID;
        retLogoutResponse.inResponseTo = request.getParameter("InResponseTo");
        String instantString = request.getParameter("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            retLogoutResponse.issueInstant = DateUtils.stringToDate((String)instantString);
        }
        catch (ParseException e) {
            throw new FSMsgException("parseError", null);
        }
        FSUtils.debug.message(" get provider Id");
        String providerID = request.getParameter("ProviderID");
        if (providerID != null) {
            retLogoutResponse.providerId = providerID;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("ProviderID : " + retLogoutResponse.providerId);
            }
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("ProviderID : " + retLogoutResponse.providerId);
            }
            throw new FSMsgException("missingElement", null);
        }
        String relayState = request.getParameter("RelayState");
        if (relayState != null) {
            retLogoutResponse.relayState = relayState;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("RelayState:" + retLogoutResponse.relayState);
            }
        }
        if ((value = request.getParameter("Value")) != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Status : " + value);
            }
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Status : " + value);
            }
            throw new FSMsgException("missingElement", null);
        }
        StatusCode statusCode = new StatusCode(value);
        retLogoutResponse.status = new Status(statusCode);
        FSUtils.debug.message("Returning Logout response Object");
        return retLogoutResponse;
    }
}

