/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.accountmgmt;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class FSAccountUtils {
    public static final String USER_FED_INFO_KEY_ATTR = "iplanet-am-user-federation-info-key";
    public static final String USER_FED_INFO_ATTR = "iplanet-am-user-federation-info";
    private static final String FED_INFO_DELIM = "|";

    public static FSAccountFedInfo stringToObject(String fedInfoString) throws FSAccountMgmtException {
        FSAccountFedInfo fedInfoObject = null;
        StringTokenizer str = new StringTokenizer(fedInfoString, FED_INFO_DELIM);
        fedInfoObject = new FSAccountFedInfo();
        try {
            String token = str.nextToken();
            fedInfoObject.setProviderID(token);
            NameIdentifier localNI = null;
            NameIdentifier remoteNI = null;
            token = str.nextToken();
            if (!token.equalsIgnoreCase("null")) {
                String localName = token;
                String localNameQualifier = "";
                String localNameFormat = "";
                token = str.nextToken();
                if (!token.equalsIgnoreCase("null")) {
                    localNameQualifier = token;
                }
                if (!(token = str.nextToken()).equalsIgnoreCase("null")) {
                    localNameFormat = token;
                }
                try {
                    localNI = new NameIdentifier(localName, localNameQualifier, localNameFormat);
                }
                catch (SAMLException se) {
                    FSUtils.debug.error("FSAccountUtils.stringToObject(): SAMLException: ", (Throwable)((Object)se));
                    throw new FSAccountMgmtException(se.getMessage());
                }
            } else {
                token = str.nextToken();
                token = str.nextToken();
            }
            fedInfoObject.setLocalNameIdentifier(localNI);
            token = str.nextToken();
            if (!token.equalsIgnoreCase("null")) {
                String remoteName = token;
                String remoteNameQualifier = "";
                String remoteNameFormat = "";
                token = str.nextToken();
                if (!token.equalsIgnoreCase("null")) {
                    remoteNameQualifier = token;
                }
                if (!(token = str.nextToken()).equalsIgnoreCase("null")) {
                    remoteNameFormat = token;
                }
                try {
                    remoteNI = new NameIdentifier(remoteName, remoteNameQualifier, remoteNameFormat);
                }
                catch (SAMLException se) {
                    FSUtils.debug.error("FSAccountUtils.stringToObject(): SAMLException: ", (Throwable)((Object)se));
                    throw new FSAccountMgmtException(se.getMessage());
                }
            } else {
                token = str.nextToken();
                token = str.nextToken();
            }
            fedInfoObject.setRemoteNameIdentifier(remoteNI);
            token = str.nextToken();
            if (token.equalsIgnoreCase("IDPRole")) {
                fedInfoObject.setRole(true);
            } else if (token.equalsIgnoreCase("SPRole")) {
                fedInfoObject.setRole(false);
            } else {
                FSUtils.debug.error("FSAccountUtils.stringToObject(): You have modified IDP/SP Role in iDS :: set it to IDPRole/SPRole ");
                throw new FSAccountMgmtException("actmgmt-fed-info-modified-in-ids", null);
            }
            token = str.nextToken();
            if (token.equalsIgnoreCase("Active")) {
                fedInfoObject.activateFedStatus();
            } else if (token.equalsIgnoreCase("InActive")) {
                fedInfoObject.deActivateFedStatus();
            } else {
                FSUtils.debug.error("FSAccountUtils.stringToObject(): You have modified Active/InActive in iDS ");
                throw new FSAccountMgmtException("actmgmt-fed-info-modified-in-ids", null);
            }
            if (str.hasMoreTokens() && (token = str.nextToken()) != null && token.equalsIgnoreCase("Affiliated")) {
                fedInfoObject.setAffiliation(true);
            }
        }
        catch (NoSuchElementException nsee) {
            FSUtils.debug.error("FSAccountUtils.stringToObject() : NoSuchElementException: ", (Throwable)nsee);
            throw new FSAccountMgmtException(nsee.getMessage());
        }
        return fedInfoObject;
    }

    public static String objectToInfoString(FSAccountFedInfo fedInfoObject) throws FSAccountMgmtException {
        String nameFormat;
        String nameQual;
        String name;
        StringBuffer fedInfoSB = new StringBuffer(1000);
        fedInfoSB.append(FED_INFO_DELIM);
        fedInfoSB.append(fedInfoObject.getProviderID());
        NameIdentifier lni = fedInfoObject.getLocalNameIdentifier();
        NameIdentifier rni = fedInfoObject.getRemoteNameIdentifier();
        if (lni == null && rni == null) {
            FSUtils.debug.error("FSAccountUtils.objectToInfoString(): both NameIdentifiers are null");
            throw new FSAccountMgmtException("actmgmt-name-identifier-is-null", null);
        }
        if (lni != null) {
            fedInfoSB.append(FED_INFO_DELIM);
            name = lni.getName();
            if (name == null || name.length() <= 0) {
                FSUtils.debug.error("FSAccountUtils.objectToInfoString(): local Name is null");
                throw new FSAccountMgmtException("actmgmt-name-is-null", null);
            }
            fedInfoSB.append(name);
            fedInfoSB.append(FED_INFO_DELIM);
            nameQual = lni.getNameQualifier();
            if (nameQual != null && nameQual.length() > 0) {
                fedInfoSB.append(nameQual);
            } else {
                fedInfoSB.append("null");
            }
            fedInfoSB.append(FED_INFO_DELIM);
            nameFormat = lni.getFormat();
            if (nameFormat != null && nameFormat.length() > 0) {
                fedInfoSB.append(nameFormat);
            } else {
                fedInfoSB.append("null");
            }
        } else {
            fedInfoSB.append(FED_INFO_DELIM);
            fedInfoSB.append("null");
            fedInfoSB.append(FED_INFO_DELIM);
            fedInfoSB.append("null");
            fedInfoSB.append(FED_INFO_DELIM);
            fedInfoSB.append("null");
        }
        if (rni != null) {
            fedInfoSB.append(FED_INFO_DELIM);
            name = rni.getName();
            if (name == null || name.length() <= 0) {
                FSUtils.debug.error("FSAccountUtils.objectToInfoString(): remote Name is null");
                throw new FSAccountMgmtException("actmgmt-name-is-null", null);
            }
            fedInfoSB.append(name);
            fedInfoSB.append(FED_INFO_DELIM);
            nameQual = rni.getNameQualifier();
            if (nameQual != null && nameQual.length() > 0) {
                fedInfoSB.append(nameQual);
            } else {
                fedInfoSB.append("null");
            }
            fedInfoSB.append(FED_INFO_DELIM);
            nameFormat = rni.getFormat();
            if (nameFormat != null && nameFormat.length() > 0) {
                fedInfoSB.append(nameFormat);
            } else {
                fedInfoSB.append("null");
            }
        } else {
            fedInfoSB.append(FED_INFO_DELIM).append("null").append(FED_INFO_DELIM).append("null").append(FED_INFO_DELIM).append("null");
        }
        fedInfoSB.append(FED_INFO_DELIM);
        if (fedInfoObject.isRoleIDP()) {
            fedInfoSB.append("IDPRole");
        } else {
            fedInfoSB.append("SPRole");
        }
        fedInfoSB.append(FED_INFO_DELIM);
        if (fedInfoObject.isFedStatusActive()) {
            fedInfoSB.append("Active");
        } else {
            fedInfoSB.append("InActive");
        }
        fedInfoSB.append(FED_INFO_DELIM);
        if (fedInfoObject.getAffiliation()) {
            fedInfoSB.append("Affiliated");
            fedInfoSB.append(FED_INFO_DELIM);
        }
        return fedInfoSB.toString();
    }

    public static String objectToKeyString(FSAccountFedInfoKey fedInfoKeyObject) throws FSAccountMgmtException {
        StringBuffer attrValueSB = new StringBuffer(300);
        String nameSpace = fedInfoKeyObject.getNameSpace();
        if (nameSpace == null || nameSpace.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.objectToKeyString():Invalid Argument : nameSpace is NULL");
            throw new FSAccountMgmtException("actmgmt-name-space-is-null", null);
        }
        String name = fedInfoKeyObject.getName();
        if (name == null || name.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.objectToKeyString():Invalid Argument : name is NULL");
            throw new FSAccountMgmtException("actmgmt-name-is-null", null);
        }
        attrValueSB.append(FED_INFO_DELIM).append(nameSpace).append(FED_INFO_DELIM).append(name).append(FED_INFO_DELIM);
        String fedKeyValue = attrValueSB.toString();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountUtils.objectToKeyString(): Value: " + fedKeyValue);
        }
        return fedKeyValue;
    }

    static String createFilter(String providerID) {
        return FED_INFO_DELIM + providerID + FED_INFO_DELIM;
    }

    static String createFilter(String providerID, String nameID) {
        String str = FED_INFO_DELIM + providerID + FED_INFO_DELIM + nameID + FED_INFO_DELIM;
        return str;
    }

    static String createFilter(FSAccountFedInfoKey fedInfoKey) throws FSAccountMgmtException {
        String nameSpace = fedInfoKey.getNameSpace();
        if (nameSpace == null || nameSpace.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.createFilter():Invalid Argument : nameSpace is NULL");
            throw new FSAccountMgmtException("actmgmt-name-space-is-null", null);
        }
        String name = fedInfoKey.getName();
        if (name == null || name.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.createFilter():Invalid Argument : name is NULL");
            throw new FSAccountMgmtException("actmgmt-name-is-null", null);
        }
        return FED_INFO_DELIM + nameSpace + FED_INFO_DELIM + name + FED_INFO_DELIM;
    }
}

