/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xmlenc;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.EncryptionProvider;
import com.sun.identity.xmlenc.EncryptionUtils;
import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedData;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509CertificateResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509IssuerSerialResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SKIResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SubjectNameResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.KeyStoreResolver;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMEncryptionProvider
implements EncryptionProvider {
    protected KeyProvider keyProvider = null;
    private boolean isJKSKeyStore = false;
    protected static Map keyMap = new HashMap();

    public void initialize(KeyProvider keystore) throws EncryptionException {
        if (keystore == null) {
            EncryptionUtils.debug.error("AMSignatureProvider.initialize: keystore is null");
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        this.keyProvider = keystore;
        if (keystore instanceof JKSKeyProvider) {
            this.isJKSKeyStore = true;
        }
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keyStrength, String certAlias, int kekStrength) throws EncryptionException {
        return this.encryptAndReplace(doc, element, secretKeyAlg, keyStrength, this.keyProvider.getPublicKey(certAlias), kekStrength, null, false);
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keyStrength, String certAlias, int kekStrength, String providerID) throws EncryptionException {
        return this.encryptAndReplace(doc, element, secretKeyAlg, keyStrength, this.keyProvider.getPublicKey(certAlias), kekStrength, providerID, false);
    }

    public Document encryptAndReplaceResourceID(Document doc, Element element, String secretKeyAlg, int keyStrength, String certAlias, int kekStrength, String providerID) throws EncryptionException {
        return this.encryptAndReplace(doc, element, secretKeyAlg, keyStrength, this.keyProvider.getPublicKey(certAlias), kekStrength, providerID, true);
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keyStrength, Key kek, int kekStrength, String providerID) throws EncryptionException {
        return this.encryptAndReplace(doc, element, secretKeyAlg, keyStrength, kek, kekStrength, providerID, false);
    }

    public Document encryptAndReplaceResourceID(Document doc, Element element, String secretKeyAlg, int keyStrength, Key kek, int kekStrength, String providerID) throws EncryptionException {
        return this.encryptAndReplace(doc, element, secretKeyAlg, keyStrength, kek, kekStrength, providerID, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keyStrength, Key kek, int kekStrength, String providerID, boolean isEncryptResourceID) throws EncryptionException {
        if (doc == null || element == null || kek == null) {
            EncryptionUtils.debug.error("AMEncryptionProvider.encryptAndReplace: Null values");
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        SecretKey secretKey = null;
        String secretKeyAlgShortName = this.getEncryptionAlgorithmShortName(secretKeyAlg);
        if (providerID != null) {
            if (keyMap.containsKey(providerID)) {
                secretKey = (SecretKey)keyMap.get(providerID);
            } else {
                secretKey = this.generateSecretKey(secretKeyAlgShortName, keyStrength);
                keyMap.put(providerID, secretKey);
            }
        } else {
            secretKey = this.generateSecretKey(secretKeyAlgShortName, keyStrength);
        }
        if (secretKey == null) {
            throw new EncryptionException(EncryptionUtils.bundle.getString("generateKeyError"));
        }
        try {
            XMLCipher cipher = null;
            String keyEncAlg = kek.getAlgorithm();
            if (keyEncAlg.equals("RSA")) {
                cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            } else if (keyEncAlg.equals("DESede")) {
                cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes");
            } else {
                if (!keyEncAlg.equals("AES")) throw new EncryptionException(EncryptionUtils.bundle.getString("unsupportedKeyAlg"));
                if (kekStrength == 0 || kekStrength == 128) {
                    cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
                } else if (kekStrength == 192) {
                    cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192");
                } else {
                    if (kekStrength != 256) throw new EncryptionException(EncryptionUtils.bundle.getString("invalidKeyStrength"));
                    cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
                }
            }
            cipher.init(3, kek);
            EncryptedKey encryptedKey = cipher.encryptKey(doc, (Key)secretKey);
            KeyInfo insideKi = new KeyInfo(doc);
            X509Data x509Data = new X509Data(doc);
            x509Data.addCertificate((X509Certificate)this.keyProvider.getCertificate((PublicKey)kek));
            insideKi.add(x509Data);
            encryptedKey.setKeyInfo(insideKi);
            String ekID = null;
            if (isEncryptResourceID) {
                ekID = SAMLUtils.generateID();
                encryptedKey.setId(ekID);
            }
            if (EncryptionUtils.debug.messageEnabled()) {
                EncryptionUtils.debug.message("AMEncryptionProvider.encryptAndReplace: Encrypted key = " + this.toString(cipher.martial(doc, encryptedKey)));
            }
            String encAlgorithm = this.getEncryptionAlgorithm(secretKeyAlgShortName, keyStrength);
            cipher = XMLCipher.getInstance((String)encAlgorithm);
            cipher.init(1, (Key)secretKey);
            EncryptedData builder = cipher.getEncryptedData();
            KeyInfo builderKeyInfo = builder.getKeyInfo();
            if (builderKeyInfo == null) {
                builderKeyInfo = new KeyInfo(doc);
                builder.setKeyInfo(builderKeyInfo);
            }
            if (isEncryptResourceID) {
                builderKeyInfo.addKeyName(providerID);
                builderKeyInfo.addRetrievalMethod("#" + ekID, null, "http://www.w3.org/2001/04/xmlenc#EncryptedKey");
            } else {
                builderKeyInfo.add(encryptedKey);
            }
            Document result = cipher.doFinal(doc, element);
            if (!isEncryptResourceID) return result;
            Element ee = (Element)result.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
            Node parentNode = ee.getParentNode();
            Element newone = result.createElementNS("urn:liberty:disco:2003-08", "EncryptedResourceID");
            parentNode.replaceChild(newone, ee);
            newone.appendChild(ee);
            Element ek = cipher.martial(doc, encryptedKey);
            Element carriedName = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CarriedKeyName");
            carriedName.appendChild(doc.createTextNode(providerID));
            ek.appendChild(carriedName);
            newone.appendChild(ek);
            return result;
        }
        catch (Exception xe) {
            EncryptionUtils.debug.error("AMEncryptionProvider.encryptAndReplace: XML Encryption error", xe);
            throw new EncryptionException(xe);
        }
    }

    public Document encryptAndReplaceWSSElements(Document doc, Map elmMap, String encDataEncAlg, int encDataEncAlgStrength, String certAlias, int kekStrength, String tokenType, String providerID) throws EncryptionException {
        return null;
    }

    public Document decryptAndReplace(Document encryptedDoc, String certAlias) throws EncryptionException {
        return this.decryptAndReplace(encryptedDoc, this.keyProvider.getPrivateKey(certAlias));
    }

    public Document decryptAndReplace(Document encryptedDoc, Key privKey) throws EncryptionException {
        EncryptionUtils.debug.message("************IN DECRYPT *************");
        if (encryptedDoc == null) {
            throw new EncryptionException(EncryptionUtils.bundle.getString("null encrypted doc"));
        }
        if (EncryptionUtils.debug.messageEnabled()) {
            EncryptionUtils.debug.message("AMEncryptionProvider.decryptAndReplace: input encrypted DOC = " + XMLUtils.print(encryptedDoc));
        }
        Key encryptionKey = null;
        Document decryptedDoc = null;
        EncryptedKey encryptedKey = null;
        Element encryptedElementNext = null;
        XMLCipher cipher = null;
        NodeList nodes = encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        int length = nodes.getLength();
        if (nodes == null || length == 0) {
            return encryptedDoc;
        }
        Element encryptedElem = (Element)encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
        try {
            cipher = XMLCipher.getInstance();
            cipher.init(2, null);
        }
        catch (Exception xe) {
            EncryptionUtils.debug.error("AMEncryptionProvider.decryptAndReplace: XML Decryption error for XMLCipher init :", xe);
            throw new EncryptionException(xe);
        }
        int i = 0;
        Element encryptedElement = (Element)nodes.item(i);
        while (i < length) {
            try {
                if (EncryptionUtils.debug.messageEnabled()) {
                    EncryptionUtils.debug.message("AMEncryptionProvider.decryptAndReplace: encrypted element (" + i + ") = " + XMLUtils.print(encryptedElement));
                }
                EncryptedData encryptedData = cipher.loadEncryptedData(encryptedDoc, encryptedElement);
                if (encryptedKey == null && (encryptedKey = cipher.loadEncryptedKey(encryptedDoc, encryptedElem)) == null) {
                    encryptedKey = encryptedData.getKeyInfo().itemEncryptedKey(0);
                }
                if (EncryptionUtils.debug.messageEnabled()) {
                    EncryptionUtils.debug.message("AMEncryptionProvider.decryptAndReplace: Encrypted key = " + this.toString(cipher.martial(encryptedDoc, encryptedKey)));
                    EncryptionUtils.debug.message("AMEncryptionProvider.decryptAndReplace: Encrypted Data (" + i + ") = " + this.toString(cipher.martial(encryptedDoc, encryptedData)));
                }
                if (encryptedKey != null) {
                    XMLCipher keyCipher = XMLCipher.getInstance();
                    if (privKey == null) {
                        privKey = this.getPrivateKey(encryptedKey.getKeyInfo());
                    }
                    keyCipher.init(4, privKey);
                    encryptionKey = keyCipher.decryptKey(encryptedKey, encryptedData.getEncryptionMethod().getAlgorithm());
                }
                cipher = XMLCipher.getInstance();
                cipher.init(2, encryptionKey);
                if (++i < length) {
                    encryptedElementNext = (Element)nodes.item(i);
                }
                decryptedDoc = cipher.doFinal(encryptedDoc, encryptedElement);
                encryptedElement = encryptedElementNext;
                if (!EncryptionUtils.debug.messageEnabled()) continue;
                EncryptionUtils.debug.message("AMEncryptionProvider.decryptAndReplace: decryptedDoc (" + (i - 1) + ") = " + XMLUtils.print(decryptedDoc));
            }
            catch (Exception xe) {
                EncryptionUtils.debug.error("AMEncryptionProvider.decryptAndReplace: XML Decryption error.", xe);
                throw new EncryptionException(xe);
            }
        }
        if (EncryptionUtils.debug.messageEnabled()) {
            EncryptionUtils.debug.message("AMEncryptionProvider.decryptAndReplace: FINAL decryptedDoc = " + XMLUtils.print(decryptedDoc));
        }
        return decryptedDoc;
    }

    private String toString(Element doc) {
        OutputFormat of = new OutputFormat();
        of.setIndenting(true);
        of.setMethod("xml");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer(baos, of);
        try {
            serializer.serialize(doc);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return baos.toString();
    }

    private String getEncryptionAlgorithmShortName(String algorithmUri) throws EncryptionException {
        if (algorithmUri == null) {
            return null;
        }
        if (algorithmUri.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || algorithmUri.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || algorithmUri.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return "AES";
        }
        if (algorithmUri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return "DESede";
        }
        throw new EncryptionException(EncryptionUtils.bundle.getString("unsupportedKeyAlg"));
    }

    protected String getEncryptionAlgorithm(String algorithm, int keyStrength) throws EncryptionException {
        if (algorithm == null) {
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        if (algorithm.equals("AES")) {
            if (keyStrength == 0 || keyStrength == 128) {
                return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            }
            if (keyStrength == 192) {
                return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            }
            if (keyStrength == 256) {
                return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            }
            throw new EncryptionException(EncryptionUtils.bundle.getString("invalidKeyStrength"));
        }
        if (algorithm.equals("DESede")) {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }
        throw new EncryptionException(EncryptionUtils.bundle.getString("unsupportedKeyAlg"));
    }

    protected SecretKey generateSecretKey(String algorithm, int keyStrength) throws EncryptionException {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
            if (keyStrength != 0) {
                keygen.init(keyStrength);
            }
            return keygen.generateKey();
        }
        catch (NoSuchAlgorithmException ne) {
            throw new EncryptionException(ne);
        }
    }

    protected PrivateKey getPrivateKey(KeyInfo keyinfo) {
        PrivateKey pk = null;
        try {
            if (keyinfo != null) {
                if (this.isJKSKeyStore) {
                    StorageResolver storageResolver = new StorageResolver(new KeyStoreResolver(((JKSKeyProvider)this.keyProvider).getKeyStore()));
                    keyinfo.addStorageResolver(storageResolver);
                    keyinfo.registerInternalKeyResolver(new X509IssuerSerialResolver());
                    keyinfo.registerInternalKeyResolver(new X509CertificateResolver());
                    keyinfo.registerInternalKeyResolver(new X509SKIResolver());
                    keyinfo.registerInternalKeyResolver(new X509SubjectNameResolver());
                }
                if (keyinfo.containsX509Data()) {
                    if (EncryptionUtils.debug.messageEnabled()) {
                        EncryptionUtils.debug.message("Found X509Data element in the KeyInfo");
                    }
                    X509Certificate certificate = keyinfo.getX509Certificate();
                    String certAlias = this.keyProvider.getCertificateAlias(certificate);
                    pk = this.keyProvider.getPrivateKey(certAlias);
                }
            }
        }
        catch (Exception e) {
            EncryptionUtils.debug.error("getPrivateKey(KeyInfo) Exception: ", e);
        }
        return pk;
    }

    static {
        Init.init();
    }
}

