/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Decision;
import com.sun.identity.xacml.context.Result;
import com.sun.identity.xacml.context.Status;
import com.sun.identity.xacml.policy.Obligations;
import com.sun.identity.xacml.policy.PolicyFactory;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultImpl
implements Result {
    private String resourceId = null;
    private Decision decision = null;
    private Status status = null;
    private Obligations obligations = null;
    private boolean mutable = true;

    public ResultImpl() throws XACMLException {
    }

    public ResultImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument(xml, XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public ResultImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        this.resourceId = resourceId;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public void setDecision(Decision decision) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (decision == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.decision = decision;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        this.status = status;
    }

    public Obligations getObligations() {
        return this.obligations;
    }

    public void setObligations(Obligations obligations) throws XACMLException {
        this.obligations = obligations;
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String nsDeclaration = "";
        String nsPrefix = "";
        if (declareNS) {
            nsDeclaration = XACMLConstants.CONTEXT_NS_DECLARATION;
        }
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        sb.append("<").append(nsPrefix).append("Result").append(nsDeclaration);
        sb.append(" ");
        if (this.resourceId != null) {
            sb.append("ResourceId").append("=").append(XACMLSDKUtils.quote(this.resourceId));
        }
        sb.append(">\n");
        if (this.decision != null) {
            sb.append(this.decision.toXMLString(includeNSPrefix, false));
        }
        if (this.status != null) {
            sb.append(this.status.toXMLString(includeNSPrefix, false));
        }
        if (this.obligations != null) {
            sb.append(this.obligations.toXMLString(includeNSPrefix, true));
        }
        sb.append("</").append(nsPrefix).append("Result").append(">\n");
        return sb.toString();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void makeImmutable() {
        if (this.mutable) {
            if (this.decision != null) {
                this.decision.makeImmutable();
            }
            if (this.status != null) {
                this.status.makeImmutable();
            }
            this.mutable = false;
        }
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals("Result")) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        String resourceIdValue = element.getAttribute("ResourceId");
        if (resourceIdValue != null || resourceIdValue.length() != 0) {
            this.resourceId = resourceIdValue;
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (int i = 0; i < numOfNodes; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            childElements.add(child);
        }
        int childCount = childElements.size();
        if (childCount < 1) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid child element count: " + childCount);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_count"));
        }
        if (childCount > 3) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid child element count: " + childCount);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_count"));
        }
        Element firstChild = (Element)childElements.get(0);
        String firstChildName = firstChild.getLocalName();
        if (!firstChildName.equals("Decision")) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid first child element: " + firstChildName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_first_child"));
        }
        this.decision = ContextFactory.getInstance().createDecision(firstChild);
        if (childCount > 1) {
            String thirdChildName;
            Element thirdChild;
            Element secondChild = (Element)childElements.get(1);
            String secondChildName = secondChild.getLocalName();
            if (secondChildName.equals("Status")) {
                this.status = ContextFactory.getInstance().createStatus(secondChild);
            } else if (secondChildName.equals(XACMLConstants.OBLIGATIONS)) {
                this.obligations = PolicyFactory.getInstance().createObligations(secondChild);
            } else {
                XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid second child element: " + secondChildName);
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_second_child"));
            }
            if (childCount > 2) {
                thirdChild = (Element)childElements.get(2);
                thirdChildName = thirdChild.getLocalName();
                if (thirdChildName.equals(XACMLConstants.OBLIGATIONS) && this.obligations == null) {
                    this.obligations = PolicyFactory.getInstance().createObligations(thirdChild);
                } else {
                    XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid third child element: " + thirdChildName);
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_third_child"));
                }
            }
            if (childCount > 3) {
                thirdChild = (Element)childElements.get(3);
                thirdChildName = thirdChild.getLocalName();
                XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid third child element: " + thirdChildName);
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_third_child"));
            }
        }
    }
}

