/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.BinarySecurityToken;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SAML2TokenUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.UserNameToken;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.XMLEncryptionManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecureSOAPMessage {
    private SOAPMessage soapMessage = null;
    private SecurityToken securityToken = null;
    private SecurityMechanism securityMechanism = null;
    private boolean create = false;
    private Element wsseHeader = null;
    private X509Certificate messageCertificate = null;
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private String server_proto = SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol");
    private String server_host = SystemConfigurationUtil.getProperty("com.iplanet.am.server.host");
    private String server_port = SystemConfigurationUtil.getProperty("com.iplanet.am.server.port");

    public SecureSOAPMessage(SOAPMessage soapMessage, boolean create) throws SecurityException {
        this.soapMessage = soapMessage;
        this.create = create;
        if (debug.messageEnabled()) {
            debug.message("SecureSOAPMessage.Input SOAP message : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        if (!create) {
            this.parseSOAPMessage(soapMessage);
        } else {
            soapMessage.getSOAPPart().normalize();
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.Input SOAP message After normalization: " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
            }
            this.addNameSpaces();
            this.addSecurityHeader();
        }
    }

    public Element getSecurityHeaderElement() {
        return this.wsseHeader;
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }

    public void setSOAPMessage(SOAPMessage inSoapMessage) {
        this.soapMessage = inSoapMessage;
    }

    private void parseSOAPMessage(SOAPMessage soapMessage) throws SecurityException {
        try {
            NodeList headerChildNodes;
            SOAPHeader header = soapMessage.getSOAPPart().getEnvelope().getHeader();
            if (header == null && debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.parseSOAPMessage: No SOAP header found.");
            }
            if (((headerChildNodes = header.getChildNodes()) == null || headerChildNodes.getLength() == 0) && debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.parseSOAPMessage: No security header found.");
            }
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                Node currentNode = headerChildNodes.item(i);
                if (currentNode.getNodeType() != 1 || !"Security".equals(currentNode.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentNode.getNamespaceURI())) continue;
                this.wsseHeader = (Element)currentNode;
            }
        }
        catch (SOAPException se) {
            debug.error("SecureSOAPMessage.parseSOAPMessage: SOAPException in parsing the headers.", se);
            throw new SecurityException(se.getMessage());
        }
    }

    public void parseSecurityHeader(Node node) throws SecurityException {
        if (node != null) {
            NodeList securityHeaders = node.getChildNodes();
            for (int i = 0; i < securityHeaders.getLength(); ++i) {
                Node currentNode = securityHeaders.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String localName = currentNode.getLocalName();
                String nameSpace = currentNode.getNamespaceURI();
                if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: Assertion token found in the security header.");
                    }
                    try {
                        this.securityToken = new AssertionToken((Element)currentNode);
                        AssertionToken assertionToken = (AssertionToken)this.securityToken;
                        this.securityMechanism = assertionToken.isSenderVouches() ? SecurityMechanism.WSS_NULL_SAML_SV : SecurityMechanism.WSS_NULL_SAML_HK;
                        this.messageCertificate = WSSUtils.getCertificate(assertionToken);
                        continue;
                    }
                    catch (SAMLException se) {
                        debug.error("SecureSOAPMessage.parseSecurityHeader: unable to parse the token", se);
                        throw new SecurityException(se.getMessage());
                    }
                }
                if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: SAML2 token found in the security header.");
                    }
                    try {
                        this.securityToken = new SAML2Token((Element)currentNode);
                        SAML2Token saml2Token = (SAML2Token)this.securityToken;
                        this.securityMechanism = saml2Token.isSenderVouches() ? SecurityMechanism.WSS_NULL_SAML2_SV : SecurityMechanism.WSS_NULL_SAML2_HK;
                        this.messageCertificate = SAML2TokenUtils.getCertificate(saml2Token);
                        continue;
                    }
                    catch (SAML2Exception se) {
                        debug.error("SecureSOAPMessage.parseSecurityHeader: unable to parse the token", se);
                        throw new SecurityException(se.getMessage());
                    }
                }
                if ("BinarySecurityToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: binary token found in the security header.");
                    }
                    this.securityToken = new BinarySecurityToken((Element)currentNode);
                    this.securityMechanism = SecurityMechanism.WSS_NULL_X509_TOKEN;
                    this.messageCertificate = WSSUtils.getCertificate(this.securityToken);
                    continue;
                }
                if ("UsernameToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: username token found in the security header.");
                    }
                    this.securityToken = new UserNameToken((Element)currentNode);
                    UserNameToken usernameToken = (UserNameToken)this.securityToken;
                    String passwordType = usernameToken.getPasswordType();
                    if (passwordType == null) continue;
                    if (passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
                        this.securityMechanism = SecurityMechanism.WSS_NULL_USERNAME_TOKEN;
                        continue;
                    }
                    if (!passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText")) continue;
                    this.securityMechanism = SecurityMechanism.WSS_NULL_USERNAME_TOKEN_PLAIN;
                    continue;
                }
                if (this.securityToken != null) continue;
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.parseSecurityHeader: security token is null, hence Security Mechanism is set to ANONYMOUS");
                }
                this.securityMechanism = SecurityMechanism.WSS_NULL_ANONYMOUS;
            }
        }
    }

    public SecurityMechanism getSecurityMechanism() {
        return this.securityMechanism;
    }

    public void setSecurityMechanism(SecurityMechanism securityMechanism) {
        this.securityMechanism = securityMechanism;
    }

    public void setSecurityToken(SecurityToken token) throws SecurityException {
        if (this.wsseHeader == null) {
            debug.error("SecureSOAPMessage.setSecurityToken:: WSSE security Header is not found in the Secure SOAP Message.");
            throw new SecurityException(bundle.getString("securityHeaderNotFound"));
        }
        this.securityToken = token;
        Element tokenE = token.toDocumentElement();
        Node tokenNode = this.soapMessage.getSOAPPart().importNode((Node)tokenE, true);
        WSSUtils.prependChildElement(this.wsseHeader, (Element)tokenNode, true, (Document)this.soapMessage.getSOAPPart());
    }

    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    private void addNameSpaces() throws SecurityException {
        try {
            SOAPEnvelope envelope = this.soapMessage.getSOAPPart().getEnvelope();
            envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPBody body = this.soapMessage.getSOAPPart().getEnvelope().getBody();
            body.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            body.setAttribute("wsu:Id", SAMLUtils.generateID());
        }
        catch (SOAPException se) {
            debug.error("SecureSOAPMessage.addNameSpaces:: Could not add Name spaces. ", se);
            throw new SecurityException(bundle.getString("nameSpaceAdditionfailure"));
        }
    }

    private void addSecurityHeader() throws SecurityException {
        if (debug.messageEnabled()) {
            debug.message("SecureSOAPMessage.addSecurityHeader:: preparing the security header");
        }
        try {
            SOAPEnvelope envelope = this.soapMessage.getSOAPPart().getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (header == null) {
                header = this.soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            SOAPPart soapPart = this.soapMessage.getSOAPPart();
            this.wsseHeader = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            this.wsseHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            this.wsseHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            this.wsseHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse11", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
            String envPrefix = envelope.getPrefix();
            if (envPrefix != null) {
                this.wsseHeader.setAttribute(envPrefix + ":" + "mustUnderstand", "1");
            }
            Element timeStamp = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
            this.wsseHeader.appendChild(timeStamp);
            Element created = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
            Date createTime = new Date();
            Date expireTime = new Date();
            expireTime.setTime(createTime.getTime() + 300000L);
            created.appendChild(soapPart.createTextNode(DateUtils.toUTCDateFormat(createTime)));
            timeStamp.appendChild(created);
            Element expires = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
            expires.appendChild(soapPart.createTextNode(DateUtils.toUTCDateFormat(expireTime)));
            timeStamp.appendChild(expires);
            header.appendChild((Node)this.wsseHeader);
        }
        catch (SOAPException se) {
            debug.error("SecureSOAPMessage.addSecurityHeader:: SOAPException while adding the security header.", se);
            throw new SecurityException(bundle.getString("addSecurityHeaderFailed"));
        }
    }

    public void sign(String certAlias) throws SecurityException {
        Document doc = this.toDocument();
        String tokenType = null;
        if (this.securityToken != null) {
            tokenType = this.securityToken.getTokenType();
        }
        if ("urn:sun:wss:samltoken".equals(tokenType) || "urn:sun:wss:saml2token".equals(tokenType)) {
            this.signWithAssertion(doc, certAlias);
        } else if ("urn:sun:wss:x509token".equals(tokenType)) {
            this.signWithBinaryToken(doc, certAlias);
        } else if ("urn:sun:wss:usernametoken".equals(tokenType) || null == this.securityToken) {
            this.signWithUNToken(doc, certAlias);
        } else {
            debug.error("SecureSOAPMessage.sign:: Invalid token type for XML signing.");
        }
        if (debug.messageEnabled()) {
            debug.message("SecureSOAPMessage.sign:: After Signing : " + WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
        }
    }

    private void signWithAssertion(Document doc, String certAlias) throws SecurityException {
        XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
        KeyProvider keyProvider = sigManager.getKeyProvider();
        X509Certificate cert = null;
        String uri = this.securityMechanism.getURI();
        if ("urn:sun:wss:security:null:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-HK".equals(uri)) {
            cert = WSSUtils.getCertificate(this.securityToken);
        } else if ("urn:sun:wss:security:null:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-HK".equals(uri)) {
            cert = SAML2TokenUtils.getCertificate(this.securityToken);
        } else if ("urn:sun:wss:security:null:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:null:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-SV".equals(uri)) {
            cert = keyProvider.getX509Certificate(certAlias);
        } else if ("urn:sun:wss:sts:security".equals(uri)) {
            if ("urn:sun:wss:samltoken".equals(this.securityToken.getTokenType())) {
                cert = WSSUtils.getCertificate(this.securityToken);
            } else if ("urn:sun:wss:saml2token".equals(this.securityToken.getTokenType())) {
                cert = SAML2TokenUtils.getCertificate(this.securityToken);
            }
            if (cert == null) {
                cert = keyProvider.getX509Certificate(certAlias);
            }
        } else {
            debug.error("SecureSOAPMessage.signWithSAMLAssertion:: Unknown security mechanism");
            throw new SecurityException(bundle.getString("unknownSecurityMechanism"));
        }
        Element sigElement = null;
        try {
            String assertionID = null;
            if (this.securityToken instanceof AssertionToken) {
                AssertionToken assertionToken = (AssertionToken)this.securityToken;
                assertionID = assertionToken.getAssertion().getAssertionID();
            } else if (this.securityToken instanceof SAML2Token) {
                SAML2Token saml2Token = (SAML2Token)this.securityToken;
                assertionID = saml2Token.getAssertion().getID();
            }
            sigElement = sigManager.signWithSAMLToken(doc, cert, assertionID, "", this.getSigningIds());
        }
        catch (XMLSignatureException se) {
            debug.error("SecureSOAPMessage.signWithAssertion:: signing failed", se);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithAssertion:: signing failed", ex);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        this.wsseHeader.appendChild(this.soapMessage.getSOAPPart().importNode((Node)sigElement, true));
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithAssertion:: SOAP message save failed : ", ex);
        }
    }

    private void signWithBinaryToken(Document doc, String certAlias) throws SecurityException {
        X509Certificate cert = null;
        Element sigElement = null;
        XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
        KeyProvider keyProvider = sigManager.getKeyProvider();
        try {
            cert = keyProvider.getX509Certificate(certAlias);
            sigElement = sigManager.signWithBinarySecurityToken(doc, cert, "", this.getSigningIds());
        }
        catch (XMLSignatureException se) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: Signature Exception.", se);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: signing failed", ex);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        this.wsseHeader.appendChild(this.soapMessage.getSOAPPart().importNode((Node)sigElement, true));
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: SOAP message save failed : ", ex);
        }
    }

    private void signWithUNToken(Document doc, String certAlias) throws SecurityException {
        X509Certificate cert = null;
        Element sigElement = null;
        XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
        KeyProvider keyProvider = sigManager.getKeyProvider();
        try {
            cert = keyProvider.getX509Certificate(certAlias);
            sigElement = sigManager.signWithUserNameToken(doc, cert, "", this.getSigningIds());
        }
        catch (XMLSignatureException se) {
            debug.error("SecureSOAPMessage.signWithUNToken:: Signature Exception.", se);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithUNToken:: signing failed", ex);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        this.wsseHeader.appendChild(this.soapMessage.getSOAPPart().importNode((Node)sigElement, true));
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithUNToken:: SOAP message save failed : ", ex);
        }
    }

    private List getSigningIds() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        SOAPBody body = this.soapMessage.getSOAPPart().getEnvelope().getBody();
        String id = body.getAttribute("wsu:Id");
        ids.add(id);
        return ids;
    }

    public boolean verifySignature() throws SecurityException {
        try {
            Document doc = this.toDocument();
            XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
            String certAlias = null;
            if (this.messageCertificate != null) {
                certAlias = sigManager.getKeyProvider().getCertificateAlias(this.messageCertificate);
            }
            return sigManager.verifyWSSSignature(doc, certAlias);
        }
        catch (SAMLException se) {
            debug.error("SecureSOAPMessage.verify:: Signature validation failed", se);
            throw new SecurityException(bundle.getString("signatureValidationFailed"));
        }
    }

    private Document toDocument() throws SecurityException {
        try {
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            this.soapMessage.writeTo((OutputStream)bop);
            ByteArrayInputStream bin = new ByteArrayInputStream(bop.toByteArray());
            return XMLUtils.toDOMDocument(bin, WSSUtils.debug);
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.toDocument: Could not Convert the SOAP Message to XML document.", ex);
            throw new SecurityException(ex.getMessage());
        }
    }

    public X509Certificate getMessageCertificate() {
        return this.messageCertificate;
    }

    public void encrypt(String certAlias, boolean encryptBody, boolean encryptHeader) throws SecurityException {
        Document doc = this.toDocument();
        String tokenType = null;
        tokenType = this.securityToken == null ? "urn:sun:wss:x509token" : this.securityToken.getTokenType();
        HashMap<Element, String> elmMap = new HashMap<Element, String>();
        Document encryptedDoc = null;
        String searchType = null;
        try {
            if (encryptBody) {
                Element bodyElement = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
                String bodyId = bodyElement.getAttribute("wsu:Id");
                Node firstNodeInsideBody = bodyElement.getFirstChild();
                elmMap.put((Element)firstNodeInsideBody, bodyId);
            }
            if (encryptHeader) {
                String tokenId = null;
                if ("urn:sun:wss:x509token".equals(tokenType)) {
                    searchType = "BinarySecurityToken";
                } else if ("urn:sun:wss:usernametoken".equals(tokenType)) {
                    searchType = "UsernameToken";
                } else if ("urn:sun:wss:samltoken".equals(tokenType)) {
                    searchType = "Assertion";
                    AssertionToken assertionToken = (AssertionToken)this.securityToken;
                    tokenId = assertionToken.getAssertion().getAssertionID();
                }
                Element secHeaderElement = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.encrypt:: Security Header : " + WSSUtils.print(secHeaderElement));
                }
                if (secHeaderElement != null) {
                    Element token = (Element)secHeaderElement.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", searchType).item(0);
                    if (token != null && tokenId == null) {
                        tokenId = token.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    }
                    elmMap.put(token, tokenId);
                }
            }
            XMLEncryptionManager encManager = WSSUtils.getXMLEncryptionManager();
            encryptedDoc = encManager.encryptAndReplaceWSSElements(doc, elmMap, "DESede", 0, certAlias, 0, tokenType, this.server_proto + "://" + this.server_host + ":" + this.server_port);
        }
        catch (EncryptionException ee) {
            debug.error("SecureSOAPMessage.encrypt:: Encryption Exception : ", ee);
            throw new SecurityException(bundle.getString("unabletoEncrypt"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.encrypt:: encryption failed : ", ex);
            throw new SecurityException(bundle.getString("unabletoEncrypt"));
        }
        try {
            Element encryptedKeyElem = (Element)encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.encrypt:EncryptedKey DOC : " + WSSUtils.print(encryptedKeyElem));
            }
            Node encKeyNode = this.soapMessage.getSOAPPart().importNode((Node)encryptedKeyElem, true);
            this.wsseHeader.appendChild(encKeyNode);
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.encrypt:: wsseHeader: after Encrypt : " + WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
            }
            NodeList nodes = encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Element encryptedDataElem = (Element)nodes.item(i);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.encrypt:EncryptedData DOC (" + i + ") : " + WSSUtils.print(encryptedDataElem));
                }
                Node encDataNode = this.soapMessage.getSOAPPart().importNode((Node)encryptedDataElem, true);
                if ("Body".equals(encryptedDataElem.getParentNode().getLocalName())) {
                    Node firstNodeInsideBody = this.soapMessage.getSOAPPart().getEnvelope().getBody().getFirstChild();
                    this.soapMessage.getSOAPPart().getEnvelope().getBody().replaceChild(encDataNode, firstNodeInsideBody);
                    continue;
                }
                if (!encryptHeader) continue;
                Element token = (Element)this.wsseHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", searchType).item(0);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.encrypt:: wsseHeader: token element : " + WSSUtils.print(token));
                }
                if (token == null) continue;
                this.wsseHeader.removeChild(encKeyNode);
                this.wsseHeader.insertBefore(encKeyNode, token);
                this.wsseHeader.replaceChild(encDataNode, token);
            }
            this.soapMessage = WSSUtils.toSOAPMessage((Document)this.soapMessage.getSOAPPart());
            this.soapMessage.saveChanges();
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.encrypt:*** SOAP PART ***");
                debug.message(WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
            }
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.encrypt:: encryption failed : ", ex);
            throw new SecurityException(bundle.getString("unabletoGetFinalSoapMessage"));
        }
    }

    public void decrypt(boolean decryptBody, boolean decryptHeader) throws SecurityException {
        Document decryptedDoc = null;
        try {
            Document doc = this.toDocument();
            NodeList nodes = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            if (nodes == null || nodes.getLength() == 0) {
                debug.error("SecureSOAPMessage.decrypt:: Request is not encrypted.");
                throw new SecurityException(bundle.getString("decryptEncryptionFailed"));
            }
            XMLSignatureManager sigManager = XMLSignatureManager.getInstance();
            XMLEncryptionManager encManager = WSSUtils.getXMLEncryptionManager();
            String certAlias = null;
            if (this.messageCertificate != null) {
                certAlias = sigManager.getKeyProvider().getCertificateAlias(this.messageCertificate);
            }
            decryptedDoc = encManager.decryptAndReplace(doc, certAlias);
        }
        catch (EncryptionException ee) {
            debug.error("SecureSOAPMessage.decrypt:: Decrypt encryption failed : ", ee);
            throw new SecurityException(bundle.getString("decryptEncryptionFailed"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.decrypt:: exception : ", ex);
            throw new SecurityException(bundle.getString("unabletoDecrypt"));
        }
        try {
            if (decryptBody) {
                Element decryptedBodyElem = (Element)decryptedDoc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
                SOAPBody bodyElement = this.soapMessage.getSOAPPart().getEnvelope().getBody();
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.decrypt::decrypted Body element : " + WSSUtils.print(decryptedBodyElem));
                    debug.message("SecureSOAPMessage.decrypt::SOAP Body element : " + WSSUtils.print((Node)bodyElement));
                }
                Node decDataNode = this.soapMessage.getSOAPPart().importNode((Node)decryptedBodyElem, true);
                Node firstNodeInsideBody = this.soapMessage.getSOAPPart().getEnvelope().getBody().getFirstChild();
                this.soapMessage.getSOAPPart().getEnvelope().getBody().replaceChild(decDataNode.getFirstChild(), firstNodeInsideBody);
            }
            if (decryptHeader) {
                Element decryptedSecHeaderElement = (Element)decryptedDoc.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
                Node decSecHeaderDataNode = this.soapMessage.getSOAPPart().importNode((Node)decryptedSecHeaderElement, true);
                Node tokenNode = this.getTokenNode(decSecHeaderDataNode);
                Element token = (Element)this.wsseHeader.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.decrypt: decrypted Security Header doc : " + WSSUtils.print(decryptedSecHeaderElement));
                    debug.message("SecureSOAPMessage.decrypt: SOAP HEADER DOC : " + WSSUtils.print(this.wsseHeader));
                    debug.message("SecureSOAPMessage.decrypt: tokenNode from decrypted Security header doc: " + WSSUtils.print(tokenNode));
                    debug.message("SecureSOAPMessage.decrypt: token from current SOAP wsseHeader : " + WSSUtils.print(token));
                }
                if (token != null) {
                    Element encKey = (Element)this.wsseHeader.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
                    this.wsseHeader.removeChild(encKey);
                    this.wsseHeader.appendChild(encKey);
                    this.wsseHeader.replaceChild(tokenNode, token);
                }
            }
            this.soapMessage = WSSUtils.toSOAPMessage((Document)this.soapMessage.getSOAPPart());
            this.soapMessage.saveChanges();
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.decrypt:*** SOAP PART ***");
                debug.message(WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
            }
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.decrypt:: decryption failed : ", ex);
            throw new SecurityException(bundle.getString("unabletoGetFinalSoapMessage"));
        }
    }

    private Node getTokenNode(Node secHeaderNode) throws Exception {
        Node tokenNode = null;
        String searchType = null;
        NodeList securityHeaders = secHeaderNode.getChildNodes();
        for (int i = 0; i < securityHeaders.getLength(); ++i) {
            Node currentNode = securityHeaders.item(i);
            String localName = currentNode.getLocalName();
            String nameSpace = currentNode.getNamespaceURI();
            if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(nameSpace)) {
                searchType = "Assertion";
            } else if ("BinarySecurityToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                searchType = "BinarySecurityToken";
            } else if ("UsernameToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                searchType = "UsernameToken";
            }
            if (searchType == null) continue;
            tokenNode = currentNode;
            break;
        }
        return tokenNode;
    }
}

