/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.util.impl;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.IDebug;
import com.sun.identity.shared.locale.Locale;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;

public class DebugImpl
implements IDebug {
    private static final String CONFIG_DEBUG_DIRECTORY = "com.iplanet.services.debug.directory";
    private static final String CONFIG_DEBUG_LEVEL = "com.iplanet.services.debug.level";
    private String debugName;
    private int debugLevel = 4;
    private PrintWriter debugWriter = null;
    private PrintWriter stdoutWriter = new PrintWriter(System.out, true);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
    private String debugFilePath;

    public DebugImpl(String debugName) {
        this.setName(debugName);
        this.setDebug(SystemProperties.get(CONFIG_DEBUG_LEVEL));
    }

    private synchronized void initialize() {
        block10: {
            if (this.debugWriter == null) {
                String debugDirectory = SystemProperties.get(CONFIG_DEBUG_DIRECTORY);
                boolean directoryAvailable = false;
                if (debugDirectory != null && debugDirectory.trim().length() > 0) {
                    File dir = new File(debugDirectory);
                    if (!dir.exists()) {
                        directoryAvailable = dir.mkdirs();
                    } else if (dir.isDirectory() && dir.canWrite()) {
                        directoryAvailable = true;
                    }
                }
                if (!directoryAvailable) {
                    ResourceBundle bundle = Locale.getInstallResourceBundle("amUtilMsgs");
                    System.err.println(bundle.getString("com.iplanet.services.debug.nodir"));
                    return;
                }
                this.debugFilePath = debugDirectory + File.separator + this.debugName;
                String prefix = this.dateFormat.format(new Date()) + ": " + Thread.currentThread().toString();
                try {
                    this.debugWriter = new PrintWriter((Writer)new FileWriter(this.debugFilePath, true), true);
                    this.writeIt(prefix, "**********************************************", null);
                }
                catch (IOException ioex) {
                    this.setDebug(4);
                    ResourceBundle bundle = Locale.getInstallResourceBundle("amUtilMsgs");
                    System.err.println(bundle.getString("com.iplanet.services.debug.nofile"));
                    ioex.printStackTrace(System.err);
                    if (this.debugWriter == null) break block10;
                    try {
                        this.debugWriter.close();
                    }
                    catch (Exception ex1) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public String getName() {
        return this.debugName;
    }

    public int getState() {
        return this.debugLevel;
    }

    public void setDebug(int level) {
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.debugLevel = level;
                break;
            }
        }
    }

    public void setDebug(String strDebugLevel) {
        int debugLevel = 4;
        if (strDebugLevel != null && strDebugLevel.trim().length() > 0) {
            if (strDebugLevel.equals("off")) {
                debugLevel = 0;
            } else if (strDebugLevel.equals("error")) {
                debugLevel = 1;
            } else if (strDebugLevel.equals("warning")) {
                debugLevel = 2;
            } else if (strDebugLevel.equals("message")) {
                debugLevel = 3;
            }
        }
        this.setDebug(debugLevel);
    }

    public boolean messageEnabled() {
        return this.debugLevel > 2;
    }

    public boolean warningEnabled() {
        return this.debugLevel > 1;
    }

    public boolean errorEnabled() {
        return this.debugLevel > 0;
    }

    public void message(String message, Throwable th) {
        if (this.messageEnabled()) {
            this.record(message, th);
        }
    }

    public void warning(String message, Throwable th) {
        if (this.warningEnabled()) {
            this.record("WARNING: " + message, th);
        }
    }

    public void error(String message, Throwable th) {
        if (this.errorEnabled()) {
            this.record("ERROR: " + message, th);
        }
    }

    private void record(String msg, Throwable th) {
        String prefix = this.dateFormat.format(new Date()) + ": " + Thread.currentThread().toString();
        this.writeIt(prefix, msg, th);
    }

    private void writeIt(String prefix, String msg, Throwable th) {
        if (this.debugLevel == 4) {
            this.writeIt(this.stdoutWriter, prefix, msg, th);
        } else {
            if (this.debugWriter == null) {
                this.initialize();
            }
            if (this.debugWriter != null) {
                this.writeIt(this.debugWriter, prefix, msg, th);
            } else {
                this.writeIt(this.stdoutWriter, prefix, "DebugWriter is null.", th);
                this.writeIt(this.stdoutWriter, prefix, msg, th);
            }
        }
    }

    private void writeIt(PrintWriter writer, String prefix, String msg, Throwable th) {
        StringBuffer buf = new StringBuffer(prefix);
        buf.append('\n');
        buf.append(msg);
        if (th != null) {
            buf.append('\n');
            StringWriter stBuf = new StringWriter(300);
            PrintWriter stackStream = new PrintWriter(stBuf);
            th.printStackTrace(stackStream);
            stackStream.flush();
            buf.append(stBuf.toString());
        }
        writer.println(buf.toString());
    }

    private void setName(String debugName) {
        this.debugName = debugName;
    }

    private PrintWriter getStdoutWriter() {
        return this.stdoutWriter;
    }

    protected void finalize() throws Throwable {
        if (this.debugWriter != null) {
            try {
                this.debugWriter.flush();
                this.debugWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

