/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceInstanceImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

class ServiceConfigManagerImpl {
    private String serviceName;
    private String version;
    private ServiceSchemaManagerImpl ssm;
    private HashMap listenerObjects;
    private String orgNotificationSearchString;
    private String glbNotificationSearchString;
    private String schemaNotificationSearchString;
    private CachedSubEntries instances;
    private CachedSubEntries groups;
    Cache globalConfigs;
    Cache orgConfigs;
    private static Map configMgrImpls = new HashMap();
    private static final String configMgrMutex = "ConfigMgrMutex";
    private static Map userPrincipals = new HashMap();
    private static Debug debug = SMSEntry.debug;

    private ServiceConfigManagerImpl(SSOToken token, String serviceName, String version) throws SMSException, SSOException {
        this.serviceName = serviceName;
        this.version = version;
        String serviceDN = ServiceManager.getServiceNameDN(serviceName, version);
        this.ssm = ServiceSchemaManagerImpl.getInstance(token, serviceName, version);
        this.listenerObjects = new HashMap();
        SMSEventListenerManager.notifyAllNodeChanges(token, this);
        DN notifyDN = new DN("ou=" + version + ",ou=" + serviceName + "," + "ou=services");
        String sdn = notifyDN.toRFCString().toLowerCase();
        this.orgNotificationSearchString = "ou=OrganizationConfig,".toLowerCase() + sdn;
        this.glbNotificationSearchString = "ou=GlobalConfig,".toLowerCase() + sdn;
        this.schemaNotificationSearchString = sdn;
        String dn = "ou=Instances," + serviceDN;
        this.instances = CachedSubEntries.getInstance(token, dn);
        dn = "ou=GlobalConfig," + serviceDN;
        this.groups = CachedSubEntries.getInstance(token, dn);
        if (SMSEntry.cacheSMSEntries) {
            this.globalConfigs = new Cache(1000);
            this.orgConfigs = new Cache(1000);
        }
    }

    ServiceSchemaManagerImpl getServiceSchemaManagerImpl() {
        return this.ssm;
    }

    String getName() {
        return this.serviceName;
    }

    String getVersion() {
        return this.version;
    }

    Set getInstanceNames(SSOToken t) throws SMSException, SSOException {
        return this.instances.getSubEntries(t);
    }

    Set getGroupNames(SSOToken t) throws SMSException, SSOException {
        return this.groups.getSubEntries(t);
    }

    ServiceInstanceImpl getInstance(SSOToken token, String instanceName) throws SMSException, SSOException {
        return ServiceInstanceImpl.getInstance(token, this.serviceName, this.version, instanceName);
    }

    ServiceConfigImpl getGlobalConfig(SSOToken token, String instanceName) throws SMSException, SSOException {
        StringBuffer sb;
        ServiceSchemaImpl ss = this.ssm.getSchema(SchemaType.GLOBAL);
        if (ss == null) {
            return null;
        }
        String groupName = instanceName == null || instanceName.equals("default") ? "default" : this.getInstance(token, instanceName).getGroup();
        String cacheName = null;
        ServiceConfigImpl answer = null;
        if (SMSEntry.cacheSMSEntries && (answer = (ServiceConfigImpl)this.globalConfigs.get(cacheName = (sb = new StringBuffer(50)).append(((Object)token.getTokenID()).toString()).append(groupName).toString().toLowerCase())) != null) {
            return answer;
        }
        String gdn = this.constructServiceConfigDN(groupName, "ou=GlobalConfig,", null);
        answer = ServiceConfigImpl.getInstance(token, this, ss, gdn, null, groupName, "", true);
        if (SMSEntry.cacheSMSEntries) {
            this.globalConfigs.put(cacheName, answer);
        }
        return answer;
    }

    ServiceConfigImpl getOrganizationConfig(SSOToken token, String orgName, String instanceName) throws SMSException, SSOException {
        StringBuffer sb;
        ServiceSchemaImpl ss = this.ssm.getSchema(SchemaType.ORGANIZATION);
        if (ss == null) {
            return null;
        }
        String groupName = instanceName == null || instanceName.equals("default") ? "default" : this.getInstance(token, instanceName).getGroup();
        String cacheName = null;
        ServiceConfigImpl answer = null;
        String orgdn = DNMapper.orgNameToDN(orgName);
        if (SMSEntry.cacheSMSEntries && (answer = (ServiceConfigImpl)this.orgConfigs.get(cacheName = (sb = new StringBuffer(50)).append(((Object)token.getTokenID()).toString()).append(groupName).append(orgdn).toString().toLowerCase())) != null) {
            return answer;
        }
        String orgDN = this.constructServiceConfigDN(groupName, "ou=OrganizationConfig,", orgdn);
        answer = ServiceConfigImpl.getInstance(token, this, ss, orgDN, orgName, groupName, "", false);
        if (answer == null) {
            return null;
        }
        if (SMSEntry.cacheSMSEntries) {
            this.orgConfigs.put(cacheName, answer);
        }
        return answer;
    }

    PluginConfigImpl getPluginConfig(SSOToken token, String name, String schemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        PluginSchemaImpl psi = PluginSchemaImpl.getInstance(token, this.serviceName, this.version, schemaName, interfaceName, orgName);
        if (psi == null) {
            throw new SMSException("amSDK", "sms-invalid-plugin-schema-name", null);
        }
        StringBuffer groupName = new StringBuffer(100);
        groupName.append(name).append(",ou=").append(schemaName).append(",ou=").append(interfaceName);
        String dn = this.constructServiceConfigDN(groupName.toString(), "ou=PluginConfig,", DNMapper.orgNameToDN(orgName));
        return PluginConfigImpl.getInstance(token, psi, dn, orgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String addListener(ServiceListener listener) {
        String id = SMSUtils.getUniqueID();
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            this.listenerObjects.put(id, listener);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeListener(String listenerID) {
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            this.listenerObjects.remove(listenerID);
        }
    }

    boolean containsGroup(SSOToken token, String groupName) throws SMSException, SSOException {
        return this.groups.contains(token, groupName);
    }

    void entryChanged(String dn, int type) {
        if (this.listenerObjects.size() == 0) {
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("ServiceConfigManagerImpl:entryChanged No listeners registered DN: " + dn + "\nService name: " + this.serviceName);
            }
            return;
        }
        boolean globalConfig = false;
        boolean orgConfig = false;
        int orgIndex = 0;
        int index = 0;
        index = dn.indexOf(this.orgNotificationSearchString);
        if (index != -1) {
            orgConfig = true;
            orgIndex = this.orgNotificationSearchString.length();
        } else {
            index = dn.indexOf(this.glbNotificationSearchString);
            if (index != -1) {
                globalConfig = true;
                orgIndex = this.glbNotificationSearchString.length();
            } else {
                index = dn.indexOf(this.schemaNotificationSearchString + "," + SMSEntry.getRootSuffix());
                if (index != -1) {
                    globalConfig = true;
                    orgConfig = true;
                    orgIndex = this.schemaNotificationSearchString.length();
                } else if (this.serviceName.equalsIgnoreCase("sunidentityrepositoryservice") && (dn.startsWith("o=") || dn.equalsIgnoreCase(DNMapper.serviceDN))) {
                    orgConfig = true;
                } else {
                    if (SMSEntry.eventDebug.messageEnabled()) {
                        SMSEntry.eventDebug.message("ServiceConfigManagerImpl:entryChanged Changed DN does not match the service. DN: " + dn + "\nService name: " + this.serviceName);
                    }
                    return;
                }
            }
        }
        String groupName = "";
        String compName = "";
        if (index > 1) {
            String[] rdns = LDAPDN.explodeDN(dn.substring(0, index - 1), true);
            groupName = rdns[rdns.length - 1];
            for (int i = rdns.length - 2; i > -1; --i) {
                compName = compName + "/" + rdns[i];
            }
            if (compName.length() == 0) {
                compName = "/";
            }
        }
        switch (type) {
            case 0: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            default: {
                type = 4;
            }
        }
        String orgName = dn;
        if (index > 0 || orgConfig && globalConfig) {
            orgName = dn.substring(index + orgIndex + 1);
        }
        if (globalConfig) {
            this.notifyGlobalConfigChange(groupName, compName, type);
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("ServiceConfigManagerImpl:entryChanged Sending global config change notifications for DN " + dn);
            }
        }
        if (orgConfig) {
            this.notifyOrgConfigChange(orgName, groupName, compName, type);
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("ServiceConfigManagerImpl:entryChanged Sending org config change notifications for DN " + dn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyGlobalConfigChange(String groupName, String comp, int type) {
        HashMap lo;
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            lo = (HashMap)this.listenerObjects.clone();
        }
        Iterator items = lo.values().iterator();
        while (items.hasNext()) {
            ServiceListener sl = (ServiceListener)items.next();
            sl.globalConfigChanged(this.serviceName, this.version, groupName, comp, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOrgConfigChange(String orgName, String groupName, String comp, int type) {
        HashMap lo;
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            lo = (HashMap)this.listenerObjects.clone();
        }
        Iterator items = lo.values().iterator();
        while (items.hasNext()) {
            ServiceListener sl = (ServiceListener)items.next();
            sl.organizationConfigChanged(this.serviceName, this.version, orgName, groupName, comp, type);
        }
    }

    String constructServiceConfigDN(String groupName, String configName, String orgName) throws SMSException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("ou=").append(groupName).append(",").append(configName).append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",");
        if (orgName == null || orgName.length() == 0) {
            orgName = SMSEntry.baseDN;
        } else if (!DN.isDN(orgName)) {
            if (orgName.startsWith("/")) {
                orgName = DNMapper.orgNameToDN(orgName);
            } else {
                Object[] args = new String[]{orgName};
                throw new SMSException("amSDK", "sms-invalid-org-name", args);
            }
        }
        sb.append(orgName);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ServiceConfigManagerImpl getInstance(SSOToken token, String serviceName, String version) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigMgrImpl::getInstance: called: " + serviceName + "(" + version + ")");
        }
        String cName = ServiceManager.getCacheIndex(serviceName, version);
        ServiceConfigManagerImpl answer = null;
        String string = configMgrMutex;
        synchronized (configMgrMutex) {
            answer = ServiceConfigManagerImpl.getFromCache(cName, serviceName, version, token);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (answer != null) {
                return answer;
            }
            ServiceConfigManagerImpl.checkAndUpdatePermission(cName, serviceName, version, token);
            answer = new ServiceConfigManagerImpl(token, serviceName, version);
            string = configMgrMutex;
            synchronized (configMgrMutex) {
                ServiceConfigManagerImpl tmp = ServiceConfigManagerImpl.getFromCache(cName, serviceName, version, null);
                if (tmp == null) {
                    configMgrImpls.put(cName, answer);
                } else {
                    answer = tmp;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                if (debug.messageEnabled()) {
                    debug.message("ServiceConfigMgrImpl::getInstance: success: " + serviceName + "(" + version + ")");
                }
                return answer;
            }
        }
    }

    static ServiceConfigManagerImpl getFromCache(String cacheName, String sName, String version, SSOToken t) throws SMSException, SSOException {
        Set principals;
        ServiceConfigManagerImpl answer = (ServiceConfigManagerImpl)configMgrImpls.get(cacheName);
        if (answer != null && t != null && !(principals = (Set)userPrincipals.get(cacheName)).contains(((Object)t.getTokenID()).toString())) {
            answer = null;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkAndUpdatePermission(String cacheName, String sName, String version, SSOToken t) throws SMSException, SSOException {
        String dn = ServiceManager.getServiceNameDN(sName, version);
        CachedSMSEntry answer = CachedSMSEntry.getInstance(t, dn, null);
        String string = configMgrMutex;
        synchronized (configMgrMutex) {
            HashSet<String> sudoPrincipals = (HashSet<String>)userPrincipals.get(cacheName);
            if (sudoPrincipals == null) {
                sudoPrincipals = new HashSet<String>(2);
                userPrincipals.put(cacheName, sudoPrincipals);
            }
            sudoPrincipals.add(((Object)t.getTokenID()).toString());
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    static void clearCache() {
        configMgrImpls = new HashMap();
        userPrincipals = new HashMap();
    }
}

