/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.keystore.v_14;

import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.keystore.AMX509KeyManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class AMX509KeyManagerImpl
implements AMX509KeyManager {
    static final String bundleName = "amSecurity";
    static ResourceBundle bundle = null;
    static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    public static Debug debug = SecurityDebug.debug;
    static String keyStoreFile = System.getProperty("javax.net.ssl.keyStore", null);
    static String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
    String certAlias = null;
    X509KeyManager sunX509KeyManager = null;
    KeyStore keyStore = null;
    KeyManagerFactory kmf = null;

    public AMX509KeyManagerImpl() {
        try {
            bundle = amCache.getResBundle(bundleName, Locale.getDefault());
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(keyStoreFile);
            ks.load(fis, keyStorePassword.toCharArray());
            this.kmf = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            this.kmf.init(ks, keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            debug.error("AMX509KeyManager.AMX509KeyManager:", e);
        }
        this.sunX509KeyManager = (X509KeyManager)this.kmf.getKeyManagers()[0];
    }

    public void setAlias(String alias) {
        this.certAlias = alias;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket sock) {
        if (debug.messageEnabled()) {
            debug.message("AMX509KeyManagerImpl.chooseClientAlias: certAlias = " + this.certAlias);
        }
        if (this.certAlias != null && this.certAlias.length() > 0) {
            return this.certAlias;
        }
        return this.sunX509KeyManager.chooseClientAlias(keyType, issuers, sock);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket sock) {
        return this.sunX509KeyManager.chooseServerAlias(keyType, issuers, sock);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.sunX509KeyManager.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.sunX509KeyManager.getServerAliases(keyType, issuers);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.sunX509KeyManager.getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.sunX509KeyManager.getPrivateKey(alias);
    }
}

