/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security;

import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;

public class ISSecurityPermission
extends Permission {
    private static Random rnd = new Random();
    private String perm;
    private Set actions = new HashSet();
    private int hashCode;

    public ISSecurityPermission(String access, String action) {
        super(access);
        this.perm = access;
        this.actions = this.convertActionStringToSet(action);
        this.hashCode = rnd.nextInt();
    }

    public ISSecurityPermission(String access) {
        super(access);
        this.perm = access;
        this.actions = this.convertActionStringToSet("adminpassword");
        this.hashCode = rnd.nextInt();
    }

    public boolean implies(Permission p) {
        if (!(p instanceof ISSecurityPermission)) {
            return false;
        }
        Set pActions = this.convertActionStringToSet(p.getActions());
        if (this.actions.contains("adminpassword") && (pActions.contains("adminpassword") || pActions.contains("crypt"))) {
            return true;
        }
        return pActions.contains("crypt") && this.actions.contains("crypt");
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        ISSecurityPermission p;
        return o instanceof ISSecurityPermission && (p = (ISSecurityPermission)o).hashCode() == this.hashCode;
    }

    public String getActions() {
        return this.convertSetToActionString(this.actions);
    }

    private Set convertActionStringToSet(String ac) {
        StringTokenizer tzer = new StringTokenizer(ac, ",");
        HashSet<String> res = new HashSet<String>();
        while (tzer.hasMoreTokens()) {
            String tmp = tzer.nextToken();
            res.add(tmp);
        }
        return res;
    }

    private String convertSetToActionString(Set a) {
        StringBuffer sb = new StringBuffer();
        Iterator it = a.iterator();
        while (it.hasNext()) {
            String t = (String)it.next();
            sb.append(t).append(",");
        }
        String s = sb.toString();
        int lastComma = s.lastIndexOf(",");
        return s.substring(0, lastComma);
    }
}

