/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.RequesterID;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequesterIDImpl
implements RequesterID {
    private String requesterIdURI;
    private boolean isMutable = false;

    public RequesterIDImpl() {
        this.isMutable = true;
    }

    public RequesterIDImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public RequesterIDImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public String getValue() {
        return this.requesterIdURI;
    }

    public void setValue(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception("objectImmutable");
        }
        this.requesterIdURI = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String reqIDXMLString = null;
        if (this.requesterIdURI != null && this.requesterIdURI.length() > 0) {
            StringBuffer xmlString = new StringBuffer(100);
            xmlString.append("<");
            if (includeNSPrefix) {
                xmlString.append("samlp:");
            }
            xmlString.append("RequesterID");
            if (declareNS) {
                xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"");
            }
            xmlString.append(">").append("\n").append(this.requesterIdURI).append("\n").append("</samlp:").append("RequesterID").append(">");
            reqIDXMLString = xmlString.toString();
        }
        return reqIDXMLString;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    void parseElement(Element element) {
        this.requesterIdURI = XMLUtils.getValueOfValueNode(element);
    }
}

