/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.NameIDPolicy;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NameIDPolicyImpl
implements NameIDPolicy {
    private static final String FORMAT = "Format";
    private static final String SPNAMEQUALIFIER = "SPNameQualifier";
    private static final String ALLOWCREATE = "AllowCreate";
    private boolean isMutable = false;
    private String format;
    private String spNameQualifier;
    private Boolean allowCreate;

    public NameIDPolicyImpl() {
        this.isMutable = true;
    }

    public NameIDPolicyImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public NameIDPolicyImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String uri) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.format = uri;
    }

    public String getSPNameQualifier() {
        return this.spNameQualifier;
    }

    public void setSPNameQualifier(String spNameQualifier) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.spNameQualifier = spNameQualifier;
    }

    public void setAllowCreate(boolean value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.allowCreate = value ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isAllowCreate() {
        if (this.allowCreate == null) {
            return false;
        }
        return this.allowCreate;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        StringBuffer xmlString = new StringBuffer(150);
        xmlString.append("<");
        if (includeNSPrefix) {
            xmlString.append("samlp:");
        }
        xmlString.append("NameIDPolicy").append(" ");
        if (declareNS) {
            xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"");
        }
        if (this.format != null && this.format.length() > 0) {
            xmlString.append(" ").append(FORMAT).append("=").append("\"").append(this.format).append("\"");
        }
        if (this.spNameQualifier != null && this.spNameQualifier.length() > 0) {
            xmlString.append(" ").append(SPNAMEQUALIFIER).append("=").append("\"").append(this.spNameQualifier).append("\"");
        }
        if (this.allowCreate != null) {
            xmlString.append(" ").append(ALLOWCREATE).append("=").append("\"").append(this.allowCreate.toString()).append("\"");
        }
        xmlString.append(">").append("</samlp:").append("NameIDPolicy").append(">");
        return xmlString.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) {
        this.format = element.getAttribute(FORMAT);
        this.spNameQualifier = element.getAttribute(SPNAMEQUALIFIER);
        String allowCreateStr = element.getAttribute(ALLOWCREATE);
        if (allowCreateStr != null && allowCreateStr.length() > 0) {
            this.allowCreate = Boolean.valueOf(allowCreateStr);
        }
    }

    private void validateData() throws SAML2Exception {
        if (!(this.format != null && this.format.length() != 0 || this.spNameQualifier != null && this.spNameQualifier.length() != 0 || this.allowCreate != null)) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("noAttributes"));
        }
    }
}

