/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.Extensions;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtensionsImpl
implements Extensions {
    private boolean isMutable = false;
    private List extensionsList = null;

    public ExtensionsImpl() {
        this.isMutable = true;
    }

    public ExtensionsImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public ExtensionsImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public void setAny(List value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.extensionsList = value;
    }

    public List getAny() {
        return this.extensionsList;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String xmlStr = null;
        if (this.extensionsList != null && !this.extensionsList.isEmpty()) {
            StringBuffer xmlString = new StringBuffer(500);
            xmlString.append("<");
            if (includeNSPrefix) {
                xmlString.append("samlp:");
            }
            xmlString.append("Extensions");
            if (declareNS) {
                xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"");
            }
            xmlString.append(">");
            Iterator extIterator = this.extensionsList.iterator();
            while (extIterator.hasNext()) {
                String extString = (String)extIterator.next();
                xmlString.append("\n").append(extString);
            }
            xmlString.append("\n").append("</samlp:").append("Extensions").append(">");
            xmlStr = xmlString.toString();
        }
        return xmlStr;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) {
        NodeList nList = element.getChildNodes();
        if (this.extensionsList == null || this.extensionsList.isEmpty()) {
            this.extensionsList = new ArrayList();
        }
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                if (childNode.getLocalName() == null) continue;
                this.extensionsList.add(XMLUtils.print(childNode));
            }
            if (this.extensionsList != null && !this.extensionsList.isEmpty()) {
                this.extensionsList = Collections.unmodifiableList(this.extensionsList);
            }
        }
    }
}

