/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.key;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.metadata.KeyDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.RoleDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.XACMLAuthzDecisionQueryDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.XACMLPDPDescriptorElement;
import com.sun.identity.saml2.jaxb.xmlenc.EncryptionMethodType;
import com.sun.identity.saml2.jaxb.xmlsig.KeyInfoType;
import com.sun.identity.saml2.jaxb.xmlsig.X509DataElement;
import com.sun.identity.saml2.jaxb.xmlsig.X509DataType;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeyUtil {
    private static KeyProvider kp = null;
    protected static Hashtable encHash = new Hashtable();
    protected static Hashtable sigHash = new Hashtable();

    private KeyUtil() {
    }

    public static KeyProvider getKeyProviderInstance() {
        return kp;
    }

    public static String getSigningCertAlias(BaseConfigType baseConfig) {
        String alias;
        Map map = SAML2MetaUtils.getAttributes(baseConfig);
        List list = (List)map.get("signingCertAlias");
        if (list != null && !list.isEmpty() && (alias = (String)list.get(0)) != null && alias.length() != 0 && kp != null) {
            return alias;
        }
        return null;
    }

    public static PrivateKey getDecryptionKey(BaseConfigType baseConfig) {
        String alias;
        Map map = SAML2MetaUtils.getAttributes(baseConfig);
        List list = (List)map.get("encryptionCertAlias");
        PrivateKey decryptionKey = null;
        if (list != null && !list.isEmpty() && (alias = (String)list.get(0)) != null && alias.length() != 0 && kp != null) {
            decryptionKey = kp.getPrivateKey(alias);
        }
        return decryptionKey;
    }

    public static X509Certificate getVerificationCert(RoleDescriptorType roled, String entityID, String role) {
        String classMethod = "KeyUtil.getVerificationCert: ";
        String index = entityID.trim() + "|" + role;
        X509Certificate cert = (X509Certificate)sigHash.get(index);
        if (cert != null) {
            return cert;
        }
        if (roled == null) {
            SAML2SDKUtils.debug.error(classMethod + "Null RoleDescriptorType input for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        KeyDescriptorType kd = KeyUtil.getKeyDescriptor(roled, "signing");
        if (kd == null) {
            SAML2SDKUtils.debug.error(classMethod + "No signing KeyDescriptor for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        cert = KeyUtil.getCert(kd);
        if (cert == null) {
            SAML2SDKUtils.debug.error(classMethod + "No signing cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        sigHash.put(index, cert);
        return cert;
    }

    public static EncInfo getEncInfo(RoleDescriptorType roled, String entityID, String role) {
        PublicKey pk;
        String index;
        EncInfo encInfo;
        String classMethod = "KeyUtil.getEncInfo: ";
        if (SAML2SDKUtils.debug.messageEnabled()) {
            SAML2SDKUtils.debug.message(classMethod + "Entering... \nEntityID=" + entityID + "\nRole=" + role);
        }
        if ((encInfo = (EncInfo)encHash.get(index = entityID.trim() + "|" + role)) != null) {
            return encInfo;
        }
        if (roled == null) {
            SAML2SDKUtils.debug.error(classMethod + "Null RoleDescriptorType input for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        KeyDescriptorType kd = KeyUtil.getKeyDescriptor(roled, "encryption");
        if (kd == null) {
            SAML2SDKUtils.debug.error(classMethod + "No encryption KeyDescriptor for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        X509Certificate cert = KeyUtil.getCert(kd);
        if (cert == null) {
            SAML2SDKUtils.debug.error(classMethod + "No encryption cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        List emList = kd.getEncryptionMethod();
        EncryptionMethodType em = null;
        String algorithm = null;
        int keySize = 0;
        if (emList != null && !emList.isEmpty() && (em = (EncryptionMethodType)emList.get(0)) != null) {
            algorithm = em.getAlgorithm();
            List cList = em.getContent();
            if (cList != null) {
                keySize = ((EncryptionMethodType.KeySize)cList.get(0)).getValue().intValue();
            }
        }
        if (algorithm == null || algorithm.length() == 0) {
            algorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            keySize = 128;
        }
        if ((pk = cert.getPublicKey()) != null) {
            encInfo = new EncInfo(pk, algorithm, keySize);
        }
        if (encInfo != null) {
            encHash.put(index, encInfo);
        }
        return encInfo;
    }

    public static KeyDescriptorType getKeyDescriptor(RoleDescriptorType roled, String usage) {
        List list = roled.getKeyDescriptor();
        Iterator iter = list.iterator();
        KeyDescriptorType kd = null;
        String use = null;
        KeyDescriptorType noUsageKD = null;
        while (iter.hasNext()) {
            kd = (KeyDescriptorType)iter.next();
            use = kd.getUse();
            if ((use == null || use.trim().length() == 0) && noUsageKD == null) {
                noUsageKD = kd;
                continue;
            }
            if (use.trim().toLowerCase().equals(usage)) break;
            kd = null;
        }
        if (kd != null) {
            return kd;
        }
        return noUsageKD;
    }

    public static X509Certificate getCert(KeyDescriptorType kd) {
        String classMethod = "KeyUtil.getCert: ";
        KeyInfoType ki = kd.getKeyInfo();
        if (ki == null) {
            SAML2SDKUtils.debug.error(classMethod + "No KeyInfo.");
            return null;
        }
        X509DataElement data = (X509DataElement)ki.getContent().get(0);
        byte[] bt = ((X509DataType.X509Certificate)data.getX509IssuerSerialOrX509SKIOrX509SubjectName().get(0)).getValue();
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            SAML2SDKUtils.debug.error(classMethod + "Unable to get CertificateFactory " + "for X.509 type", ce);
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bt);
        X509Certificate retCert = null;
        try {
            while (bais.available() > 0) {
                retCert = (X509Certificate)cf.generateCertificate(bais);
            }
        }
        catch (CertificateException ce) {
            SAML2SDKUtils.debug.error(classMethod + "Unable to generate certificate from byte " + "array input stream.", ce);
            return null;
        }
        return retCert;
    }

    public static X509Certificate getPEPVerificationCert(XACMLAuthzDecisionQueryDescriptorElement pepDesc, String entityID) {
        String index;
        X509Certificate cert;
        String classMethod = "KeyUtil.getPEPVerificationCert: ";
        String role = "PEPRole";
        if (SAML2SDKUtils.debug.messageEnabled()) {
            SAML2SDKUtils.debug.message(classMethod + "Entering... \nEntityID=" + entityID + "\nRole=" + role);
        }
        if ((cert = (X509Certificate)sigHash.get(index = entityID.trim() + "|" + role)) != null) {
            return cert;
        }
        if (pepDesc == null) {
            SAML2SDKUtils.debug.error(classMethod + "Null DescriptorType input for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        List kdlist = pepDesc.getKeyDescriptor();
        KeyDescriptorType kd = KeyUtil.getKeyDescriptor(kdlist, "signing");
        if (kd == null) {
            SAML2SDKUtils.debug.error(classMethod + "No signing KeyDescriptor for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        cert = KeyUtil.getCert(kd);
        if (cert == null) {
            SAML2SDKUtils.debug.error(classMethod + "No signing cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        sigHash.put(index, cert);
        return cert;
    }

    public static KeyDescriptorType getKeyDescriptor(List kdList, String usage) {
        KeyDescriptorType noUsageKD = null;
        if (kdList != null && !kdList.isEmpty()) {
            Iterator iter = kdList.iterator();
            KeyDescriptorType kd = null;
            String use = null;
            while (iter.hasNext()) {
                kd = (KeyDescriptorType)iter.next();
                use = kd.getUse();
                if ((use == null || use.trim().length() == 0) && noUsageKD == null) {
                    noUsageKD = kd;
                    continue;
                }
                if (use.trim().toLowerCase().equals(usage)) break;
                kd = null;
            }
            if (kd != null) {
                return kd;
            }
            return noUsageKD;
        }
        return noUsageKD;
    }

    public static EncInfo getPEPEncInfo(XACMLAuthzDecisionQueryDescriptorElement pepDesc, String pepEntityID) {
        String index;
        EncInfo encInfo;
        String classMethod = "KeyUtil.getEncInfo: ";
        String role = "PEPRole";
        if (SAML2SDKUtils.debug.messageEnabled()) {
            SAML2SDKUtils.debug.message(classMethod + "Entering... \nEntityID=" + pepEntityID + "\nRole=" + role);
        }
        if ((encInfo = (EncInfo)encHash.get(index = pepEntityID.trim() + "|" + role)) != null) {
            return encInfo;
        }
        if (pepDesc == null) {
            SAML2SDKUtils.debug.error(classMethod + "Null PEP Descriptor input for entityID=" + pepEntityID + " in " + role + " role.");
            return null;
        }
        List kdList = pepDesc.getKeyDescriptor();
        KeyDescriptorType kd = KeyUtil.getKeyDescriptor(kdList, "encryption");
        if (kd == null) {
            SAML2SDKUtils.debug.error(classMethod + "No encryption KeyDescriptor for entityID=" + pepEntityID + " in " + role + " role.");
            return null;
        }
        return KeyUtil.getEncryptionInfo(kd, pepEntityID, role);
    }

    private static EncInfo getEncryptionInfo(KeyDescriptorType kd, String entityID, String role) {
        String classMethod = "KeyUtil:getEncryptionInfo:";
        X509Certificate cert = KeyUtil.getCert(kd);
        if (cert == null) {
            SAML2SDKUtils.debug.error(classMethod + "No encryption cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        List emList = kd.getEncryptionMethod();
        EncryptionMethodType em = null;
        String algorithm = null;
        int keySize = 0;
        if (emList != null && !emList.isEmpty() && (em = (EncryptionMethodType)emList.get(0)) != null) {
            algorithm = em.getAlgorithm();
            List cList = em.getContent();
            if (cList != null) {
                keySize = ((EncryptionMethodType.KeySize)cList.get(0)).getValue().intValue();
            }
        }
        if (algorithm == null || algorithm.length() == 0) {
            algorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            keySize = 128;
        }
        PublicKey pk = cert.getPublicKey();
        EncInfo encInfo = null;
        if (pk != null) {
            encInfo = new EncInfo(pk, algorithm, keySize);
        }
        String index = entityID.trim() + "|" + role;
        if (encInfo != null) {
            encHash.put(index, encInfo);
        }
        return encInfo;
    }

    public static X509Certificate getPDPVerificationCert(XACMLPDPDescriptorElement pdpDesc, String entityID) {
        String index;
        X509Certificate cert;
        String classMethod = "KeyUtil.getPDPVerificationCert: ";
        String role = "PDPRole";
        if (SAML2SDKUtils.debug.messageEnabled()) {
            SAML2SDKUtils.debug.message(classMethod + "Entering... \nEntityID=" + entityID + "\nRole=" + role);
        }
        if ((cert = (X509Certificate)sigHash.get(index = entityID.trim() + "|" + role)) != null) {
            return cert;
        }
        if (pdpDesc == null) {
            SAML2SDKUtils.debug.error(classMethod + "Null DescriptorType input for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        List kdList = pdpDesc.getKeyDescriptor();
        KeyDescriptorType kd = KeyUtil.getKeyDescriptor(kdList, "signing");
        if (kd == null) {
            SAML2SDKUtils.debug.error(classMethod + "No signing KeyDescriptor for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        cert = KeyUtil.getCert(kd);
        if (cert == null) {
            SAML2SDKUtils.debug.error(classMethod + "No signing cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        sigHash.put(index, cert);
        return cert;
    }

    static {
        try {
            kp = (KeyProvider)Class.forName(SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.keyprovider.class")).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            SAML2SDKUtils.debug.error("KeyUtil static block: Couldn't find the class.", cnfe);
            kp = null;
        }
        catch (InstantiationException ie) {
            SAML2SDKUtils.debug.error("KeyUtil static block: Couldn't instantiate the key provider instance.", ie);
            kp = null;
        }
        catch (IllegalAccessException iae) {
            SAML2SDKUtils.debug.error("KeyUtil static block: Couldn't access the default constructor.", iae);
            kp = null;
        }
    }
}

