/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.SubjectLocality;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SubjectLocalityImpl
implements SubjectLocality {
    private String address = null;
    private String dnsName = null;
    private boolean mutable = true;

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("SubjectLocalityImpl.parseElement: Input element is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("SubjectLocality")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("SubjectLocalityImpl.parseElement: input is not SubjectLocality");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            Node att = atts.getNamedItem("Address");
            if (att != null) {
                this.address = ((Attr)att).getValue().trim();
            }
            if ((att = atts.getNamedItem("DNSName")) != null) {
                this.dnsName = ((Attr)att).getValue().trim();
            }
        }
        this.mutable = false;
    }

    public SubjectLocalityImpl() {
    }

    public SubjectLocalityImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public SubjectLocalityImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public String getDNSName() {
        return this.dnsName;
    }

    public void setDNSName(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.dnsName = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.address = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        result.append("<").append(prefix).append("SubjectLocality").append(uri);
        if (this.address != null && this.address.trim().length() != 0) {
            result.append(" Address=\"").append(this.address).append("\"");
        }
        if (this.dnsName != null && this.dnsName.trim().length() != 0) {
            result.append(" DNSName=\"").append(this.dnsName).append("\"");
        }
        result.append("></").append(prefix).append("SubjectLocality>");
        return result.toString();
    }
}

