/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.impl.NameIDTypeImpl;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.xmlenc.EncManager;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.Serializable;
import java.security.Key;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NameIDImpl
extends NameIDTypeImpl
implements NameID,
Serializable {
    public static final String NAME_ID_ELEMENT = "NameID";

    public NameIDImpl() {
    }

    public NameIDImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument(xml, SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("NameIDImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public NameIDImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2SDKUtils.debug.error("NameIDImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("NameIDImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(NAME_ID_ELEMENT)) {
            SAML2SDKUtils.debug.error("NameIDImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        this.getValueAndAttributes(element);
    }

    public EncryptedID encrypt(Key recipientPublicKey, String dataEncAlgorithm, int dataEncStrength, String recipientEntityID) throws SAML2Exception {
        Element el = EncManager.getEncInstance().encrypt(this.toXMLString(true, true), recipientPublicKey, dataEncAlgorithm, dataEncStrength, recipientEntityID, "EncryptedID");
        return AssertionFactory.getInstance().createEncryptedID(el);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String spProvidedID;
        String format;
        String spNameQualifier;
        StringBuffer sb = new StringBuffer(2000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        sb.append("<").append(appendNS).append(NAME_ID_ELEMENT).append(NS);
        String nameQualifier = this.getNameQualifier();
        if (nameQualifier != null && nameQualifier.trim().length() != 0) {
            sb.append(" ").append("NameQualifier").append("=\"").append(nameQualifier).append("\"");
        }
        if ((spNameQualifier = this.getSPNameQualifier()) != null && spNameQualifier.trim().length() != 0) {
            sb.append(" ").append("SPNameQualifier").append("=\"").append(spNameQualifier).append("\"");
        }
        if ((format = this.getFormat()) != null && format.trim().length() != 0) {
            sb.append(" ").append("Format").append("=\"").append(format).append("\"");
        }
        if ((spProvidedID = this.getSPProvidedID()) != null && spProvidedID.trim().length() != 0) {
            sb.append(" ").append("SPProvidedID").append("=\"").append(spProvidedID).append("\"");
        }
        sb.append(">");
        String value = this.getValue();
        if (value == null || value.trim().length() == 0) {
            SAML2SDKUtils.debug.error("NameIDImpl.processElement(): name identifier is missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_name_identifier"));
        }
        sb.append(value);
        sb.append("</").append(appendNS).append(NAME_ID_ELEMENT).append(">");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }
}

