/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class StatusCode {
    private StatusCode subStatusCode = null;
    private String value = null;

    StatusCode() {
    }

    public StatusCode(Element statusCode) throws SAMLException {
        if (statusCode == null) {
            SAMLUtils.debug.message("StatusCode: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String tagName = statusCode.getLocalName();
        if (!tagName.equals("StatusCode")) {
            SAMLUtils.debug.message("StatusCode: Wrong input: " + tagName);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.value = statusCode.getAttribute("Value");
        if (this.value == null || this.value.length() == 0) {
            SAMLUtils.debug.message("StatusCode: empty attribute Value.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        List subCodenl = XMLUtils.getElementsByTagNameNS1(statusCode, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
        int length = subCodenl.size();
        if (length == 1) {
            this.subStatusCode = new StatusCode((Element)subCodenl.get(0));
        } else if (length != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("StatusCode: Included more than one <StatusCode> in element " + tagName);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
    }

    public StatusCode(String value, StatusCode subCode) throws SAMLException {
        this.value = this.checkAndGetValue(value);
        this.subStatusCode = subCode;
    }

    public StatusCode(String value) throws SAMLException {
        this.value = this.checkAndGetValue(value);
    }

    private String checkAndGetValue(String value) throws SAMLException {
        if (value == null || value.length() == 0) {
            SAMLUtils.debug.message("StatusCode: empty attribute Value.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        if (value.indexOf(":") == -1) {
            return "samlp:" + value;
        }
        StringTokenizer st = new StringTokenizer(value, ":");
        if (st.countTokens() != 2) {
            SAMLUtils.debug.message("StatusCode: wrong attribute value.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongAttrValue"));
        }
        return value;
    }

    public void setStatusCode(StatusCode subcode) {
        this.subStatusCode = subcode;
    }

    public StatusCode getStatusCode() {
        return this.subStatusCode;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(100);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String tag = "StatusCode";
        xml.append("<").append(prefix).append(tag).append(uri).append(" Value=\"");
        if (this.value.startsWith("samlp:")) {
            xml.append(this.value);
        } else {
            try {
                xml.append(this.checkAndGetValue(this.value));
            }
            catch (SAMLException e) {
                SAMLUtils.debug.error("StatusCode.toString: ", e);
                xml.append(this.value);
            }
        }
        xml.append("\">\n");
        if (this.subStatusCode != null && this.subStatusCode != Collections.EMPTY_LIST) {
            xml.append(this.subStatusCode.toString(includeNS, false));
        }
        xml.append("</").append(prefix).append(tag).append(">\n");
        return xml.toString();
    }
}

