/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Subject {
    static SAMLConstants sc;
    protected SubjectConfirmation _subjectConfirmation;
    protected NameIdentifier _nameIdentifier;

    protected Subject() {
    }

    public Subject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation) throws SAMLException {
        if (nameIdentifier == null && subjectConfirmation == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject:  null NameIdentifier and SubjectConfirmation  specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (nameIdentifier != null) {
            this._nameIdentifier = nameIdentifier;
        }
        if (subjectConfirmation != null) {
            this._subjectConfirmation = subjectConfirmation;
        }
    }

    public boolean equals(Subject subject) {
        boolean nidEqual = false;
        boolean scEqual = false;
        if (subject != null) {
            NameIdentifier nid = subject.getNameIdentifier();
            if (this._nameIdentifier != null) {
                nidEqual = this._nameIdentifier.equals(nid);
            } else if (nid == null) {
                nidEqual = true;
            }
            SubjectConfirmation sc = subject.getSubjectConfirmation();
            if (this._subjectConfirmation != null) {
                scEqual = this._subjectConfirmation.equals(sc);
            } else if (sc == null) {
                scEqual = true;
            }
            return nidEqual && scEqual;
        }
        return false;
    }

    public Subject(NameIdentifier nameIdentifier) throws SAMLException {
        if (nameIdentifier == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject:  null NameIdentifier specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._nameIdentifier = nameIdentifier;
    }

    public Subject(Element subjectElement) throws SAMLException {
        int elementCount = 0;
        Element elt = subjectElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!eltName.equals("Subject")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        NodeList nl = subjectElement.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject: No sub elements found");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("emptyElement"));
        }
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("NameIdentifier")) {
                this._nameIdentifier = this.createNameIdentifier((Element)child);
                ++elementCount;
                continue;
            }
            if (childName.equals("SubjectConfirmation")) {
                this._subjectConfirmation = this.createSubjectConfirmation((Element)child);
                ++elementCount;
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject: Invalid element encountered.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        if (elementCount > 2) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject: more than allowed elements passed");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
        }
    }

    public Subject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        if (subjectConfirmation == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject:  null SubjectConfirmation specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._subjectConfirmation = subjectConfirmation;
    }

    public boolean setSubjectConfirmation(SubjectConfirmation subjectConfirmation) {
        if (subjectConfirmation == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject:  null SubjectConfirmation specified");
            }
            return false;
        }
        this._subjectConfirmation = subjectConfirmation;
        return true;
    }

    public boolean removeSubjectConfirmation() {
        if (this._nameIdentifier == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject:At least one of NameIdentifier and SubjectConfirmation is mandatory");
            }
            return false;
        }
        this._subjectConfirmation = null;
        return true;
    }

    public boolean setNameIdentifier(NameIdentifier nameIdentifier) {
        if (nameIdentifier == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject:  null nameIdentifier specified");
            }
            return false;
        }
        this._nameIdentifier = nameIdentifier;
        return true;
    }

    public boolean removeNameIdentifier() {
        if (this._subjectConfirmation == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Subject:At least one of NameIdentifier and SubjectConfirmation is mandatory");
            }
            return false;
        }
        this._nameIdentifier = null;
        return true;
    }

    public NameIdentifier getNameIdentifier() {
        return this._nameIdentifier;
    }

    public SubjectConfirmation getSubjectConfirmation() {
        return this._subjectConfirmation;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String o = SAMLUtilsCommon.makeStartElementTagXML("Subject", includeNS, declareNS);
        xml.append(o).append("\n");
        if (this._nameIdentifier != null) {
            xml.append(this._nameIdentifier.toString(includeNS, false));
        }
        if (this._subjectConfirmation != null) {
            xml.append(this._subjectConfirmation.toString(includeNS, false));
        }
        o = SAMLUtilsCommon.makeEndElementTagXML("Subject", includeNS);
        xml.append(o);
        return xml.toString();
    }

    protected NameIdentifier createNameIdentifier(Element nameIdentifierElement) throws SAMLException {
        return new NameIdentifier(nameIdentifierElement);
    }

    protected SubjectConfirmation createSubjectConfirmation(Element subjectConfirmationElement) throws SAMLException {
        return new SubjectConfirmation(subjectConfirmationElement);
    }
}

