/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EvidenceBase {
    static SAMLConstants sc;
    private Set _assertionIDRef = new HashSet();
    private Set _assertion = new HashSet();

    public EvidenceBase(Element assertionSpecifierElement) throws SAMLException {
        String elementName = assertionSpecifierElement.getLocalName();
        if (elementName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!elementName.equals("Evidence")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement") + ":" + elementName);
        }
        NodeList nl = assertionSpecifierElement.getChildNodes();
        int length = nl.getLength();
        if (length <= 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message(elementName + ":" + "no sub elements found in this Element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("noElement"));
        }
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("Assertion")) {
                this._assertion.add(this.createAssertion((Element)child));
                continue;
            }
            if (childName.equals("AssertionIDReference")) {
                this._assertionIDRef.add(this.createAssertionIDReference(XMLUtils.getElementValue((Element)child)));
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  invalid sub element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
    }

    public EvidenceBase(Set evidenceContent) throws SAMLException {
        if (evidenceContent.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Iterator it = evidenceContent.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof AssertionBase) {
                this._assertion.add((AssertionBase)obj);
                continue;
            }
            if (obj instanceof AssertionIDReference) {
                this._assertionIDRef.add((AssertionIDReference)obj);
                continue;
            }
            SAMLUtilsCommon.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
    }

    public EvidenceBase(Set assertionIDRef, Set assertion) throws SAMLException {
        if (assertionIDRef.isEmpty() && assertion.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Iterator it = assertionIDRef.iterator();
        while (it.hasNext()) {
            Object assID = it.next();
            if (assID instanceof AssertionIDReference) {
                this._assertionIDRef.add((AssertionIDReference)assID);
                continue;
            }
            SAMLUtilsCommon.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        it = assertion.iterator();
        while (it.hasNext()) {
            Object ass = it.next();
            if (ass instanceof AssertionBase) {
                this._assertion.add((AssertionBase)ass);
                continue;
            }
            SAMLUtilsCommon.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
    }

    public boolean addAssertion(AssertionBase assertion) {
        if (assertion == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            return false;
        }
        this._assertion.add(assertion);
        return true;
    }

    public boolean addAssertionIDReference(AssertionIDReference assertionIDRef) {
        if (assertionIDRef == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            return false;
        }
        this._assertionIDRef.add(assertionIDRef);
        return true;
    }

    public boolean removeAssertion(AssertionBase assertion) {
        if (assertion != null) {
            if (this._assertionIDRef.size() + this._assertion.size() > 1) {
                this._assertion.remove(assertion);
                return true;
            }
        } else if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Evidence:  null input specified");
        }
        return false;
    }

    public boolean removeAssertionIDReference(AssertionIDReference assertionIDRef) {
        if (assertionIDRef != null) {
            if (this._assertionIDRef.size() + this._assertion.size() > 1) {
                this._assertionIDRef.remove(assertionIDRef);
                return true;
            }
        } else if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Evidence:  null input specified");
        }
        return false;
    }

    public Set getAssertionIDReference() {
        return this._assertionIDRef;
    }

    public Set getAssertion() {
        return this._assertion;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String o = null;
        o = SAMLUtilsCommon.makeStartElementTagXML("Evidence", includeNS, declareNS);
        xml.append(o).append("\n");
        Iterator it = this._assertion.iterator();
        while (it.hasNext()) {
            AssertionBase assertion = (AssertionBase)it.next();
            xml.append(assertion.toString(includeNS, false));
        }
        it = this._assertionIDRef.iterator();
        while (it.hasNext()) {
            AssertionIDReference aidRef = (AssertionIDReference)it.next();
            xml.append(aidRef.toString(includeNS, false));
        }
        o = SAMLUtilsCommon.makeEndElementTagXML("Evidence", includeNS);
        xml.append(o);
        return xml.toString();
    }

    protected abstract AssertionBase createAssertion(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(String var1) throws SAMLException;
}

