/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Condition;
import com.sun.identity.saml.assertion.DoNotCacheCondition;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.DateUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Conditions {
    static SAMLConstants sc;
    private Date _notBefore = null;
    private Date _notOnOrAfter = null;
    private Set _arcs = Collections.synchronizedSet(new HashSet());
    protected DoNotCacheCondition doNotCache = null;

    public Conditions() {
    }

    public Conditions(Date notBefore, Date notOnOrAfter) throws SAMLException {
        if (notBefore != null) {
            if (notOnOrAfter != null) {
                if (notBefore.after(notOnOrAfter) || notBefore.equals(notOnOrAfter)) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Conditions:  invalid    notBefore or notOnOrAfter");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                this._notBefore = notBefore;
                this._notOnOrAfter = notOnOrAfter;
            } else {
                this._notBefore = notBefore;
            }
        } else {
            this._notOnOrAfter = notOnOrAfter;
        }
    }

    public Conditions(Date notBefore, Date notOnOrAfter, Condition condition, AudienceRestrictionCondition arc) throws SAMLException {
        this._notBefore = notBefore;
        this._notOnOrAfter = notOnOrAfter;
        if (notBefore != null && notOnOrAfter != null && (notBefore.after(notOnOrAfter) || notBefore.equals(notOnOrAfter))) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Conditions:  invalid  data");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        if (arc != null) {
            this._arcs.add(arc);
        }
    }

    public Conditions(Date notBefore, Date notOnOrAfter, Condition condition, AudienceRestrictionCondition arc, DoNotCacheCondition doNotCacheCnd) throws SAMLException {
        this(notBefore, notOnOrAfter, condition, arc);
        if (doNotCacheCnd != null) {
            this.doNotCache = doNotCacheCnd;
        }
    }

    public Conditions(Element conditionsElement) throws SAMLException {
        Element elt = conditionsElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Conditions: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!eltName.equals("Conditions")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Conditions: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement") + ":" + eltName);
        }
        String dt = elt.getAttribute("NotBefore");
        if (dt != null && dt.length() != 0) {
            try {
                this._notBefore = DateUtils.stringToDate(dt);
            }
            catch (ParseException pe) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Conditions: could not parse  NotBefore or NotOnOrAfter ");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput") + pe.getMessage());
            }
        }
        if ((dt = elt.getAttribute("NotOnOrAfter")) != null && dt.length() != 0) {
            try {
                this._notOnOrAfter = DateUtils.stringToDate(elt.getAttribute("NotOnOrAfter"));
            }
            catch (ParseException pe) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Conditions: could not parse NotBefore or NotOnOrAfter ");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput") + pe.getMessage());
            }
        }
        NodeList nl = conditionsElement.getChildNodes();
        int length = nl.getLength();
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("AudienceRestrictionCondition")) {
                this._arcs.add(this.createAudienceRestrictionCondition((Element)child));
                continue;
            }
            if (childName.equals("DoNotCacheCondition")) {
                this.doNotCache = this.createDoNotCacheCondition((Element)child);
                continue;
            }
            String type = ((Element)child).getAttribute("xsi:type");
            if (type.equals("AudienceRestrictionCondition")) {
                this._arcs.add(this.createAudienceRestrictionCondition((Element)child));
                continue;
            }
            if (type.equals("DoNotCacheCondition")) {
                this.doNotCache = this.createDoNotCacheCondition((Element)child);
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Conditions: unsupported condition, cannot determine extension ");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("unsupportedCondition"));
        }
    }

    public Date getNotBefore() {
        return this._notBefore;
    }

    public Date getNotOnorAfter() {
        return this._notOnOrAfter;
    }

    public boolean addAudienceRestrictionCondition(AudienceRestrictionCondition arc) {
        if (arc != null) {
            this._arcs.add(arc);
            return true;
        }
        return false;
    }

    public boolean checkDateValidity(long someTime) {
        if (this._notBefore == null) {
            if (this._notOnOrAfter == null) {
                return true;
            }
            if (someTime < this._notOnOrAfter.getTime()) {
                return true;
            }
        } else if (this._notOnOrAfter == null ? someTime >= this._notBefore.getTime() : someTime >= this._notBefore.getTime() && someTime < this._notOnOrAfter.getTime()) {
            return true;
        }
        return false;
    }

    public Set getAudienceRestrictionCondition() {
        return this._arcs;
    }

    public boolean removeAudienceRestrictionCondition(String audience) {
        Iterator it = this._arcs.iterator();
        while (it.hasNext()) {
            AudienceRestrictionCondition arc = (AudienceRestrictionCondition)it.next();
            if (!arc.containsAudience(audience)) continue;
            return arc.removeAudience(audience);
        }
        return false;
    }

    public void setDoNotCacheCondition(DoNotCacheCondition doNotCacheCnd) {
        if (doNotCacheCnd != null) {
            this.doNotCache = doNotCacheCnd;
        }
    }

    public DoNotCacheCondition getDoNotCacheCondition() {
        return this.doNotCache;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (includeNS) {
            appendNS = "saml:";
        }
        xml.append("<").append(appendNS).append("Conditions").append(" ").append(NS).append(" ");
        if (this._notBefore != null) {
            xml.append("NotBefore").append("=\"").append(DateUtils.toUTCDateFormat(this._notBefore)).append("\"").append(" ");
        }
        if (this._notOnOrAfter != null) {
            xml.append("NotOnOrAfter").append("=\"").append(DateUtils.toUTCDateFormat(this._notOnOrAfter)).append("\"").append(" ");
        }
        xml.append(">").append("\n");
        if (this._arcs.size() > 0) {
            Iterator it = this._arcs.iterator();
            while (it.hasNext()) {
                xml.append(((AudienceRestrictionCondition)it.next()).toString(includeNS, false));
            }
        }
        if (this.doNotCache != null) {
            xml.append(this.doNotCache.toString(includeNS, false));
        }
        String o = SAMLUtilsCommon.makeEndElementTagXML("Conditions", includeNS);
        xml.append(o);
        return xml.toString();
    }

    protected AudienceRestrictionCondition createAudienceRestrictionCondition(Element audienceRestrictionElement) throws SAMLException {
        return new AudienceRestrictionCondition(audienceRestrictionElement);
    }

    protected DoNotCacheCondition createDoNotCacheCondition(Element doNotCacheConditionElement) throws SAMLException {
        return new DoNotCacheCondition(doNotCacheConditionElement);
    }
}

