/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.AdviceBase;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatementBase;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Assertion
extends AssertionBase {
    public boolean isSignatureValid() {
        if (this.signed & !this.validationDone) {
            this.valid = SAMLUtils.checkSignatureValid(this.xmlString, "AssertionID", this._issuer);
            this.validationDone = true;
        }
        return this.valid;
    }

    public void signXML() throws SAMLException {
        String certAlias = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.certalias");
        this.signXML(certAlias);
    }

    public void signXML(String certAlias) throws SAMLException {
        if (this.signed) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion.signXML: the assertion is already signed.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("alreadySigned"));
        }
        if (certAlias == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assetion.signXML: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("cannotFindCertAlias"));
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        if (this._majorVersion == 1 && this._minorVersion == 0) {
            SAMLUtils.debug.message("Assetion.signXML: sign with version 1.0");
            this.signatureString = manager.signXML(this.toString(true, true), certAlias);
            this.signature = XMLUtils.toDOMDocument(this.signatureString, SAMLUtils.debug).getDocumentElement();
        } else {
            SAMLUtils.debug.message("Assetion.signXML: sign with version 1.1");
            Document doc = XMLUtils.toDOMDocument(this.toString(true, true), SAMLUtils.debug);
            this.signature = manager.signXML(doc, certAlias, null, "AssertionID", this.getAssertionID(), true, null);
            this.signatureString = XMLUtils.print(this.signature);
        }
        this.signed = true;
        this.xmlString = this.toString(true, true);
    }

    protected Assertion() {
    }

    public Assertion(Element assertionElement) throws SAMLException {
        this.parseAssertionElement(assertionElement);
    }

    protected void parseAssertionElement(Element assertionElement) throws SAMLException {
        Element elt;
        String eltName;
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Assertion.parseAssertionElement:");
        }
        if ((eltName = (elt = assertionElement).getLocalName()) == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!eltName.equals("Assertion")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement") + ":" + eltName);
        }
        String read = elt.getAttribute("Issuer");
        if (read == null || read.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: Issuer missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "Issuer");
        }
        this._issuer = read;
        List signs = XMLUtils.getElementsByTagNameNS1(assertionElement, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            this.xmlString = XMLUtils.print(assertionElement);
            this.signed = true;
            this.validationDone = false;
        } else if (signsSize != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
        read = elt.getAttribute("MajorVersion");
        if (read == null || read.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MajorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "MajorVersion");
        }
        int ver = 0;
        try {
            ver = Integer.parseInt(read);
        }
        catch (NumberFormatException ne) {
            SAMLUtils.debug.error("Assertion: invalid integer in MajorVersion", ne);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidNumber") + ":" + "MajorVersion");
        }
        if (ver != 1) {
            if (ver < 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MajorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooLow") + ":" + "MajorVersion");
            }
            if (ver > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MajorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooHigh") + ":" + "MajorVersion");
            }
        }
        if ((read = elt.getAttribute("MinorVersion")) == null || read.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MinorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "MinorVersion");
        }
        ver = 0;
        try {
            ver = Integer.parseInt(read);
        }
        catch (NumberFormatException ne) {
            SAMLUtils.debug.error("Assertion: invalid integer in MinorVersion", ne);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidNumber") + ":" + "MinorVersion");
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Assertion.parseAssertionElement: minMinorVersion = " + this.getMinAssertionMinorVersion() + ", maxMinorVersion = " + this.getMaxAssertionMinorVersion());
        }
        if (ver < this.getMinAssertionMinorVersion()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MinorVersion too low");
            }
            throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooLow"));
        }
        if (ver > this.getMaxAssertionMinorVersion()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MinorVersion too high");
            }
            throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooHigh") + ":" + "MinorVersion");
        }
        this._minorVersion = ver;
        read = elt.getAttribute("AssertionID");
        if (read == null || read.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: AssertionID missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "AssertionID");
        }
        this._assertionID = new AssertionIDReference(read);
        read = elt.getAttribute("IssueInstant");
        if (read == null || read.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: IssueInstant missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "IssueInstant");
        }
        try {
            this._issueInstant = DateUtils.stringToDate(read);
        }
        catch (ParseException pe) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: could not parse IssueInstant", pe);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput") + " " + pe.getMessage());
        }
        NodeList nl = assertionElement.getChildNodes();
        int length = nl.getLength();
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("Conditions")) {
                this._conditions = new Conditions((Element)child);
                continue;
            }
            if (childName.equals("Advice")) {
                this._advice = new Advice((Element)child);
                continue;
            }
            if (childName.equals("AuthenticationStatement")) {
                this._statements.add(new AuthenticationStatement((Element)child));
                continue;
            }
            if (childName.equals("AuthorizationDecisionStatement")) {
                this._statements.add(new AuthorizationDecisionStatement((Element)child));
                continue;
            }
            if (childName.equals("AttributeStatement")) {
                this._statements.add(new AttributeStatement((Element)child));
                continue;
            }
            if (childName.equals("Signature")) {
                this.signature = (Element)child;
                continue;
            }
            if (this.processUnknownElement((Element)child)) continue;
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: invalid element in Assertion");
            }
            throw new SAMLRequesterException("invalidElement");
        }
        if (this._statements.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: mandatory statement missing");
            }
            throw new SAMLRequesterException("missingStatement");
        }
    }

    public Assertion(String assertionID, String issuer, Date issueInstant, Set statements) throws SAMLException {
        super(assertionID, issuer, issueInstant, statements);
    }

    public Assertion(String assertionID, String issuer, Date issueInstant, Conditions conditions, Set statements) throws SAMLException {
        super(assertionID, issuer, issueInstant, conditions, statements);
    }

    public Assertion(String assertionID, String issuer, Date issueInstant, Conditions conditions, Advice advice, Set statements) throws SAMLException {
        super(assertionID, issuer, issueInstant, conditions, advice, statements);
    }

    public Advice getAdvice() {
        return (Advice)this._advice;
    }

    protected AdviceBase createAdvice(Element adviceElement) throws SAMLException {
        return new Advice(adviceElement);
    }

    protected AuthorizationDecisionStatementBase createAuthorizationDecisionStatement(Element authDecisionElement) throws SAMLException {
        return new AuthorizationDecisionStatement(authDecisionElement);
    }

    protected AuthenticationStatement createAuthenticationStatement(Element authenticationElement) throws SAMLException {
        return new AuthenticationStatement(authenticationElement);
    }

    protected AttributeStatement createAttributeStatement(Element attributeElement) throws SAMLException {
        return new AttributeStatement(attributeElement);
    }

    protected AssertionIDReference createAssertionIDReference(Element assertionIDRefElement) throws SAMLException {
        return new AssertionIDReference(assertionIDRefElement);
    }

    protected AssertionIDReference createAssertionIDReference(String assertionID) throws SAMLException {
        return new AssertionIDReference(assertionID);
    }

    protected Conditions createConditions(Element conditionsElement) throws SAMLException {
        return new Conditions(conditionsElement);
    }

    protected boolean processUnknownElement(Element element) throws SAMLException {
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Assertion.processUnknownElement:");
        }
        return false;
    }

    protected int getMinAssertionMinorVersion() {
        return 0;
    }

    protected int getMaxAssertionMinorVersion() {
        return 1;
    }
}

