/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class IDRepoResponseProvider
implements ResponseProvider {
    private static final Debug DEBUG = Debug.getInstance("amPolicy");
    public static final String STATIC_ATTRIBUTE = "StaticAttribute";
    public static final String DYNAMIC_ATTRIBUTE = "DynamicAttribute";
    public static final String ATTR_DELIMITER = "=";
    public static final String VAL_DELIMITER = "|";
    private Map properties;
    private static List propertyNames = new ArrayList(2);
    private boolean initialized = false;
    private String orgName = null;
    private Set validDynamicAttrNames = null;
    private Map staticResponse = null;
    private Set responseAttrNames = null;
    private Set repoAttrNames = null;
    private Map responseAttrToRepoAttr = null;

    public void initialize(Map configParams) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.initialize():entering");
        }
        if (configParams == null) {
            throw new PolicyException("amPolicy", "idrepo_initialization_failed", null, null);
        }
        Set orgNameSet = (Set)configParams.get("OrganizationName");
        if (orgNameSet != null && orgNameSet.size() != 0) {
            Iterator items = orgNameSet.iterator();
            this.orgName = (String)items.next();
        }
        this.validDynamicAttrNames = (Set)configParams.get("sun-am-policy-dynamic-response-attributes");
        if (this.validDynamicAttrNames == null) {
            this.validDynamicAttrNames = Collections.EMPTY_SET;
        }
        this.initialized = true;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.initialize():initialized with:orgName=" + this.orgName + ",validDynamicAttrNames=" + this.validDynamicAttrNames);
        }
    }

    public List getPropertyNames() {
        return propertyNames;
    }

    public Syntax getPropertySyntax(String property) {
        if (property.equals(STATIC_ATTRIBUTE)) {
            return Syntax.ANY;
        }
        if (property.equals(DYNAMIC_ATTRIBUTE)) {
            return Syntax.MULTIPLE_CHOICE;
        }
        return Syntax.ANY;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "idrepo_response_provider_not_yet_initialized", null, null);
        }
        if (property.equals(DYNAMIC_ATTRIBUTE)) {
            return this.validDynamicAttrNames;
        }
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        Set dynamicSet;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.setProperties():entering with properties=" + properties);
        }
        if (properties == null || properties.isEmpty()) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        this.properties = properties;
        if (!properties.containsKey(STATIC_ATTRIBUTE) && !properties.containsKey(DYNAMIC_ATTRIBUTE)) {
            Object[] args = new String[]{STATIC_ATTRIBUTE, DYNAMIC_ATTRIBUTE};
            throw new PolicyException("amPolicy", "missing_required_property", args, null);
        }
        Set staticSet = (Set)properties.get(STATIC_ATTRIBUTE);
        if (staticSet != null) {
            this.validateStaticAttribute(staticSet);
        }
        if ((dynamicSet = (Set)properties.get(DYNAMIC_ATTRIBUTE)) != null) {
            this.validateDynamicAttribute(dynamicSet);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.setProperties():returning");
        }
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public Map getResponseDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.getResponseDecision():entering");
        }
        HashMap returnValues = new HashMap();
        if (this.staticResponse != null) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("IDRepoResponseProvider.getResponseDecision():adding staticResponse=" + this.staticResponse);
            }
            PolicyUtils.appendMapToMap(this.staticResponse, returnValues);
        }
        if (this.repoAttrNames != null && !this.repoAttrNames.isEmpty()) {
            HashMap dynamicResponse = new HashMap();
            Map idRepoMap = new HashMap();
            try {
                if (token.getPrincipal() != null) {
                    AMIdentity id = IdUtils.getIdentity(token);
                    idRepoMap = id.getAttributes(this.repoAttrNames);
                    if (idRepoMap != null) {
                        Iterator iter = this.responseAttrNames.iterator();
                        while (iter.hasNext()) {
                            String responseAttrName = (String)iter.next();
                            Set idRepoAttrNames = (Set)this.responseAttrToRepoAttr.get(responseAttrName);
                            HashSet values = new HashSet();
                            Iterator iter1 = idRepoAttrNames.iterator();
                            while (iter1.hasNext()) {
                                String repoAttrName = (String)iter1.next();
                                Set subValues = (Set)idRepoMap.get(repoAttrName);
                                if (subValues == null) continue;
                                values.addAll(subValues);
                            }
                            dynamicResponse.put(responseAttrName, values);
                        }
                    }
                    if (DEBUG.messageEnabled()) {
                        DEBUG.message("IDRepoResponseProvider.getResponseDecision():adding dynamicResponse=" + dynamicResponse);
                    }
                } else {
                    DEBUG.error("IDRepoResponseProvider:getResponseDecision(): Principal is null");
                    throw new PolicyException("amPolicy", "token_principal_null", null, null);
                }
                PolicyUtils.appendMapToMap(dynamicResponse, returnValues);
            }
            catch (IdRepoException ide) {
                DEBUG.error("IDRepoResponseProvider:getResponseDecision():IdRepoException", ide);
                throw new PolicyException(ide);
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.getResponseDecision():returning response=" + returnValues);
        }
        return returnValues;
    }

    private void validateStaticAttribute(Set staticSet) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():entering with staticSet=" + staticSet);
        }
        if (!staticSet.isEmpty()) {
            this.staticResponse = new HashMap();
            Iterator it = staticSet.iterator();
            while (it.hasNext()) {
                String attrValueString = (String)it.next();
                if (attrValueString.indexOf(ATTR_DELIMITER) == -1) {
                    this.clearProperties();
                    DEBUG.error("IDRepoResponseProvider.validateStaticAttribute(): Invalid format in defining StaticAttribute, needs to be attr=value format");
                    Object[] args = new String[]{attrValueString};
                    throw new PolicyException("amPolicy", "invalid_format_static_property", args, null);
                }
                int index = attrValueString.indexOf(ATTR_DELIMITER);
                String attrName = attrValueString.substring(0, index).trim();
                String attrValue = attrValueString.substring(index + 1);
                Set values = PolicyUtils.delimStringToSet(attrValue, VAL_DELIMITER);
                PolicyUtils.appendElementToMap(attrName, values, this.staticResponse);
                if (!DEBUG.messageEnabled()) continue;
                DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():attrName=" + attrName + ",values=" + values);
                DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():caching staticResponse:" + this.staticResponse);
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():returning");
        }
    }

    private void validateDynamicAttribute(Set dynamicSet) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():entering with dynamicSet=" + dynamicSet);
        }
        this.responseAttrNames = new HashSet();
        this.repoAttrNames = new HashSet();
        this.responseAttrToRepoAttr = new HashMap();
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():valid dynamic attributes:" + this.validDynamicAttrNames);
        }
        Set dynamicAttrs = (Set)this.properties.get(DYNAMIC_ATTRIBUTE);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():selected dynamic attributes:" + dynamicAttrs);
        }
        Iterator dynamicAttrsIter = dynamicAttrs.iterator();
        while (dynamicAttrsIter.hasNext()) {
            String attr = (String)dynamicAttrsIter.next();
            if (!this.validDynamicAttrNames.contains(attr)) {
                if (!DEBUG.warningEnabled()) continue;
                DEBUG.warning("IDReporesponseProvider.validateDynamicAttribute():Invalid dynamic property encountered:" + attr);
                continue;
            }
            String[] attrNames = this.parseDynamicAttrName(attr);
            String responseAttrName = attrNames[0];
            String repoAttrName = attrNames[1];
            this.responseAttrNames.add(responseAttrName);
            this.repoAttrNames.add(repoAttrName);
            this.addToResponseAttrToRepoAttrMap(responseAttrName, repoAttrName);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():responseAttrName=" + responseAttrName + ", repoAttrName=" + repoAttrName);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():responseAttrToRepoAttr=" + this.responseAttrToRepoAttr);
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():returning");
        }
    }

    private String[] parseDynamicAttrName(String dynamicAttrName) throws PolicyException {
        String[] parsedNames = new String[2];
        if (dynamicAttrName != null) {
            int delimiterIndex = dynamicAttrName.indexOf(ATTR_DELIMITER);
            if (delimiterIndex == 0) {
                this.clearProperties();
                Object[] args = new String[]{dynamicAttrName};
                throw new PolicyException("amPolicy", "invalid_dynamic_property_being_set", args, null);
            }
            if (delimiterIndex < 0) {
                String value = dynamicAttrName.trim();
                if (value.length() == 0) {
                    this.clearProperties();
                    Object[] args = new String[]{dynamicAttrName};
                    throw new PolicyException("amPolicy", "invalid_dynamic_property_being_set", args, null);
                }
                parsedNames[0] = value;
                parsedNames[1] = value;
            } else {
                String value1 = dynamicAttrName.substring(0, delimiterIndex).trim();
                String value2 = dynamicAttrName.substring(delimiterIndex + 1).trim();
                if (value1.length() == 0 || value2.length() == 0) {
                    this.clearProperties();
                    Object[] args = new String[]{dynamicAttrName};
                    throw new PolicyException("amPolicy", "invalid_dynamic_property_being_set", args, null);
                }
                parsedNames[0] = value1;
                parsedNames[1] = value2;
            }
        }
        return parsedNames;
    }

    private void addToResponseAttrToRepoAttrMap(String responseAttrName, String repoAttrName) throws PolicyException {
        HashSet<String> idRepoAttrNames = (HashSet<String>)this.responseAttrToRepoAttr.get(responseAttrName);
        if (idRepoAttrNames == null) {
            idRepoAttrNames = new HashSet<String>();
            this.responseAttrToRepoAttr.put(responseAttrName, idRepoAttrNames);
        }
        idRepoAttrNames.add(repoAttrName);
    }

    private void clearProperties() {
        this.properties = null;
        this.staticResponse = null;
        this.responseAttrNames = null;
        this.repoAttrNames = null;
        this.responseAttrToRepoAttr = null;
    }

    public Object clone() {
        HashSet values;
        Object obj;
        Iterator iter;
        IDRepoResponseProvider theClone = null;
        try {
            theClone = (IDRepoResponseProvider)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.validDynamicAttrNames != null) {
            theClone.validDynamicAttrNames = new HashSet();
            theClone.validDynamicAttrNames.addAll(this.validDynamicAttrNames);
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            iter = this.properties.keySet().iterator();
            while (iter.hasNext()) {
                obj = iter.next();
                values = new HashSet();
                values.addAll((Set)this.properties.get(obj));
                theClone.properties.put(obj, values);
            }
        }
        if (this.staticResponse != null) {
            theClone.staticResponse = new HashMap();
            iter = this.staticResponse.keySet().iterator();
            while (iter.hasNext()) {
                obj = iter.next();
                values = new HashSet();
                values.addAll((Set)this.staticResponse.get(obj));
                theClone.staticResponse.put(obj, values);
            }
        }
        if (this.responseAttrNames != null) {
            theClone.responseAttrNames = new HashSet();
            theClone.responseAttrNames.addAll(this.responseAttrNames);
        }
        if (this.repoAttrNames != null) {
            theClone.repoAttrNames = new HashSet();
            theClone.repoAttrNames.addAll(this.repoAttrNames);
        }
        if (this.responseAttrToRepoAttr != null) {
            theClone.responseAttrToRepoAttr = new HashMap();
            iter = this.responseAttrToRepoAttr.keySet().iterator();
            while (iter.hasNext()) {
                obj = iter.next();
                values = new HashSet();
                values.addAll((Set)this.responseAttrToRepoAttr.get(obj));
                theClone.responseAttrToRepoAttr.put(obj, values);
            }
        }
        return theClone;
    }

    static {
        propertyNames.add(STATIC_ATTRIBUTE);
        propertyNames.add(DYNAMIC_ATTRIBUTE);
    }
}

