/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.AMSignatureProvider;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityUtils {
    private static SecurityUtils securityManager = null;
    private static JKSKeyProvider keys = null;
    private static AMSignatureProvider asp = null;
    private static XMLSignatureManager sm = null;
    private static Debug debug = null;
    private static String PROP_TRUSTED_CA_CERT_ALIASES = "com.sun.identity.liberty.ws.trustedca.certaliases";
    private static Set trustedCACertAliases = new HashSet();
    private static Map issuerTrustedCACertAliases = new HashMap();
    private static KeyProvider keystore = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Element signMessage(Message m) {
        try {
            Document doc = m.toDocument(true);
            int securityType = m.getSecurityProfileType();
            X509Certificate cert = null;
            List ids = m.getSigningIds();
            if (debug.messageEnabled()) {
                debug.message("Security Type = " + securityType);
            }
            if (securityType == 1) {
                cert = m.getMessageCertificate();
                return sm.signWithWSSX509TokenProfile(doc, cert, "", ids, m.getWSFVersion());
            }
            if (securityType == 2) {
                SecurityAssertion assertion = m.getAssertion();
                cert = m.getMessageCertificate();
                String assertionID = assertion.getAssertionID();
                return sm.signWithWSSSAMLTokenProfile(doc, cert, assertionID, "", ids, m.getWSFVersion());
            }
            if (securityType != 0) return null;
        }
        catch (Exception e) {
            debug.error("Unable to sign Soap message!", e);
        }
        return null;
    }

    public static boolean verifyMessage(Message m) {
        try {
            Document doc = m.toDocument(false);
            X509Certificate clientCert = m.getPeerCertificate();
            X509Certificate messageCert = m.getMessageCertificate();
            int securityProfileType = m.getSecurityProfileType();
            if (securityProfileType == 2 || securityProfileType == 3) {
                SecurityAssertion assertion = m.getAssertion();
                String certAlias = null;
                X509Certificate signingCert = SecurityUtils.getAssertionSigningCert(assertion);
                if (signingCert == null) {
                    certAlias = (String)issuerTrustedCACertAliases.get(assertion.getIssuer());
                    if (certAlias == null) {
                        debug.error("SecurityUtils.verifyMessage: assertion doesn't have keyInfo and issuer is not in com.sun.identity.liberty.ws.trustedca.certalias in AMConfig");
                        return false;
                    }
                } else {
                    certAlias = keystore.getCertificateAlias(signingCert);
                    if (certAlias == null) {
                        debug.error("SecurityUtils.verifyMessage: assertion is signed with a certificate that  is not in the keystore");
                        return false;
                    }
                    if (!trustedCACertAliases.contains(certAlias)) {
                        debug.error("SecurityUtils.verifyMessage: assertion is signed with a certificate that  is in the keystore but not in com.sun.identity.liberty.ws.trustedca.certalias in AMConfig");
                        return false;
                    }
                }
                assertion.setVerifyingCertAlias(certAlias);
                if (!assertion.isSignatureValid()) {
                    debug.error("SecurityUtils.verifyMessage: assertion signature invalid");
                    return false;
                }
                if (debug.messageEnabled()) {
                    debug.message("SecurityUtils.verifyMessage: Assertion  signing cert alias = " + certAlias);
                }
            }
            if (clientCert != null && !clientCert.equals(messageCert)) {
                debug.error("Client authentication certificate is not the same as the certificate inside the soap message");
                return false;
            }
            if (messageCert != null) {
                String messageCertAlias = keystore.getCertificateAlias(messageCert);
                return sm.verifyXMLSignature(m.getWSFVersion(), messageCertAlias, doc);
            }
            return true;
        }
        catch (Exception e) {
            debug.error("Unable to verify Soap Message!", e);
            return false;
        }
    }

    public static Certificate getCertificate(BinarySecurityToken binarySecurityToken) {
        Certificate cert = null;
        try {
            String certString = binarySecurityToken.getTokenValue();
            StringBuffer xml = new StringBuffer(100);
            xml.append("-----BEGIN CERTIFICATE-----\n");
            xml.append(certString);
            xml.append("\n-----END CERTIFICATE-----");
            byte[] barr = null;
            barr = xml.toString().getBytes();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(barr);
            QName valueType = binarySecurityToken.getValueType();
            if (valueType.equals(BinarySecurityToken.PKCS7)) {
                Collection<? extends Certificate> c = cf.generateCertificates(bais);
                Iterator<? extends Certificate> i = c.iterator();
                while (i.hasNext()) {
                    cert = i.next();
                }
            } else {
                while (bais.available() > 0) {
                    cert = cf.generateCertificate(bais);
                }
            }
        }
        catch (Exception e) {
            debug.error("WSSecurityManager:getX509Certificate", e);
        }
        return cert;
    }

    public static Certificate getCertificate(SecurityAssertion assertion) {
        if (debug.messageEnabled()) {
            debug.message("SecurityAssertion = " + assertion.toString());
        }
        try {
            Set statements = assertion.getStatement();
            if (statements != null && !statements.isEmpty()) {
                Iterator iterator = statements.iterator();
                while (iterator.hasNext()) {
                    SubjectConfirmation subConfirm;
                    SessionContextStatement scStatement;
                    Statement statement = (Statement)iterator.next();
                    int stype = statement.getStatementType();
                    Subject subject = null;
                    if (stype == 1) {
                        subject = ((AuthenticationStatement)statement).getSubject();
                    } else if (stype == 4) {
                        ResourceAccessStatement raStatement = (ResourceAccessStatement)statement;
                        subject = raStatement.getProxySubject();
                        if (subject == null) {
                            subject = raStatement.getSubject();
                        }
                    } else if (stype == 5 && (subject = (scStatement = (SessionContextStatement)statement).getProxySubject()) == null) {
                        subject = scStatement.getSubject();
                    }
                    if (subject == null || !(subConfirm = subject.getSubjectConfirmation()).getConfirmationMethod().contains("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key")) continue;
                    Element keyinfo = subConfirm.getKeyInfo();
                    return SecurityUtils.getCertificate(keyinfo);
                }
            } else {
                debug.error("Assertion does not contain any Statement.");
            }
        }
        catch (Exception e) {
            debug.error("getCertificate Exception: ", e);
        }
        return null;
    }

    private static X509Certificate getCertificate(Element keyinfo) {
        Element x509;
        X509Certificate cert = null;
        if (debug.messageEnabled()) {
            debug.message("KeyInfo = " + XMLUtils.print(keyinfo));
        }
        if ((x509 = (Element)keyinfo.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0)) == null) {
            try {
                PublicKey pk = SecurityUtils.getPublicKey(keyinfo);
                cert = (X509Certificate)keystore.getCertificate(pk);
            }
            catch (Exception e) {
                debug.error("getCertificate Exception: ", e);
            }
        } else {
            String certString = x509.getChildNodes().item(0).getNodeValue();
            cert = SecurityUtils.getCertificate(certString, null);
        }
        return cert;
    }

    private static PublicKey getPublicKey(Element reference) throws XMLSignatureException {
        PublicKey pubKey = null;
        Document doc = reference.getOwnerDocument();
        Element dsaKey = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue").item(0);
        if (dsaKey != null) {
            NodeList nodes = dsaKey.getChildNodes();
            int nodeCount = nodes.getLength();
            if (nodeCount > 0) {
                BigInteger p = null;
                BigInteger q = null;
                BigInteger g = null;
                BigInteger y = null;
                for (int i = 0; i < nodeCount; ++i) {
                    Node currentNode = nodes.item(i);
                    if (currentNode.getNodeType() != 1) continue;
                    String tagName = currentNode.getLocalName();
                    Node sub = currentNode.getChildNodes().item(0);
                    String value = sub.getNodeValue();
                    value = SAMLUtils.removeNewLineChars(value);
                    BigInteger v = new BigInteger(Base64.decode(value));
                    if (tagName.equals("P")) {
                        p = v;
                        continue;
                    }
                    if (tagName.equals("Q")) {
                        q = v;
                        continue;
                    }
                    if (tagName.equals("G")) {
                        g = v;
                        continue;
                    }
                    if (tagName.equals("Y")) {
                        y = v;
                        continue;
                    }
                    SAMLUtils.debug.error("Wrong tag name in DSA key.");
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                }
                DSAKeyValue dsaKeyValue = new DSAKeyValue(doc, p, q, g, y);
                try {
                    pubKey = dsaKeyValue.getPublicKey();
                }
                catch (XMLSecurityException xse) {
                    SAMLUtils.debug.error("Could not get Public Key from DSA key value.");
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                }
            }
        } else {
            Element rsaKey = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue").item(0);
            if (rsaKey != null) {
                NodeList nodes = rsaKey.getChildNodes();
                int nodeCount = nodes.getLength();
                BigInteger m = null;
                BigInteger e = null;
                if (nodeCount > 0) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Node currentNode = nodes.item(i);
                        if (currentNode.getNodeType() != 1) continue;
                        String tagName = currentNode.getLocalName();
                        Node sub = currentNode.getChildNodes().item(0);
                        String value = sub.getNodeValue();
                        value = SAMLUtils.removeNewLineChars(value);
                        BigInteger v = new BigInteger(Base64.decode(value));
                        if (tagName.equals("Exponent")) {
                            e = v;
                            continue;
                        }
                        if (tagName.equals("Modulus")) {
                            m = v;
                            continue;
                        }
                        SAMLUtils.debug.error("Wrong tag name from RSA key element.");
                        throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                    }
                }
                RSAKeyValue rsaKeyValue = new RSAKeyValue(doc, m, e);
                try {
                    pubKey = rsaKeyValue.getPublicKey();
                }
                catch (XMLSecurityException ex) {
                    SAMLUtils.debug.error("Could not get Public Key from RSA key value.");
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                }
            }
        }
        return pubKey;
    }

    private static X509Certificate getCertificate(String certString, String format) {
        X509Certificate cert = null;
        try {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("getCertificate(Assertion) : " + certString);
            }
            StringBuffer xml = new StringBuffer(100);
            xml.append("-----BEGIN CERTIFICATE-----\n");
            xml.append(certString);
            xml.append("\n-----END CERTIFICATE-----");
            byte[] barr = null;
            barr = xml.toString().getBytes();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(barr);
            if (format != null && format.equals("wsse:PKCS7")) {
                Collection<? extends Certificate> c = cf.generateCertificates(bais);
                Iterator<? extends Certificate> i = c.iterator();
                while (i.hasNext()) {
                    cert = (X509Certificate)i.next();
                }
            } else {
                while (bais.available() > 0) {
                    cert = (X509Certificate)cf.generateCertificate(bais);
                }
            }
        }
        catch (Exception e) {
            SAMLUtils.debug.error("getCertificate Exception: ", e);
        }
        return cert;
    }

    private static X509Certificate getAssertionSigningCert(SecurityAssertion assertion) {
        X509Certificate cert = null;
        Element signature = assertion.getSignature();
        Element keyInfo = (Element)signature.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
        if (keyInfo != null) {
            cert = SecurityUtils.getCertificate(keyInfo);
        }
        return cert;
    }

    public static XMLSignatureManager getSignatureManager() {
        return sm;
    }

    static {
        debug = Debug.getInstance("libWSSecurity");
        String tmpStr = SystemPropertiesManager.get(PROP_TRUSTED_CA_CERT_ALIASES);
        if (debug.messageEnabled()) {
            debug.message("SecurityUtils.static: trusted ca certaliases = " + tmpStr);
        }
        if (tmpStr != null) {
            StringTokenizer stz = new StringTokenizer(tmpStr, "|");
            while (stz.hasMoreTokens()) {
                String issuer;
                String aliasIssuer = stz.nextToken().trim();
                if (aliasIssuer.length() <= 0) continue;
                int index = aliasIssuer.indexOf(":");
                if (index == -1) {
                    trustedCACertAliases.add(aliasIssuer);
                    if (!debug.messageEnabled()) continue;
                    debug.message("SecurityUtils.static: add " + aliasIssuer + " to trustedCACertAliases");
                    continue;
                }
                String alias = aliasIssuer.substring(0, index).trim();
                if (alias.length() <= 0) continue;
                trustedCACertAliases.add(alias);
                if (debug.messageEnabled()) {
                    debug.message("SecurityUtils.static: add " + alias + " to trustedCACertAliases");
                }
                if ((issuer = aliasIssuer.substring(index + 1).trim()).length() <= 0) continue;
                issuerTrustedCACertAliases.put(issuer, alias);
                if (!debug.messageEnabled()) continue;
                debug.message("SecurityUtils.static: add [" + issuer + ", " + alias + "] to issuerTrustedCACertAliases");
            }
        }
        keys = new JKSKeyProvider();
        asp = new AMSignatureProvider();
        sm = XMLSignatureManager.getInstance(keys, asp);
        keystore = sm.getKeyProvider();
    }
}

