/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTQuery {
    private String resourceID = null;
    private EncryptedResourceID encryptedResourceID = null;
    private String id = null;
    private String itemID = null;
    private List dstQueryItems = new ArrayList();
    private List extensions = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTQuery() {
    }

    public DSTQuery(String resourceID, List items, String serviceNS) {
        this.resourceID = resourceID;
        if (items != null && items.size() != 0) {
            this.dstQueryItems.addAll(items);
            DSTQueryItem item = (DSTQueryItem)items.get(0);
            this.nameSpaceURI = serviceNS == null ? item.getNameSpaceURI() : serviceNS;
            this.prefix = item.getNameSpacePrefix();
        }
    }

    public DSTQuery(EncryptedResourceID encResourceID, List items, String serviceNS) {
        this.encryptedResourceID = encResourceID;
        if (items != null && items.size() != 0) {
            this.dstQueryItems.addAll(items);
            DSTQueryItem item = (DSTQueryItem)items.get(0);
            this.nameSpaceURI = serviceNS == null ? item.getNameSpaceURI() : serviceNS;
            this.prefix = item.getNameSpacePrefix();
        }
    }

    public DSTQuery(Element element) throws DSTException {
        if (element == null) {
            DSTUtils.debug.error("DSTQuery(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String elementName = element.getLocalName();
        if (elementName == null || !elementName.equals("Query")) {
            DSTUtils.debug.error("DSTQuery(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModify(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemID = element.getAttribute("itemID");
        NodeList list = element.getElementsByTagNameNS(this.nameSpaceURI, "ResourceID");
        if (list.getLength() == 0 || list.getLength() > 1) {
            DSTUtils.debug.error("DSTQuery(element): ResourceIDNode is null or more than one resource id is found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        this.resourceID = XMLUtils.getElementValue((Element)list.item(0));
        if (this.resourceID == null) {
            DSTUtils.debug.error("DSTQuery(element): ResourceID is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        NodeList queryItemNodes = element.getElementsByTagNameNS(this.nameSpaceURI, "QueryItem");
        if (queryItemNodes == null || queryItemNodes.getLength() == 0) {
            DSTUtils.debug.error("DSTQuery(element): QueryItems are null");
            throw new DSTException(DSTUtils.bundle.getString("nullQueryItems"));
        }
        int size = queryItemNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = queryItemNodes.item(0);
            DSTQueryItem dstQueryItem = new DSTQueryItem((Element)node);
            this.dstQueryItems.add(dstQueryItem);
        }
    }

    public List getQueryItems() {
        return this.dstQueryItems;
    }

    public void setQueryItem(List items) {
        if (items != null && items.size() != 0) {
            this.dstQueryItems.addAll(items);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptedResourceID;
    }

    public void setEncryptedResourceID(EncryptedResourceID encResourceID) {
        this.encryptedResourceID = encResourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String value) {
        this.itemID = value;
    }

    public List getExtension() {
        return this.extensions;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpace) {
        this.nameSpaceURI = nameSpace;
    }

    public void setNameSpacePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        if (this.encryptedResourceID == null && this.resourceID == null || this.dstQueryItems.isEmpty()) {
            DSTUtils.debug.error("DSTQuery.toString: ResourceID or QueryItems are null.");
            return "";
        }
        String tempPrefix = "";
        if (includeNS) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            tempPrefix = this.prefix + ":";
        }
        if (declareNS && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQuery.toString: Name Space is not defined");
            return "";
        }
        StringBuffer sb = new StringBuffer(3000);
        sb.append("<").append(tempPrefix).append("Query");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemID != null && this.itemID.length() != 0) {
            sb.append(" itemID=\"").append(this.itemID).append("\"");
        }
        if (declareNS) {
            sb.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"");
        }
        sb.append(">");
        if (this.encryptedResourceID == null) {
            sb.append("<").append(tempPrefix).append("ResourceID").append(">").append(this.resourceID).append("</").append(tempPrefix).append("ResourceID").append(">");
        } else {
            sb.append(this.encryptedResourceID.toString(this.nameSpaceURI));
        }
        Iterator iter = this.dstQueryItems.iterator();
        while (iter.hasNext()) {
            DSTQueryItem item = (DSTQueryItem)iter.next();
            sb.append(item.toString(true, false));
        }
        sb.append("</").append(tempPrefix).append("Query").append(">");
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTQuery.toString: Query: " + sb.toString());
        }
        return sb.toString();
    }
}

