/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.GetComplete;
import com.sun.identity.federation.message.common.IDPEntries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSIDPList {
    private List getCompleteList = null;
    public IDPEntries idpEntries = null;
    private int minorVersion = 0;

    public FSIDPList() {
    }

    public FSIDPList(Element root) throws FSMsgException {
        if (root == null) {
            FSUtils.debug.message("FSIDPList.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String ns = root.getNamespaceURI();
        if (ns == null) {
            FSUtils.debug.error("FSIDPList(Element):No namespace");
            throw new FSMsgException("wrongInput", null);
        }
        if (ns.equals("urn:liberty:iff:2003-08")) {
            this.minorVersion = 2;
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("IDPList")) {
            FSUtils.debug.message("FSIDPList.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("GetComplete")) {
                if (this.getCompleteList == null || this.getCompleteList == Collections.EMPTY_LIST) {
                    this.getCompleteList = new ArrayList();
                }
                this.getCompleteList.add(new GetComplete((Element)child));
                continue;
            }
            if (!childName.equals("IDPEntries")) continue;
            this.idpEntries = new IDPEntries((Element)child);
        }
    }

    public FSIDPList(IDPEntries idpEntries, List getCompleteList) {
        this.idpEntries = idpEntries;
        this.getCompleteList = getCompleteList;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public IDPEntries getIDPEntries() {
        return this.idpEntries;
    }

    public List getGetCompleteList() {
        return this.getCompleteList;
    }

    public void setIDPEntries(IDPEntries idpEntries) {
        this.idpEntries = idpEntries;
    }

    public void setGetCompleteList(List getCompleteList) {
        this.getCompleteList = getCompleteList;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"").append(" ").append('?').append(">");
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        xml.append("<").append(prefix).append("IDPList").append(uri).append(">");
        if (this.idpEntries != null) {
            xml.append(this.idpEntries.toXMLString(true, false));
        }
        if (this.getCompleteList != null && this.getCompleteList != Collections.EMPTY_LIST) {
            Iterator i = this.getCompleteList.iterator();
            while (i.hasNext()) {
                xml.append((String)i.next());
            }
        }
        xml.append("</").append(prefix).append("IDPList").append(">");
        return xml.toString();
    }
}

