/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cot;

import com.sun.identity.cot.COTCache;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.COTServiceListener;
import com.sun.identity.cot.COTUtils;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.LogUtil;
import com.sun.identity.federation.meta.IDFFCOTUtils;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.saml2.meta.SAML2COTUtils;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.shared.debug.Debug;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class CircleOfTrustManager {
    private static final String SUBCONFIG_ID = "cot";
    private static final int SUBCONFIG_PRIORITY = 0;
    private static ConfigurationInstance configInst;
    private static Debug debug;

    public CircleOfTrustManager() throws COTException {
        if (configInst == null) {
            throw new COTException("nullConfig", null);
        }
    }

    public void createCircleOfTrust(String realm, CircleOfTrustDescriptor cotDescriptor) throws COTException {
        String name;
        String classMethod = "COTManager.createCircleOfTrust: ";
        if (cotDescriptor == null) {
            throw new COTException("nullCot", null);
        }
        Object entityId = null;
        if (realm == null) {
            realm = "/";
        }
        if ((name = cotDescriptor.getCircleOfTrustName()) == null || name.trim().length() == 0) {
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NO_COT_NAME_CREATE_COT_DESCRIPTOR", data);
            throw new COTException("invalidCOTName", null);
        }
        if (this.getAllCirclesOfTrust(realm).contains(name)) {
            debug.error(classMethod + "Circle of trust already exists" + name);
            Object[] data = new String[]{name, realm};
            LogUtil.error(Level.INFO, "COT_EXISTS_CREATE_COT_DESCRIPTOR", (String[])data);
            throw new COTException("cotExists", data);
        }
        Map attrs = cotDescriptor.getAttributes();
        Map tpMap = this.checkAndSetTrustedProviders(realm, cotDescriptor);
        if (tpMap != null) {
            this.updateEntityConfig(realm, name, "saml2", (Set)tpMap.get("saml2"));
            this.updateEntityConfig(realm, name, "idff", (Set)tpMap.get("idff"));
            this.updateEntityConfig(realm, name, "wsfed", (Set)tpMap.get("wsfed"));
        }
        try {
            configInst.createConfiguration(realm, name, attrs);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "circle of trust is created.");
            }
            String[] data = new String[]{name, realm};
            LogUtil.access(Level.INFO, "COT_DESCRIPTOR_CREATED", data);
        }
        catch (ConfigurationException e) {
            debug.error(classMethod, e);
            String[] data = new String[]{e.getMessage(), name, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_COT_DESCRIPTOR", data);
            throw new COTException(e);
        }
    }

    private Map checkAndSetTrustedProviders(String realm, CircleOfTrustDescriptor cotDescriptor) throws COTException {
        Set tp = cotDescriptor.getTrustedProviders();
        Map map = null;
        if (tp != null && !tp.isEmpty()) {
            map = COTUtils.trustedProviderSetToProtocolMap(tp, realm);
            this.retainValidEntityIDs(map, "saml2", realm);
            this.retainValidEntityIDs(map, "idff", realm);
        }
        return map;
    }

    private void retainValidEntityIDs(Map map, String protocol, String realm) throws COTException {
        Set pSet = (Set)map.get(protocol);
        if (pSet != null && !pSet.isEmpty()) {
            Set entityIds = this.getAllEntities(realm, protocol);
            if (entityIds == null || entityIds.isEmpty()) {
                map.remove(protocol);
            } else if (!entityIds.containsAll(pSet) && entityIds.retainAll(pSet)) {
                if (debug.messageEnabled()) {
                    debug.message("COTDescriptor.retainValidEntityIDs: Following entity id: " + entityIds + " are valid and will be added to " + "the circle of trust");
                }
                map.put(protocol, entityIds);
            }
        }
    }

    public void modifyCircleOfTrust(String realm, CircleOfTrustDescriptor cotDescriptor) throws COTException {
        String classMethod = "COTManager.modifyCircleOfTrust :";
        if (cotDescriptor == null) {
            throw new COTException("nullCot", null);
        }
        if (realm == null) {
            realm = "/";
        }
        String name = cotDescriptor.getCircleOfTrustName();
        this.isValidCOTName(realm, name);
        try {
            Map attrs = cotDescriptor.getAttributes();
            configInst.setConfiguration(realm, name, attrs);
        }
        catch (ConfigurationException e) {
            debug.error(classMethod, e);
            String[] data = new String[]{e.getMessage(), name, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_MODIFY_COT_DESCRIPTOR", data);
            throw new COTException(e);
        }
    }

    public Set getAllCirclesOfTrust(String realm) throws COTException {
        Set valueSet = null;
        HashSet<String> cotSet = new HashSet<String>();
        if (realm == null) {
            realm = "/";
        }
        String classMethod = "COTManager.getAllCircleOfTrust: ";
        try {
            valueSet = configInst.getAllConfigurationNames(realm);
            if (valueSet != null && !valueSet.isEmpty()) {
                Iterator iter = valueSet.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    cotSet.add(name);
                }
            }
        }
        catch (ConfigurationException e) {
            debug.error(classMethod, e);
            String[] data = new String[]{e.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_COT_DESCRIPTOR", data);
            throw new COTException(e);
        }
        return cotSet;
    }

    boolean isValidProtocolType(String protocolType) throws COTException {
        String classMethod = "COTManager:isValidProtocolType";
        if (!COTUtils.isValidProtocolType(protocolType)) {
            debug.error(classMethod + "Invalid protocol Type " + protocolType);
            Object[] data = new String[]{protocolType};
            throw new COTException("invalidProtocolType", data);
        }
        return true;
    }

    Set getAllEntities(String realm, String type) throws COTException {
        Set entityIds = Collections.EMPTY_SET;
        if (type != null) {
            if (type.equalsIgnoreCase("idff")) {
                entityIds = this.getIDFFEntities(realm);
            } else if (type.equalsIgnoreCase("saml2")) {
                entityIds = this.getSAML2Entities(realm);
            } else {
                Object[] data = new String[]{type};
                throw new COTException("invalidProtocolType", data);
            }
        }
        return entityIds;
    }

    Set getIDFFEntities(String realm) throws COTException {
        try {
            IDFFMetaManager idffMetaMgr = new IDFFMetaManager(null);
            return idffMetaMgr.getAllEntities(realm);
        }
        catch (IDFFMetaException idffe) {
            throw new COTException(idffe);
        }
    }

    Set getSAML2Entities(String realm) throws COTException {
        try {
            SAML2MetaManager saml2MetaMgr = new SAML2MetaManager();
            return saml2MetaMgr.getAllEntities(realm);
        }
        catch (SAML2MetaException sme) {
            throw new COTException(sme);
        }
    }

    void updateEntityConfig(String realm, String cotName, String protocolType, Set trustedProviders) throws COTException {
        if (protocolType.equalsIgnoreCase("idff")) {
            this.updateIDFFEntityConfig(realm, cotName, trustedProviders);
        } else if (protocolType.equalsIgnoreCase("saml2")) {
            this.updateSAML2EntityConfig(realm, cotName, trustedProviders);
        } else if (protocolType.equalsIgnoreCase("wsfed")) {
            this.updateWSFedEntityConfig(realm, cotName, trustedProviders);
        } else {
            Object[] args = new String[]{protocolType};
            throw new COTException("invalidProtocolType", args);
        }
    }

    void updateEntityConfig(String realm, String cotName, String protocolType, String entityID) throws COTException, JAXBException {
        if (protocolType.equalsIgnoreCase("idff")) {
            try {
                new IDFFCOTUtils().updateEntityConfig(realm, cotName, entityID);
            }
            catch (IDFFMetaException idffe) {
                throw new COTException(idffe);
            }
        } else if (protocolType.equalsIgnoreCase("saml2")) {
            try {
                new SAML2COTUtils().updateEntityConfig(realm, cotName, entityID);
            }
            catch (SAML2MetaException idffe) {
                throw new COTException(idffe);
            }
        } else if (protocolType.equalsIgnoreCase("wsfed")) {
            try {
                Class<?> clazz = Class.forName("com.sun.identity.wsfederation.meta.WSFederationCOTUtils");
                Class[] formalParams = new Class[]{String.class, String.class, String.class};
                Method updateEntity = clazz.getDeclaredMethod("updateEntityConfig", formalParams);
                Object[] params = new Object[]{realm, cotName, entityID};
                updateEntity.invoke(null, params);
            }
            catch (NoSuchMethodException e) {
                Object[] args = new String[]{protocolType};
                throw new COTException("invalidProtocolType", args);
            }
            catch (ClassNotFoundException e) {
                Object[] args = new String[]{protocolType};
                throw new COTException("invalidProtocolType", args);
            }
            catch (Exception e) {
                throw new COTException(e);
            }
        } else {
            Object[] args = new String[]{protocolType};
            throw new COTException("invalidProtocolType", args);
        }
    }

    void removeFromEntityConfig(String realm, String cotName, String protocolType, String entityID) throws COTException, JAXBException {
        if (protocolType.equalsIgnoreCase("idff")) {
            try {
                new IDFFCOTUtils().removeFromEntityConfig(realm, cotName, entityID);
            }
            catch (IDFFMetaException idme) {
                throw new COTException(idme);
            }
        } else if (protocolType.equalsIgnoreCase("saml2")) {
            try {
                new SAML2COTUtils().removeFromEntityConfig(realm, cotName, entityID);
            }
            catch (SAML2MetaException sme) {
                throw new COTException(sme);
            }
        } else if (protocolType.equalsIgnoreCase("wsfed")) {
            try {
                Class<?> clazz = Class.forName("com.sun.identity.wsfederation.meta.WSFederationCOTUtils");
                Class[] formalParams = new Class[]{String.class, String.class, String.class};
                Method removeFromEntityConfig = clazz.getDeclaredMethod("removeFromEntityConfig", formalParams);
                Object[] params = new Object[]{realm, cotName, entityID};
                removeFromEntityConfig.invoke(null, params);
            }
            catch (NoSuchMethodException e) {
                Object[] data = new String[]{protocolType};
                throw new COTException("invalidProtocolType", data);
            }
            catch (ClassNotFoundException e) {
                Object[] data = new String[]{protocolType};
                throw new COTException("invalidProtocolType", data);
            }
            catch (Exception e) {
                throw new COTException(e);
            }
        } else {
            Object[] data = new String[]{protocolType};
            throw new COTException("invalidProtocolType", data);
        }
    }

    void updateIDFFEntityConfig(String realm, String cotName, Set trustedProviders) throws COTException {
        String classMethod = "COTManager:updateIDFFEntityConfig";
        IDFFCOTUtils idffCotUtils = new IDFFCOTUtils();
        String entityId = null;
        if (trustedProviders != null && !trustedProviders.isEmpty()) {
            Iterator iter = trustedProviders.iterator();
            while (iter.hasNext()) {
                entityId = (String)iter.next();
                try {
                    idffCotUtils.updateEntityConfig(realm, cotName, entityId);
                }
                catch (IDFFMetaException idfe) {
                    throw new COTException(idfe);
                }
                catch (JAXBException jbe) {
                    debug.error(classMethod, jbe);
                    String[] data = new String[]{jbe.getMessage(), cotName, entityId, realm};
                    LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_COT_DESCRIPTOR", data);
                    throw new COTException(jbe);
                }
            }
        }
    }

    void updateSAML2EntityConfig(String realm, String cotName, Set trustedProviders) throws COTException {
        String classMethod = "COTManager:updateSAML2EntityConfig";
        String entityId = null;
        SAML2COTUtils saml2CotUtils = new SAML2COTUtils();
        if (trustedProviders != null && !trustedProviders.isEmpty()) {
            Iterator iter = trustedProviders.iterator();
            while (iter.hasNext()) {
                entityId = (String)iter.next();
                try {
                    saml2CotUtils.updateEntityConfig(realm, cotName, entityId);
                }
                catch (SAML2MetaException sme) {
                    throw new COTException(sme);
                }
                catch (JAXBException e) {
                    debug.error(classMethod, e);
                    String[] data = new String[]{e.getMessage(), cotName, entityId, realm};
                    LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_COT_DESCRIPTOR", data);
                    throw new COTException(e);
                }
            }
        }
    }

    void updateWSFedEntityConfig(String realm, String cotName, Set trustedProviders) throws COTException {
        String classMethod = "COTManager:updateWSFedEntityConfig";
        Method updateEntity = null;
        String entityId = null;
        try {
            Class<?> clazz = Class.forName("com.sun.identity.wsfederation.meta.WSFederationCOTUtils");
            Class[] formalParams = new Class[]{String.class, String.class, String.class};
            updateEntity = clazz.getDeclaredMethod("updateEntityConfig", formalParams);
        }
        catch (NoSuchMethodException e) {
            throw new COTException(e);
        }
        catch (ClassNotFoundException e) {
            throw new COTException(e);
        }
        if (trustedProviders != null && !trustedProviders.isEmpty()) {
            Iterator iter = trustedProviders.iterator();
            while (iter.hasNext()) {
                entityId = (String)iter.next();
                try {
                    Object[] params = new Object[]{realm, cotName, entityId};
                    updateEntity.invoke(null, params);
                }
                catch (Exception e) {
                    throw new COTException(e);
                }
            }
        }
    }

    public void addCircleOfTrustMember(String realm, String cotName, String protocolType, String entityId) throws COTException {
        String classMethod = "COTManager.addCircleOfTrustMember: ";
        if (realm == null) {
            realm = "/";
        }
        if (cotName == null || cotName.trim().length() == 0) {
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NULL_COT_NAME_ADD_COT_DESCRIPTOR", data);
            throw new COTException("invalidCOTName", null);
        }
        if (entityId == null || entityId.trim().length() == 0) {
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NULL_ENTITYID_ADD_COT_DESCRIPTOR", data);
            throw new COTException("invalidEntityID", null);
        }
        try {
            Map attrs = configInst.getConfiguration(realm, cotName);
            this.isValidProtocolType(protocolType);
            this.updateEntityConfig(realm, cotName, protocolType, entityId);
            CircleOfTrustDescriptor cotDesc = attrs == null ? new CircleOfTrustDescriptor(cotName, realm, "active") : new CircleOfTrustDescriptor(cotName, realm, attrs);
            if (!cotDesc.add(entityId, protocolType)) {
                debug.error(classMethod + "fail to add entityid to the circle of trust." + entityId + " in Realm " + realm);
                Object[] args = new String[]{realm, entityId};
                throw new COTException("addCOTFailed", args);
            }
            this.modifyCircleOfTrust(realm, cotDesc);
        }
        catch (ConfigurationException e) {
            debug.error(classMethod, e);
            String[] data = new String[]{e.getMessage(), cotName, entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_ADD_COT_MEMBER", data);
            throw new COTException(e);
        }
        catch (JAXBException jbe) {
            debug.error(classMethod, jbe);
            String[] data = new String[]{jbe.getMessage(), cotName, entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_COT_DESCRIPTOR", data);
            throw new COTException(jbe);
        }
    }

    public void removeCircleOfTrustMember(String realm, String cotName, String protocolType, String entityId) throws COTException {
        String classMethod = "COTManager.removeCircleOfTrustMember: ";
        if (cotName == null || cotName.trim().length() == 0) {
            String[] data = new String[]{cotName, realm};
            LogUtil.error(Level.INFO, "NULL_COT_NAME_REMOVE_COT_MEMBER", data);
            throw new COTException("invalidCOTName", null);
        }
        if (entityId == null || entityId.trim().length() == 0) {
            String[] data = new String[]{cotName, entityId, realm};
            LogUtil.error(Level.INFO, "NULL_ENTITYID_REMOVE_COT_MEMBER", data);
            throw new COTException("invalidEntityID", null);
        }
        if (realm == null) {
            realm = "/";
        }
        try {
            this.removeFromEntityConfig(realm, cotName, protocolType, entityId);
            Map attrs = configInst.getConfiguration(realm, cotName);
            CircleOfTrustDescriptor cotDesc = attrs == null ? new CircleOfTrustDescriptor(cotName, realm, "active") : new CircleOfTrustDescriptor(cotName, realm, attrs);
            if (!cotDesc.remove(entityId, protocolType)) {
                debug.error(classMethod + "fail to remove entityid from the circle of trust." + realm);
                Object[] data = new String[]{entityId, realm};
                throw new COTException("removeCOTFailed", data);
            }
            this.modifyCircleOfTrust(realm, cotDesc);
        }
        catch (ConfigurationException e) {
            debug.error(classMethod, e);
            String[] data = new String[]{e.getMessage(), cotName, entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_REMOVE_COT_MEMBER", data);
            throw new COTException(e);
        }
        catch (JAXBException jaxbe) {
            debug.error(classMethod, jaxbe);
            String[] data = new String[]{jaxbe.getMessage(), cotName, entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_REMOVE_COT_MEMBER", data);
            throw new COTException(jaxbe);
        }
    }

    public Set listCircleOfTrustMember(String realm, String cotName, String protocolType) throws COTException {
        String classMethod = "COTManager.listCircleOfTrustMember: ";
        if (cotName == null || cotName.trim().length() == 0) {
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NULL_COT_NAME_LIST_COT", data);
            throw new COTException("invalidCOTName", null);
        }
        if (realm == null) {
            realm = "/";
        }
        Set trustedProviders = new HashSet();
        try {
            CircleOfTrustDescriptor cotDesc = null;
            Map attrs = configInst.getConfiguration(realm, cotName);
            if (attrs == null) {
                return null;
            }
            this.isValidProtocolType(protocolType);
            cotDesc = new CircleOfTrustDescriptor(cotName, realm, attrs);
            trustedProviders = cotDesc.getTrustedProviders(protocolType);
        }
        catch (ConfigurationException e) {
            debug.error(classMethod, e);
            String[] data = new String[]{e.getMessage(), cotName, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_LIST_COT_MEMBER", data);
            throw new COTException(e);
        }
        return trustedProviders;
    }

    public void deleteCircleOfTrust(String realm, String cotName) throws COTException {
        String classMethod = "COTManager.deleteCircleOfTrust:";
        if (realm == null) {
            realm = "/";
        }
        String[] data = new String[]{cotName, realm};
        this.isValidCOTName(realm, cotName);
        try {
            Set trustProviders = null;
            Map attrs = configInst.getConfiguration(realm, cotName);
            if (attrs != null) {
                CircleOfTrustDescriptor cotDesc = new CircleOfTrustDescriptor(cotName, realm, attrs);
                trustProviders = cotDesc.getTrustedProviders();
            }
            if (attrs != null && trustProviders != null && !trustProviders.isEmpty()) {
                debug.error(classMethod + "Delete circle of trust" + " is not allowed since it contains members.");
                LogUtil.error(Level.INFO, "HAS_ENTITIES_DELETE_COT_DESCRIPTOR", data);
                Object[] args = new String[]{cotName, realm};
                throw new COTException("deleteCOTFailedHasMembers", args);
            }
            configInst.deleteConfiguration(realm, cotName, null);
            LogUtil.access(Level.INFO, "COT_DESCRIPTOR_DELETED", data);
        }
        catch (ConfigurationException e) {
            debug.error(classMethod, e);
            String[] args = new String[]{e.getMessage(), cotName, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_DELETE_COT_DESCRIPTOR", args);
            throw new COTException(e);
        }
    }

    public CircleOfTrustDescriptor getCircleOfTrust(String realm, String name) throws COTException {
        String classMethod = "COTManager.getCircleOfTrust :";
        if (realm == null) {
            realm = "/";
        }
        this.isValidCOTName(realm, name);
        String[] data = new String[]{name, realm};
        CircleOfTrustDescriptor cotDesc = COTCache.getCircleOfTrust(realm, name);
        if (cotDesc != null) {
            LogUtil.access(Level.FINE, "COT_FROM_CACHE", data);
        } else {
            try {
                Map attrs = configInst.getConfiguration(realm, name);
                cotDesc = attrs == null ? new CircleOfTrustDescriptor(name, realm, "active") : new CircleOfTrustDescriptor(name, realm, attrs);
                COTCache.putCircleOfTrust(realm, name, cotDesc);
                LogUtil.access(Level.INFO, "COT_DESCRIPTOR_RETRIEVED", data);
            }
            catch (ConfigurationException e) {
                debug.error(classMethod, e);
                data[0] = e.getMessage();
                data[1] = name;
                data[2] = realm;
                LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_COT_DESCRIPTOR", data);
                throw new COTException(e);
            }
        }
        return cotDesc;
    }

    public Set getAllActiveCirclesOfTrust(String realm) throws COTException {
        String classMethod = "COTManager.getAllActiveCirclesOfTrust: ";
        HashSet<String> activeAuthDomains = new HashSet<String>();
        try {
            Set valueSet = configInst.getAllConfigurationNames(realm);
            if (valueSet != null && !valueSet.isEmpty()) {
                Iterator iter = valueSet.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    Map attrMap = configInst.getConfiguration(realm, name);
                    if (!COTUtils.getFirstEntry(attrMap, "sun-fm-cot-status").equalsIgnoreCase("active")) continue;
                    activeAuthDomains.add(name);
                }
            }
        }
        catch (ConfigurationException se) {
            debug.error(classMethod, se);
            String[] data = new String[]{se.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_ACTIVE_COT", data);
            throw new COTException(se);
        }
        return activeAuthDomains;
    }

    public boolean isInCircleOfTrust(String realm, String name, String protocolType, String entityId) {
        HashSet tProviders = new HashSet();
        try {
            CircleOfTrustDescriptor cotd = this.getCircleOfTrust(realm, name);
            Set pSet = cotd.getTrustedProviders(protocolType);
            return pSet != null && !pSet.isEmpty() && pSet.contains(entityId);
        }
        catch (Exception me) {
            debug.error("COTManager.isInCircleOfTrust", me);
            String[] data = new String[]{me.getMessage(), name, entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_RETREIVE_COT", data);
            return false;
        }
    }

    boolean isValidCOTName(String realm, String name) throws COTException {
        String classMethod = "COTManager.isValidCOTName: ";
        if (name == null || name.trim().length() == 0 || !this.getAllCirclesOfTrust(realm).contains(name)) {
            debug.error(classMethod + "invalid circle of trust name :" + name);
            Object[] data = new String[]{realm, name};
            LogUtil.error(Level.INFO, "INVALID_COT_NAME", (String[])data);
            throw new COTException("invalidCOTName", data);
        }
        return true;
    }

    boolean isActiveCOT(String cotStatus) {
        return cotStatus != null && cotStatus.equalsIgnoreCase("active");
    }

    public Map getIDFFCOTProviderMapping(String realm) throws COTException {
        String classMethod = "COTManager.getAllActiveCirclesOfTrust: ";
        HashMap<String, Set> cotMap = new HashMap<String, Set>();
        if (realm == null) {
            realm = "/";
        }
        try {
            Set valueSet = configInst.getAllConfigurationNames(realm);
            if (valueSet != null && !valueSet.isEmpty()) {
                Iterator iter = valueSet.iterator();
                while (iter.hasNext()) {
                    Set trustedProviders;
                    Map map;
                    Set idffSet;
                    String name = (String)iter.next();
                    Map attrMap = configInst.getConfiguration(realm, name);
                    String cotStatus = COTUtils.getFirstEntry(attrMap, "sun-fm-cot-status");
                    if (!this.isActiveCOT(cotStatus) || (idffSet = (Set)(map = COTUtils.trustedProviderSetToProtocolMap(trustedProviders = (Set)attrMap.get("sun-fm-trusted-providers"), "/")).get("idff")) == null || idffSet.isEmpty()) continue;
                    cotMap.put(name, idffSet);
                }
            }
        }
        catch (ConfigurationException se) {
            debug.error(classMethod, se);
            String[] data = new String[]{se.getMessage(), "idff", realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_ACTIVE_COT", data);
            throw new COTException(se);
        }
        return cotMap;
    }

    static {
        debug = COTUtils.debug;
        try {
            configInst = ConfigurationManager.getConfigurationInstance("LIBCOT");
        }
        catch (ConfigurationException ce) {
            debug.error("COTManager.static: Unable to get COT service config", ce);
            configInst = null;
        }
        if (configInst != null) {
            try {
                configInst.addListener(new COTServiceListener());
            }
            catch (ConfigurationException ce) {
                debug.error("COTManager.static: Unable to add ConfigurationListener for COT service.", ce);
            }
        }
    }
}

