/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cot;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.COTUtils;
import com.sun.identity.shared.validation.URLValidator;
import com.sun.identity.shared.validation.ValidationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CircleOfTrustDescriptor {
    private String circleOfTrustType = null;
    private String circleOfTrustName = null;
    private String realm = null;
    private String circleOfTrustDescription = null;
    private String circleOfTrustStatus = null;
    private String writerServiceURL = null;
    private String readerServiceURL = null;
    private String idffWriterServiceURL = null;
    private String idffReaderServiceURL = null;
    private String saml2WriterServiceURL = null;
    private String saml2ReaderServiceURL = null;
    private Set trustedProviders = null;
    private Map trustedProviderMap = null;

    CircleOfTrustDescriptor(String name, String realm, Map attrMap) throws COTException {
        this.setCircleOfTrustName(name);
        this.realm = realm;
        this.setCircleOfTrustDescription(COTUtils.getFirstEntry(attrMap, "sun-fm-cot-description"));
        this.setCircleOfTrustType(COTUtils.getFirstEntry(attrMap, "sun-fm-cot-type"));
        this.setCircleOfTrustStatus(COTUtils.getFirstEntry(attrMap, "sun-fm-cot-status"));
        this.setWriterServiceURL(COTUtils.getFirstEntry(attrMap, "sun-fm-writerservice-url"));
        this.setReaderServiceURL(COTUtils.getFirstEntry(attrMap, "sun-fm-readerservice-url"));
        this.setSAML2WriterServiceURL(COTUtils.getFirstEntry(attrMap, "sun-fm-saml2-writerservice-url"));
        this.setSAML2ReaderServiceURL(COTUtils.getFirstEntry(attrMap, "sun-fm-saml2-readerservice-url"));
        this.setIDFFWriterServiceURL(COTUtils.getFirstEntry(attrMap, "sun-fm-idff-writerservice-url"));
        this.setIDFFReaderServiceURL(COTUtils.getFirstEntry(attrMap, "sun-fm-idff-readerservice-url"));
        this.setTrustedProviders((Set)attrMap.get("sun-fm-trusted-providers"));
    }

    public CircleOfTrustDescriptor(String circleOfTrustName, String realm, String circleOfTrustStatus) throws COTException {
        this.setCircleOfTrustName(circleOfTrustName);
        this.realm = realm;
        this.setCircleOfTrustStatus(circleOfTrustStatus);
    }

    public CircleOfTrustDescriptor(String circleOfTrustName, String realm, String circleOfTrustStatus, String circleOfTrustDescription, String circleOfTrustIDFFReaderURL, String circleOfTrustIDFFWriterURL, String circleOfTrustSAML2ReaderURL, String circleOfTrustSAML2WriterURL, Set circleOfTrustProvider) throws COTException {
        this.setCircleOfTrustName(circleOfTrustName);
        this.realm = realm;
        this.setCircleOfTrustStatus(circleOfTrustStatus);
        this.setCircleOfTrustDescription(circleOfTrustDescription);
        if (circleOfTrustIDFFReaderURL != null) {
            this.setIDFFReaderServiceURL(circleOfTrustIDFFReaderURL);
        }
        if (circleOfTrustIDFFWriterURL != null) {
            this.setIDFFWriterServiceURL(circleOfTrustIDFFWriterURL);
        }
        if (circleOfTrustSAML2ReaderURL != null) {
            this.setSAML2ReaderServiceURL(circleOfTrustSAML2ReaderURL);
        }
        if (circleOfTrustSAML2WriterURL != null) {
            this.setSAML2WriterServiceURL(circleOfTrustSAML2WriterURL);
        }
        this.setTrustedProviders(circleOfTrustProvider);
    }

    private void setCircleOfTrustName(String name) throws COTException {
        if (name == null || name.trim().length() <= 0) {
            Object[] args = new String[]{name};
            throw new COTException("invalidCOTName", args);
        }
        this.circleOfTrustName = name;
    }

    private void setCircleOfTrustType(String type) throws COTException {
        if (type != null && !COTUtils.isValidProtocolType(type)) {
            Object[] data = new String[]{type};
            throw new COTException("invalidProtooclType", data);
        }
        COTUtils.debug.message("Circle of Trust type is : " + type);
        this.circleOfTrustType = type;
    }

    public String getCircleOfTrustName() {
        return this.circleOfTrustName;
    }

    public String getCircleOfTrustRealm() {
        return this.realm;
    }

    public String getCircleOfTrustStatus() {
        return this.circleOfTrustStatus;
    }

    public String getCircleOfTrustDescription() {
        return this.circleOfTrustDescription;
    }

    public String getIDFFReaderServiceURL() {
        if (this.idffReaderServiceURL != null) {
            return this.idffReaderServiceURL;
        }
        if (this.circleOfTrustType != null && this.circleOfTrustType.equalsIgnoreCase("idff")) {
            return this.readerServiceURL;
        }
        return null;
    }

    public String getSAML2ReaderServiceURL() {
        if (this.saml2ReaderServiceURL != null) {
            return this.saml2ReaderServiceURL;
        }
        if (this.circleOfTrustType != null && this.circleOfTrustType.equalsIgnoreCase("saml2")) {
            return this.readerServiceURL;
        }
        return null;
    }

    public String getIDFFWriterServiceURL() {
        if (this.idffWriterServiceURL != null) {
            return this.idffWriterServiceURL;
        }
        if (this.circleOfTrustType != null && this.circleOfTrustType.equalsIgnoreCase("idff")) {
            return this.writerServiceURL;
        }
        return null;
    }

    public String getSAML2WriterServiceURL() {
        if (this.saml2WriterServiceURL != null) {
            return this.saml2WriterServiceURL;
        }
        if (this.circleOfTrustType != null && this.circleOfTrustType.equalsIgnoreCase("saml2")) {
            return this.writerServiceURL;
        }
        return null;
    }

    public void setCircleOfTrustDescription(String circleOfTrustDescription) {
        this.circleOfTrustDescription = circleOfTrustDescription;
    }

    private void setReaderServiceURL(String readerServiceURL) throws COTException {
        if (readerServiceURL != null && readerServiceURL.trim().length() > 0) {
            URLValidator validator = URLValidator.getInstance();
            try {
                validator.validate(readerServiceURL);
            }
            catch (ValidationException e) {
                throw new COTException("invalidReaderUrl", null);
            }
        }
        this.readerServiceURL = readerServiceURL;
    }

    public void setIDFFReaderServiceURL(String readerServiceURL) throws COTException {
        if (readerServiceURL != null && readerServiceURL.trim().length() > 0) {
            URLValidator validator = URLValidator.getInstance();
            try {
                validator.validate(readerServiceURL);
            }
            catch (ValidationException e) {
                throw new COTException("invalidReaderUrl", null);
            }
        }
        this.idffReaderServiceURL = readerServiceURL;
    }

    public void setSAML2ReaderServiceURL(String readerServiceURL) throws COTException {
        if (readerServiceURL != null && readerServiceURL.trim().length() > 0) {
            URLValidator validator = URLValidator.getInstance();
            try {
                validator.validate(readerServiceURL);
            }
            catch (ValidationException e) {
                throw new COTException("invalidReaderUrl", null);
            }
        }
        this.saml2ReaderServiceURL = readerServiceURL;
    }

    private void setWriterServiceURL(String writerServiceURL) throws COTException {
        if (writerServiceURL != null && writerServiceURL.trim().length() > 0) {
            URLValidator validator = URLValidator.getInstance();
            try {
                validator.validate(writerServiceURL);
            }
            catch (ValidationException e) {
                throw new COTException("invalidWriterUrl", null);
            }
        }
        this.writerServiceURL = writerServiceURL;
    }

    public void setIDFFWriterServiceURL(String writerServiceURL) throws COTException {
        if (writerServiceURL != null && writerServiceURL.trim().length() > 0) {
            URLValidator validator = URLValidator.getInstance();
            try {
                validator.validate(writerServiceURL);
            }
            catch (ValidationException e) {
                throw new COTException("invalidWriterUrl", null);
            }
        }
        this.idffWriterServiceURL = writerServiceURL;
    }

    public void setSAML2WriterServiceURL(String writerServiceURL) throws COTException {
        if (writerServiceURL != null && writerServiceURL.trim().length() > 0) {
            URLValidator validator = URLValidator.getInstance();
            try {
                validator.validate(writerServiceURL);
            }
            catch (ValidationException e) {
                throw new COTException("invalidWriterUrl", null);
            }
        }
        this.saml2WriterServiceURL = writerServiceURL;
    }

    public void setCircleOfTrustStatus(String circleOfTrustStatus) throws COTException {
        if (circleOfTrustStatus == null || !circleOfTrustStatus.equalsIgnoreCase("active") && !circleOfTrustStatus.equalsIgnoreCase("inactive")) {
            throw new COTException("invalidCotStatus", null);
        }
        this.circleOfTrustStatus = circleOfTrustStatus;
    }

    public void setTrustedProviders(Set circleOfTrustProvider) {
        this.trustedProviderMap = Collections.unmodifiableMap(COTUtils.trustedProviderSetToProtocolMap(circleOfTrustProvider, this.realm));
        this.trustedProviders = Collections.unmodifiableSet(COTUtils.trustedProviderProtocolMapToSet(this.trustedProviderMap));
    }

    public Set getTrustedProviders() {
        if (this.trustedProviders == null) {
            return null;
        }
        HashSet ret = new HashSet();
        ret.addAll(this.trustedProviders);
        return ret;
    }

    public Set getTrustedProviders(String protocol) {
        if (this.trustedProviderMap == null || protocol == null) {
            return null;
        }
        Set tmp = (Set)this.trustedProviderMap.get(protocol);
        if (tmp != null) {
            if (this.circleOfTrustType == null || this.circleOfTrustType.equalsIgnoreCase(protocol)) {
                HashSet ret = new HashSet();
                ret.addAll(tmp);
                return ret;
            }
            return null;
        }
        return null;
    }

    public boolean add(String entityID, String protocol) throws COTException {
        if (!COTUtils.isValidProtocolType(protocol)) {
            throw new COTException("invalidProtocolType", null);
        }
        if (this.trustedProviderMap == null || this.trustedProviderMap.get(protocol) == null || !((Set)this.trustedProviderMap.get(protocol)).contains(entityID)) {
            HashSet<String> ret = new HashSet<String>();
            if (this.trustedProviders != null) {
                ret.addAll(this.trustedProviders);
            }
            boolean result = ret.add(entityID + "|" + protocol);
            this.setTrustedProviders(ret);
            return result;
        }
        throw new COTException("entityExistsInCot", null);
    }

    public boolean remove(String entityID, String protocol) {
        boolean result;
        if (!COTUtils.isValidProtocolType(protocol)) {
            return false;
        }
        if (this.trustedProviderMap == null || this.trustedProviderMap.get(protocol) == null || !((Set)this.trustedProviderMap.get(protocol)).contains(entityID)) {
            return false;
        }
        HashSet ret = new HashSet();
        if (this.trustedProviders != null) {
            ret.addAll(this.trustedProviders);
        }
        if (!(result = ret.remove(entityID + "|" + protocol))) {
            result = ret.remove(entityID);
        }
        this.setTrustedProviders(ret);
        return result;
    }

    protected Map getAttributes() {
        HashMap<String, Set> attrMap = new HashMap<String, Set>();
        COTUtils.fillEntriesInSet(attrMap, "sun-fm-cot-description", this.circleOfTrustDescription);
        COTUtils.fillEntriesInSet(attrMap, "sun-fm-cot-status", this.circleOfTrustStatus);
        COTUtils.fillEntriesInSet(attrMap, "sun-fm-saml2-writerservice-url", this.saml2WriterServiceURL);
        COTUtils.fillEntriesInSet(attrMap, "sun-fm-idff-writerservice-url", this.idffWriterServiceURL);
        COTUtils.fillEntriesInSet(attrMap, "sun-fm-saml2-readerservice-url", this.saml2ReaderServiceURL);
        COTUtils.fillEntriesInSet(attrMap, "sun-fm-idff-readerservice-url", this.idffReaderServiceURL);
        attrMap.put("sun-fm-trusted-providers", this.trustedProviders);
        return attrMap;
    }
}

