/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.protocol.AMURLStreamHandlerFactory;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpURLConnectionManager {
    private static Debug debug = Debug.getInstance("PLLClient");
    private static int READTIMEOUT = 30000;
    private static final String URL_READTIMEOUT = "com.sun.identity.url.readTimeout";
    private static Method method;
    private static Object[] args;
    private static String prot_handler_string;
    private static AMURLStreamHandlerFactory stFactory;

    public static HttpURLConnection getConnection(URL url) throws IOException {
        if (prot_handler_string != null && url.getProtocol().equalsIgnoreCase("https")) {
            url = new URL(url, url.toExternalForm(), stFactory.createURLStreamHandler("https"));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (method != null) {
            try {
                method.invoke((Object)conn, args);
                if (debug.messageEnabled()) {
                    debug.message("HttpURLConnectionManager.getConnection: set read timeout to " + READTIMEOUT);
                }
            }
            catch (IllegalAccessException e) {
                debug.error("HttpURLConnectionManager.getConnection: Failed to set read timeout", e);
            }
            catch (IllegalArgumentException e) {
                debug.error("HttpURLConnectionManager.getConnection: Failed to set read timeout", e);
            }
            catch (InvocationTargetException e) {
                debug.error("HttpURLConnectionManager.getConnection: Failed to set read timeout", e);
            }
        }
        return conn;
    }

    static {
        prot_handler_string = null;
        stFactory = new AMURLStreamHandlerFactory();
        String rto = SystemPropertiesManager.get(URL_READTIMEOUT);
        prot_handler_string = SystemPropertiesManager.get("java.protocol.handler.pkgs", null);
        if (debug.messageEnabled()) {
            debug.message("Configured Protocol Handler : " + prot_handler_string);
        }
        if (rto != null && rto.length() > 0) {
            try {
                READTIMEOUT = Integer.valueOf(rto);
                if (debug.messageEnabled()) {
                    debug.message("HttpURLConnectionManager.<init>: Set READTIMEOUT to " + READTIMEOUT);
                }
            }
            catch (Exception e) {
                debug.error("HttpURLConnectionManager.<init>: Fail to read com.sun.identity.url.readTimeout set READTIMEOUT to the default " + READTIMEOUT, e);
            }
            try {
                Method getlocalserver = Class.forName("com.iplanet.services.naming.WebtopNaming").getMethod("getLocalServer", null);
                String serverURL = (String)getlocalserver.invoke(null, null);
                if (serverURL != null) {
                    URL url = new URL(serverURL);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    Class[] param = new Class[]{Integer.TYPE};
                    method = conn.getClass().getMethod("setReadTimeout", param);
                    args = new Object[]{new Integer(READTIMEOUT)};
                } else if (debug.messageEnabled()) {
                    debug.message("HttpURLConnectionManager.<init>: Server URL is not available");
                }
            }
            catch (NoSuchMethodException e) {
                debug.warning("HttpURLConnectionManager.<init>: setReadTimeout is not supported by the JVM", e);
            }
            catch (Exception e) {
                debug.error("HttpURLConnectionManager.<init>: Failed to find setReadTimeout method ", e);
            }
        }
    }
}

